/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui.test.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.NextButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.ui.test.wizard.RedDeerWizardTestCase;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestCaseWizard;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestCaseWizardPageOne;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestCaseWizardPageTwo;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RedDeerTestCaseWizardTest
extends RedDeerWizardTestCase {
    private static final String PROJECT_NAME = "testproject";
    private static final String CLASS_NAME = "TestClass";
    private static final String TEST_CLASS_NAME = "TestClassTest";
    private static final String PACKAGE = "org.example.test";
    private List<String> methodNames = new ArrayList<String>();

    @BeforeClass
    public static void setup() {
        wizard = new RedDeerTestCaseWizard();
        projectName = PROJECT_NAME;
        RedDeerTestCaseWizardTest.createTestProject();
    }

    @Test
    public void testOpen() {
        Assert.assertEquals((Object)"New RedDeer Test Case", (Object)new DefaultShell().getText());
        Assert.assertEquals((Object)"testproject/src", (Object)new LabeledText("Source folder:").getText());
        Assert.assertEquals((Object)PACKAGE, (Object)new LabeledText("Package:").getText());
        Assert.assertEquals((Object)TEST_CLASS_NAME, (Object)new LabeledText("Name:").getText());
        Assert.assertEquals((Object)"java.lang.Object", (Object)new LabeledText("Superclass:").getText());
        Assert.assertEquals((Object)"org.example.test.TestClass", (Object)new LabeledText("Class under test:").getText());
        Assert.assertTrue((String)"Next Button is not enabled", (boolean)new NextButton().isEnabled());
        Assert.assertTrue((String)"Finish Button is not enabled", (boolean)new FinishButton().isEnabled());
        wizard.next();
        Assert.assertTrue((String)"Method selection is empty", (new DefaultTree().getAllItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreate() {
        this.fillInWizard();
        wizard.finish();
        this.parseMethodNames();
        TextEditor editor = new TextEditor();
        Assert.assertEquals((Object)"TestClassTest.java", (Object)editor.getTitle());
        Assert.assertTrue((String)"Method 'setUp' not generated properly", (boolean)this.methodGeneratedProperly(editor, "setUp", "Before", false));
        Assert.assertTrue((String)"Method 'tearDown' not generated properly", (boolean)this.methodGeneratedProperly(editor, "tearDown", "After", false));
        Assert.assertTrue((String)"Method 'setUpBeforeClass' not generated properly", (boolean)this.methodGeneratedProperly(editor, "setUpBeforeClass", "BeforeClass", true));
        Assert.assertTrue((String)"Method 'tearDownAfterClass' not generated properly", (boolean)this.methodGeneratedProperly(editor, "tearDownAfterClass", "AfterClass", true));
        for (String methodName : this.methodNames) {
            Assert.assertTrue((String)("Method '" + methodName + "' not generated properly"), (boolean)this.methodGeneratedProperly(editor, methodName, "Test", false));
        }
    }

    private boolean methodGeneratedProperly(TextEditor editor, String methodName, String annotation, boolean isStatic) {
        String staticModifier = isStatic ? " static " : " ";
        String signature = "public" + staticModifier + "void " + methodName + "()";
        int i = 0;
        while (i < editor.getNumberOfLines()) {
            String line = editor.getTextAtLine(i);
            if (line.contains(signature)) {
                if (!editor.getTextAtLine(i - 1).contains("@" + annotation)) {
                    return false;
                }
                String comment = "";
                int j = 4;
                while (j > 1) {
                    comment = String.valueOf(comment) + editor.getTextAtLine(i - j);
                    --j;
                }
                if (comment.contains("/**") && comment.contains("*/")) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void fillInWizard() {
        RedDeerTestCaseWizardPageOne pageOne = new RedDeerTestCaseWizardPageOne((ReferencedComposite)wizard);
        pageOne.setAfterClassTearDown(true);
        pageOne.setBeforeClassSetup(true);
        pageOne.setSetupMethod(true);
        pageOne.setTearDownMethod(true);
        pageOne.setGenerateComments(true);
        pageOne.setName(TEST_CLASS_NAME);
        pageOne.setPackage(PACKAGE);
        wizard.next();
        RedDeerTestCaseWizardPageTwo pageTwo = new RedDeerTestCaseWizardPageTwo((ReferencedComposite)wizard);
        pageTwo.selectAll();
        DefaultTree tree = new DefaultTree();
        for (TreeItem item : tree.getAllItems()) {
            if (!item.getText().contains("(") || !item.isChecked()) continue;
            this.methodNames.add(item.getText());
        }
    }

    private void parseMethodNames() {
        ArrayList<String> testMethods = new ArrayList<String>();
        Iterator<String> iterator = this.methodNames.iterator();
        while (iterator.hasNext()) {
            String method = iterator.next();
            if (!method.contains("()")) continue;
            testMethods.add("test" + method.substring(0, 1).toUpperCase() + method.substring(1, method.indexOf("(")));
            iterator.remove();
        }
        for (String method : this.methodNames) {
            String testMethod = "test" + method.substring(0, 1).toUpperCase() + method.substring(1, method.indexOf("("));
            if (testMethods.contains(testMethod)) {
                String[] split = method.substring(method.indexOf("(") + 1, method.lastIndexOf(")")).split(",");
                int i = 0;
                while (i < split.length) {
                    testMethod = String.valueOf(testMethod) + split[i].trim().substring(0, 1).toUpperCase() + split[i].trim().substring(1);
                    ++i;
                }
            }
            testMethods.add(testMethod);
        }
        this.methodNames = testMethods;
    }

    private static void createTestProject() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)dialog).setProjectName(PROJECT_NAME);
        dialog.finish();
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage classPage = new NewClassWizardPage((ReferencedComposite)classDialog);
        classPage.setName(CLASS_NAME);
        classPage.setPackage(PACKAGE);
        classDialog.finish();
    }

    @Override
    String getWizardText() {
        return "New RedDeer Test Case";
    }
}

