/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int clientHandle;
    int labelHandle;
    String text = "";
    GdkRGBA foreground;

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    int clientHandle() {
        return this.clientHandle;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        int width;
        Point size = super.computeSizeInPixels(wHint, hHint, changed);
        if (GTK.GTK3) {
            width = this.computeNativeSize((int)this.handle, (int)-1, (int)-1, (boolean)false).x;
        } else {
            int x_thickness = GTK.gtk_style_get_xthickness(GTK.gtk_widget_get_style(this.handle));
            int minimalSizeAroundLabel = 2 * (3 + x_thickness);
            width = this.computeNativeSize((int)this.labelHandle, (int)-1, (int)-1, (boolean)false).x + minimalSizeAroundLabel;
        }
        size.x = Math.max(size.x, width);
        return size;
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        this.forceResize();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.clientHandle, allocation);
        int clientX = allocation.x;
        int clientY = allocation.y;
        return new Rectangle(x -= clientX, y -= clientY, width += clientX + clientX, height += clientX + clientY);
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle clientRectangle = super.getClientAreaInPixels();
        clientRectangle.x = 0;
        clientRectangle.y = 0;
        return clientRectangle;
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            if (this.foreground != null) {
                return this.foreground;
            }
            return this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        return super.getContextColorGdkRGBA();
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            return super.getContextBackgroundGdkRGBA();
        }
        int context = GTK.gtk_widget_get_style_context(this.fixedHandle);
        GdkRGBA rgba = new GdkRGBA();
        GTK.gtk_style_context_get_background_color(context, 0, rgba);
        if ((this.state & 0x2000) == 0) {
            return this.defaultBackground();
        }
        return rgba;
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = GTK.gtk_frame_new(null);
        if (this.handle == 0) {
            this.error(2);
        }
        this.labelHandle = GTK.gtk_label_new(null);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        OS.g_object_ref(this.labelHandle);
        OS.g_object_ref_sink(this.labelHandle);
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.clientHandle == 0) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.clientHandle, true);
        GTK.gtk_container_add(this.fixedHandle, this.handle);
        GTK.gtk_container_add(this.handle, this.clientHandle);
        if ((this.style & 4) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 1);
        }
        if ((this.style & 8) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 2);
        }
        if ((this.style & 0x10) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 3);
        }
        if ((this.style & 0x40) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 4);
        }
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    int applyThemeBackground() {
        return 1;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    @Override
    void enableWidget(boolean enabled) {
        GTK.gtk_widget_set_sensitive(this.labelHandle, enabled);
    }

    @Override
    int eventHandle() {
        return this.clientHandle;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    @Override
    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    @Override
    int parentingHandle() {
        return this.clientHandle;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.clientHandle = 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0) {
            OS.g_object_unref(this.labelHandle);
        }
        this.text = null;
    }

    @Override
    void setBackgroundGdkRGBA(int handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        super.setBackgroundGdkRGBA(this.fixedHandle, rgba);
    }

    @Override
    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(color);
        this.setBackgroundGdkColor(this.fixedHandle, color);
        this.setBackgroundGdkColor(this.clientHandle, color);
    }

    @Override
    void setFontDescription(int font) {
        super.setFontDescription(font);
        this.setFontDescription(this.labelHandle, font);
    }

    @Override
    void setForegroundGdkRGBA(int handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (GTK.GTK_VERSION < OS.VERSION(3, 14, 0)) {
            super.setForegroundGdkRGBA(handle, rgba);
            return;
        }
        if (this.text != null && !this.text.isEmpty()) {
            super.setForegroundGdkRGBA(this.labelHandle, rgba);
        }
        this.foreground = rgba;
    }

    @Override
    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setForegroundGdkColor(color);
        this.setForegroundColor(this.labelHandle, color);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        super.setForegroundGdkRGBA(rgba);
        this.setForegroundGdkRGBA(this.labelHandle, rgba);
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.labelHandle, dir);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            if (GTK.gtk_frame_get_label_widget(this.handle) == 0) {
                GTK.gtk_frame_set_label_widget(this.handle, this.labelHandle);
            }
        } else {
            GTK.gtk_frame_set_label_widget(this.handle, 0);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0) && this.foreground != null) {
            this.setForegroundGdkRGBA(this.labelHandle, this.foreground);
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.clientHandle != 0) {
            GTK.gtk_widget_show(this.clientHandle);
        }
        if (this.labelHandle != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (GTK.GTK3) {
            GtkRequisition requisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(this.handle, requisition, null);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                width = width - (requisition.width - width) < 0 ? requisition.width : width;
                height = height - (requisition.height - height) < 0 ? requisition.height : height;
            } else {
                width = Math.max(requisition.width, width);
            }
        }
        return super.setBounds(x, y, width, height, move, resize);
    }

    @Override
    int paintHandle() {
        if (GTK.GTK3) {
            return super.paintHandle();
        }
        int topHandle = this.topHandle();
        int paintHandle = this.clientHandle;
        while (paintHandle != topHandle) {
            if (GTK.gtk_widget_get_has_window(paintHandle)) break;
            paintHandle = GTK.gtk_widget_get_parent(paintHandle);
        }
        return paintHandle;
    }

    @Override
    int paintWindow() {
        int paintHandle = this.clientHandle;
        GTK.gtk_widget_realize(paintHandle);
        return this.gtk_widget_get_window(paintHandle);
    }
}

