/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    long menuHandle;
    int lastEventTime;
    int visibleCount = 10;
    long imContext;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean selectionAdded;
    int indexSelected;
    GdkRGBA background;
    public static final int LIMIT = 65535;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.items.length) {
            this.error(6);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = string;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        byte[] buffer = Converter.wcsToMbcs(string, true);
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert(this.handle, index, null, buffer);
            }
        } else if (this.handle != 0L) {
            GTK.gtk_combo_box_text_insert_text(this.handle, index, buffer);
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(listener));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int position = GTK.gtk_editable_get_position(this.entryHandle);
            GTK.gtk_editable_select_region(this.entryHandle, position, position);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0) {
            int index = GTK.gtk_combo_box_get_active(this.handle);
            if (index != -1) {
                long modelHandle = GTK.gtk_combo_box_get_model(this.handle);
                long[] ptr = new long[1];
                long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(modelHandle, iter, 0L, index);
                GTK.gtk_tree_model_get(modelHandle, iter, 0, ptr, -1);
                OS.g_free(iter);
                if (ptr[0] != 0L && C.strlen(ptr[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(ptr[0]);
            }
        } else {
            GTK.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        GTK.gtk_combo_box_set_active(this.handle, -1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if ((this.style & 8) != 0 || GTK.GTK3) {
            return this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        GTK.gtk_widget_realize(this.entryHandle);
        long layout = GTK.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_pixel_size(layout, w, h);
        int xborder = 2;
        int yborder = 2;
        Point thickness = this.getThickness(this.entryHandle);
        xborder += thickness.x;
        yborder += thickness.y;
        int[] property = new int[1];
        GTK.gtk_widget_style_get(this.entryHandle, OS.interior_focus, property, 0L);
        if (property[0] == 0) {
            GTK.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, property, 0L);
            xborder += property[0];
            yborder += property[0];
        }
        int width = w[0] + xborder * 2;
        int height = h[0] + yborder * 2;
        GtkRequisition arrowRequesition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.buttonHandle, arrowRequesition);
        GtkRequisition listRequesition = new GtkRequisition();
        long listParent = GTK.gtk_bin_get_child(this.popupHandle);
        this.gtk_widget_get_preferred_size(listParent, listRequesition);
        width = Math.max(listRequesition.width, width) + arrowRequesition.width;
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        long oldList = GTK.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = GTK.gtk_combo_box_text_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.cellHandle = GTK.gtk_bin_get_child(this.handle);
            if (this.cellHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_combo_box_set_wrap_width(this.handle, 1);
        } else {
            this.handle = GTK.gtk_combo_box_text_new_with_entry();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.entryHandle = GTK.gtk_bin_get_child(this.handle);
            if (this.entryHandle == 0L) {
                this.error(2);
            }
            if (GTK.GTK3) {
                this.imContext = OS.imContextLast();
            }
        }
        this.popupHandle = this.findPopupHandle(oldList);
        GTK.gtk_container_add(this.fixedHandle, this.handle);
        this.textRenderer = GTK.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0L) {
            this.error(2);
        }
        int pad = 0;
        OS.g_object_set(this.textRenderer, OS.ypad, pad, 0L);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        GTK.gtk_cell_layout_clear(this.handle);
        this.display.setWarnings(warnings);
        GTK.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
        GTK.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0L);
        this.menuHandle = this.findMenuHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
        }
        this.buttonHandle = this.findButtonHandle();
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
        }
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            GTK.gtk_widget_set_receives_default(this.buttonHandle, false);
        }
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handleRGBA;
    }

    @Override
    void deregister() {
        long imContext;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0L) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.removeWidget(imContext);
        }
    }

    @Override
    boolean filterKey(int keyval, long event) {
        int time = GDK.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            long imContext = this.imContext();
            if (imContext != 0L) {
                return GTK.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    long findPopupHandle(long oldList) {
        long result = 0L;
        long currentList = GTK.gtk_window_list_toplevels();
        long oldFromList = oldList;
        long newFromList = OS.g_list_last(currentList);
        while (newFromList != 0L) {
            long newToplevel = OS.g_list_data(newFromList);
            boolean isFound = false;
            oldFromList = oldList;
            while (oldFromList != 0L) {
                long oldToplevel = OS.g_list_data(oldFromList);
                if (newToplevel == oldToplevel) {
                    isFound = true;
                    break;
                }
                oldFromList = OS.g_list_next(oldFromList);
            }
            if (!isFound) {
                result = newToplevel;
                break;
            }
            newFromList = OS.g_list_previous(newFromList);
        }
        OS.g_list_free(oldList);
        OS.g_list_free(currentList);
        return result;
    }

    long findButtonHandle() {
        long widget;
        long list;
        long result = 0L;
        long childHandle = this.handle;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
            GTK.gtk_container_forall(this.handle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                list = this.display.allChildren;
                while (list != 0L) {
                    widget = OS.g_list_data(list);
                    if (widget != 0L) {
                        childHandle = widget;
                        break;
                    }
                    list = OS.g_list_next(list);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
        }
        GTK.gtk_container_forall(childHandle, this.display.allChildrenProc, 0L);
        if (this.display.allChildren != 0L) {
            list = this.display.allChildren;
            while (list != 0L) {
                widget = OS.g_list_data(list);
                if (GTK.GTK_IS_BUTTON(widget)) {
                    result = widget;
                    break;
                }
                list = OS.g_list_next(list);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
        return result;
    }

    long findMenuHandle() {
        if (this.popupHandle == 0L) {
            return 0L;
        }
        long result = 0L;
        GTK.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0L);
        if (this.display.allChildren != 0L) {
            long list = this.display.allChildren;
            while (list != 0L) {
                long widget = OS.g_list_data(list);
                if (OS.G_OBJECT_TYPE(widget) == GTK.GTK_TYPE_MENU()) {
                    result = widget;
                    break;
                }
                list = OS.g_list_next(list);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
        return result;
    }

    @Override
    void fixModal(long group, long modalGroup) {
        if (this.popupHandle != 0L) {
            if (group != 0L) {
                GTK.gtk_window_group_add_window(group, this.popupHandle);
            } else if (modalGroup != 0L) {
                GTK.gtk_window_group_remove_window(modalGroup, this.popupHandle);
            }
        }
    }

    void fixIM() {
        long imContext;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (imContext = this.imContext()) != 0L) {
            GTK.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    @Override
    long focusHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0L && GTK.gtk_widget_has_focus(this.entryHandle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.getClosure(37), false);
        }
        this.hookEvents(new long[]{this.buttonHandle, this.entryHandle, this.menuHandle});
        long imContext = this.imContext();
        if (imContext != 0L) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.getClosure(9), false);
            int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int blockMask = 17;
            OS.g_signal_handlers_block_matched(imContext, blockMask, id, 0, 0L, 0L, this.entryHandle);
        }
    }

    void hookEvents(long[] handles) {
        int eventMask = 772;
        int i = 0;
        while (i < handles.length) {
            long eventHandle = handles[i];
            if (eventHandle != 0L) {
                GTK.gtk_widget_add_events(eventHandle, eventMask);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(3), true);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(5), true);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(34), true);
                if (eventHandle != this.focusHandle()) {
                    OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
                }
                if (OS.G_OBJECT_TYPE(eventHandle) == GTK.GTK_TYPE_MENU()) {
                    OS.g_signal_connect_closure(eventHandle, OS.selection_done, this.display.getClosure(68), true);
                }
            }
            ++i;
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return this.entryHandle != 0L ? GTK.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0L;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (GTK.gtk_combo_box_get_active(this.handle) == index) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        if (filter && this.entryHandle != 0L) {
            int[] index = new int[1];
            int[] trailing = new int[1];
            long layout = GTK.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
            long ptr = OS.pango_layout_get_text(layout);
            int position = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)index[0]) + trailing[0];
            int[] start = new int[1];
            int[] end = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
            if (start[0] <= position && position < end[0] && super.dragDetect(x, y, filter, dragOnTimeout, consume)) {
                if (consume != null) {
                    consume[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(x, y, filter, dragOnTimeout, consume);
    }

    @Override
    long enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    GdkColor getBackgroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getBaseGdkColor();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int index = GTK.gtk_editable_get_position(this.entryHandle);
        index = GTK.gtk_entry_text_index_to_layout_index(this.entryHandle, index);
        int[] offset_x = new int[1];
        int[] offset_y = new int[1];
        GTK.gtk_entry_get_layout_offsets(this.entryHandle, offset_x, offset_y);
        long layout = GTK.gtk_entry_get_layout(this.entryHandle);
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos(layout, index, pos);
        int x = offset_x[0] + OS.PANGO_PIXELS(pos.x) - this.getBorderWidthInPixels();
        int y = offset_y[0] + OS.PANGO_PIXELS(pos.y);
        return new Point(x, y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        long ptr = GTK.gtk_entry_get_text(this.entryHandle);
        return (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_editable_get_position(this.entryHandle));
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkColor getForegroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0L && GTK.gtk_widget_get_visible(this.popupHandle);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int length = 0;
            int index = GTK.gtk_combo_box_get_active(this.handle);
            if (index != -1) {
                length = this.getItem(index).length();
            }
            return new Point(0, length);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
            long ptr = GTK.gtk_entry_get_text(this.entryHandle);
            start[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
            end[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return GTK.gtk_combo_box_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long str = GTK.gtk_entry_get_text(this.entryHandle);
            if (str == 0L) {
                return "";
            }
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            return new String(Converter.mbcsToWcs(buffer));
        }
        int index = GTK.gtk_combo_box_get_active(this.handle);
        return index != -1 ? this.getItem(index) : "";
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        this.checkWidget();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, requisition);
        if (GTK.GTK3) {
            return requisition.height;
        }
        return GTK.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = this.entryHandle != 0L ? GTK.gtk_entry_get_max_length(this.entryHandle) : 0;
        return limit == 0 ? LIMIT : limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    long gtk_activate(long widget) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.type == 4 && gdkEvent.button == 1) {
            return this.gtk_button_press_event(widget, event, false);
        }
        return super.gtk_button_press_event(widget, event);
    }

    @Override
    long gtk_changed(long widget) {
        if (widget == this.handle) {
            int index;
            if (this.entryHandle == 0L) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0L;
                }
            }
            if ((index = GTK.gtk_combo_box_get_active(this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0L;
        }
        boolean keyPress = false;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    keyPress = true;
                }
            }
            GDK.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long imContext, long text) {
        if (text == 0L) {
            return 0L;
        }
        if (!GTK.gtk_editable_get_editable(this.entryHandle)) {
            return 0L;
        }
        int length = C.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0L, 0L, this.entryHandle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(this.entryHandle, this.fixStart);
            GTK.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        int end;
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long ptr = GTK.gtk_entry_get_text(this.entryHandle);
        if (end_pos == -1L) {
            end_pos = OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText("", start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{(int)end_pos};
            byte[] buffer = Converter.wcsToMbcs(newText, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(this.entryHandle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(this.entryHandle, pos[0]);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 1) break;
                if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                    return 1L;
                }
                if ((this.style & 8) != 0 || widget != this.buttonHandle) break;
                GTK.gtk_widget_grab_focus(this.entryHandle);
                break;
            }
            case 12: {
                if ((this.style & 8) != 0) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, gdkEvent, (long)GdkEventFocus.sizeof);
                if (gdkEventFocus.in != 0) {
                    if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                        GTK.gtk_widget_set_focus_on_click(this.handle, false);
                        break;
                    }
                    GTK.gtk_combo_box_set_focus_on_click(this.handle, false);
                    break;
                }
                if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                    GTK.gtk_widget_set_focus_on_click(this.handle, true);
                    break;
                }
                GTK.gtk_combo_box_set_focus_on_click(this.handle, true);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    @Override
    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (new_text == 0L || new_text_length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)new_text_length];
        C.memmove(buffer, new_text, (long)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(buffer));
        int[] pos = new int[1];
        C.memmove(pos, position, 4L);
        long ptr = GTK.gtk_entry_get_text(this.entryHandle);
        if (pos[0] == -1) {
            pos[0] = (int)OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText(oldText, start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, pos[0]), start)) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] buffer3 = Converter.wcsToMbcs(newText, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(this.entryHandle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            C.memmove(position, pos, 4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            this.gdkEventKey = 0L;
            this.fixIM();
            return result;
        }
        if (this.gdkEventKey == -1L) {
            result = 1L;
        }
        this.gdkEventKey = 0L;
        if ((this.style & 8) == 0) {
            int oldIndex;
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
            int newIndex = oldIndex = GTK.gtk_combo_box_get_active(this.handle);
            int key = keyEvent.keyval;
            switch (key) {
                case 65364: 
                case 65433: {
                    if (oldIndex == this.items.length - 1) break;
                    newIndex = oldIndex + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (oldIndex == -1 || oldIndex == 0) break;
                    newIndex = oldIndex - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    newIndex = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    newIndex = this.items.length - 1;
                }
            }
            if (newIndex != oldIndex) {
                GTK.gtk_combo_box_set_active(this.handle, newIndex);
                return 1L;
            }
        }
        return result;
    }

    @Override
    long gtk_populate_popup(long widget, long menu) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(menu, 2);
            GTK.gtk_container_forall(menu, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_selection_done(long menushell) {
        int index = GTK.gtk_combo_box_get_active(this.handle);
        if (this.indexSelected == -1) {
            this.indexSelected = index;
        } else if (index != -1 && this.indexSelected == index) {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_style_set(long widget, long previousStyle) {
        this.setButtonHandle(this.findButtonHandle());
        this.setMenuHandle(this.findMenuHandle());
        return super.gtk_style_set(widget, previousStyle);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start < 0 || start >= this.items.length) {
            return -1;
        }
        int i = start;
        while (i < this.items.length) {
            if (string.equals(this.items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    boolean isFocusHandle(long widget) {
        if (this.buttonHandle != 0L && widget == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0L && widget == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(widget);
    }

    @Override
    long paintWindow() {
        long childHandle = this.entryHandle != 0L ? this.entryHandle : this.handle;
        GTK.gtk_widget_realize(childHandle);
        long window = this.gtk_widget_get_window(childHandle);
        if ((this.style & 8) != 0) {
            return window;
        }
        long children = GDK.gdk_window_get_children(window);
        if (children != 0L) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                do {
                    window = OS.g_list_data(children);
                } while ((children = OS.g_list_next(children)) != 0L);
            } else {
                window = OS.g_list_data(children);
            }
        }
        OS.g_list_free(children);
        return window;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void register() {
        long imContext;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.popupHandle != 0L) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0L) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.addWidget(imContext, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
        }
        if (this.buttonHandle != 0L) {
            OS.g_object_unref(this.buttonHandle);
        }
        this.entryHandle = 0L;
        this.buttonHandle = 0L;
        this.menuHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - 1];
        System.arraycopy(oldItems, 0, newItems, 0, index);
        System.arraycopy(oldItems, index + 1, newItems, index, oldItems.length - index - 1);
        this.items = newItems;
        if (GTK.gtk_combo_box_get_active(this.handle) == index) {
            this.clearText();
        }
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove(this.handle, index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - (end - start + 1)];
        System.arraycopy(oldItems, 0, newItems, 0, start);
        System.arraycopy(oldItems, end + 1, newItems, start, oldItems.length - end - 1);
        this.items = newItems;
        int index = GTK.gtk_combo_box_get_active(this.handle);
        if (start <= index && index <= end) {
            this.clearText();
        }
        int i = end;
        while (i >= start) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove(this.handle, i);
            }
            --i;
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.items.length;
        this.items = new String[0];
        this.clearText();
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove_all(this.handle);
            }
        } else {
            int i = count - 1;
            while (i >= 0) {
                if (this.handle != 0L) {
                    GTK.gtk_combo_box_text_remove(this.handle, i);
                }
                --i;
            }
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        int selected = GTK.gtk_combo_box_get_active(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_combo_box_set_active(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0 && selected != index) {
            this.sendEvent(24);
        }
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        this.background = rgba;
        String css = "* {\n";
        String color = rgba != null ? this.display.gtk_rgba_to_css_string(rgba) : ((this.style & 8) != 0 ? this.display.gtk_rgba_to_css_string(this.display.COLOR_WIDGET_BACKGROUND_RGBA) : this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA));
        this.cssBackground = css = String.valueOf(css) + "background: " + color + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        if (this.entryHandle == 0L || (this.style & 8) != 0) {
            this.gtk_css_provider_load_from_css(GTK.gtk_widget_get_style_context(this.buttonHandle), finalCss);
        } else if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.gtk_css_provider_load_from_css(GTK.gtk_widget_get_style_context(this.entryHandle), finalCss);
        } else {
            this.setBackgroundGradientGdkRGBA(GTK.gtk_widget_get_style_context(this.entryHandle), handle, rgba);
            super.setBackgroundGdkRGBA(GTK.gtk_widget_get_style_context(this.entryHandle), this.entryHandle, rgba);
        }
        OS.g_object_set(this.textRenderer, OS.background_rgba, rgba, 0L);
    }

    @Override
    void setBackgroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        super.setBackgroundGdkRGBA(rgba);
        if (this.entryHandle != 0L) {
            this.setBackgroundGdkRGBA(this.entryHandle, rgba);
        }
        this.setBackgroundGdkRGBA(this.fixedHandle, rgba);
    }

    @Override
    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(color);
        if (this.entryHandle != 0L) {
            GTK.gtk_widget_modify_base(this.entryHandle, 0, color);
        }
        if (this.cellHandle != 0L) {
            OS.g_object_set(this.cellHandle, OS.background_gdk, color, 0L);
        }
        OS.g_object_set(this.textRenderer, OS.background_gdk, color, 0L);
        if (this.entryHandle != 0L) {
            this.setBackgroundGdkColor(this.entryHandle, color);
        }
        this.setBackgroundGdkColor(this.fixedHandle, color);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int newHeight = height;
        if (resize) {
            newHeight = Math.max(this.getTextHeightInPixels(), height);
        }
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    void setButtonHandle(long widget) {
        if (this.buttonHandle == widget) {
            return;
        }
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
            OS.g_object_unref(this.buttonHandle);
        }
        this.buttonHandle = widget;
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
            this.display.addWidget(this.buttonHandle, this);
            this.hookEvents(new long[]{this.buttonHandle});
        }
    }

    void setMenuHandle(long widget) {
        if (this.menuHandle == widget) {
            return;
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
            OS.g_object_unref(this.menuHandle);
        }
        this.menuHandle = widget;
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
            this.display.addWidget(this.menuHandle, this);
            this.hookEvents(new long[]{this.menuHandle});
        }
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        if (this.entryHandle != 0L) {
            this.setFontDescription(this.entryHandle, font);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, font, 0L);
        if ((this.style & 8) != 0) {
            int index = GTK.gtk_combo_box_get_active(this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_combo_box_set_active(this.handle, -1);
            GTK.gtk_combo_box_set_active(this.handle, index);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    @Override
    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setForegroundColor(this.handle, color, false);
        if (this.entryHandle != 0L) {
            this.setForegroundColor(this.entryHandle, color, false);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_gdk, color, 0L);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (this.entryHandle != 0L) {
            this.setForegroundGdkRGBA(this.entryHandle, rgba);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_rgba, rgba, 0L);
        super.setForegroundGdkRGBA(rgba);
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.items.length) {
            this.error(5);
        }
        this.items[index] = string;
        byte[] buffer = Converter.wcsToMbcs(string, true);
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove(this.handle, index);
            }
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert(this.handle, index, null, buffer);
            }
        } else {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove(this.handle, index);
            }
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert_text(this.handle, index, buffer);
            }
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setItems(String ... items) {
        int i;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2] == null) {
                this.error(5);
            }
            ++i2;
        }
        int count = this.items.length;
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, items.length);
        this.clearText();
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove_all(this.handle);
            }
        } else {
            i = count - 1;
            while (i >= 0) {
                if (this.handle != 0L) {
                    GTK.gtk_combo_box_text_remove(this.handle, i);
                }
                --i;
            }
        }
        i = 0;
        while (i < items.length) {
            String string = items[i];
            byte[] buffer = Converter.wcsToMbcs(string, true);
            if (GTK.GTK3) {
                if (this.handle != 0L) {
                    GTK.gtk_combo_box_text_insert(this.handle, i, null, buffer);
                }
            } else if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert_text(this.handle, i, buffer);
            }
            if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
                GTK.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
            }
            ++i;
        }
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            GTK.gtk_combo_box_popup(this.handle);
        } else {
            GTK.gtk_combo_box_popdown(this.handle);
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0L) {
                GTK.gtk_widget_set_direction(this.entryHandle, dir);
            }
            if (this.cellHandle != 0L) {
                GTK.gtk_widget_set_direction(this.cellHandle, dir);
            }
            if (!create && this.popupHandle != 0L) {
                GTK.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, dir);
            }
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            long ptr = GTK.gtk_entry_get_text(this.entryHandle);
            int start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, selection.x);
            int end = (int)OS.g_utf16_offset_to_utf8_offset(ptr, selection.y);
            GTK.gtk_editable_set_position(this.entryHandle, start);
            GTK.gtk_editable_select_region(this.entryHandle, start, end);
        }
    }

    public void setText(String string) {
        long ptr;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index == -1) {
                return;
            }
            this.select(index);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf16_strlen(ptr = GTK.gtk_entry_get_text(this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        GTK.gtk_entry_set_text(this.entryHandle, buffer);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            GTK.gtk_entry_set_max_length(this.entryHandle, limit);
        }
    }

    @Override
    void setToolTipText(Shell shell, String newString) {
        if (this.entryHandle != 0L) {
            shell.setToolTipText(this.entryHandle, newString);
        }
        if (this.buttonHandle != 0L) {
            shell.setToolTipText(this.buttonHandle, newString);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                long imContext = this.imContext();
                if (imContext == 0L) break;
                long[] preeditString = new long[1];
                GTK.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0L) break;
                int length = C.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            GDK.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

