/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.BROWSEINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    static final byte[] CLSID_FileOpenDialog = new byte[16];
    static final byte[] IID_IFileOpenDialog = new byte[16];
    static final byte[] IID_IShellItem = new byte[16];
    String message = "";
    String filterPath = "";
    String directoryPath;

    static {
        if (OS.IsWinVista) {
            OS.IIDFromString("{DC1C5A9C-E88A-4dde-A5A1-60F82A20AEF7}\u0000".toCharArray(), CLSID_FileOpenDialog);
            OS.IIDFromString("{d57c7288-d4ad-4768-be02-9d969532d960}\u0000".toCharArray(), IID_IFileOpenDialog);
            OS.IIDFromString("{43826d1e-e718-42ee-bc55-a1e261c37bfe}\u0000".toCharArray(), IID_IShellItem);
        }
    }

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    int BrowseCallbackProc(int hwnd, int uMsg, int lParam, int lpData) {
        switch (uMsg) {
            case 1: {
                TCHAR buffer;
                if (this.filterPath != null && this.filterPath.length() != 0) {
                    buffer = new TCHAR(0, this.filterPath.replace('/', '\\'), true);
                    OS.SendMessage(hwnd, OS.BFFM_SETSELECTION, 1, buffer);
                }
                if (this.title == null || this.title.length() == 0) break;
                buffer = new TCHAR(0, this.title, true);
                OS.SetWindowText(hwnd, buffer);
                break;
            }
            case 3: 
            case 4: {
                int length = OS.IsUnicode ? OS.wcslen(lParam) : C.strlen(lParam);
                TCHAR buffer = new TCHAR(0, length);
                int byteCount = buffer.length() * TCHAR.sizeof;
                OS.MoveMemory(buffer, lParam, byteCount);
                this.directoryPath = buffer.toString(0, length);
            }
        }
        return 0;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        if (OS.IsWinVista) {
            return this.openCommonItemDialog();
        }
        return this.openCommonFileDialog();
    }

    private String openCommonFileDialog() {
        int[] ppMalloc;
        TCHAR buffer;
        boolean success;
        Callback callback;
        int lpfn;
        if (OS.IsWinCE) {
            this.error(20);
        }
        int hHeap = OS.GetProcessHeap();
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        int lpszTitle = 0;
        if (this.message.length() != 0) {
            String string = this.message;
            if (string.indexOf(38) != -1) {
                int length = string.length();
                char[] buffer2 = new char[length * 2];
                int index = 0;
                int i = 0;
                while (i < length) {
                    char ch = string.charAt(i);
                    if (ch == '&') {
                        buffer2[index++] = 38;
                    }
                    buffer2[index++] = ch;
                    ++i;
                }
                string = new String(buffer2, 0, index);
            }
            TCHAR buffer3 = new TCHAR(0, string, true);
            int byteCount = buffer3.length() * TCHAR.sizeof;
            lpszTitle = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszTitle, buffer3, byteCount);
        }
        if ((lpfn = (callback = new Callback(this, "BrowseCallbackProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        Dialog oldModal = null;
        Display display = this.parent.getDisplay();
        if ((this.style & 0x30000) != 0) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        this.directoryPath = null;
        BROWSEINFO lpbi = new BROWSEINFO();
        lpbi.hwndOwner = hwndOwner;
        lpbi.lpszTitle = lpszTitle;
        lpbi.ulFlags = 113;
        lpbi.lpfn = lpfn;
        int oldErrorMode = OS.SetErrorMode(1);
        display.sendPreExternalEventDispatchEvent();
        boolean oldRunMessages = display.runMessages;
        if (OS.COMCTL32_MAJOR < 6) {
            display.runMessages = false;
        }
        int lpItemIdList = OS.SHBrowseForFolder(lpbi);
        if (OS.COMCTL32_MAJOR < 6) {
            display.runMessages = oldRunMessages;
        }
        display.sendPostExternalEventDispatchEvent();
        OS.SetErrorMode(oldErrorMode);
        if ((this.style & 0x30000) != 0) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = lpItemIdList != 0;
        if (success && OS.SHGetPathFromIDList(lpItemIdList, buffer = new TCHAR(0, 260))) {
            this.filterPath = this.directoryPath = buffer.toString(0, buffer.strlen());
        }
        callback.dispose();
        if (lpszTitle != 0) {
            OS.HeapFree(hHeap, 0, lpszTitle);
        }
        if (OS.SHGetMalloc(ppMalloc = new int[1]) == 0) {
            OS.VtblCall(5, ppMalloc[0], lpItemIdList);
        }
        if (!success) {
            return null;
        }
        return this.directoryPath;
    }

    private String openCommonItemDialog() {
        this.directoryPath = null;
        int[] ppv = new int[1];
        if (OS.CoCreateInstance(CLSID_FileOpenDialog, 0, 1, IID_IFileOpenDialog, ppv) == 0) {
            int hwndOwner;
            int fileDialog = ppv[0];
            int[] options = new int[1];
            if (OS.VtblCall(10, fileDialog, options) == 0) {
                options[0] = options[0] | 0x68;
                OS.VtblCall(9, fileDialog, options[0]);
            }
            if (this.title == null) {
                this.title = "";
            }
            if (this.title.length() > 0) {
                char[] buffer = new char[this.title.length() + 1];
                this.title.getChars(0, this.title.length(), buffer, 0);
                OS.VtblCall(17, fileDialog, buffer);
            }
            if (this.filterPath != null && this.filterPath.length() > 0) {
                String path = this.filterPath.replace('/', '\\');
                char[] buffer = new char[path.length() + 1];
                path.getChars(0, path.length(), buffer, 0);
                if (OS.SHCreateItemFromParsingName(buffer, 0, IID_IShellItem, ppv) == 0) {
                    int psi = ppv[0];
                    OS.VtblCall(25, fileDialog);
                    OS.VtblCall(11, fileDialog, psi);
                    OS.VtblCall(2, psi);
                }
            }
            if (OS.VtblCall(3, fileDialog, hwndOwner = this.parent.handle) == 0 && OS.VtblCall(20, fileDialog, ppv) == 0) {
                int psi = ppv[0];
                if (OS.VtblCall(5, psi, -2147123200, ppv) == 0) {
                    int wstr = ppv[0];
                    int length = OS.wcslen(wstr);
                    char[] buffer = new char[length];
                    OS.MoveMemory(buffer, wstr, length * 2);
                    OS.CoTaskMemFree(wstr);
                    this.directoryPath = new String(buffer);
                }
                OS.VtblCall(2, psi);
            }
            OS.VtblCall(2, fileDialog);
        }
        return this.directoryPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

