/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.preferences;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;

public class FileTypeTable
implements ICellModifier,
IStructuredContentProvider,
ITableLabelProvider {
    private static final int COMBO_INDEX_BINARY = 0;
    private static final int COMBO_INDEX_TEXT = 1;
    private static final String[] MODES_TEXT = new String[]{TeamUIMessages.FileTypeTable_0, TeamUIMessages.FileTypeTable_1};
    private static final int COMBO_INDEX_SAVE = 0;
    private static final int COMBO_INDEX_DONT_SAVE = 1;
    private static final String[] SAVE_TEXT = new String[]{TeamUIMessages.FileTypeTable_2, TeamUIMessages.FileTypeTable_3};
    private static final int COLUMN_PADDING = 5;
    protected static final String ITEM = "item";
    protected static final String PROPERTY_MODE = "mode";
    protected static final String PROPERTY_SAVE = "save";
    private final TableViewer fTableViewer;
    private final List fItems;
    private final boolean fShowSaveColumn;

    public FileTypeTable(Composite composite, List items, boolean showSaveColumn) {
        int length;
        this.fShowSaveColumn = showSaveColumn;
        this.fItems = items;
        Table table = new Table(composite, 68098);
        table.setLayoutData((Object)SWTUtils.createHVFillGridData());
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)composite);
        TableColumn fileColumn = new TableColumn(table, 0, 0);
        fileColumn.setWidth(converter.convertWidthInCharsToPixels(TeamUIMessages.FileTypeTable_4.length() + 5));
        fileColumn.setText(TeamUIMessages.FileTypeTable_4);
        TableColumn modeColumn = new TableColumn(table, 0, 1);
        try {
            length = TeamUIMessages.FileTypeTable_5.length();
            length = Math.max(length, TeamUIMessages.FileTypeTable_0.length());
            length = Math.max(length, TeamUIMessages.FileTypeTable_1.length());
        }
        catch (RuntimeException runtimeException) {
            length = 15;
        }
        modeColumn.setWidth(converter.convertWidthInCharsToPixels(length + 5));
        modeColumn.setText(TeamUIMessages.FileTypeTable_5);
        if (this.fShowSaveColumn) {
            TableColumn saveColumn = new TableColumn(table, 0, 2);
            saveColumn.setWidth(converter.convertWidthInCharsToPixels(TeamUIMessages.FileTypeTable_6.length() + 5));
            saveColumn.setText(TeamUIMessages.FileTypeTable_6);
        }
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)this);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this);
        this.fTableViewer.setComparator((ViewerComparator)new FileTypeComparator());
        new TableEditor(table);
        ComboBoxCellEditor modeEditor = new ComboBoxCellEditor((Composite)table, MODES_TEXT, 8);
        ComboBoxCellEditor saveEditor = new ComboBoxCellEditor((Composite)table, SAVE_TEXT, 8);
        if (this.fShowSaveColumn) {
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[1] = modeEditor;
            cellEditorArray[2] = saveEditor;
            this.fTableViewer.setCellEditors(cellEditorArray);
            this.fTableViewer.setColumnProperties(new String[]{ITEM, PROPERTY_MODE, PROPERTY_SAVE});
        } else {
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = modeEditor;
            this.fTableViewer.setCellEditors(cellEditorArray);
            this.fTableViewer.setColumnProperties(new String[]{ITEM, PROPERTY_MODE});
        }
        this.fTableViewer.setCellModifier((ICellModifier)this);
        this.fTableViewer.setInput((Object)this.fItems);
    }

    public Object getValue(Object element, String property) {
        Item item = (Item)element;
        if (PROPERTY_MODE.equals(property)) {
            if (item.mode == 2) {
                return 0;
            }
            if (item.mode == 1) {
                return 1;
            }
        }
        if (this.fShowSaveColumn && PROPERTY_SAVE.equals(property)) {
            return item.save ? 0 : 1;
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        return PROPERTY_MODE.equals(property) || this.fShowSaveColumn && PROPERTY_SAVE.equals(property);
    }

    public void modify(Object element, String property, Object value) {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Item item = (Item)selection.getFirstElement();
        if (item == null) {
            return;
        }
        int comboIndex = (Integer)value;
        if (PROPERTY_MODE.equals(property)) {
            if (comboIndex == 0) {
                item.mode = 2;
            }
            if (comboIndex == 1) {
                item.mode = 1;
            }
        }
        if (this.fShowSaveColumn && PROPERTY_SAVE.equals(property)) {
            item.save = comboIndex == 0;
        }
        this.fTableViewer.refresh((Object)item);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Item item = (Item)element;
        if (columnIndex == 0) {
            String label = String.valueOf(item instanceof Extension ? "*." : "") + item.name;
            label = TextProcessor.process((String)label, (String)".*");
            return label;
        }
        if (columnIndex == 1) {
            if (item.mode == 2) {
                return MODES_TEXT[0];
            }
            if (item.mode == 1) {
                return MODES_TEXT[1];
            }
        }
        if (columnIndex == 2 && this.fShowSaveColumn) {
            return SAVE_TEXT[item.save ? 0 : 1];
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        return ((Collection)inputElement).toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    public void setInput(List items) {
        this.fItems.clear();
        this.fItems.addAll(items);
        this.fTableViewer.refresh();
    }

    public TableViewer getViewer() {
        return this.fTableViewer;
    }

    public static class Extension
    extends Item {
        public Extension(String name, boolean contributed) {
            super(name, contributed);
        }
    }

    private static final class FileTypeComparator
    extends ViewerComparator {
        private int getCategory(Object element) {
            if (element instanceof Extension) {
                return 0;
            }
            if (element instanceof Name) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int compare = this.getCategory(e1) - this.getCategory(e2);
            if (compare != 0) {
                return compare;
            }
            return super.compare(viewer, (Object)((Item)e1).name, (Object)((Item)e2).name);
        }
    }

    public static abstract class Item
    implements Comparable {
        public final String name;
        public boolean save;
        public int mode;
        public boolean contributed;

        public Item(String name, boolean contributed) {
            this.name = name;
            this.contributed = contributed;
            this.save = true;
            this.mode = 2;
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((Item)o).name);
        }
    }

    public static class Name
    extends Item {
        public Name(String name, boolean contributed) {
            super(name, contributed);
        }
    }
}

