/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;
import org.eclipse.ui.views.bookmarkexplorer.MarkerUtil;

class CopyBookmarkAction
extends BookmarkAction {
    public CopyBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.CopyBookmark_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.copy_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        BookmarkNavigator bookmarkNavigator = this.getView();
        StructuredViewer viewer = bookmarkNavigator.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List list = selection.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        this.setClipboard(markers, this.createBookmarkReport(markers));
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.setEnabled(!sel.isEmpty());
    }

    private void setClipboard(IMarker[] markers, String markerReport) {
        block3: {
            try {
                Object[] data = new Object[]{markers, markerReport};
                Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                this.getView().getClipboard().setContents(data, transferTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getView().getShell(), (String)BookmarkMessages.CopyToClipboardProblemDialog_title, (String)BookmarkMessages.CopyToClipboardProblemDialog_message)) break block3;
                this.setClipboard(markers, markerReport);
            }
        }
    }

    private String createBookmarkReport(IMarker[] markers) {
        StringBuilder report = new StringBuilder();
        report.append(BookmarkMessages.ColumnDescription_header).append('\t');
        report.append(BookmarkMessages.ColumnResource_header).append('\t');
        report.append(BookmarkMessages.ColumnFolder_header).append('\t');
        report.append(BookmarkMessages.ColumnLocation_header);
        report.append(System.getProperty("line.separator"));
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            report.append(MarkerUtil.getMessage(marker)).append('\t');
            report.append(MarkerUtil.getResourceName(marker)).append('\t');
            report.append(MarkerUtil.getContainerName(marker)).append('\t');
            int line = MarkerUtil.getLineNumber(marker);
            report.append(NLS.bind((String)BookmarkMessages.LineIndicator_text, (Object)String.valueOf(line)));
            report.append(System.getProperty("line.separator"));
            ++n2;
        }
        return report.toString();
    }
}

