/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.wst.common.internal.emf.plugin.EcoreUtilitiesPlugin;
import org.eclipse.wst.common.internal.emf.resource.AbstractRendererImpl;
import org.eclipse.wst.common.internal.emf.resource.IRootObjectResource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedXMIResourceImpl;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.StringUtil;
import org.xml.sax.EntityResolver;

public abstract class TranslatorResourceImpl
extends ReferencedXMIResourceImpl
implements TranslatorResource,
IRootObjectResource {
    public static final EStructuralFeature ID_FEATURE = EcorePackage.eINSTANCE.getEClass_EIDAttribute();
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String DEFAULT_VERSION = "1.0";
    protected Renderer renderer;
    protected String publicId;
    protected String systemId;
    protected String xmlVersion;
    protected int versionID;

    public TranslatorResourceImpl() {
    }

    public TranslatorResourceImpl(URI uri) {
        super(uri);
    }

    public TranslatorResourceImpl(URI uri, Renderer aRenderer) {
        super(uri);
        this.setRenderer(aRenderer);
        this.versionID = this.getDefaultVersionID();
    }

    public TranslatorResourceImpl(Renderer aRenderer) {
        this.setRenderer(aRenderer);
    }

    public String getEncoding() {
        if (super.getEncoding() == null) {
            this.setEncoding(DEFAULT_ENCODING);
        }
        return super.getEncoding();
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public EObject getRootObject() {
        if (this.contents == null || this.contents.isEmpty()) {
            return null;
        }
        return (EObject)this.getContents().get(0);
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setDoctypeValues(String aPublicId, String aSystemId) {
        boolean changed = !StringUtil.stringsEqual(this.publicId, aPublicId) || !StringUtil.stringsEqual(this.systemId, aSystemId);
        this.publicId = aPublicId;
        this.systemId = aSystemId;
        if (changed) {
            this.eNotify((Notification)new NotificationImpl(1, null, null){

                public Object getFeature() {
                    return DOC_TYPE_FEATURE;
                }

                public Object getNotifier() {
                    return TranslatorResourceImpl.this;
                }
            });
        }
    }

    @Override
    public String getXMLVersion() {
        if (this.xmlVersion == null) {
            this.xmlVersion = DEFAULT_VERSION;
        }
        return this.xmlVersion;
    }

    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    protected void basicDoLoad(InputStream inputStream, Map options) throws IOException {
        boolean isTrackingMods = this.isTrackingModification();
        try {
            if (isTrackingMods) {
                this.setTrackingModification(false);
            }
            this.renderer.doLoad(inputStream, options);
        }
        finally {
            if (isTrackingMods) {
                this.setTrackingModification(true);
            }
        }
    }

    @Override
    public void save(Map options) throws IOException {
        if (this.renderer.useStreamsForIO()) {
            super.save(options);
        } else {
            this.notifyAboutToSave();
            try {
                this.doSave(null, options);
                this.notifySaved();
            }
            catch (Exception e) {
                this.notifySaveFailed();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                EcoreUtilitiesPlugin.logError(e);
            }
            this.notifySaved();
        }
    }

    @Override
    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.renderer.doSave(outputStream, options);
        this.setModified(false);
    }

    @Override
    protected void doUnload() {
        this.renderer.preUnload();
        super.doUnload();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + this.getURI().toString();
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        if (renderer.getResource() != this) {
            renderer.setResource(this);
        }
    }

    protected EList primGetContents() {
        return super.getContents();
    }

    @Override
    public EList getContents() {
        this.waitForResourceToLoadIfNecessary();
        if (this.contents == null) {
            this.initializeContents();
        }
        return this.contents;
    }

    protected void initializeContents() {
        this.contents = new ResourceImpl.ContentsEList((ResourceImpl)this){
            private static final long serialVersionUID = 1L;

            public boolean add(Object object) {
                TranslatorResourceImpl.this.renderer.prepareToAddContents();
                return super.add(object);
            }

            public boolean addAll(Collection collection) {
                TranslatorResourceImpl.this.renderer.prepareToAddContents();
                return super.addAll(collection);
            }
        };
    }

    @Override
    public void setDefaults() {
        if (this.systemId != null && this.publicId != null) {
            return;
        }
        String pubId = this.publicId == null ? this.getDefaultPublicId() : this.publicId;
        String sysId = this.systemId == null ? this.getDefaultSystemId() : this.systemId;
        this.setDoctypeValues(pubId, sysId);
    }

    @Override
    protected void init() {
        super.init();
        this.setEncoding(DEFAULT_ENCODING);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    protected abstract String getDefaultPublicId();

    protected abstract String getDefaultSystemId();

    protected abstract int getDefaultVersionID();

    @Override
    public int getVersionID() {
        return this.versionID;
    }

    @Override
    public void setVersionID(int i) {
        this.versionID = i;
    }

    @Override
    public boolean usesDTD() {
        return this.getPublicId() != null && this.getSystemId() != null;
    }

    public void setID(EObject eObject, String id) {
        String oldId = this.getID(eObject);
        super.setID(eObject, id);
        eObject.eNotify((Notification)new ENotificationImpl((InternalEObject)eObject, 1, ID_FEATURE, (Object)oldId, (Object)id));
    }

    public boolean isModified() {
        return super.isModified() || this.renderer.isModified();
    }

    public boolean isReverting() {
        return ((AbstractRendererImpl)this.renderer).isReverting();
    }

    @Override
    public void accessForWrite() {
        this.renderer.accessForWrite();
        super.accessForWrite();
    }

    @Override
    public void accessForRead() {
        this.renderer.accessForRead();
        super.accessForRead();
    }

    @Override
    public void releaseFromRead() {
        this.renderer.releaseFromRead();
        super.releaseFromRead();
    }

    @Override
    public void releaseFromWrite() {
        this.renderer.releaseFromWrite();
        super.releaseFromWrite();
    }

    @Override
    public void preDelete() {
        super.preDelete();
        this.renderer.preDelete();
    }

    @Override
    public boolean isShared() {
        return super.isShared() || this.renderer.isShared();
    }

    @Override
    public boolean isSharedForWrite() {
        return super.isSharedForWrite() || this.renderer.isSharedForWrite();
    }

    @Override
    public void load(Map options) throws IOException {
        if (this.isLoaded()) {
            return;
        }
        if (this.renderer.useStreamsForIO()) {
            super.load(options);
        } else if (!this.isLoaded()) {
            this.isShared();
            this.loadExisting(options);
        }
    }

    public void eNotify(Notification notification) {
        Adapter[] originalEAdapters = this.eBasicAdapterArray();
        Adapter[] eAdapters = Arrays.copyOf(originalEAdapters, originalEAdapters.length);
        if (eAdapters != null && this.eDeliver()) {
            int i = 0;
            int size = eAdapters.length;
            while (i < size) {
                Adapter temp = eAdapters[i];
                if (temp != null) {
                    temp.notifyChanged(notification);
                }
                ++i;
            }
        }
    }
}

