/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ResetSendMode;
import org.eclipse.epp.logging.aeri.core.SendMode;

public class ResetSendModeHandler {
    private boolean onFirstRun = true;

    @Execute
    public SendMode execute(ISystemSettings system) {
        switch (system.getResetSendMode()) {
            case PERMANENT: 
            case KEEP: {
                break;
            }
            case RESTART: {
                if (!this.onFirstRun) break;
                system.setSendMode(SendMode.NOTIFY);
                system.setResetSendMode(ResetSendMode.KEEP);
                system.setResetSendModeOn(0L);
                this.onFirstRun = false;
                break;
            }
            case HOURS_24: {
                if (system.getResetSendModeOn() >= System.currentTimeMillis()) break;
                system.setSendMode(SendMode.NOTIFY);
                system.setResetSendMode(ResetSendMode.KEEP);
                system.setResetSendModeOn(0L);
            }
        }
        return system.getSendMode();
    }
}

