/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    protected static final int CHANGE_SCALEFACTOR = 1;
    int gsettingsProc;
    Callback gsettingsCallback;
    boolean isConnected = false;
    int displaySettings;
    protected int xDisplay;
    int shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    int logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"", "GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS", "GIO"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static int XErrorProc;
    static int XIOErrorProc;
    static int XNullErrorProc;
    static int XNullIOErrorProc;
    static Device[] Devices;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_TRANSPARENT;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    Point dpi;
    protected int scaleFactor;
    int emptyTab;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        Devices = new Device[4];
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(data);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0;
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == object) {
                    this.objects[i] = null;
                    this.errors[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    static synchronized Device findDevice(int xDisplay) {
        int i = 0;
        while (i < Devices.length) {
            Device device = Devices[i];
            if (device != null && device.xDisplay == xDisplay) {
                return device;
            }
            ++i;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (device == Devices[i]) {
                Device.Devices[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i = 0;
                while (i < length) {
                    if (this.objects[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        data.objects[index] = this.objects[i2];
                        data.errors[index] = this.errors[i2];
                        ++index;
                    }
                    ++i2;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        int[] family = new int[1];
        int[] face = new int[1];
        int[] families = new int[1];
        int[] n_families = new int[1];
        int[] faces = new int[1];
        int[] n_faces = new int[1];
        int context = GDK.gdk_pango_context_get();
        OS.pango_context_list_families(context, families, n_families);
        int nFds = 0;
        FontData[] fds = new FontData[faceName != null ? 4 : n_families[0]];
        int i = 0;
        while (i < n_families[0]) {
            C.memmove(family, families[0] + i * C.PTR_SIZEOF, C.PTR_SIZEOF);
            boolean match = true;
            if (faceName != null) {
                int familyName = OS.pango_font_family_get_name(family[0]);
                int length = C.strlen(familyName);
                byte[] buffer = new byte[length];
                C.memmove(buffer, familyName, length);
                String name = new String(Converter.mbcsToWcs(buffer));
                match = faceName.equalsIgnoreCase(name);
            }
            if (match) {
                OS.pango_font_family_list_faces(family[0], faces, n_faces);
                int j = 0;
                while (j < n_faces[0]) {
                    C.memmove(face, faces[0] + j * C.PTR_SIZEOF, C.PTR_SIZEOF);
                    int fontDesc = OS.pango_font_face_describe(face[0]);
                    Font font = Font.gtk_new(this, fontDesc);
                    FontData data = font.getFontData()[0];
                    if (nFds == fds.length) {
                        FontData[] newFds = new FontData[fds.length + n_families[0]];
                        System.arraycopy(fds, 0, newFds, 0, nFds);
                        fds = newFds;
                    }
                    fds[nFds++] = data;
                    OS.pango_font_description_free(fontDesc);
                    ++j;
                }
                OS.g_free(faces[0]);
                if (faceName != null) break;
            }
            ++i;
        }
        OS.g_free(families[0]);
        OS.g_object_unref(context);
        if (nFds == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[nFds];
        System.arraycopy(fds, 0, result, 0, nFds);
        return result;
    }

    Point getScreenDPI() {
        int widthMM = GDK.gdk_screen_width_mm();
        int width = GDK.gdk_screen_width();
        int dpi = Compatibility.round(254 * width, widthMM * 10);
        return new Point(dpi, dpi);
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 37: {
                return this.COLOR_TRANSPARENT;
            }
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        int defaultFont;
        boolean fixAIX;
        this.dpi = this.getDPI();
        this.scaleFactor = this.getDeviceZoom();
        DPIUtil.setDeviceZoom(this.scaleFactor);
        boolean bl = fixAIX = OS.IsAIX && C.PTR_SIZEOF == 8;
        if ((this.debug || fixAIX) && this.xDisplay != 0) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = this.getClass();
            synchronized (clazz2) {
                int index = 0;
                while (index < Devices.length) {
                    if (Devices[index] != null) break;
                    ++index;
                }
                if (index == Devices.length) {
                    XErrorCallback = new Callback(clazz, "XErrorProc", 2);
                    XNullErrorProc = XErrorCallback.getAddress();
                    if (XNullErrorProc == 0) {
                        SWT.error(3);
                    }
                    if ((XNullIOErrorProc = (XIOErrorCallback = new Callback(clazz, "XIOErrorProc", 1)).getAddress()) == 0) {
                        SWT.error(3);
                    }
                    XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                    XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
                }
            }
            if (this.debug) {
                OS.XSynchronize(this.xDisplay, true);
            }
        }
        if (this.xDisplay != 0) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.logProc == 0) {
                SWT.error(3);
            }
            if (this.debug) {
                int flags = -1;
                int i = 0;
                while (i < this.log_domains.length) {
                    byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                    this.handler_ids[i] = OS.g_log_set_handler(log_domain, flags, this.logProc, 0);
                    ++i;
                }
            }
        }
        this.COLOR_TRANSPARENT = new Color(this, 255, 255, 255, 0);
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0, 1);
        this.shellHandle = GTK.gtk_window_new(0);
        if (this.shellHandle == 0) {
            SWT.error(2);
        }
        GTK.gtk_widget_realize(this.shellHandle);
        int[] defaultFontArray = new int[1];
        if (GTK.GTK3) {
            int context = GTK.gtk_widget_get_style_context(this.shellHandle);
            if (GTK.GTK_VERSION < OS.VERSION(3, 8, 0)) {
                defaultFont = GTK.gtk_style_context_get_font(context, 0);
            } else if (GTK.GTK_VERSION >= OS.VERSION(3, 18, 0)) {
                GTK.gtk_style_context_save(context);
                GTK.gtk_style_context_set_state(context, 0);
                GTK.gtk_style_context_get(context, 0, GTK.gtk_style_property_font, defaultFontArray, 0);
                GTK.gtk_style_context_restore(context);
                defaultFont = defaultFontArray[0];
            } else {
                GTK.gtk_style_context_get(context, 0, GTK.gtk_style_property_font, defaultFontArray, 0);
                defaultFont = defaultFontArray[0];
            }
        } else {
            int style = GTK.gtk_widget_get_style(this.shellHandle);
            defaultFont = GTK.gtk_style_get_font_desc(style);
        }
        defaultFont = OS.pango_font_description_copy(defaultFont);
        Point dpi = this.getDPI();
        Point screenDPI = this.getScreenDPI();
        if (dpi.y != screenDPI.y) {
            int size = OS.pango_font_description_get_size(defaultFont);
            OS.pango_font_description_set_size(defaultFont, size * dpi.y / screenDPI.y);
        }
        this.systemFont = Font.gtk_new(this, defaultFont);
        if (GTK.GTK3) {
            int screen = GDK.gdk_screen_get_default();
            int provider = GTK.gtk_css_provider_new();
            String resourcePath = "";
            if (screen != 0 && provider != 0) {
                BufferedReader buffer;
                Object var12_21;
                Throwable throwable;
                String userCSS = "";
                String additionalCSSPath = System.getProperty("org.eclipse.swt.internal.gtk.cssFile");
                if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && additionalCSSPath != null) {
                    try {
                        throwable = null;
                        var12_21 = null;
                        try {
                            buffer = new BufferedReader(new FileReader(new File(additionalCSSPath)));
                            try {
                                userCSS = buffer.lines().collect(Collectors.joining("\n"));
                            }
                            finally {
                                if (buffer != null) {
                                    buffer.close();
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {}
                }
                resourcePath = GTK.GTK_VERSION < OS.VERSION(3, 20, 0) ? "/org/eclipse/swt/internal/gtk/swtgtk_pre320.css" : "/org/eclipse/swt/internal/gtk/swtgtk_320.css";
                try {
                    throwable = null;
                    var12_21 = null;
                    try {
                        buffer = new BufferedReader(new InputStreamReader(Device.class.getResourceAsStream(resourcePath)));
                        try {
                            String css = buffer.lines().collect(Collectors.joining("\n"));
                            String fullCSS = String.valueOf(css) + userCSS;
                            GTK.gtk_style_context_add_provider_for_screen(screen, provider, 600);
                            GTK.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(fullCSS, true), -1, null);
                        }
                        finally {
                            if (buffer != null) {
                                buffer.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public abstract int internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(path, true);
        return OS.FcConfigAppFontAddFile(0, buffer);
    }

    int logProc(int log_domain, int log_level, int message, int user_data) {
        if (DEBUG) {
            new Error().printStackTrace();
        }
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(log_domain, log_level, message, 0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == null) {
                    this.objects[i] = object;
                    this.errors[i] = new Error();
                    return;
                }
                ++i;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    static synchronized void register(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (Devices[i] == null) {
                Device.Devices[i] = device;
                return;
            }
            ++i;
        }
        Device[] newDevices = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, newDevices, 0, Devices.length);
        newDevices[Device.Devices.length] = device;
        Devices = newDevices;
    }

    protected void release() {
        if (this.shellHandle != 0) {
            GTK.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.gdkColors != null && !GTK.GTK3) {
            int colormap = GDK.gdk_colormap_get_system();
            int i = 0;
            while (i < this.gdkColors.length) {
                GdkColor color = this.gdkColors[i];
                if (color != null) {
                    while (this.colorRefCount[i] > 0) {
                        GDK.gdk_colormap_free_colors(colormap, color, 1);
                        int n = i;
                        this.colorRefCount[n] = this.colorRefCount[n] - 1;
                    }
                }
                ++i;
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.emptyTab != 0) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0;
        if (this.xDisplay != 0) {
            int i = 0;
            while (i < this.handler_ids.length) {
                if (this.handler_ids[i] != 0) {
                    byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                    OS.g_log_remove_handler(log_domain, this.handler_ids[i]);
                    this.handler_ids[i] = 0;
                }
                ++i;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0;
        }
        if (this.gsettingsCallback != null) {
            this.gsettingsCallback.dispose();
            this.gsettingsCallback = null;
        }
        this.gsettingsProc = 0;
    }

    public void setWarnings(boolean warnings) {
        block9: {
            block8: {
                this.checkDevice();
                if (!warnings) break block8;
                if (--this.warningLevel != 0) break block9;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0) {
                    int i = 0;
                    while (i < this.handler_ids.length) {
                        if (this.handler_ids[i] != 0) {
                            byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                            OS.g_log_remove_handler(log_domain, this.handler_ids[i]);
                            this.handler_ids[i] = 0;
                        }
                        ++i;
                    }
                }
                break block9;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0) {
                    int flags = -1;
                    int i = 0;
                    while (i < this.log_domains.length) {
                        byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                        this.handler_ids[i] = OS.g_log_set_handler(log_domain, flags, this.logProc, 0);
                        ++i;
                    }
                }
            }
        }
    }

    static int XErrorProc(int xDisplay, int xErrorEvent) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (device.warningLevel == 0) {
                boolean fixAIX;
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                boolean bl = fixAIX = OS.IsAIX && C.PTR_SIZEOF == 8;
                if (!fixAIX) {
                    OS.Call(XErrorProc, xDisplay, xErrorEvent);
                }
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, xDisplay, xErrorEvent);
        }
        return 0;
    }

    static int XIOErrorProc(int xDisplay) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, xDisplay, 0);
        return 0;
    }

    int _getDPIx() {
        return this.scaleFactor * 96 / 100;
    }

    protected int getDeviceZoom() {
        int screen = GDK.gdk_screen_get_default();
        int dpi = (int)GDK.gdk_screen_get_resolution(screen);
        if (dpi <= 0) {
            dpi = 96;
        }
        if (GTK.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            int monitor_num = GDK.gdk_screen_get_monitor_at_point(screen, 0, 0);
            int scale = GDK.gdk_screen_get_monitor_scale_factor(screen, monitor_num);
            dpi *= scale;
        }
        return DPIUtil.mapDPIToZoom(dpi);
    }

    protected int gsettingsProc(int gobject, int arg1, int user_data) {
        switch (user_data) {
            case 1: {
                this.scaleFactor = this.getDeviceZoom();
                DPIUtil.setDeviceZoom(this.scaleFactor);
            }
        }
        return 0;
    }
}

