/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class SetBinding
extends Binding {
    private UpdateSetStrategy targetToModel;
    private UpdateSetStrategy modelToTarget;
    private IObservableValue validationStatusObservable;
    private boolean updatingTarget;
    private boolean updatingModel;
    private ISetChangeListener targetChangeListener = event -> {
        if (!this.updatingTarget) {
            this.doUpdate((IObservableSet)this.getTarget(), (IObservableSet)this.getModel(), event.diff, this.targetToModel, false, false);
        }
    };
    private ISetChangeListener modelChangeListener = event -> {
        if (!this.updatingModel) {
            this.doUpdate((IObservableSet)this.getModel(), (IObservableSet)this.getTarget(), event.diff, this.modelToTarget, false, false);
        }
    };

    public SetBinding(IObservableSet target, IObservableSet model, UpdateSetStrategy targetToModelStrategy, UpdateSetStrategy modelToTargetStrategy) {
        super((IObservable)target, (IObservable)model);
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
    }

    @Override
    public IObservableValue getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateSetStrategy.POLICY_UPDATE) {
            this.getModel().getRealm().exec(() -> {
                ((IObservableSet)this.getModel()).addSetChangeListener(this.modelChangeListener);
                this.updateModelToTarget();
            });
        } else {
            this.modelChangeListener = null;
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateSetStrategy.POLICY_UPDATE) {
            this.getTarget().getRealm().exec(() -> {
                ((IObservableSet)this.getTarget()).addSetChangeListener(this.targetChangeListener);
                if (this.modelToTarget.getUpdatePolicy() == UpdateSetStrategy.POLICY_NEVER) {
                    this.updateTargetToModel();
                } else {
                    this.validateTargetToModel();
                }
            });
        } else {
            this.targetChangeListener = null;
        }
    }

    @Override
    public void updateModelToTarget() {
        IObservableSet modelSet = (IObservableSet)this.getModel();
        modelSet.getRealm().exec(() -> {
            SetDiff diff = Diffs.computeSetDiff((Set)Collections.EMPTY_SET, (Set)modelSet);
            this.doUpdate(modelSet, (IObservableSet)this.getTarget(), diff, this.modelToTarget, true, true);
        });
    }

    @Override
    public void updateTargetToModel() {
        IObservableSet targetSet = (IObservableSet)this.getTarget();
        targetSet.getRealm().exec(() -> {
            SetDiff diff = Diffs.computeSetDiff((Set)Collections.EMPTY_SET, (Set)targetSet);
            this.doUpdate(targetSet, (IObservableSet)this.getModel(), diff, this.targetToModel, true, true);
        });
    }

    @Override
    public void validateModelToTarget() {
    }

    @Override
    public void validateTargetToModel() {
    }

    private void doUpdate(IObservableSet source, IObservableSet destination, SetDiff diff, UpdateSetStrategy updateSetStrategy, boolean explicit, boolean clearDestination) {
        int policy = updateSetStrategy.getUpdatePolicy();
        if (policy == UpdateSetStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateSetStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        destination.getRealm().exec(() -> {
            if (destination == this.getTarget()) {
                this.updatingTarget = true;
            } else {
                this.updatingModel = true;
            }
            BindingStatus multiStatus = BindingStatus.ok();
            try {
                if (clearDestination) {
                    destination.clear();
                }
                Iterator iterator1 = diff.getRemovals().iterator();
                while (iterator1.hasNext()) {
                    IStatus setterStatus1 = updateSetStrategy.doRemove(destination, updateSetStrategy.convert(iterator1.next()));
                    this.mergeStatus(multiStatus, setterStatus1);
                }
                Iterator iterator2 = diff.getAdditions().iterator();
                while (iterator2.hasNext()) {
                    IStatus setterStatus2 = updateSetStrategy.doAdd(destination, updateSetStrategy.convert(iterator2.next()));
                    this.mergeStatus(multiStatus, setterStatus2);
                }
            }
            finally {
                this.setValidationStatus((IStatus)multiStatus);
                if (destination == this.getTarget()) {
                    this.updatingTarget = false;
                } else {
                    this.updatingModel = false;
                }
            }
        });
    }

    private void setValidationStatus(IStatus status) {
        this.validationStatusObservable.getRealm().exec(() -> this.validationStatusObservable.setValue((Object)status));
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            ((IObservableSet)this.getTarget()).removeSetChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            ((IObservableSet)this.getModel()).removeSetChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

