/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DefaultExceptionHandler;
import org.eclipse.swt.internal.GDBus;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkKeymapKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int gdkEventCount;
    long[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    long fds;
    int allocated_nfds;
    boolean wake;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    Callback filterCallback;
    long eventProc;
    long filterProc;
    long windowProc2;
    long windowProc3;
    long windowProc4;
    long windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    long[] closures;
    long[] closuresProc;
    int[] closuresCount;
    int[] signalIds;
    long shellMapProcClosure;
    int[] indexTable;
    int freeSlot;
    long lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    Shell[] modalShells;
    Dialog modalDialog;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    boolean ignoreActivate;
    boolean ignoreFocus;
    Tracker tracker;
    Control imControl;
    long preeditWindow;
    long preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Consumer<RuntimeException> runtimeExceptionHandler = DefaultExceptionHandler.RUNTIME_EXCEPTION_HANDLER;
    Consumer<Error> errorHandler = DefaultExceptionHandler.RUNTIME_ERROR_HANDLER;
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    long timerProc;
    Callback windowTimerCallback;
    long windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    long caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    long mouseHoverHandle;
    long mouseHoverProc;
    Callback mouseHoverCallback;
    long sizeAllocateProc;
    Callback sizeAllocateCallback;
    long sizeRequestProc;
    Callback sizeRequestCallback;
    long shellMapProc;
    Callback shellMapCallback;
    long idleProc;
    int idleHandle;
    Callback idleCallback;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    Object idleLock = new Object();
    boolean idleNeeded;
    long cellDataProc;
    Callback cellDataCallback;
    long setDirectionProc;
    Callback setDirectionCallback;
    static final String GET_DIRECTION_PROC_KEY = "org.eclipse.swt.internal.gtk.getDirectionProc";
    long emissionProc;
    Callback emissionProcCallback;
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";
    long allChildrenProc;
    long allChildren;
    Callback allChildrenCallback;
    long signalProc;
    Callback signalCallback;
    long shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    static final int STYLE_SET = 1;
    static final int PROPERTY_NOTIFY = 2;
    boolean entrySelectOnFocus;
    Control currentControl;
    long checkIfEventProc;
    Callback checkIfEventCallback;
    long flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    long[] flushData = new long[1];
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_LIST_SELECTION_INACTIVE;
    GdkColor COLOR_LIST_SELECTION_TEXT_INACTIVE;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_LINK_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    GdkRGBA COLOR_WIDGET_DARK_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_NORMAL_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_LIGHT_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_BACKGROUND_RGBA;
    GdkRGBA COLOR_WIDGET_FOREGROUND_RGBA;
    GdkRGBA COLOR_WIDGET_BORDER_RGBA;
    GdkRGBA COLOR_LIST_FOREGROUND_RGBA;
    GdkRGBA COLOR_LIST_BACKGROUND_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_TEXT_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_INACTIVE_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA;
    GdkRGBA COLOR_INFO_BACKGROUND_RGBA;
    GdkRGBA COLOR_INFO_FOREGROUND_RGBA;
    GdkRGBA COLOR_LINK_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_BACKGROUND_RGBA;
    GdkRGBA COLOR_TITLE_BACKGROUND_GRADIENT_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_BACKGROUND_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA;
    ArrayList<String> colorList;
    final int SWT_COLOR_LIST_SELECTION_TEXT_INACTIVE = 38;
    final int SWT_COLOR_LIST_SELECTION_INACTIVE = 39;
    Menu[] popups;
    int clickCount = 1;
    static final int INNER_BORDER = 2;
    int lastEventTime;
    int lastUserEventTime;
    long pangoLayoutNewProc;
    long pangoFontFamilyNewProc;
    long pangoFontFaceNewProc;
    long imContextNewProc;
    long printerOptionWidgetNewProc;
    double resizeLocationX;
    double resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static long fixed_type;
    static long fixed_info_ptr;
    static Callback fixedClassInitCallback;
    static Callback fixedMapCallback;
    static Callback fixedSizeAllocateCallback;
    static long fixedClassInitProc;
    static long fixedMapProc;
    static long fixedSizeAllocateProc;
    static long oldFixedSizeAllocateProc;
    static long text_renderer_type;
    static long pixbuf_renderer_type;
    static long toggle_renderer_type;
    static long text_renderer_info_ptr;
    static long pixbuf_renderer_info_ptr;
    static long toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererGetSizeCallback;
    static Callback rendererGetPreferredWidthCallback;
    static long rendererClassInitProc;
    static long rendererRenderProc;
    static long rendererGetSizeProc;
    static long rendererGetPreferredWidthProc;
    static final int[][] KeyTable;
    private int latinKeyGroup;
    long keysChangedProc;
    Callback keysChangedCallback;
    static Display Default;
    static Display[] Displays;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int GTK3_MAJOR = 3;
    static final int GTK3_MINOR = 0;
    static final int GTK3_MICRO = 0;
    static final int GTK2_MAJOR = 2;
    static final int GTK2_MINOR = 24;
    static final int GTK2_MICRO = 0;
    Object data;
    String[] keys;
    Object[] values;
    static final int TRIM_NONE = 0;
    static final int TRIM_BORDER = 1;
    static final int TRIM_RESIZE = 2;
    static final int TRIM_TITLE_BORDER = 3;
    static final int TRIM_TITLE_RESIZE = 4;
    static final int TRIM_TITLE = 5;
    int[] trimWidths = new int[6];
    int[] trimHeights = new int[6];
    boolean ignoreTrim;
    String windowManager;

    static {
        byte[] buffer = Converter.wcsToMbcs("SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string(buffer);
        buffer = Converter.wcsToMbcs("SWT_OBJECT_INDEX1", true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string(buffer);
        buffer = Converter.wcsToMbcs("SWT_OBJECT_INDEX2", true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string(buffer);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[4];
        DeviceFinder = () -> {
            Display device = Display.getCurrent();
            if (device == null) {
                device = Display.getDefault();
            }
            Display.setDevice(device);
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
        File file;
        this.trimWidths[0] = 0;
        this.trimHeights[0] = 0;
        this.trimWidths[1] = 4;
        this.trimHeights[1] = 4;
        this.trimWidths[2] = 6;
        this.trimHeights[2] = 6;
        this.trimWidths[3] = 5;
        this.trimHeights[3] = 28;
        this.trimWidths[4] = 6;
        this.trimHeights[4] = 29;
        this.trimWidths[5] = 0;
        this.trimHeights[5] = 23;
        String path = System.getProperty("user.home");
        if (path != null && (file = new File(path, ".swt/trims.prefs")).exists() && file.isFile()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    props.load(fis);
                    String trimWidthsString = props.getProperty("trimWidths");
                    String trimHeightsString = props.getProperty("trimHeights");
                    if (trimWidthsString != null && trimHeightsString != null) {
                        StringTokenizer tok = new StringTokenizer(trimWidthsString);
                        int i = 0;
                        while (i < this.trimWidths.length && tok.hasMoreTokens()) {
                            this.trimWidths[i] = Integer.parseInt(tok.nextToken());
                            ++i;
                        }
                        tok = new StringTokenizer(trimHeightsString);
                        i = 0;
                        while (i < this.trimHeights.length && tok.hasMoreTokens()) {
                            this.trimHeights[i] = Integer.parseInt(tok.nextToken());
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NumberFormatException exception) {}
        }
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    void addGdkEvent(long event) {
        int length;
        if (this.gdkEvents == null) {
            length = 1024;
            this.gdkEvents = new long[length];
            this.gdkEventWidgets = new Widget[length];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            length = this.gdkEventCount + 1024;
            long[] newEvents = new long[length];
            System.arraycopy(this.gdkEvents, 0, newEvents, 0, this.gdkEventCount);
            this.gdkEvents = newEvents;
            Widget[] newWidgets = new Widget[length];
            System.arraycopy(this.gdkEventWidgets, 0, newWidgets, 0, this.gdkEventCount);
            this.gdkEventWidgets = newWidgets;
        }
        Widget widget = null;
        long handle = GTK.gtk_get_event_widget(event);
        if (handle != 0L) {
            while ((widget = this.getWidget(handle)) == null && (handle = GTK.gtk_widget_get_parent(handle)) != 0L) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = event;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            this.idleNeeded = true;
            if (this.idleHandle == 0) {
                this.idleHandle = OS.g_idle_add(this.idleProc, 0L);
            }
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        if (eventType == 46 || eventType == 54) {
            this.gdbus_init_methods();
        }
        this.eventTable.hook(eventType, listener);
    }

    private void gdbus_init_methods() {
        GDBus.GDBusMethod[] methods = new GDBus.GDBusMethod[]{new GDBus.GDBusMethod("FileOpen", new String[][]{{"as", "A String array containing file paths or URLs for OpenDocument/OpenUrl signal"}}, new String[0][0], args -> {
            String[] fileNames = (String[])args[0];
            int i = 0;
            while (i < fileNames.length) {
                block4: {
                    Event event = new Event();
                    event.text = fileNames[i];
                    try {
                        if (new URI(fileNames[i]).getScheme() != null) {
                            this.sendEvent(54, event);
                            break block4;
                        }
                        throw new URISyntaxException(fileNames[i], "Not a valid Url. Probably file.");
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.sendEvent(46, event);
                    }
                }
                ++i;
            }
            return null;
        })};
        GDBus.init(methods);
    }

    long allChildrenProc(long widget, long recurse) {
        this.allChildren = OS.g_list_append(this.allChildren, widget);
        if (recurse != 0L && GTK.GTK_IS_CONTAINER(widget)) {
            GTK.gtk_container_forall(widget, this.allChildrenProc, recurse);
        }
        return 0L;
    }

    void addMouseHoverTimeout(long handle) {
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = OS.g_timeout_add(400, this.mouseHoverProc, handle);
        this.mouseHoverHandle = handle;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(long handle, Widget widget) {
        if (handle == 0L) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        int index = this.freeSlot + 1;
        OS.g_object_set_qdata(handle, SWT_OBJECT_INDEX, index);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0L);
                }
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        GDK.gdk_beep();
        if (!OS.isX11()) {
            GDK.gdk_flush();
        } else {
            long xDisplay = GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default());
            OS.XFlush(xDisplay);
        }
    }

    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0L;
        }
        return widget.cellDataProc(tree_column, cell, tree_model, iter, data);
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long checkIfEventProc(long display, long xEvent, long userData) {
        int type = OS.X_EVENT_TYPE(xEvent);
        switch (type) {
            case 12: 
            case 13: {
                break;
            }
            default: {
                return 0L;
            }
        }
        long window = GDK.gdk_x11_window_lookup_for_display(GDK.gdk_display_get_default(), OS.X_EVENT_WINDOW(xEvent));
        if (window == 0L) {
            return 0L;
        }
        if (this.flushWindow != 0L) {
            if (this.flushAll) {
                long tempWindow = window;
                while (tempWindow != this.flushWindow && (tempWindow = GDK.gdk_window_get_parent(tempWindow)) != 0L) {
                }
                if (tempWindow != this.flushWindow) {
                    return 0L;
                }
            } else if (window != this.flushWindow) {
                return 0L;
            }
        }
        OS.memmove(this.exposeEvent, xEvent, (long)XExposeEvent.sizeof);
        switch (type) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = Math.max(0, this.exposeEvent.width);
                this.flushRect.height = Math.max(0, this.exposeEvent.height);
                GDK.gdk_window_invalidate_rect(window, this.flushRect, true);
                this.exposeEvent.type = -1;
                OS.memmove(xEvent, this.exposeEvent, (long)XExposeEvent.sizeof);
            }
        }
        return 0L;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) break;
            if (this.modalShells[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        byte[] type_name;
        int major;
        long ptr;
        if (OS.GLIB_VERSION < OS.VERSION(2, 32, 0) && !OS.g_thread_supported()) {
            OS.g_thread_init(0L);
        }
        if (!GTK.gtk_init_check(new long[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        System.setProperty("org.eclipse.swt.internal.gtk.theme", OS.getThemeName());
        if (OS.isX11()) {
            this.xDisplay = GDK.gdk_x11_get_default_xdisplay();
        }
        if ((ptr = (major = GTK.gtk_major_version()) == 3 ? GTK.gtk_check_version(3, 0, 0) : GTK.gtk_check_version(2, 24, 0)) != 0L) {
            int length = C.strlen(ptr);
            byte[] buffer = new byte[length];
            C.memmove(buffer, ptr, (long)length);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(buffer)));
            System.out.println("***WARNING: SWT requires GTK 2.24.0");
            int minor = GTK.gtk_minor_version();
            int micro = GTK.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + major + "." + minor + "." + micro);
        }
        if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 9, 4)) {
            System.out.println("***WARNING: SWT requires Cairo 1.9.4 or newer");
            String version = Converter.cCharPtrToJavaString(Cairo.cairo_version_string(), false);
            System.out.println("***WARNING: Detected: " + version);
        }
        if (GTK.GTK3) {
            fixed_type = OS.swt_fixed_get_type();
        }
        if (fixed_type == 0L) {
            byte[] type_name2 = Converter.wcsToMbcs("SwtFixed", true);
            fixedClassInitCallback = new Callback(this.getClass(), "fixedClassInitProc", 2);
            fixedClassInitProc = fixedClassInitCallback.getAddress();
            if (fixedClassInitProc == 0L) {
                this.error(3);
            }
            if ((fixedMapProc = (fixedMapCallback = new Callback(this.getClass(), "fixedMapProc", 1)).getAddress()) == 0L) {
                this.error(3);
            }
            if ((fixedSizeAllocateProc = (fixedSizeAllocateCallback = new Callback(this.getClass(), "fixedSizeAllocateProc", 2)).getAddress()) == 0L) {
                this.error(3);
            }
            long queryPtr = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(GTK.GTK_TYPE_FIXED(), queryPtr);
            GTypeQuery query = new GTypeQuery();
            OS.memmove(query, queryPtr, (long)GTypeQuery.sizeof);
            OS.g_free(queryPtr);
            GTypeInfo fixed_info = new GTypeInfo();
            fixed_info.class_size = (short)query.class_size;
            fixed_info.class_init = fixedClassInitProc;
            fixed_info.instance_size = (short)query.instance_size;
            fixed_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(fixed_info_ptr, fixed_info, GTypeInfo.sizeof);
            fixed_type = OS.g_type_register_static(GTK.GTK_TYPE_FIXED(), type_name2, fixed_info_ptr, 0);
        }
        if (rendererClassInitProc == 0L && (rendererClassInitProc = (rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2)).getAddress()) == 0L) {
            this.error(3);
        }
        if (rendererRenderProc == 0L && (rendererRenderProc = (rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", GTK.GTK3 ? 6 : 7)).getAddress()) == 0L) {
            this.error(3);
        }
        if (GTK.GTK3) {
            if (rendererGetPreferredWidthProc == 0L && (rendererGetPreferredWidthProc = (rendererGetPreferredWidthCallback = new Callback(this.getClass(), "rendererGetPreferredWidthProc", 4)).getAddress()) == 0L) {
                this.error(3);
            }
        } else if (rendererGetSizeProc == 0L && (rendererGetSizeProc = (rendererGetSizeCallback = new Callback(this.getClass(), "rendererGetSizeProc", 7)).getAddress()) == 0L) {
            this.error(3);
        }
        if (text_renderer_type == 0L) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)GTK.GtkCellRendererTextClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)GTK.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs("SwtTextRenderer", true);
            text_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_TEXT(), type_name, text_renderer_info_ptr, 0);
        }
        if (pixbuf_renderer_type == 0L) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)GTK.GtkCellRendererPixbufClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)GTK.GtkCellRendererPixbuf_sizeof();
            pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(pixbuf_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs("SwtPixbufRenderer", true);
            pixbuf_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_PIXBUF(), type_name, pixbuf_renderer_info_ptr, 0);
        }
        if (toggle_renderer_type == 0L) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)GTK.GtkCellRendererToggleClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)GTK.GtkCellRendererToggle_sizeof();
            toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(toggle_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs("SwtToggleRenderer", true);
            toggle_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_TOGGLE(), type_name, toggle_renderer_info_ptr, 0);
        }
        GTK.gtk_widget_set_default_direction(1);
        byte[] buffer = Converter.wcsToMbcs(APP_NAME, true);
        OS.g_set_prgname(buffer);
        GDK.gdk_set_program_class(buffer);
        if (!GTK.GTK3) {
            byte[] flatStyle = Converter.wcsToMbcs("style \"swt-flat\" { GtkToolbar::shadow-type = none } widget \"*.swt-toolbar-flat\" style : highest \"swt-flat\"", true);
            GTK.gtk_rc_parse_string(flatStyle);
        }
        this.shellHandle = GTK.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_realize(this.shellHandle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0L) {
            this.error(3);
        }
        GDK.gdk_event_handler_set(this.eventProc, 0L, 0L);
        this.filterCallback = new Callback(this, "filterProc", 3);
        this.filterProc = this.filterCallback.getAddress();
        if (this.filterProc == 0L) {
            this.error(3);
        }
        GDK.gdk_window_add_filter(0L, this.filterProc, 0L);
        byte[] atomName = Converter.wcsToMbcs("SWT_Window_" + APP_NAME, true);
        long atom = GDK.gdk_atom_intern(atomName, false);
        GDK.gdk_selection_owner_set(GTK.gtk_widget_get_window(this.shellHandle), atom, 0, false);
        GDK.gdk_selection_owner_get(atom);
        this.signalCallback = new Callback(this, "signalProc", 3);
        this.signalProc = this.signalCallback.getAddress();
        if (this.signalProc == 0L) {
            this.error(3);
        }
        GTK.gtk_widget_add_events(this.shellHandle, 65536);
        OS.g_signal_connect(this.shellHandle, OS.property_notify_event, this.signalProc, 2L);
        this.latinKeyGroup = this.findLatinKeyGroup();
        this.keysChangedCallback = new Callback(this, "keysChangedProc", 2);
        this.keysChangedProc = this.keysChangedCallback.getAddress();
        if (this.keysChangedProc == 0L) {
            this.error(3);
        }
        OS.g_signal_connect(GDK.gdk_keymap_get_default(), OS.keys_changed, this.keysChangedProc, 0L);
    }

    private int findLatinKeyGroup() {
        int result = 0;
        HashMap<Integer, Integer> groupKeysCount = new HashMap<Integer, Integer>();
        long keymap = GDK.gdk_keymap_get_default();
        int keyval = 97;
        while (keyval <= 122) {
            long[] keys = new long[1];
            int[] n_keys = new int[1];
            if (GDK.gdk_keymap_get_entries_for_keyval(keymap, keyval, keys, n_keys)) {
                GdkKeymapKey key_entry = new GdkKeymapKey();
                int key = 0;
                while (key < n_keys[0]) {
                    OS.memmove(key_entry, keys[0] + (long)(key * GdkKeymapKey.sizeof), (long)GdkKeymapKey.sizeof);
                    Integer keys_count = (Integer)groupKeysCount.get(key_entry.group);
                    keys_count = keys_count != null ? Integer.valueOf(keys_count + 1) : Integer.valueOf(1);
                    groupKeysCount.put(key_entry.group, keys_count);
                    ++key;
                }
                OS.g_free(keys[0]);
            }
            ++keyval;
        }
        int max_keys_count = 0;
        for (Map.Entry entry : groupKeysCount.entrySet()) {
            Integer group = (Integer)entry.getKey();
            Integer keys_count = (Integer)entry.getValue();
            if (keys_count <= max_keys_count) continue;
            result = group;
            max_keys_count = keys_count;
        }
        return result;
    }

    int getLatinKeyGroup() {
        return this.latinKeyGroup;
    }

    long keysChangedProc(long keymap, long user_data) {
        this.latinKeyGroup = this.findLatinKeyGroup();
        return 0L;
    }

    Image createImage(String name) {
        byte[] buffer = Converter.wcsToMbcs(name, true);
        long pixbuf = GTK.gtk_icon_theme_load_icon(GTK.gtk_icon_theme_get_default(), buffer, 48, 4, 0L);
        if (pixbuf == 0L) {
            return null;
        }
        int width = GDK.gdk_pixbuf_get_width(pixbuf);
        int height = GDK.gdk_pixbuf_get_height(pixbuf);
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        byte[] data = new byte[stride * height];
        C.memmove(data, pixels, (long)data.length);
        OS.g_object_unref(pixbuf);
        ImageData imageData = null;
        if (hasAlpha) {
            PaletteData palette = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(width, height, 32, palette);
            byte[] alpha = new byte[stride * height];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    alpha[y * width + x] = data[y * stride + x * 4 + 3];
                    data[y * stride + x * 4 + 3] = 0;
                    ++x;
                }
                ++y;
            }
            imageData.setAlphas(0, 0, width * height, alpha, 0);
        } else {
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(width, height, 24, palette);
        }
        imageData.data = data;
        imageData.bytesPerLine = stride;
        return new Image((Device)this, imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    long emissionProc(long ihint, long n_param_values, long param_values, long data) {
        if (GTK.gtk_widget_get_toplevel(OS.g_value_peek_pointer(param_values)) == data) {
            GTK.gtk_widget_set_direction(OS.g_value_peek_pointer(param_values), 2);
        }
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    long eventProc(long event, long data) {
        int time = GDK.gdk_event_get_time(event);
        if (time != 0) {
            this.lastEventTime = time;
        }
        int eventType = GDK.GDK_EVENT_TYPE(event);
        switch (eventType) {
            case 4: 
            case 8: {
                this.lastUserEventTime = time;
            }
        }
        boolean dispatch = true;
        if (this.dispatchEvents != null) {
            dispatch = false;
            int i = 0;
            while (i < this.dispatchEvents.length) {
                if (eventType == this.dispatchEvents[i]) {
                    dispatch = true;
                    break;
                }
                ++i;
            }
        }
        if (!dispatch) {
            this.addGdkEvent(GDK.gdk_event_copy(event));
            return 0L;
        }
        dispatch = true;
        if (this.tracker != null) {
            dispatch = this.tracker.processEvent(event);
        }
        if (dispatch) {
            GTK.gtk_main_do_event(event);
        }
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        return 0L;
    }

    public Widget findWidget(long handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(long handle, long id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, long id) {
        this.checkDevice();
        return null;
    }

    static long fixedClassInitProc(long g_class, long class_data) {
        GtkWidgetClass klass = new GtkWidgetClass();
        OS.memmove(klass, g_class);
        klass.map = fixedMapProc;
        oldFixedSizeAllocateProc = klass.size_allocate;
        klass.size_allocate = fixedSizeAllocateProc;
        OS.memmove(g_class, klass);
        return 0L;
    }

    static long fixedMapProc(long handle) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.fixedMapProc(handle);
        }
        return 0L;
    }

    static long fixedSizeAllocateProc(long handle, long allocation) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.fixedSizeAllocateProc(handle, allocation);
        }
        return OS.Call(oldFixedSizeAllocateProc, handle, allocation);
    }

    static long rendererClassInitProc(long g_class, long class_data) {
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        klass.render = rendererRenderProc;
        if (GTK.GTK3) {
            klass.get_preferred_width = rendererGetPreferredWidthProc;
        } else {
            klass.get_size = rendererGetSizeProc;
        }
        OS.memmove(g_class, klass);
        return 0L;
    }

    static long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererGetPreferredWidthProc(cell, handle, minimun_size, natural_size);
        }
        return 0L;
    }

    static long rendererGetSizeProc(long cell, long handle, long cell_area, long x_offset, long y_offset, long width, long height) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererGetSizeProc(cell, handle, cell_area, x_offset, y_offset, width, height);
        }
        return 0L;
    }

    static long rendererRenderProc(long cell, long cr, long handle, long background_area, long cell_area, long flags) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererRenderProc(cell, cr, handle, background_area, cell_area, flags);
        }
        return 0L;
    }

    static long rendererRenderProc(long cell, long window, long handle, long background_area, long cell_area, long expose_area, long flags) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererRenderProc(cell, window, handle, background_area, cell_area, expose_area, flags);
        }
        return 0L;
    }

    void flushExposes(long window, boolean all) {
        GDK.gdk_flush();
        GDK.gdk_flush();
        if (OS.isX11()) {
            this.flushWindow = window;
            this.flushAll = all;
            long xDisplay = GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default());
            long xEvent = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(xDisplay, xEvent, this.checkIfEventProc, 0L);
            OS.g_free(xEvent);
            this.flushWindow = 0L;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        return new Rectangle(0, 0, GDK.gdk_screen_width(), GDK.gdk_screen_height());
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        long settings = GTK.gtk_settings_get_default();
        if (settings == 0L) {
            return 500;
        }
        int[] buffer = new int[1];
        OS.g_object_get(settings, GTK.gtk_cursor_blink, buffer, 0L);
        if (buffer[0] == 0) {
            return 0;
        }
        OS.g_object_get(settings, GTK.gtk_cursor_blink_time, buffer, 0L);
        if (buffer[0] == 0) {
            return 500;
        }
        return buffer[0] / 2;
    }

    long getClosure(int id) {
        if (OS.GLIB_VERSION >= OS.VERSION(2, 36, 0)) {
            int n = id;
            this.closuresCount[n] = this.closuresCount[n] + 1;
            if (this.closuresCount[n] >= 255) {
                if (this.closures[id] != 0L) {
                    OS.g_closure_unref(this.closures[id]);
                }
                this.closures[id] = OS.g_cclosure_new(this.closuresProc[id], id, 0L);
                OS.g_closure_ref(this.closures[id]);
                OS.g_closure_sink(this.closures[id]);
                this.closuresCount[id] = 0;
            }
        }
        return this.closures[id];
    }

    public Control getCursorControl() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        long handle = 0L;
        long[] user_data = new long[1];
        long window = this.gdk_device_get_window_at_position(x, y);
        if (window != 0L) {
            GDK.gdk_window_get_user_data(window, user_data);
            handle = user_data[0];
        } else {
            long xWindow;
            if (!OS.isX11()) {
                return null;
            }
            GDK.gdk_error_trap_push();
            int[] unusedInt = new int[1];
            long[] unusedPtr = new long[1];
            long[] buffer = new long[1];
            long xParent = OS.XDefaultRootWindow(this.xDisplay);
            do {
                if (OS.XQueryPointer(this.xDisplay, xParent, unusedPtr, buffer, unusedInt, unusedInt, unusedInt, unusedInt, unusedInt) == 0) {
                    handle = 0L;
                    break;
                }
                xWindow = buffer[0];
                if (xWindow == 0L) continue;
                xParent = xWindow;
                long gdkWindow = GDK.gdk_x11_window_lookup_for_display(GDK.gdk_display_get_default(), xWindow);
                if (gdkWindow == 0L) continue;
                GDK.gdk_window_get_user_data(gdkWindow, user_data);
                if (user_data[0] == 0L) continue;
                handle = user_data[0];
            } while (xWindow != 0L);
            GDK.gdk_error_trap_pop();
        }
        if (handle == 0L) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) continue;
            return control;
        } while ((handle = GTK.gtk_widget_get_parent(handle)) != 0L);
        return null;
    }

    static GtkBorder getEntryInnerBorder(long handle) {
        GtkBorder gtkBorder = new GtkBorder();
        long border = GTK.gtk_entry_get_inner_border(handle);
        if (border != 0L) {
            OS.memmove(gtkBorder, border, (long)GtkBorder.sizeof);
            return gtkBorder;
        }
        long[] borderPtr = new long[1];
        GTK.gtk_widget_style_get(handle, OS.inner_border, borderPtr, 0L);
        if (borderPtr[0] != 0L) {
            OS.memmove(gtkBorder, borderPtr[0], (long)GtkBorder.sizeof);
            GTK.gtk_border_free(borderPtr[0]);
            return gtkBorder;
        }
        gtkBorder.left = 2;
        gtkBorder.top = 2;
        gtkBorder.right = 2;
        gtkBorder.bottom = 2;
        return gtkBorder;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int type = event.type;
            this.sendPreEvent(type);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(type);
            }
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    long filterProc(long xEvent, long gdkEvent, long data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0L;
        }
        return widget.filterProc(xEvent, gdkEvent, data);
    }

    public Point getCursorLocation() {
        return DPIUtil.autoScaleDown(this.getCursorLocationInPixels());
    }

    Point getCursorLocationInPixels() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        this.gdk_window_get_device_position(0L, x, y, null);
        if (!OS.isX11() && this.activeShell != null) {
            Shell tempShell = this.activeShell;
            int[] offsetX = new int[1];
            int[] offsetY = new int[1];
            while (tempShell.getParent() != null) {
                GTK.gtk_window_get_position(tempShell.shellHandle, offsetX, offsetY);
                x[0] = x[0] + offsetX[0];
                y[0] = y[0] + offsetY[0];
                tempShell = tempShell.getParent().getShell();
            }
        }
        return new Point(x[0], y[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (key.equals(GET_MODAL_DIALOG)) {
            return this.modalDialog;
        }
        if (key.equals(GET_DIRECTION_PROC_KEY)) {
            return new LONG(this.setDirectionProc);
        }
        if (key.equals(GET_EMISSION_PROC_KEY)) {
            return new LONG(this.emissionProc);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    long gtk_fixed_get_type() {
        return fixed_type;
    }

    long gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    long gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    long gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    String gtk_css_create_css_color_string(String background, String foreground, int property) {
        switch (property) {
            case 16: {
                if (foreground != null && background != null) {
                    return String.valueOf(foreground) + "\n" + background;
                }
                if (foreground != null) {
                    return foreground;
                }
                return "";
            }
            case 8: {
                if (foreground != null && background != null) {
                    return String.valueOf(background) + "\n" + foreground;
                }
                if (background != null) {
                    return background;
                }
                return "";
            }
        }
        return "";
    }

    String gtk_css_default_theme_values(int swt) {
        byte[] buffer = OS.getThemeNameBytes();
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        long themeProvider = GTK.gtk_css_provider_get_named(buffer, null);
        long str = GTK.gtk_css_provider_to_string(themeProvider);
        int length = C.strlen(str);
        if (length == 0) {
            return "";
        }
        byte[] themeBuffer = new byte[length];
        C.memmove(themeBuffer, str, (long)length);
        String cssOutput = new String(Converter.mbcsToWcs(themeBuffer));
        String color = "";
        switch (swt) {
            case 28: {
                return this.gtk_css_default_theme_values_irregular(swt, cssOutput, themeProvider);
            }
            case 29: {
                return this.gtk_css_default_theme_values_irregular(swt, cssOutput, themeProvider);
            }
            case 36: {
                return this.gtk_css_default_theme_values_irregular(swt, cssOutput, themeProvider);
            }
            case 25: {
                int tSelected = cssOutput.indexOf("@define-color theme_base_color");
                int selected = cssOutput.indexOf("@define-color base_color");
                if (!(tSelected != -1 ? !(color = this.simple_color_parser(cssOutput, "@define-color theme_base_color", tSelected)).isEmpty() : selected != -1 && !(color = this.simple_color_parser(cssOutput, "@define-color base_color", selected)).isEmpty())) break;
                break;
            }
            case 24: {
                int tSelected = cssOutput.indexOf("@define-color theme_text_color");
                int selected = cssOutput.indexOf("@define-color text_color");
                if (!(tSelected != -1 ? !(color = this.simple_color_parser(cssOutput, "@define-color theme_text_color", tSelected)).isEmpty() : selected != -1 && !(color = this.simple_color_parser(cssOutput, "@define-color text_color", selected)).isEmpty())) break;
                break;
            }
            case 26: {
                int tSelected = cssOutput.indexOf("@define-color theme_selected_bg_color");
                int selected = cssOutput.indexOf("@define-color selected_bg_color");
                if (!(tSelected != -1 ? !(color = this.simple_color_parser(cssOutput, "@define-color theme_selected_bg_color", tSelected)).isEmpty() : selected != -1 && !(color = this.simple_color_parser(cssOutput, "@define-color selected_bg_color", selected)).isEmpty())) break;
                break;
            }
            case 39: {
                int tSelected = cssOutput.indexOf("@define-color theme_unfocused_selected_bg_color");
                if (tSelected == -1 || (color = this.simple_color_parser(cssOutput, "@define-color theme_unfocused_selected_bg_color", tSelected)).isEmpty()) break;
                break;
            }
            case 27: {
                int tSelected = cssOutput.indexOf("@define-color theme_selected_fg_color");
                int selected = cssOutput.indexOf("@define-color selected_fg_color");
                if (!(tSelected != -1 ? !(color = this.simple_color_parser(cssOutput, "@define-color theme_selected_fg_color", tSelected)).isEmpty() : selected != -1 && !(color = this.simple_color_parser(cssOutput, "@define-color selected_fg_color", selected)).isEmpty())) break;
                break;
            }
            case 38: {
                int tSelected = cssOutput.indexOf("@define-color theme_unfocused_selected_fg_color");
                if (tSelected == -1 || (color = this.simple_color_parser(cssOutput, "@define-color theme_unfocused_selected_fg_color", tSelected)).isEmpty()) break;
                break;
            }
            case 33: {
                int tSelected = cssOutput.indexOf("@define-color insensitive_fg_color");
                if (tSelected == -1 || (color = this.simple_color_parser(cssOutput, "@define-color insensitive_fg_color", tSelected)).isEmpty()) break;
                break;
            }
            case 34: {
                int tSelected = cssOutput.indexOf("@define-color insensitive_bg_color");
                if (tSelected == -1 || (color = this.simple_color_parser(cssOutput, "@define-color insensitive_bg_color", tSelected)).isEmpty()) break;
                break;
            }
            case 22: {
                int tSelected = cssOutput.indexOf("@define-color theme_bg_color");
                int selected = cssOutput.indexOf("@define-color bg_color");
                if (!(tSelected != -1 ? !(color = this.simple_color_parser(cssOutput, "@define-color theme_bg_color", tSelected)).isEmpty() : selected != -1 && !(color = this.simple_color_parser(cssOutput, "@define-color bg_color", selected)).isEmpty())) break;
                break;
            }
            case 21: {
                int tSelected = cssOutput.indexOf("@define-color theme_fg_color");
                int selected = cssOutput.indexOf("@define-color fg_color");
                if (!(tSelected != -1 ? !(color = this.simple_color_parser(cssOutput, "@define-color theme_fg_color", tSelected)).isEmpty() : selected != -1 && !(color = this.simple_color_parser(cssOutput, "@define-color fg_color", selected)).isEmpty())) break;
                break;
            }
            default: {
                return "";
            }
        }
        return color;
    }

    String gtk_css_default_theme_values_irregular(int swt, String cssOutput, long themeProvider) {
        String color = "";
        switch (swt) {
            case 28: {
                int selected = cssOutput.indexOf("@define-color tooltip_fg_color");
                int tSelected = cssOutput.indexOf("@define-color theme_tooltip_fg_color");
                int classDef = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? cssOutput.indexOf("tooltip * {") : cssOutput.indexOf(".tooltip {");
                if (selected != -1 || tSelected != -1) {
                    if (selected != -1) {
                        color = this.simple_color_parser(cssOutput, "@define-color tooltip_fg_color", selected);
                    } else if (tSelected != -1) {
                        color = this.simple_color_parser(cssOutput, "@define-color theme_tooltip_fg_color", tSelected);
                    }
                    if (color.isEmpty()) break;
                    break;
                }
                if (classDef == -1) break;
                this.COLOR_INFO_FOREGROUND_RGBA = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.gtk_css_parse_foreground(themeProvider, "tooltip * {") : this.gtk_css_parse_foreground(themeProvider, ".tooltip {");
                return "parsed";
            }
            case 29: {
                int selected = cssOutput.indexOf("@define-color tooltip_bg_color");
                int tSelected = cssOutput.indexOf("@define-color theme_tooltip_bg_color");
                int classDef = cssOutput.indexOf("tooltip.background {");
                if (selected != -1 || tSelected != -1) {
                    if (selected != -1) {
                        color = this.simple_color_parser(cssOutput, "@define-color tooltip_bg_color", selected);
                    } else if (tSelected != -1) {
                        color = this.simple_color_parser(cssOutput, "@define-color theme_tooltip_bg_color", tSelected);
                    }
                    if (color.isEmpty()) break;
                    break;
                }
                if (classDef == -1) break;
                this.COLOR_INFO_BACKGROUND_RGBA = this.gtk_css_parse_background(themeProvider, "tooltip.background {");
                return "parsed";
            }
            case 36: {
                int selected = cssOutput.indexOf("@define-color link_color");
                int tSelected = cssOutput.indexOf("@define-color theme_link_color");
                int classDef = cssOutput.indexOf("*:link {");
                int selectedBg = cssOutput.indexOf("@define-color link_color @selected_bg_color");
                if (selected != -1 || tSelected != -1) {
                    if (selected != -1) {
                        color = this.simple_color_parser(cssOutput, "@define-color link_color", selected);
                    } else if (tSelected != -1) {
                        color = this.simple_color_parser(cssOutput, "@define-color theme_link_color", tSelected);
                    }
                    if (color.isEmpty()) break;
                    break;
                }
                if (selectedBg != -1) {
                    this.COLOR_LINK_FOREGROUND_RGBA = this.COLOR_LIST_SELECTION_RGBA;
                    return "parsed";
                }
                if (classDef == -1) break;
                this.COLOR_LINK_FOREGROUND_RGBA = this.gtk_css_parse_foreground(themeProvider, "*:link {");
                return "parsed";
            }
        }
        return color;
    }

    GdkRGBA gtk_css_parse_background(long provider, String precise) {
        GdkRGBA rgba = new GdkRGBA();
        long str = GTK.gtk_css_provider_to_string(provider);
        if (str == 0L) {
            return this.COLOR_WIDGET_BACKGROUND_RGBA;
        }
        int length = C.strlen(str);
        byte[] buffer = new byte[length];
        C.memmove(buffer, str, (long)length);
        String cssOutput = new String(Converter.mbcsToWcs(buffer));
        String searched = "";
        if (precise != null) {
            if (cssOutput.contains(precise)) {
                searched = cssOutput.substring(cssOutput.indexOf(precise));
            }
        } else {
            searched = cssOutput;
        }
        if (searched.isEmpty()) {
            return this.COLOR_WIDGET_BACKGROUND_RGBA;
        }
        if (searched.contains("background-color:")) {
            int startIndex = searched.indexOf("background-color:");
            String shortOutput = searched.substring(startIndex + 18);
            rgba = this.gtk_css_property_to_rgba(shortOutput);
        } else if (searched.contains("background:")) {
            int startIndex = searched.indexOf("background:");
            String shortOutput = searched.substring(startIndex + 13);
            rgba = this.gtk_css_property_to_rgba(shortOutput);
        }
        return rgba;
    }

    GdkRGBA gtk_css_parse_foreground(long provider, String precise) {
        if (provider == 0L) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        GdkRGBA rgba = new GdkRGBA();
        long str = GTK.gtk_css_provider_to_string(provider);
        if (str == 0L) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        int length = C.strlen(str);
        byte[] buffer = new byte[length];
        C.memmove(buffer, str, (long)length);
        String cssOutput = new String(Converter.mbcsToWcs(buffer));
        String searched = "";
        if (precise != null) {
            if (cssOutput.contains(precise)) {
                searched = cssOutput.substring(cssOutput.indexOf(precise));
            }
        } else {
            searched = cssOutput;
        }
        if (searched.isEmpty()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        String pattern = "[^-]color: rgba?\\((\\d+(,\\s?)?){3,4}\\)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(searched);
        if (m.find()) {
            String match = m.group(0);
            if (match.contains("color:")) {
                int startIndex = match.indexOf("color:");
                String shortOutput = match.substring(startIndex + 7);
                rgba = this.gtk_css_property_to_rgba(shortOutput);
            }
        } else {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        return rgba;
    }

    GdkRGBA gtk_css_property_to_rgba(String property) {
        GdkRGBA rgba = new GdkRGBA();
        String[] propertyParsed = new String[1];
        propertyParsed = property.split(";");
        GDK.gdk_rgba_parse(rgba, Converter.wcsToMbcs(propertyParsed[0], true));
        return rgba;
    }

    String gtk_rgba_to_css_string(GdkRGBA rgba) {
        GdkRGBA toConvert = rgba != null ? rgba : this.COLOR_WIDGET_BACKGROUND_RGBA;
        long str = GDK.gdk_rgba_to_string(toConvert);
        int length = C.strlen(str);
        byte[] buffer = new byte[length];
        C.memmove(buffer, str, (long)length);
        return new String(Converter.mbcsToWcs(buffer));
    }

    String gtk_widget_get_name(long handle) {
        String name;
        long str = GTK.gtk_widget_get_name(handle);
        if (str == 0L) {
            name = "*";
        } else {
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            name = new String(Converter.mbcsToWcs(buffer));
        }
        return name;
    }

    String gtk_widget_class_get_css_name(long handle) {
        String name;
        long str = GTK.gtk_widget_class_get_css_name(GTK.GTK_WIDGET_GET_CLASS(handle));
        if (str == 0L) {
            name = "*";
        } else {
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            name = new String(Converter.mbcsToWcs(buffer));
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class<?> clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        int[] buffer = new int[1];
        long settings = GTK.gtk_settings_get_default();
        OS.g_object_get(settings, GTK.gtk_alternative_button_order, buffer, 0L);
        return buffer[0] == 1 ? 16384 : 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        long settings = GTK.gtk_settings_get_default();
        int[] buffer = new int[1];
        OS.g_object_get(settings, GTK.gtk_double_click_time, buffer, 0L);
        return buffer[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        long shellHandle = this.activeShell.shellHandle;
        long handle = GTK.gtk_window_get_focus(shellHandle);
        if (handle == 0L) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((handle = GTK.gtk_widget_get_parent(handle)) != 0L);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    @Override
    public int getDepth() {
        this.checkDevice();
        return GDK.gdk_visual_get_depth(GDK.gdk_visual_get_system());
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Rectangle getWorkArea() {
        byte[] name = Converter.wcsToMbcs("_NET_WORKAREA", true);
        long atom = GDK.gdk_atom_intern(name, true);
        if (atom == 0L) {
            return null;
        }
        long[] actualType = new long[1];
        int[] actualFormat = new int[1];
        int[] actualLength = new int[1];
        long[] data = new long[1];
        if (!GDK.gdk_property_get(GDK.gdk_get_default_root_window(), atom, 0L, 0L, 16L, 0, actualType, actualFormat, actualLength, data)) {
            return null;
        }
        Rectangle result = null;
        if (data[0] != 0L) {
            if (actualLength[0] == 16) {
                int[] values = new int[4];
                C.memmove(values, data[0], 16L);
                result = new Rectangle(values[0], values[1], values[2], values[3]);
            } else if (actualLength[0] == 32) {
                long[] values = new long[4];
                C.memmove(values, data[0], 32L);
                result = new Rectangle((int)values[0], (int)values[1], (int)values[2], (int)values[3]);
            }
            OS.g_free(data[0]);
        }
        return result;
    }

    public Monitor[] getMonitors() {
        int monitorCount;
        this.checkDevice();
        Monitor[] monitors = null;
        Rectangle workArea = DPIUtil.autoScaleDown(this.getWorkArea());
        long screen = GDK.gdk_screen_get_default();
        if (screen != 0L && (monitorCount = GDK.gdk_screen_get_n_monitors(screen)) > 0) {
            monitors = new Monitor[monitorCount];
            GdkRectangle dest = new GdkRectangle();
            int i = 0;
            while (i < monitorCount) {
                GDK.gdk_screen_get_monitor_geometry(screen, i, dest);
                Monitor monitor = new Monitor();
                monitor.handle = i;
                monitor.x = DPIUtil.autoScaleDown(dest.x);
                monitor.y = DPIUtil.autoScaleDown(dest.y);
                monitor.width = DPIUtil.autoScaleDown(dest.width);
                monitor.height = DPIUtil.autoScaleDown(dest.height);
                if (GTK.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                    GDK.gdk_screen_get_monitor_workarea(screen, i, dest);
                    monitor.clientX = DPIUtil.autoScaleDown(dest.x);
                    monitor.clientY = DPIUtil.autoScaleDown(dest.y);
                    monitor.clientWidth = DPIUtil.autoScaleDown(dest.width);
                    monitor.clientHeight = DPIUtil.autoScaleDown(dest.height);
                } else {
                    if (workArea != null) {
                        monitor.clientX = Math.max(monitor.x, workArea.x);
                        monitor.clientY = Math.max(monitor.y, workArea.y);
                        monitor.clientHeight = Math.max(Math.min(monitor.y + monitor.height, workArea.y + workArea.height) - monitor.clientY, 0);
                        monitor.clientWidth = Math.max(Math.min(monitor.x + monitor.width, workArea.x + workArea.width) - monitor.clientX, 0);
                    }
                    if (workArea == null || monitor.clientWidth == 0 || monitor.clientHeight == 0) {
                        monitor.clientX = monitor.x;
                        monitor.clientY = monitor.y;
                        monitor.clientHeight = monitor.height;
                        monitor.clientWidth = monitor.width;
                    }
                }
                monitors[i] = monitor;
                ++i;
            }
        }
        if (monitors == null) {
            Monitor monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            if (workArea != null) {
                monitor.clientX = workArea.x;
                monitor.clientY = workArea.y;
                monitor.clientWidth = workArea.width;
                monitor.clientHeight = workArea.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitors = new Monitor[]{monitor};
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitors = this.getMonitors();
        int primaryMonitorIndex = 0;
        long screen = GDK.gdk_screen_get_default();
        if (screen != 0L) {
            primaryMonitorIndex = GDK.gdk_screen_get_primary_monitor(screen);
        }
        return monitors[primaryMonitorIndex];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                int j = 0;
                while (j < index) {
                    if (result[j] == widget) break;
                    ++j;
                }
                if (j == index) {
                    if (index == result.length) {
                        Shell[] newResult = new Shell[index + 16];
                        System.arraycopy(result, 0, newResult, 0, index);
                        result = newResult;
                    }
                    result[index++] = (Shell)widget;
                }
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int id) {
        this.checkDevice();
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = null;
            switch (id) {
                case 36: {
                    gdkRGBA = this.copyRGBA(this.COLOR_LINK_FOREGROUND_RGBA);
                    break;
                }
                case 28: {
                    gdkRGBA = this.copyRGBA(this.COLOR_INFO_FOREGROUND_RGBA);
                    break;
                }
                case 29: {
                    gdkRGBA = this.copyRGBA(this.COLOR_INFO_BACKGROUND_RGBA);
                    break;
                }
                case 30: {
                    gdkRGBA = this.copyRGBA(this.COLOR_TITLE_FOREGROUND_RGBA);
                    break;
                }
                case 31: {
                    gdkRGBA = this.copyRGBA(this.COLOR_TITLE_BACKGROUND_RGBA);
                    break;
                }
                case 32: {
                    gdkRGBA = this.copyRGBA(this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA);
                    break;
                }
                case 33: {
                    gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA);
                    break;
                }
                case 34: {
                    gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA);
                    break;
                }
                case 35: {
                    gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA);
                    break;
                }
                case 17: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_DARK_SHADOW_RGBA);
                    break;
                }
                case 18: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_NORMAL_SHADOW_RGBA);
                    break;
                }
                case 19: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_LIGHT_SHADOW_RGBA);
                    break;
                }
                case 20: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA);
                    break;
                }
                case 22: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA);
                    break;
                }
                case 21: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_FOREGROUND_RGBA);
                    break;
                }
                case 23: {
                    gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_BORDER_RGBA);
                    break;
                }
                case 24: {
                    gdkRGBA = this.copyRGBA(this.COLOR_LIST_FOREGROUND_RGBA);
                    break;
                }
                case 25: {
                    gdkRGBA = this.copyRGBA(this.COLOR_LIST_BACKGROUND_RGBA);
                    break;
                }
                case 26: {
                    gdkRGBA = this.copyRGBA(this.COLOR_LIST_SELECTION_RGBA);
                    break;
                }
                case 27: {
                    gdkRGBA = this.copyRGBA(this.COLOR_LIST_SELECTION_TEXT_RGBA);
                    break;
                }
                default: {
                    return super.getSystemColor(id);
                }
            }
            if (gdkRGBA == null) {
                return super.getSystemColor(2);
            }
            return Color.gtk_new((Device)this, gdkRGBA);
        }
        GdkColor gdkColor = null;
        switch (id) {
            case 36: {
                gdkColor = this.COLOR_LINK_FOREGROUND;
                break;
            }
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new((Device)this, gdkColor);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        switch (id) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("dialog-error");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("dialog-information");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("dialog-question");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("dialog-warning");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    GdkRGBA toGdkRGBA(GdkRGBA rgba, double brightness) {
        GdkRGBA newRGBA = new GdkRGBA();
        newRGBA.red = rgba.red;
        newRGBA.green = rgba.green;
        newRGBA.blue = rgba.blue;
        newRGBA.alpha = rgba.alpha;
        double[] hue = new double[1];
        double[] saturationHSV = new double[1];
        double[] value = new double[1];
        GTK.gtk_rgb_to_hsv(newRGBA.red, newRGBA.green, newRGBA.blue, hue, saturationHSV, value);
        double luminosity = (2.0 - saturationHSV[0]) * value[0] / 2.0;
        double saturationHSL = saturationHSV[0] * value[0];
        saturationHSL /= luminosity <= 1.0 ? luminosity : 2.0 - luminosity;
        saturationHSL = Math.max(0.0, Math.min(1.0, saturationHSL * brightness));
        luminosity = Math.max(0.0, Math.min(1.0, luminosity * brightness));
        value[0] = (luminosity + (saturationHSL *= luminosity <= 1.0 ? luminosity : 2.0 - (luminosity *= 2.0))) / 2.0;
        saturationHSV[0] = 2.0 * saturationHSL / (luminosity + saturationHSL);
        GTK.gtk_hsv_to_rgb(hue[0], saturationHSV[0], value[0], hue, saturationHSV, value);
        newRGBA.red = hue[0];
        newRGBA.green = saturationHSV[0];
        newRGBA.blue = value[0];
        return newRGBA;
    }

    GdkRGBA getBackgroundColor(long context, int state) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        GdkRGBA rgba = new GdkRGBA();
        GTK.gtk_style_context_save(context);
        GTK.gtk_style_context_set_state(context, state);
        long surface = Cairo.cairo_image_surface_create(1, 1, 1);
        long cairo = Cairo.cairo_create(surface);
        GTK.gtk_render_background(context, cairo, -50.0, -50.0, 100.0, 100.0);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_surface_flush(surface);
        byte[] buffer = new byte[3];
        C.memmove(buffer, Cairo.cairo_image_surface_get_data(surface), (long)buffer.length);
        rgba.red = (float)buffer[2] / 255.0f;
        rgba.green = (float)buffer[1] / 255.0f;
        rgba.blue = (float)buffer[0] / 255.0f;
        rgba.alpha = 1.0;
        Cairo.cairo_surface_destroy(surface);
        Cairo.cairo_destroy(cairo);
        GTK.gtk_style_context_restore(context);
        return rgba;
    }

    GdkRGBA copyRGBA(GdkRGBA source) {
        GdkRGBA retRGBA = new GdkRGBA();
        if (source != null) {
            retRGBA.alpha = source.alpha;
            retRGBA.red = source.red;
            retRGBA.green = source.green;
            retRGBA.blue = source.blue;
        }
        return retRGBA;
    }

    void initializeSystemColors() {
        long tooltipShellHandle = GTK.gtk_window_new(1);
        if (tooltipShellHandle == 0L) {
            this.error(2);
        }
        byte[] gtk_tooltip = Converter.wcsToMbcs(GTK.GTK3 ? "gtk-tooltip" : "gtk-tooltips", true);
        GTK.gtk_widget_set_name(tooltipShellHandle, gtk_tooltip);
        GTK.gtk_widget_realize(tooltipShellHandle);
        if (GTK.GTK3) {
            String colorTitleInactiveForeground;
            String colorListSelectionTextInactive;
            String colorListSelectionText;
            String colorListForeground;
            String colorWidgetForeground;
            this.COLOR_WIDGET_DARK_SHADOW_RGBA = new GdkRGBA();
            this.COLOR_WIDGET_DARK_SHADOW_RGBA.alpha = 1.0;
            long context = GTK.gtk_widget_get_style_context(tooltipShellHandle);
            GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_TOOLTIP);
            GTK.gtk_style_context_invalidate(context);
            GdkRGBA rgba = new GdkRGBA();
            this.initializeColorList();
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorInfoForeground = this.gtk_css_default_theme_values(28);
                if (!colorInfoForeground.isEmpty()) {
                    if (colorInfoForeground != "parsed") {
                        this.COLOR_INFO_FOREGROUND_RGBA = this.gtk_css_property_to_rgba(colorInfoForeground);
                    }
                } else {
                    this.COLOR_INFO_FOREGROUND_RGBA = this.styleContextGetColor(context, 0);
                }
            } else {
                this.COLOR_INFO_FOREGROUND_RGBA = this.styleContextGetColor(context, 0);
            }
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorInfoBackground = this.gtk_css_default_theme_values(29);
                if (!colorInfoBackground.isEmpty()) {
                    if (colorInfoBackground != "parsed") {
                        this.COLOR_INFO_BACKGROUND_RGBA = this.gtk_css_property_to_rgba(colorInfoBackground);
                    }
                } else {
                    this.COLOR_INFO_BACKGROUND_RGBA = this.getBackgroundColor(context, 0);
                }
            } else {
                this.COLOR_INFO_BACKGROUND_RGBA = this.getBackgroundColor(context, 0);
            }
            GTK.gtk_widget_destroy(tooltipShellHandle);
            context = GTK.gtk_widget_get_style_context(this.shellHandle);
            this.COLOR_WIDGET_FOREGROUND_RGBA = GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) ? (!(colorWidgetForeground = this.gtk_css_default_theme_values(21)).isEmpty() ? this.gtk_css_property_to_rgba(colorWidgetForeground) : this.styleContextGetColor(context, 0)) : this.styleContextGetColor(context, 0);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorWidgetBackground = this.gtk_css_default_theme_values(22);
                if (!colorWidgetBackground.isEmpty()) {
                    this.COLOR_WIDGET_BACKGROUND_RGBA = this.gtk_css_property_to_rgba(colorWidgetBackground);
                } else {
                    GTK.gtk_style_context_get_background_color(context, 0, rgba);
                    this.COLOR_WIDGET_BACKGROUND_RGBA = this.copyRGBA(rgba);
                }
            } else {
                GTK.gtk_style_context_get_background_color(context, 0, rgba);
                this.COLOR_WIDGET_BACKGROUND_RGBA = this.copyRGBA(rgba);
            }
            this.COLOR_WIDGET_LIGHT_SHADOW_RGBA = this.COLOR_WIDGET_BACKGROUND_RGBA;
            this.COLOR_WIDGET_NORMAL_SHADOW_RGBA = this.toGdkRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA, 0.7);
            this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA = this.toGdkRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA, 1.3);
            GTK.gtk_style_context_save(context);
            GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_VIEW);
            GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_CELL);
            GTK.gtk_style_context_invalidate(context);
            this.COLOR_LIST_FOREGROUND_RGBA = GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) ? (!(colorListForeground = this.gtk_css_default_theme_values(24)).isEmpty() ? this.gtk_css_property_to_rgba(colorListForeground) : this.styleContextGetColor(context, 0)) : this.styleContextGetColor(context, 0);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorListBackground = this.gtk_css_default_theme_values(25);
                if (!colorListBackground.isEmpty()) {
                    this.COLOR_LIST_BACKGROUND_RGBA = this.gtk_css_property_to_rgba(colorListBackground);
                } else {
                    GTK.gtk_style_context_get_background_color(context, 0, rgba);
                    this.COLOR_LIST_BACKGROUND_RGBA = this.copyRGBA(rgba);
                }
            } else {
                GTK.gtk_style_context_get_background_color(context, 0, rgba);
                this.COLOR_LIST_BACKGROUND_RGBA = this.copyRGBA(rgba);
            }
            GTK.gtk_style_context_restore(context);
            this.COLOR_LIST_SELECTION_TEXT_RGBA = GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) ? (!(colorListSelectionText = this.gtk_css_default_theme_values(27)).isEmpty() ? this.gtk_css_property_to_rgba(colorListSelectionText) : this.styleContextGetColor(context, 4)) : this.styleContextGetColor(context, 4);
            this.COLOR_TITLE_FOREGROUND_RGBA = this.COLOR_LIST_SELECTION_TEXT_RGBA;
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorListSelection = this.gtk_css_default_theme_values(26);
                if (!colorListSelection.isEmpty()) {
                    this.COLOR_LIST_SELECTION_RGBA = this.gtk_css_property_to_rgba(colorListSelection);
                } else {
                    GTK.gtk_style_context_get_background_color(context, 4, rgba);
                    this.COLOR_LIST_SELECTION_RGBA = this.copyRGBA(rgba);
                }
            } else {
                GTK.gtk_style_context_get_background_color(context, 4, rgba);
                this.COLOR_LIST_SELECTION_RGBA = this.copyRGBA(rgba);
            }
            this.COLOR_TITLE_BACKGROUND_RGBA = this.COLOR_LIST_SELECTION_RGBA;
            this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA = this.toGdkRGBA(this.COLOR_LIST_SELECTION_RGBA, 1.3);
            this.COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA = GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) ? (!(colorListSelectionTextInactive = this.gtk_css_default_theme_values(38)).isEmpty() ? this.gtk_css_property_to_rgba(colorListSelectionTextInactive) : this.styleContextGetColor(context, 1)) : this.styleContextGetColor(context, 1);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorListSelectionInactive = this.gtk_css_default_theme_values(39);
                if (!colorListSelectionInactive.isEmpty()) {
                    this.COLOR_LIST_SELECTION_INACTIVE_RGBA = this.gtk_css_property_to_rgba(colorListSelectionInactive);
                } else {
                    GTK.gtk_style_context_get_background_color(context, 1, rgba);
                    this.COLOR_LIST_SELECTION_INACTIVE_RGBA = this.copyRGBA(rgba);
                }
            } else {
                GTK.gtk_style_context_get_background_color(context, 1, rgba);
                this.COLOR_LIST_SELECTION_INACTIVE_RGBA = this.copyRGBA(rgba);
            }
            this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA = GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) ? (!(colorTitleInactiveForeground = this.gtk_css_default_theme_values(33)).isEmpty() ? this.gtk_css_property_to_rgba(colorTitleInactiveForeground) : this.styleContextGetColor(context, 8)) : this.styleContextGetColor(context, 8);
            this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = rgba;
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorTitleInactiveBackground = this.gtk_css_default_theme_values(34);
                if (!colorTitleInactiveBackground.isEmpty()) {
                    this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = this.gtk_css_property_to_rgba(colorTitleInactiveBackground);
                } else {
                    GTK.gtk_style_context_get_background_color(context, 8, rgba);
                    this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = this.copyRGBA(rgba);
                }
            } else {
                GTK.gtk_style_context_get_background_color(context, 8, rgba);
                this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = this.copyRGBA(rgba);
            }
            this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA = this.toGdkRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA, 1.3);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
                String colorLinkForeground = this.gtk_css_default_theme_values(36);
                if (!colorLinkForeground.isEmpty()) {
                    if (colorLinkForeground != "parsed") {
                        this.COLOR_LINK_FOREGROUND_RGBA = this.gtk_css_property_to_rgba(colorLinkForeground);
                    }
                } else {
                    this.COLOR_LINK_FOREGROUND_RGBA = this.COLOR_LIST_SELECTION_RGBA;
                }
            } else {
                this.COLOR_LINK_FOREGROUND_RGBA = this.COLOR_LIST_SELECTION_RGBA;
            }
            return;
        }
        this.COLOR_LINK_FOREGROUND = this.initializeColorLinkForeground(tooltipShellHandle);
        long colormap = GDK.gdk_colormap_get_system();
        GDK.gdk_colormap_alloc_color(colormap, this.COLOR_LINK_FOREGROUND, true, true);
        long tooltipStyle = GTK.gtk_widget_get_style(tooltipShellHandle);
        GdkColor gdkColor = new GdkColor();
        GTK.gtk_style_get_fg(tooltipStyle, 0, gdkColor);
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_bg(tooltipStyle, 0, gdkColor);
        this.COLOR_INFO_BACKGROUND = gdkColor;
        GTK.gtk_widget_destroy(tooltipShellHandle);
        long style = GTK.gtk_widget_get_style(this.shellHandle);
        gdkColor = new GdkColor();
        GTK.gtk_style_get_black(style, gdkColor);
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_dark(style, 0, gdkColor);
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_bg(style, 0, gdkColor);
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_light(style, 0, gdkColor);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_fg(style, 0, gdkColor);
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_bg(style, 0, gdkColor);
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_text(style, 0, gdkColor);
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_base(style, 0, gdkColor);
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_text(style, 3, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_base(style, 3, gdkColor);
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_text(style, 1, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_base(style, 1, gdkColor);
        this.COLOR_LIST_SELECTION_INACTIVE = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_bg(style, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_fg(style, 3, gdkColor);
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_light(style, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_bg(style, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_fg(style, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        GTK.gtk_style_get_light(style, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
    }

    GdkColor initializeColorLinkForeground(long tooltipShellHandle) {
        long linkWidget = GTK.gtk_label_new(new byte[1]);
        if (linkWidget == 0L) {
            this.error(2);
        }
        GTK.gtk_container_add(tooltipShellHandle, linkWidget);
        long[] linkColor = new long[1];
        GTK.gtk_widget_style_get(linkWidget, OS.link_color, linkColor, 0L);
        GdkColor gdkColor = new GdkColor();
        if (linkColor[0] != 0L) {
            OS.memmove(gdkColor, linkColor[0], (long)GdkColor.sizeof);
            GDK.gdk_color_free(linkColor[0]);
        } else {
            gdkColor.blue = (short)-4370;
        }
        return gdkColor;
    }

    GdkRGBA styleContextGetColor(long context, int flag) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        GdkRGBA rgba = new GdkRGBA();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 18, 0)) {
            GTK.gtk_style_context_save(context);
            GTK.gtk_style_context_set_state(context, flag);
            GTK.gtk_style_context_get_color(context, flag, rgba);
            GTK.gtk_style_context_restore(context);
        } else {
            GTK.gtk_style_context_get_color(context, flag, rgba);
        }
        return rgba;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    Widget getWidget(long handle) {
        if (handle == 0L) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == handle) {
            return this.lastWidget;
        }
        long index = OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX) - 1L;
        if (0L <= index && index < (long)this.widgetTable.length) {
            this.lastHandle = handle;
            this.lastWidget = this.widgetTable[(int)index];
            return this.lastWidget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long idleProc(long data) {
        boolean result = this.runAsyncMessages(false);
        if (!result) {
            Object object = this.idleLock;
            synchronized (object) {
                this.idleHandle = 0;
            }
        }
        return result ? 1 : 0;
    }

    @Override
    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSubclasses();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeWindowManager();
    }

    void initializeCallbacks() {
        this.closures = new long[85];
        this.closuresCount = new int[85];
        this.closuresProc = new long[85];
        this.signalIds = new int[85];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[15] = OS.g_signal_lookup(OS.event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, GTK.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(GTK.GTK3 ? OS.draw : OS.expose_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[19] = OS.g_signal_lookup(GTK.GTK3 ? OS.draw : OS.expose_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, GTK.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, GTK.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, GTK.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, GTK.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[38] = OS.g_signal_lookup(OS.popup_menu, GTK.GTK_TYPE_WIDGET());
        this.signalIds[40] = OS.g_signal_lookup(OS.realize, GTK.GTK_TYPE_WIDGET());
        this.signalIds[43] = OS.g_signal_lookup(OS.scroll_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show, GTK.GTK_TYPE_WIDGET());
        this.signalIds[46] = OS.g_signal_lookup(OS.show_help, GTK.GTK_TYPE_WIDGET());
        this.signalIds[47] = OS.g_signal_lookup(OS.size_allocate, GTK.GTK_TYPE_WIDGET());
        this.signalIds[48] = OS.g_signal_lookup(OS.style_set, GTK.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap, GTK.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.unmap_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[56] = OS.g_signal_lookup(OS.realize, GTK.GTK_TYPE_WIDGET());
        this.signalIds[59] = OS.g_signal_lookup(OS.window_state_event, GTK.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0L) {
            this.error(3);
        }
        this.closuresProc[1] = this.windowProc2;
        this.closuresProc[60] = this.windowProc2;
        this.closuresProc[6] = this.windowProc2;
        this.closuresProc[8] = this.windowProc2;
        this.closuresProc[83] = this.windowProc2;
        this.closuresProc[61] = this.windowProc2;
        this.closuresProc[66] = this.windowProc2;
        this.closuresProc[24] = this.windowProc2;
        this.closuresProc[23] = this.windowProc2;
        this.closuresProc[30] = this.windowProc2;
        this.closuresProc[62] = this.windowProc2;
        this.closuresProc[36] = this.windowProc2;
        this.closuresProc[38] = this.windowProc2;
        this.closuresProc[39] = this.windowProc2;
        this.closuresProc[40] = this.windowProc2;
        this.closuresProc[44] = this.windowProc2;
        this.closuresProc[68] = this.windowProc2;
        this.closuresProc[45] = this.windowProc2;
        this.closuresProc[69] = this.windowProc2;
        this.closuresProc[57] = this.windowProc2;
        this.closuresProc[54] = this.windowProc2;
        this.closuresProc[56] = this.windowProc2;
        this.closuresProc[70] = this.windowProc2;
        this.closuresProc[71] = this.windowProc2;
        this.closuresProc[72] = this.windowProc2;
        this.closuresProc[73] = this.windowProc2;
        this.closuresProc[74] = this.windowProc2;
        this.closuresProc[75] = this.windowProc2;
        this.closuresProc[76] = this.windowProc2;
        this.closuresProc[77] = this.windowProc2;
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0L) {
            this.error(3);
        }
        this.closuresProc[2] = this.windowProc3;
        this.closuresProc[3] = this.windowProc3;
        this.closuresProc[4] = this.windowProc3;
        this.closuresProc[5] = this.windowProc3;
        this.closuresProc[9] = this.windowProc3;
        this.closuresProc[10] = this.windowProc3;
        this.closuresProc[11] = this.windowProc3;
        this.closuresProc[14] = this.windowProc3;
        this.closuresProc[15] = this.windowProc3;
        this.closuresProc[16] = this.windowProc3;
        this.closuresProc[18] = this.windowProc3;
        this.closuresProc[19] = this.windowProc3;
        this.closuresProc[20] = this.windowProc3;
        this.closuresProc[21] = this.windowProc3;
        this.closuresProc[22] = this.windowProc3;
        this.closuresProc[27] = this.windowProc3;
        this.closuresProc[28] = this.windowProc3;
        this.closuresProc[25] = this.windowProc3;
        this.closuresProc[29] = this.windowProc3;
        this.closuresProc[31] = this.windowProc3;
        this.closuresProc[32] = this.windowProc3;
        this.closuresProc[33] = this.windowProc3;
        this.closuresProc[34] = this.windowProc3;
        this.closuresProc[35] = this.windowProc3;
        this.closuresProc[37] = this.windowProc3;
        this.closuresProc[43] = this.windowProc3;
        this.closuresProc[46] = this.windowProc3;
        this.closuresProc[47] = this.windowProc3;
        this.closuresProc[48] = this.windowProc3;
        this.closuresProc[53] = this.windowProc3;
        this.closuresProc[55] = this.windowProc3;
        this.closuresProc[59] = this.windowProc3;
        this.closuresProc[65] = this.windowProc3;
        this.closuresProc[82] = this.windowProc3;
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0L) {
            this.error(3);
        }
        this.closuresProc[12] = this.windowProc4;
        this.closuresProc[13] = this.windowProc4;
        this.closuresProc[67] = this.windowProc4;
        this.closuresProc[41] = this.windowProc4;
        this.closuresProc[42] = this.windowProc4;
        this.closuresProc[63] = this.windowProc4;
        this.closuresProc[49] = this.windowProc4;
        this.closuresProc[50] = this.windowProc4;
        this.closuresProc[51] = this.windowProc4;
        this.closuresProc[64] = this.windowProc4;
        this.closuresProc[84] = this.windowProc4;
        this.closuresProc[78] = this.windowProc4;
        this.closuresProc[79] = this.windowProc4;
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0L) {
            this.error(3);
        }
        this.closuresProc[7] = this.windowProc5;
        this.closuresProc[17] = this.windowProc5;
        this.closuresProc[26] = this.windowProc5;
        this.closuresProc[52] = this.windowProc5;
        this.closuresProc[80] = this.windowProc5;
        this.closuresProc[81] = this.windowProc5;
        int i = 0;
        while (i < 85) {
            if (this.closuresProc[i] != 0L) {
                this.closures[i] = OS.g_cclosure_new(this.closuresProc[i], i, 0L);
            }
            if (this.closures[i] != 0L) {
                OS.g_closure_ref(this.closures[i]);
                OS.g_closure_sink(this.closures[i]);
            }
            ++i;
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0L) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0L) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0L) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0L) {
            this.error(3);
        }
        this.sizeAllocateCallback = new Callback(this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        if (this.sizeAllocateProc == 0L) {
            this.error(3);
        }
        this.sizeRequestCallback = new Callback(this, "sizeRequestProc", 3);
        this.sizeRequestProc = this.sizeRequestCallback.getAddress();
        if (this.sizeRequestProc == 0L) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0L) {
            this.error(3);
        }
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0L, 0L);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        if (this.cellDataProc == 0L) {
            this.error(3);
        }
        this.setDirectionCallback = new Callback(this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        if (this.setDirectionProc == 0L) {
            this.error(3);
        }
        this.emissionProcCallback = new Callback(this, "emissionProc", 4);
        this.emissionProc = this.emissionProcCallback.getAddress();
        if (this.emissionProc == 0L) {
            this.error(3);
        }
        this.allChildrenCallback = new Callback(this, "allChildrenProc", 2);
        this.allChildrenProc = this.allChildrenCallback.getAddress();
        if (this.allChildrenProc == 0L) {
            this.error(3);
        }
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        if (this.checkIfEventProc == 0L) {
            this.error(3);
        }
        this.idleCallback = new Callback(this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
        if (this.idleProc == 0L) {
            this.error(3);
        }
    }

    void initializeColorList() {
        this.colorList = new ArrayList();
        this.colorList.add("black");
        this.colorList.add("darkred");
        this.colorList.add("darkgreen");
        this.colorList.add("darkyellow");
        this.colorList.add("darkblue");
        this.colorList.add("darkmagenta");
        this.colorList.add("darkcyan");
        this.colorList.add("darkgray");
        this.colorList.add("gray");
        this.colorList.add("red");
        this.colorList.add("green");
        this.colorList.add("yellow");
        this.colorList.add("blue");
        this.colorList.add("magenta");
        this.colorList.add("cyan");
        this.colorList.add("white");
    }

    void initializeSubclasses() {
        long pangoLayoutType = OS.PANGO_TYPE_LAYOUT();
        long pangoLayoutClass = OS.g_type_class_ref(pangoLayoutType);
        this.pangoLayoutNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(pangoLayoutClass);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoLayoutClass, OS.pangoLayoutNewProc_CALLBACK(this.pangoLayoutNewProc));
        OS.g_type_class_unref(pangoLayoutClass);
        if (GTK.GTK3) {
            long imContextType = GTK.GTK_TYPE_IM_MULTICONTEXT();
            long imContextClass = OS.g_type_class_ref(imContextType);
            this.imContextNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(imContextClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(imContextClass, OS.imContextNewProc_CALLBACK(this.imContextNewProc));
            OS.g_type_class_unref(imContextClass);
            long pangoFontFamilyType = OS.PANGO_TYPE_FONT_FAMILY();
            long pangoFontFamilyClass = OS.g_type_class_ref(pangoFontFamilyType);
            this.pangoFontFamilyNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(pangoFontFamilyClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFamilyClass, OS.pangoFontFamilyNewProc_CALLBACK(this.pangoFontFamilyNewProc));
            OS.g_type_class_unref(pangoFontFamilyClass);
            long pangoFontFaceType = OS.PANGO_TYPE_FONT_FACE();
            long pangoFontFaceClass = OS.g_type_class_ref(pangoFontFaceType);
            this.pangoFontFaceNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(pangoFontFaceClass);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFaceClass, OS.pangoFontFaceNewProc_CALLBACK(this.pangoFontFaceNewProc));
            OS.g_type_class_unref(pangoFontFaceClass);
            if (!OS.IsWin32) {
                long printerOptionWidgetType = GTK.gtk_printer_option_widget_get_type();
                long printerOptionWidgetClass = OS.g_type_class_ref(printerOptionWidgetType);
                this.printerOptionWidgetNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(printerOptionWidgetClass);
                OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(printerOptionWidgetClass, OS.printerOptionWidgetNewProc_CALLBACK(this.printerOptionWidgetNewProc));
                OS.g_type_class_unref(printerOptionWidgetClass);
            }
        }
    }

    void initializeSystemSettings() {
        OS.g_signal_connect(this.shellHandle, OS.style_set, this.signalProc, 1L);
        long entry = GTK.gtk_entry_new();
        GTK.gtk_widget_destroy(entry);
        int[] buffer2 = new int[1];
        long settings = GTK.gtk_settings_get_default();
        OS.g_object_get(settings, GTK.gtk_entry_select_on_focus, buffer2, 0L);
        this.entrySelectOnFocus = buffer2[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    void initializeWindowManager() {
        int length;
        long ptr2;
        long screen;
        this.windowManager = "";
        if (OS.isX11() && (screen = GDK.gdk_screen_get_default()) != 0L && (ptr2 = GDK.gdk_x11_screen_get_window_manager_name(screen)) != 0L && (length = C.strlen(ptr2)) > 0) {
            byte[] buffer2 = new byte[length];
            C.memmove(buffer2, ptr2, (long)length);
            this.windowManager = new String(Converter.mbcsToWcs(buffer2));
        }
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        Cairo.cairo_destroy(hDC);
    }

    @Override
    public long internal_new_GC(GCData data) {
        long root;
        long gc;
        if (this.isDisposed()) {
            this.error(45);
        }
        if ((gc = GDK.gdk_cairo_create(root = GDK.gdk_get_default_root_window())) == 0L) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = root;
            if (GTK.GTK3) {
                data.backgroundRGBA = this.getSystemColor((int)1).handleRGBA;
                data.foregroundRGBA = this.getSystemColor((int)2).handleRGBA;
            } else {
                data.background = this.getSystemColor((int)1).handle;
                data.foreground = this.getSystemColor((int)2).handle;
            }
            data.font = this.getSystemFont();
        }
        return gc;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        if (from != null) {
            origin = DPIUtil.autoScaleDown(from.getWindowOrigin());
            if ((from.style & 0x8000000) != 0) {
                point.x = DPIUtil.autoScaleDown(from.getClientWidth()) - point.x;
            }
            point.x += origin.x;
            point.y += origin.y;
        }
        if (to != null) {
            origin = DPIUtil.autoScaleDown(to.getWindowOrigin());
            point.x -= origin.x;
            point.y -= origin.y;
            if ((to.style & 0x8000000) != 0) {
                point.x = DPIUtil.autoScaleDown(to.getClientWidth()) - point.x;
            }
        }
        return point;
    }

    Point mapInPixels(Control from, Control to, int x, int y) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        if (from != null) {
            origin = from.getWindowOrigin();
            if ((from.style & 0x8000000) != 0) {
                point.x = from.getClientWidth() - point.x;
            }
            point.x += origin.x;
            point.y += origin.y;
        }
        if (to != null) {
            origin = to.getWindowOrigin();
            point.x -= origin.x;
            point.y -= origin.y;
            if ((to.style & 0x8000000) != 0) {
                point.x = to.getClientWidth() - point.x;
            }
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    Rectangle mapInPixels(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.mapInPixels(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from == to) {
            return rect;
        }
        boolean fromRTL = false;
        boolean toRTL = false;
        if (from != null) {
            origin = DPIUtil.autoScaleDown(from.getWindowOrigin());
            fromRTL = (from.style & 0x8000000) != 0;
            if (fromRTL) {
                rect.x = DPIUtil.autoScaleDown(from.getClientWidth()) - rect.x;
            }
            rect.x += origin.x;
            rect.y += origin.y;
        }
        if (to != null) {
            origin = DPIUtil.autoScaleDown(to.getWindowOrigin());
            rect.x -= origin.x;
            rect.y -= origin.y;
            toRTL = (to.style & 0x8000000) != 0;
            if (toRTL) {
                rect.x = DPIUtil.autoScaleDown(to.getClientWidth()) - rect.x;
            }
        }
        if (fromRTL != toRTL) {
            rect.x -= rect.width;
        }
        return rect;
    }

    Rectangle mapInPixels(Control from, Control to, int x, int y, int width, int height) {
        Point origin;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from == to) {
            return rect;
        }
        boolean fromRTL = false;
        boolean toRTL = false;
        if (from != null) {
            origin = from.getWindowOrigin();
            fromRTL = (from.style & 0x8000000) != 0;
            if (fromRTL) {
                rect.x = from.getClientWidth() - rect.x;
            }
            rect.x += origin.x;
            rect.y += origin.y;
        }
        if (to != null) {
            origin = to.getWindowOrigin();
            rect.x -= origin.x;
            rect.y -= origin.y;
            toRTL = (to.style & 0x8000000) != 0;
            if (toRTL) {
                rect.x = to.getClientWidth() - rect.x;
            }
        }
        if (fromRTL != toRTL) {
            rect.x -= rect.width;
        }
        return rect;
    }

    long mouseHoverProc(long handle) {
        Widget widget = this.getWidget(handle);
        this.mouseHoverId = 0;
        if (widget == null) {
            return 0L;
        }
        return widget.hoverProc(handle);
    }

    /*
     * Exception decompiling
     */
    public boolean post(Event event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            int i = 0;
            while (i < this.gdkEventCount) {
                long event = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    GDK.gdk_event_put(event);
                }
                GDK.gdk_event_free(event);
                this.gdkEvents[i] = 0L;
                this.gdkEventWidgets[i] = null;
                ++i;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean events = false;
        events |= this.runSettings();
        events |= this.runPopups();
        GDK.gdk_threads_leave();
        if (events |= OS.g_main_context_iteration(0L, false)) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                Runnable next = this.disposeList[i];
                if (next != null) {
                    try {
                        next.run();
                    }
                    catch (RuntimeException exception) {
                        this.runtimeExceptionHandler.accept(exception);
                    }
                    catch (Error error) {
                        this.errorHandler.accept(error);
                    }
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        File dir;
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        this.windowProc5 = 0L;
        this.windowProc4 = 0L;
        this.windowProc3 = 0L;
        this.windowProc2 = 0L;
        if (this.filterProc != 0L) {
            GDK.gdk_window_remove_filter(0L, this.filterProc, 0L);
        }
        this.filterCallback.dispose();
        this.filterCallback = null;
        this.filterProc = 0L;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0L;
        if (this.preeditWindow != 0L) {
            GTK.gtk_widget_destroy(this.preeditWindow);
        }
        this.imControl = null;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0L;
        this.sizeRequestCallback.dispose();
        this.sizeRequestCallback = null;
        this.sizeRequestProc = 0L;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0L;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0L;
        if (this.idleHandle != 0) {
            OS.g_source_remove(this.idleHandle);
        }
        this.idleHandle = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0L;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0L;
        this.emissionProcCallback.dispose();
        this.emissionProcCallback = null;
        this.emissionProc = 0L;
        this.allChildrenCallback.dispose();
        this.allChildrenCallback = null;
        this.allChildrenProc = 0L;
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0L;
        this.caretCallback.dispose();
        this.caretCallback = null;
        int i = 0;
        while (i < 85) {
            if (this.closures[i] != 0L) {
                OS.g_closure_unref(this.closures[i]);
            }
            ++i;
        }
        if (this.shellMapProcClosure != 0L) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.g_source_remove(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0L;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0L;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0L;
        this.mouseHoverHandle = 0L;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.resources != null) {
            i = 0;
            while (i < this.resources.length) {
                if (this.resources[i] != null) {
                    this.resources[i].dispose();
                }
                ++i;
            }
            this.resources = null;
        }
        this.COLOR_LINK_FOREGROUND = null;
        this.COLOR_INFO_FOREGROUND = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_BACKGROUND = null;
        this.COLOR_TITLE_FOREGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE = null;
        this.COLOR_LIST_SELECTION_INACTIVE = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        GDK.gdk_event_handler_set(0L, 0L, 0L);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0L) {
            GTK.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0L;
        this.signalCallback.dispose();
        this.signalCallback = null;
        this.signalProc = 0L;
        this.keysChangedCallback.dispose();
        this.keysChangedCallback = null;
        this.keysChangedProc = 0L;
        long pangoLayoutType = OS.PANGO_TYPE_LAYOUT();
        long pangoLayoutClass = OS.g_type_class_ref(pangoLayoutType);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoLayoutClass, this.pangoLayoutNewProc);
        OS.g_type_class_unref(pangoLayoutClass);
        this.pangoLayoutNewProc = 0L;
        if (GTK.GTK3) {
            long imContextType = GTK.GTK_TYPE_IM_MULTICONTEXT();
            long imContextClass = OS.g_type_class_ref(imContextType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(imContextClass, this.imContextNewProc);
            OS.g_type_class_unref(imContextClass);
            this.imContextNewProc = 0L;
            long pangoFontFamilyType = OS.PANGO_TYPE_FONT_FAMILY();
            long pangoFontFamilyClass = OS.g_type_class_ref(pangoFontFamilyType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFamilyClass, this.pangoFontFamilyNewProc);
            OS.g_type_class_unref(pangoFontFamilyClass);
            this.pangoFontFamilyNewProc = 0L;
            long pangoFontFaceType = OS.PANGO_TYPE_FONT_FACE();
            long pangoFontFaceClass = OS.g_type_class_ref(pangoFontFaceType);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(pangoFontFaceClass, this.pangoFontFaceNewProc);
            OS.g_type_class_unref(pangoFontFaceClass);
            this.pangoFontFaceNewProc = 0L;
        }
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0L) {
            OS.g_free(this.fds);
        }
        this.fds = 0L;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
        this.lastWidget = null;
        this.closures = null;
        this.flushData = null;
        this.signalIds = null;
        this.indexTable = null;
        this.modalShells = null;
        this.widgetTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.windowManager = null;
        this.filterTable = null;
        this.eventTable = null;
        this.modalDialog = null;
        this.flushRect = null;
        this.exposeEvent = null;
        this.idleLock = null;
        String userHome = System.getProperty("user.home");
        if (userHome != null && ((dir = new File(userHome, ".swt")).exists() && dir.isDirectory() || dir.mkdirs())) {
            File file = new File(dir, "trims.prefs");
            Properties props = new Properties();
            StringBuilder buf = new StringBuilder();
            int[] nArray = this.trimWidths;
            int n = this.trimWidths.length;
            int n2 = 0;
            while (n2 < n) {
                int w = nArray[n2];
                buf.append(w).append(' ');
                ++n2;
            }
            props.put("trimWidths", buf.toString());
            buf = new StringBuilder();
            nArray = this.trimHeights;
            n = this.trimHeights.length;
            n2 = 0;
            while (n2 < n) {
                int h = nArray[n2];
                buf.append(h).append(' ');
                ++n2;
            }
            props.put("trimHeights", buf.toString());
            try {
                Throwable throwable = null;
                Object var11_12 = null;
                try (FileOutputStream fos = new FileOutputStream(file);){
                    props.store(fos, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    long removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0L;
        }
        long event = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0L;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            if (this.idleHandle != 0) {
                OS.g_source_remove(this.idleHandle);
            }
            this.idleNeeded = false;
            this.idleHandle = 0;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMouseHoverTimeout(long handle) {
        if (handle != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0L;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(long handle) {
        if (handle == 0L) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        int index = (int)OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.g_object_set_qdata(handle, SWT_OBJECT_INDEX, 0L);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            this.update();
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.fixStyle();
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++i;
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int i = 0;
                while (i < count) {
                    Widget widget = oldSkinWidgets[i];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFEFFFFFF;
                        oldSkinWidgets[i] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public static void setAppVersion(String version) {
        APP_VERSION = version;
    }

    public void setCursorLocation(int x, int y) {
        this.setCursorLocation(new Point(x, y));
    }

    void setCursorLocationInPixels(Point location) {
        long gdkDisplay = GDK.gdk_display_get_default();
        long gdkScreen = GDK.gdk_screen_get_default();
        if (!GTK.GTK3) {
            GDK.gdk_display_warp_pointer(gdkDisplay, gdkScreen, location.x, location.y);
        } else {
            long gdkPointer = GDK.gdk_get_pointer(gdkDisplay);
            GDK.gdk_device_warp(gdkPointer, gdkScreen, location.x, location.y);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setCursorLocationInPixels(point);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY) && (value == null || value instanceof int[])) {
            this.dispatchEvents = (int[])value;
            if (value == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (key.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog((Dialog)value);
            return;
        }
        if (key.equals(ADD_WIDGET_KEY)) {
            Object[] data = (Object[])value;
            long handle = ((LONG)data[0]).value;
            Widget widget = (Widget)data[1];
            if (widget != null) {
                this.addWidget(handle, widget);
            } else {
                this.removeWidget(handle);
            }
        }
        if (key.equals(ADD_IDLE_PROC_KEY)) {
            this.addIdleProc();
            return;
        }
        if (key.equals(REMOVE_IDLE_PROC_KEY)) {
            this.removeIdleProc();
            return;
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    long setDirectionProc(long widget, long direction) {
        long submenu;
        GTK.gtk_widget_set_direction(widget, (int)direction);
        if (GTK.GTK_IS_MENU_ITEM(widget) && (submenu = GTK.gtk_menu_item_get_submenu(widget)) != 0L) {
            GTK.gtk_widget_set_direction(submenu, (int)direction);
            GTK.gtk_container_forall(submenu, this.setDirectionProc, direction);
        }
        if (GTK.GTK_IS_CONTAINER(widget)) {
            GTK.gtk_container_forall(widget, this.setDirectionProc, direction);
        }
        return 0L;
    }

    void setModalDialog(Dialog modalDailog) {
        this.modalDialog = modalDailog;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    void setModalShell(Shell shell) {
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    public final void setRuntimeExceptionHandler(Consumer<RuntimeException> runtimeExceptionHandler) {
        this.checkDevice();
        this.runtimeExceptionHandler = Objects.requireNonNull(runtimeExceptionHandler);
    }

    public final Consumer<RuntimeException> getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public final void setErrorHandler(Consumer<Error> errorHandler) {
        this.checkDevice();
        this.errorHandler = Objects.requireNonNull(errorHandler);
    }

    public final Consumer<Error> getErrorHandler() {
        return this.errorHandler;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0L) {
            this.preeditWindow = GTK.gtk_window_new(1);
            if (this.preeditWindow == 0L) {
                this.error(2);
            }
            this.preeditLabel = GTK.gtk_label_new(null);
            if (this.preeditLabel == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add(this.preeditWindow, this.preeditLabel);
            GTK.gtk_widget_show(this.preeditLabel);
        }
        long[] preeditString = new long[1];
        long[] pangoAttrs = new long[1];
        long imHandle = control.imHandle();
        GTK.gtk_im_context_get_preedit_string(imHandle, preeditString, pangoAttrs, null);
        if (preeditString[0] != 0L && C.strlen(preeditString[0]) > 0) {
            Control widget = control.findBackgroundControl();
            if (widget == null) {
                widget = control;
            }
            if (GTK.GTK3) {
                widget.setBackgroundGdkRGBA(this.preeditWindow, control.getBackgroundGdkRGBA());
                widget.setForegroundGdkRGBA(this.preeditLabel, control.getForegroundGdkRGBA());
            } else {
                GdkColor color = widget.getBackgroundGdkColor();
                GTK.gtk_widget_modify_bg(this.preeditWindow, 0, color);
                widget.setForegroundColor(this.preeditLabel, control.getForegroundGdkColor());
            }
            widget.setFontDescription(this.preeditLabel, control.getFontDescription());
            if (pangoAttrs[0] != 0L) {
                GTK.gtk_label_set_attributes(this.preeditLabel, pangoAttrs[0]);
            }
            GTK.gtk_label_set_text(this.preeditLabel, preeditString[0]);
            Point point = control.toDisplayInPixels(control.getIMCaretPos());
            GTK.gtk_window_move(this.preeditWindow, point.x, point.y);
            GtkRequisition requisition = new GtkRequisition();
            if (GTK.GTK3) {
                GTK.gtk_widget_get_preferred_size(this.preeditLabel, requisition, null);
            } else {
                GTK.gtk_widget_size_request(this.preeditLabel, requisition);
            }
            GTK.gtk_window_resize(this.preeditWindow, requisition.width, requisition.height);
            GTK.gtk_widget_show(this.preeditWindow);
        } else {
            GTK.gtk_widget_hide(this.preeditWindow);
        }
        if (preeditString[0] != 0L) {
            OS.g_free(preeditString[0]);
        }
        if (pangoAttrs[0] != 0L) {
            OS.pango_attr_list_unref(pangoAttrs[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            return false;
        }
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        if (this.fds == 0L) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        context = OS.g_main_context_default();
        result = false;
        do {
            if (!OS.g_main_context_acquire(context)) continue;
            result = OS.g_main_context_prepare(context, this.max_priority);
            while ((nfds = OS.g_main_context_query(context, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) > this.allocated_nfds) {
                OS.g_free(this.fds);
                this.allocated_nfds = nfds;
                this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
            }
            poll = OS.g_main_context_get_poll_func(context);
            if (poll != 0L && (nfds > 0 || this.timeout[0] != 0)) {
                if (this.timeout[0] < 0) {
                    this.timeout[0] = 50;
                }
                lock = Platform.lock;
                count = lock.lock();
                i = 0;
                while (i < count) {
                    lock.unlock();
                    ++i;
                }
                try {
                    this.wake = false;
                    OS.Call(poll, this.fds, nfds, this.timeout[0]);
                }
                finally {
                    i = 0;
                    ** while (i < count)
                }
lbl-1000:
                // 1 sources

                {
                    lock.lock();
                    ++i;
                    continue;
                }
lbl50:
                // 1 sources

                lock.unlock();
            }
            OS.g_main_context_check(context, this.max_priority[0], this.fds, nfds);
            OS.g_main_context_release(context);
        } while (!result && this.getMessageCount() == 0 && !this.wake);
        this.wake = false;
        this.sendPostExternalEventDispatchEvent();
        return true;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.g_source_remove(this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = OS.g_timeout_add(milliseconds, this.timerProc, index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    long timerProc(long i) {
        if (this.timerList == null) {
            return 0L;
        }
        int index = (int)i;
        if (index >= 0 && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                try {
                    runnable.run();
                }
                catch (RuntimeException exception) {
                    this.runtimeExceptionHandler.accept(exception);
                }
                catch (Error exception) {
                    this.errorHandler.accept(exception);
                }
            }
        }
        return 0L;
    }

    long caretProc(long clientData) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0L;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            if (blinkRate == 0) {
                return 0L;
            }
            this.currentCaret.getParent().blink = true;
            this.caretId = OS.g_timeout_add(blinkRate, this.caretProc, 0L);
        } else {
            this.currentCaret = null;
        }
        return 0L;
    }

    void resetCaretTiming() {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
            this.caretId = OS.g_timeout_add(this.currentCaret.blinkRate, this.caretProc, 0L);
        }
    }

    long sizeAllocateProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(user_data);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeAllocateProc(handle, arg0, user_data);
    }

    long sizeRequestProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(user_data);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeRequestProc(handle, arg0, user_data);
    }

    void saveResources() {
        int resourceCount = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            resourceCount = this.resources.length;
            Resource[] newResources = new Resource[resourceCount + 27];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
        if (this.errorImage != null) {
            this.resources[resourceCount++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[resourceCount++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[resourceCount++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[resourceCount++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.resources[resourceCount++] = this.cursors[i];
            }
            this.cursors[i] = null;
            ++i;
        }
        if (resourceCount < 27) {
            Resource[] newResources = new Resource[resourceCount];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(EventTable eventTable, Event event) {
        int type = event.type;
        this.sendPreEvent(type);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(type);
        }
    }

    void sendPreEvent(int eventType) {
        if (eventType != 50 && eventType != 51 && eventType != 52 && eventType != 53 && this.eventTable != null && this.eventTable.hooks(50)) {
            Event event = new Event();
            event.detail = eventType;
            this.sendEvent(50, event);
        }
    }

    void sendPostEvent(int eventType) {
        if (eventType != 50 && eventType != 51 && eventType != 52 && eventType != 53 && this.eventTable != null && this.eventTable.hooks(51)) {
            Event event = new Event();
            event.detail = eventType;
            this.sendEvent(51, event);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(52)) {
            this.sendEvent(52, null);
        }
    }

    public void sendPostExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(53)) {
            this.sendEvent(53, null);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int blinkRate = this.currentCaret.blinkRate;
        this.caretId = OS.g_timeout_add(blinkRate, this.caretProc, 0L);
    }

    long shellMapProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.shellMapProc(handle, arg0, user_data);
    }

    String simple_color_parser(String output, String value, int index) {
        if (output != null && value != null) {
            String[] cut;
            int position = index + value.length() + 1;
            String color = output.substring(position);
            if (color.startsWith("#") || color.startsWith("rgb")) {
                return color;
            }
            if (!color.startsWith("@") && this.colorList.contains((cut = color.split(";"))[0])) {
                return color;
            }
        }
        return "";
    }

    long signalProc(long gobject, long arg1, long user_data) {
        switch ((int)user_data) {
            case 1: {
                this.settingsChanged = true;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0L);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0L, true);
        if (GTK.GTK_VERSION < OS.VERSION(3, 16, 0)) {
            GDK.gdk_window_process_all_updates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.g_main_context_wakeup(0L);
        this.wake = true;
    }

    long windowProc(long handle, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, user_data);
    }

    long windowProc(long handle, long arg0, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, user_data);
    }

    long windowProc(long handle, long arg0, long arg1, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, arg1, user_data);
    }

    long windowProc(long handle, long arg0, long arg1, long arg2, long user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(handle, arg0, arg1, arg2, user_data);
    }

    long windowTimerProc(long handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0L;
        }
        return widget.timerProc(handle);
    }

    long gdk_window_get_device_position(long window, int[] x, int[] y, int[] mask) {
        if (GTK.GTK3) {
            long display = 0L;
            if (window != 0L) {
                display = GDK.gdk_window_get_display(window);
            } else {
                window = GDK.gdk_get_default_root_window();
                display = GDK.gdk_window_get_display(window);
            }
            long pointer = GDK.gdk_get_pointer(display);
            return GDK.gdk_window_get_device_position(window, pointer, x, y, mask);
        }
        return GDK.gdk_window_get_pointer(window, x, y, mask);
    }

    long gdk_device_get_window_at_position(int[] win_x, int[] win_y) {
        if (GTK.GTK3) {
            long display = GDK.gdk_display_get_default();
            long device = GDK.gdk_get_pointer(display);
            return GDK.gdk_device_get_window_at_position(device, win_x, win_y);
        }
        return GDK.gdk_window_at_pointer(win_x, win_y);
    }

    @Override
    protected long gsettingsProc(long gobject, long arg1, long user_data) {
        switch ((int)user_data) {
            case 1: {
                this.scaleFactor = this.getDeviceZoom();
                DPIUtil.setDeviceZoom(this.scaleFactor);
                Shell[] shells = this.getShells();
                int i = 0;
                while (i < shells.length) {
                    shells[i].layout(true, true);
                    ++i;
                }
                break;
            }
        }
        return 0L;
    }
}

