/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.test.section;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.uiforms.impl.form.DefaultForm;
import org.eclipse.reddeer.uiforms.impl.section.DefaultSection;
import org.eclipse.reddeer.uiforms.test.ui.views.UIFormView;
import org.eclipse.reddeer.workbench.api.View;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultSectionTest {
    private View uiFormView = new UIFormView();

    @Before
    public void openView() {
        this.uiFormView.open();
    }

    @Test
    public void defaultConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultSection().getText(), (Matcher)Is.is((Object)"Section A"));
    }

    @Test
    public void indexedConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultSection(1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Section B"));
    }

    @Test
    public void titleConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultSection("Section A").getText(), (Matcher)Is.is((Object)"Section A"));
    }

    @Test
    public void defaultConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultSection((ReferencedComposite)rc).getText(), (Matcher)Is.is((Object)"Section C"));
    }

    @Test
    public void indexedConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultSection((ReferencedComposite)rc, 1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Section D"));
    }

    @Test
    public void titleConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultSection((ReferencedComposite)rc, "Section C").getText(), (Matcher)Is.is((Object)"Section C"));
    }

    @Test(expected=CoreLayerException.class)
    public void testInvalidInstance() {
        new DefaultSection("Non existing section title");
    }

    @Test
    public void testExpanded_true() {
        DefaultSection section = new DefaultSection();
        section.setExpanded(true);
        Assert.assertNotNull((Object)new DefaultText((ReferencedComposite)section, "Value: "));
    }

    @Test(expected=CoreLayerException.class)
    public void testExpanded_false() {
        DefaultSection section = new DefaultSection();
        section.setExpanded(false);
        new DefaultText((ReferencedComposite)section, "Value: ");
    }
}

