/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filebuffers.DocumentReader;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileStoreFileBuffer;
import org.eclipse.core.internal.filebuffers.NLSUtility;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

public class FileStoreTextFileBuffer
extends FileStoreFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.FileBuffer_status_error, null);
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final QualifiedName[] NO_PROPERTIES = new QualifiedName[0];
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();
    private String fExplicitEncoding;
    private boolean fHasBOM;
    private IAnnotationModel fAnnotationModel;
    private final Object fAnnotationModelCreationLock = new Object();
    private boolean fIsCacheUpdated = false;

    public FileStoreTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    @Override
    public IDocument getDocument() {
        return this.fDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAnnotationModel getAnnotationModel() {
        Object object = this.fAnnotationModelCreationLock;
        synchronized (object) {
            if (this.fAnnotationModel == null && !this.isDisconnected()) {
                this.fAnnotationModel = this.fManager.createAnnotationModel(this.getLocationOrName(), LocationKind.LOCATION);
                if (this.fAnnotationModel != null) {
                    this.fAnnotationModel.connect(this.fDocument);
                }
            }
        }
        return this.fAnnotationModel;
    }

    @Override
    public String getEncoding() {
        if (!this.fIsCacheUpdated) {
            this.cacheEncodingState();
        }
        return this.fEncoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.fExplicitEncoding = encoding;
        if (encoding == null || encoding.equals(this.fEncoding)) {
            this.fIsCacheUpdated = false;
        } else {
            this.fEncoding = encoding;
            this.fHasBOM = false;
        }
    }

    @Override
    public IStatus getStatus() {
        if (!this.isDisconnected()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : Status.OK_STATUS;
        }
        return STATUS_ERROR;
    }

    private InputStream getFileContents(IFileStore fileStore) throws CoreException {
        if (!this.fFileStore.fetchInfo().exists()) {
            return null;
        }
        return fileStore.openInputStream(0, null);
    }

    private void setFileContents(InputStream stream, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStream out = this.fFileStore.openOutputStream(0, null);){
                    byte[] buffer = new byte[8192];
                    while (true) {
                        int bytesRead = -1;
                        bytesRead = stream.read(buffer);
                        if (bytesRead == -1) {
                            out.close();
                            break;
                        }
                        out.write(buffer, 0, bytesRead);
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                String message = ex.getMessage() != null ? ex.getMessage() : "";
                Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)ex);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void revert(IProgressMonitor monitor) throws CoreException {
        boolean replaceContents;
        if (this.isDisconnected()) {
            return;
        }
        IDocument original = null;
        this.fStatus = null;
        try {
            original = this.fManager.createEmptyDocument(this.getLocationOrName(), LocationKind.LOCATION);
            this.cacheEncodingState();
            this.setDocumentContent(original, this.fFileStore, this.fEncoding, this.fHasBOM, monitor);
        }
        catch (CoreException x) {
            this.fStatus = x.getStatus();
        }
        if (original == null) {
            return;
        }
        String originalContents = original.get();
        boolean bl = replaceContents = !originalContents.equals(this.fDocument.get());
        if (!replaceContents && !this.fCanBeSaved) {
            return;
        }
        this.fManager.fireStateChanging(this);
        try {
            IFileInfo info;
            if (replaceContents) {
                this.fManager.fireBufferContentAboutToBeReplaced(this);
                this.fDocument.set(original.get());
            }
            boolean fireDirtyStateChanged = this.fCanBeSaved;
            if (this.fCanBeSaved) {
                this.fCanBeSaved = false;
                this.addFileBufferContentListeners();
            }
            if (replaceContents) {
                this.fManager.fireBufferContentReplaced(this);
            }
            if ((info = this.fFileStore.fetchInfo()).exists()) {
                this.fSynchronizationStamp = this.fFileStore.fetchInfo().getLastModified();
            }
            if (this.fAnnotationModel instanceof IPersistableAnnotationModel) {
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                try {
                    persistableModel.revert(this.fDocument);
                }
                catch (CoreException x) {
                    this.fStatus = x.getStatus();
                }
            }
            if (fireDirtyStateChanged) {
                this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
            }
        }
        catch (RuntimeException x) {
            this.fManager.fireStateChangeFailed(this);
            throw x;
        }
    }

    @Override
    public IContentType getContentType() throws CoreException {
        InputStream stream;
        block27: {
            IContentType iContentType;
            block28: {
                IContentDescription desc;
                Object var2_5;
                Throwable throwable;
                block26: {
                    if (this.isDirty()) {
                        throwable = null;
                        var2_5 = null;
                        try (DocumentReader reader = new DocumentReader(this.getDocument());){
                            desc = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFileStore.getName(), NO_PROPERTIES);
                            if (desc == null || desc.getContentType() == null) break block26;
                            return desc.getContentType();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                throwable = null;
                var2_5 = null;
                stream = this.fFileStore.openInputStream(0, null);
                try {
                    desc = Platform.getContentTypeManager().getDescriptionFor(stream, this.fFileStore.getName(), NO_PROPERTIES);
                    if (desc == null || desc.getContentType() == null) break block27;
                    iContentType = desc.getContentType();
                    if (stream == null) break block28;
                }
                catch (Throwable throwable3) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                        catch (IOException x) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, NLSUtility.format(FileBuffersMessages.FileBuffer_error_queryContentDescription, this.fFileStore.toString()), (Throwable)x));
                        }
                    }
                }
                stream.close();
            }
            return iContentType;
        }
        if (stream != null) {
            stream.close();
        }
        return null;
    }

    @Override
    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    @Override
    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    @Override
    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocationOrName(), LocationKind.LOCATION);
            this.cacheEncodingState();
            this.setDocumentContent(this.fDocument, this.fFileStore, this.fEncoding, this.fHasBOM, monitor);
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocationOrName(), LocationKind.LOCATION);
            this.fStatus = x.getStatus();
        }
    }

    @Override
    protected void connected() {
        super.connected();
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.connect(this.fDocument);
        }
    }

    @Override
    protected void disconnected() {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.disconnect(this.fDocument);
        }
        super.disconnected();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cacheEncodingState() {
        block12: {
            this.fEncoding = this.fExplicitEncoding;
            this.fHasBOM = false;
            this.fIsCacheUpdated = true;
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    InputStream stream = this.getFileContents(this.fFileStore);
                    try {
                        if (stream == null) {
                            return;
                        }
                        QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                        IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(stream, this.fFileStore.getName(), options);
                        if (description == null) break block12;
                        boolean bl = this.fHasBOM = description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                        if (this.fEncoding == null) {
                            this.fEncoding = description.getCharset();
                        }
                    }
                    finally {
                        if (stream == null) return;
                        stream.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        if (this.fEncoding != null) return;
        this.fEncoding = this.fManager.getDefaultEncoding();
    }

    @Override
    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        byte[] bytes;
        int bytesLength;
        Charset charset;
        if (!this.isSynchronized() && !overwrite) {
            String message = NLSUtility.format(FileBuffersMessages.FileBuffer_error_outOfSync, this.getFileStore().toURI());
            throw new CoreException((IStatus)new Status(2, "org.eclipse.core.filebuffers", 274, message, null));
        }
        String encoding = this.computeEncoding();
        try {
            charset = Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException ex) {
            String message = NLSUtility.format(FileBuffersMessages.ResourceTextFileBuffer_error_unsupported_encoding_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
        catch (IllegalCharsetNameException ex) {
            String message = NLSUtility.format(FileBuffersMessages.ResourceTextFileBuffer_error_illegal_encoding_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(this.fDocument.get()));
            bytesLength = byteBuffer.limit();
            if (byteBuffer.hasArray()) {
                bytes = byteBuffer.array();
            } else {
                bytes = new byte[bytesLength];
                byteBuffer.get(bytes);
            }
        }
        catch (CharacterCodingException ex) {
            Assert.isTrue((boolean)(ex instanceof UnmappableCharacterException));
            String message = NLSUtility.format(FileBuffersMessages.ResourceTextFileBuffer_error_charset_mapping_failed_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 3, message, null);
            throw new CoreException((IStatus)s);
        }
        IFileInfo fileInfo = this.fFileStore.fetchInfo();
        if (fileInfo != null && fileInfo.exists()) {
            if (!overwrite) {
                this.checkSynchronizationState();
            }
            InputStream stream = new ByteArrayInputStream(bytes, 0, bytesLength);
            if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                stream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), stream);
            }
            this.setFileContents(stream, monitor);
            this.fSynchronizationStamp = this.fFileStore.fetchInfo().getLastModified();
            if (this.fAnnotationModel instanceof IPersistableAnnotationModel) {
                IPersistableAnnotationModel persistableModel22 = (IPersistableAnnotationModel)this.fAnnotationModel;
                persistableModel22.commit(this.fDocument);
            }
        } else {
            this.fFileStore.getParent().mkdir(0, null);
            try {
                Throwable stream = null;
                Object persistableModel22 = null;
                try (OutputStream out = this.fFileStore.openOutputStream(0, null);){
                    if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                        out.write(IContentDescription.BOM_UTF_8);
                    }
                    out.write(bytes, 0, bytesLength);
                    out.flush();
                    out.close();
                }
                catch (Throwable persistableModel22) {
                    if (stream == null) {
                        stream = persistableModel22;
                    } else if (stream != persistableModel22) {
                        stream.addSuppressed(persistableModel22);
                    }
                    throw stream;
                }
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.core.filebuffers", 0, x.getLocalizedMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
            this.fSynchronizationStamp = this.fFileStore.fetchInfo().getLastModified();
        }
    }

    private String computeEncoding() {
        block15: {
            if (!this.fIsCacheUpdated) {
                this.cacheEncodingState();
            }
            if (this.fExplicitEncoding != null) {
                return this.fExplicitEncoding;
            }
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (DocumentReader reader = new DocumentReader(this.fDocument);){
                    String encoding;
                    QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                    IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFileStore.getName(), options);
                    if (description == null || (encoding = description.getCharset()) == null) break block15;
                    return encoding;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        if (this.fHasBOM) {
            return this.fEncoding;
        }
        return this.fManager.getDefaultEncoding();
    }

    private void setDocumentContent(IDocument document, IFileStore file, String encoding, boolean hasBOM, IProgressMonitor monitor) throws CoreException {
        InputStream contentStream = this.getFileContents(file);
        if (contentStream == null) {
            return;
        }
        Reader in = null;
        try {
            try {
                if (encoding == null) {
                    encoding = this.fManager.getDefaultEncoding();
                }
                if (hasBOM && CHARSET_UTF_8.equals(encoding)) {
                    int bytes;
                    int n = 0;
                    do {
                        if ((bytes = contentStream.read(new byte[IContentDescription.BOM_UTF_8.length])) != -1) continue;
                        throw new IOException();
                    } while ((n += bytes) < IContentDescription.BOM_UTF_8.length);
                }
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 16384);
                StringBuilder buffer = new StringBuilder(16384);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
                document.set(buffer.toString());
            }
            catch (IOException x) {
                String msg = x.getMessage() == null ? "" : x.getMessage();
                Status s = new Status(4, "org.eclipse.core.filebuffers", 0, msg, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                } else {
                    contentStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            } else {
                contentStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.isSynchronized()) {
            String message = NLSUtility.format(FileBuffersMessages.FileBuffer_error_outOfSync, this.getFileStore().toURI());
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    private IPath getLocationOrName() {
        IPath path = this.getLocation();
        if (path == null) {
            path = new Path(this.fFileStore.getName());
        }
        return path;
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            FileStoreTextFileBuffer.this.fCanBeSaved = true;
            FileStoreTextFileBuffer.this.removeFileBufferContentListeners();
            FileStoreTextFileBuffer.this.fManager.fireDirtyStateChanged(FileStoreTextFileBuffer.this, FileStoreTextFileBuffer.this.fCanBeSaved);
        }
    }
}

