/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.hover;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.GenericContentTypeRelatedExtension;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.hover.OrderedExtensionComparator;

public final class TextHoverRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.hoverProviders";
    private SortedSet<TextHoverExtension> extensions;
    private boolean outOfSync = true;

    public TextHoverRegistry(IPreferenceStore preferenceStore) {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                TextHoverRegistry.this.outOfSync = true;
            }
        }, EXTENSION_POINT_ID);
    }

    public List<ITextHover> getAvailableHovers(ISourceViewer sourceViewer, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        return this.extensions.stream().filter(ext -> contentTypes.contains(ext.targetContentType)).map(GenericContentTypeRelatedExtension::createDelegate).collect(Collectors.toList());
    }

    private void sync() {
        Set<Object> toRemoveExtensions = new HashSet();
        Map<Object, Object> ext = new HashMap();
        if (this.extensions != null) {
            ext = this.extensions.stream().collect(Collectors.toMap(TextHoverExtension::getConfigurationElement, Function.identity()));
            toRemoveExtensions = ext.keySet();
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(iConfigurationElement);
            if (!ext.containsKey(iConfigurationElement)) {
                try {
                    ext.put(iConfigurationElement, new TextHoverExtension(iConfigurationElement));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement iConfigurationElement : toRemoveExtensions) {
            ext.remove(iConfigurationElement);
        }
        OrderedExtensionComparator orderedExtensionComparator = new OrderedExtensionComparator(ext.values());
        this.extensions = new TreeSet<TextHoverExtension>(orderedExtensionComparator);
        this.extensions.addAll(ext.values());
        this.outOfSync = false;
    }

    static class TextHoverExtension
    extends GenericContentTypeRelatedExtension<ITextHover> {
        private static final String ID_ATTRIBUTE = "id";
        private static final String IS_BEFORE_ATTRIBUTE = "isBefore";
        private static final String IS_AFTER_ATTRIBUTE = "isAfter";
        private String id;
        private String isBefore;
        private String isAfter;

        public TextHoverExtension(IConfigurationElement extension) throws Exception {
            super(extension);
            this.id = extension.getAttribute(ID_ATTRIBUTE);
            this.isBefore = extension.getAttribute(IS_BEFORE_ATTRIBUTE);
            this.isAfter = extension.getAttribute(IS_AFTER_ATTRIBUTE);
        }

        public String getId() {
            if (this.id != null) {
                return this.id;
            }
            return String.valueOf(this.extension.getContributor().getName()) + '@' + this.toString();
        }

        public String getIsAfter() {
            return this.isAfter;
        }

        public String getIsBefore() {
            return this.isBefore;
        }

        IConfigurationElement getConfigurationElement() {
            return this.extension;
        }
    }
}

