/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.InvalidTargetBundle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinitionPersistenceHelper;
import org.xml.sax.SAXException;

public class TargetDefinition
implements ITargetDefinition {
    private String fName;
    private NameVersionDescriptor[] fIncluded;
    private String fProgramArgs;
    private String fVMArgs;
    private IPath fJREContainer;
    private String fArch;
    private String fOS;
    private String fWS;
    private String fNL;
    private ITargetLocation[] fContainers;
    private ITargetHandle fHandle;
    private IStatus fResolutionStatus;
    private NameVersionDescriptor[] fImplicit;
    private int fUIMode = 0;
    public static final int MODE_PLUGIN = 0;
    public static final int MODE_FEATURE = 1;
    private static Map<String, TargetFeature[]> fFeaturesInLocation = new HashMap<String, TargetFeature[]>();
    private TargetFeature[] fFeatures;
    private TargetBundle[] fOtherBundles;
    private int fSequenceNumber = -1;

    TargetDefinition(ITargetHandle handle) {
        this.fHandle = handle;
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public ITargetLocation[] getTargetLocations() {
        return this.fContainers;
    }

    @Override
    public String getNL() {
        return this.fNL;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getOS() {
        return this.fOS;
    }

    @Override
    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    @Override
    public String getVMArguments() {
        return this.fVMArgs;
    }

    @Override
    public String getWS() {
        return this.fWS;
    }

    @Override
    public void setArch(String arch) {
        this.incrementSequenceNumber();
        this.fArch = arch;
    }

    @Override
    public void setNL(String nl) {
        this.incrementSequenceNumber();
        this.fNL = nl;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setOS(String os) {
        this.incrementSequenceNumber();
        this.fOS = os;
    }

    @Override
    public void setProgramArguments(String args) {
        if (args != null && args.length() == 0) {
            args = null;
        }
        this.fProgramArgs = args;
    }

    @Override
    public void setVMArguments(String args) {
        if (args != null && args.length() == 0) {
            args = null;
        }
        this.fVMArgs = args;
    }

    @Override
    public void setWS(String ws) {
        this.incrementSequenceNumber();
        this.fWS = ws;
    }

    @Override
    public void setTargetLocations(ITargetLocation[] locations) {
        this.incrementSequenceNumber();
        this.fFeatures = null;
        this.fOtherBundles = null;
        if (locations != null && locations.length == 0) {
            locations = null;
        }
        this.fContainers = locations;
        if (locations == null) {
            this.fIncluded = null;
        } else {
            ITargetLocation[] iTargetLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof AbstractBundleContainer) {
                    ((AbstractBundleContainer)location).associateWithTarget(this);
                }
                ++n2;
            }
        }
    }

    public void flushCaches(String location) {
        this.fFeatures = null;
        this.fOtherBundles = null;
        if (location == null) {
            fFeaturesInLocation.clear();
        } else {
            fFeaturesInLocation.remove(location);
        }
        if (this.fContainers == null) {
            this.fIncluded = null;
        }
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        ITargetLocation[] containers = this.getTargetLocations();
        int num = 0;
        HashMap<P2TargetUtils, Integer> synchronizerNumContainerMap = new HashMap<P2TargetUtils, Integer>();
        if (containers != null) {
            num = containers.length;
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation element = iTargetLocationArray[n2];
                P2TargetUtils synchronizer = (P2TargetUtils)element.getAdapter(P2TargetUtils.class);
                if (synchronizer != null) {
                    if (!synchronizerNumContainerMap.containsKey(synchronizer)) {
                        synchronizerNumContainerMap.put(synchronizer, 1);
                    } else {
                        Integer numberIU = (Integer)synchronizerNumContainerMap.get(synchronizer);
                        synchronizerNumContainerMap.put(synchronizer, numberIU + 1);
                    }
                }
                ++n2;
            }
        }
        this.fResolutionStatus = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TargetDefinition_1, (int)(num * 100));
        try {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_2, null);
            HashSet<P2TargetUtils> seen = new HashSet<P2TargetUtils>();
            if (containers != null) {
                P2TargetUtils synchronizer;
                ITargetLocation container;
                P2TargetUtils.fgTargetArtifactRepo.clear();
                P2TargetUtils.fgArtifactKeyRepoFile.clear();
                ITargetLocation[] iTargetLocationArray = containers;
                int n = containers.length;
                int n3 = 0;
                while (n3 < n) {
                    container = iTargetLocationArray[n3];
                    if (subMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    subMonitor.subTask(Messages.TargetDefinition_4);
                    synchronizer = (P2TargetUtils)container.getAdapter(P2TargetUtils.class);
                    if (synchronizer != null && !seen.contains(synchronizer)) {
                        seen.add(synchronizer);
                        try {
                            synchronizer.synchronize(this, (IProgressMonitor)subMonitor.split((Integer)synchronizerNumContainerMap.get(synchronizer) * 95));
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    }
                    ++n3;
                }
                synchronizerNumContainerMap.clear();
                if (!status.isOK()) {
                    this.fResolutionStatus = status;
                    MultiStatus multiStatus = this.fResolutionStatus;
                    return multiStatus;
                }
                if (subMonitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                iTargetLocationArray = containers;
                n = containers.length;
                n3 = 0;
                while (n3 < n) {
                    IStatus s;
                    container = iTargetLocationArray[n3];
                    if (subMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    subMonitor.subTask(Messages.TargetDefinition_4);
                    synchronizer = (P2TargetUtils)container.getAdapter(P2TargetUtils.class);
                    int totalWork = 5;
                    if (synchronizer == null) {
                        totalWork = 100;
                    }
                    if (!(s = container.resolve(this, (IProgressMonitor)subMonitor.split(totalWork))).isOK()) {
                        status.add(s);
                    }
                    ++n3;
                }
            }
            if (status.isOK()) {
                IStatus iStatus = this.fResolutionStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (subMonitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.fResolutionStatus = status;
            MultiStatus multiStatus = this.fResolutionStatus;
            return multiStatus;
        }
        finally {
            TargetPlatformHelper.addTargetDefinitionMap(this);
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public boolean isResolved() {
        ITargetLocation[] containers = this.getTargetLocations();
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation targetLocation = iTargetLocationArray[n2];
                if (!targetLocation.isResolved()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public IStatus getStatus() {
        if (this.fResolutionStatus != null && !this.fResolutionStatus.isOK()) {
            return this.fResolutionStatus;
        }
        if (this.isResolved()) {
            ITargetLocation[] containers = this.getTargetLocations();
            if (containers != null) {
                MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
                ITargetLocation[] iTargetLocationArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    ITargetLocation container = iTargetLocationArray[n2];
                    IStatus containerStatus = container.getStatus();
                    if (containerStatus != null && !containerStatus.isOK()) {
                        result.add(containerStatus);
                    }
                    ++n2;
                }
                TargetBundle[] bundles = this.getBundles();
                int i = 0;
                while (i < bundles.length) {
                    if (!bundles[i].getStatus().isOK()) {
                        result.add(bundles[i].getStatus());
                    }
                    ++i;
                }
                if (result.isOK()) {
                    return Status.OK_STATUS;
                }
                return result;
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    @Override
    public void setIncluded(NameVersionDescriptor[] included) {
        this.fIncluded = included;
    }

    @Override
    public NameVersionDescriptor[] getIncluded() {
        return this.fIncluded;
    }

    @Override
    public TargetBundle[] getBundles() {
        return this.getBundles(false);
    }

    @Override
    public TargetBundle[] getAllBundles() {
        return this.getBundles(true);
    }

    private TargetBundle[] getBundles(boolean allBundles) {
        if (this.isResolved()) {
            ITargetLocation[] containers = this.getTargetLocations();
            if (containers != null) {
                ArrayList<TargetBundle> all = new ArrayList<TargetBundle>();
                ITargetLocation[] iTargetLocationArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    ITargetLocation container = iTargetLocationArray[n2];
                    TargetBundle[] bundles = container.getBundles();
                    if (bundles != null) {
                        TargetBundle[] targetBundleArray = bundles;
                        int n3 = bundles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TargetBundle rb = targetBundleArray[n4];
                            all.add(rb);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                TargetBundle[] allResolvedBundles = all.toArray(new TargetBundle[all.size()]);
                if (allBundles) {
                    return allResolvedBundles;
                }
                return this.filterBundles(allResolvedBundles, this.getIncluded());
            }
            return new TargetBundle[0];
        }
        return null;
    }

    private TargetBundle[] filterBundles(TargetBundle[] bundles, NameVersionDescriptor[] filter) {
        if (filter == null) {
            return bundles;
        }
        if (filter.length == 0) {
            return new TargetBundle[0];
        }
        boolean containsFeatures = false;
        ArrayList<NameVersionDescriptor> missingFeatures = new ArrayList<NameVersionDescriptor>();
        ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
        NameVersionDescriptor[] nameVersionDescriptorArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            NameVersionDescriptor element = nameVersionDescriptorArray[n2];
            if (element.getType() == "plugin") {
                included.add(element);
            } else if (element.getType() == "feature") {
                containsFeatures = true;
                TargetFeature[] features = this.getAllFeatures();
                TargetFeature bestMatch = null;
                TargetFeature[] targetFeatureArray = features;
                int n3 = features.length;
                int n4 = 0;
                while (n4 < n3) {
                    TargetFeature feature = targetFeatureArray[n4];
                    if (feature.getId().equals(element.getId())) {
                        Version v2;
                        Version v1;
                        if (element.getVersion() != null) {
                            if (element.getVersion().equals(feature.getVersion())) {
                                bestMatch = feature;
                                break;
                            }
                        } else if (bestMatch != null && (v1 = Version.parseVersion((String)feature.getVersion())).compareTo((Object)(v2 = Version.parseVersion((String)bestMatch.getVersion()))) > 0) {
                            bestMatch = feature;
                        }
                        if (bestMatch == null) {
                            bestMatch = feature;
                        }
                    }
                    ++n4;
                }
                if (bestMatch != null) {
                    NameVersionDescriptor[] plugins;
                    NameVersionDescriptor[] nameVersionDescriptorArray2 = plugins = bestMatch.getPlugins();
                    int n5 = plugins.length;
                    n3 = 0;
                    while (n3 < n5) {
                        NameVersionDescriptor plugin = nameVersionDescriptorArray2[n3];
                        included.add(plugin);
                        ++n3;
                    }
                } else {
                    missingFeatures.add(element);
                }
            }
            ++n2;
        }
        List<TargetBundle> result = TargetDefinition.getMatchingBundles(bundles, included.toArray(new NameVersionDescriptor[included.size()]), !containsFeatures);
        if (containsFeatures && !missingFeatures.isEmpty()) {
            for (NameVersionDescriptor missing : missingFeatures) {
                BundleInfo info = new BundleInfo(missing.getId(), missing.getVersion(), null, -1, false);
                String message = NLS.bind((String)Messages.TargetDefinition_RequiredFeatureCouldNotBeFound, (Object)missing.getId());
                Status status = new Status(4, "org.eclipse.pde.core", 110, message, null);
                result.add(new InvalidTargetBundle(info, (IStatus)status));
            }
        }
        return result.toArray(new TargetBundle[result.size()]);
    }

    static List<TargetBundle> getMatchingBundles(TargetBundle[] collection, NameVersionDescriptor[] included, boolean handleMissingBundles) {
        Object resolved;
        if (included == null) {
            ArrayList<TargetBundle> result = new ArrayList<TargetBundle>();
            result.addAll(Arrays.asList(collection));
            return result;
        }
        HashMap<String, List<TargetBundle>> bundleMap = new HashMap<String, List<TargetBundle>>(collection.length);
        TargetBundle[] targetBundleArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            resolved = targetBundleArray[n2];
            ArrayList<Object> list = (ArrayList<Object>)bundleMap.get(((TargetBundle)resolved).getBundleInfo().getSymbolicName());
            if (list == null) {
                list = new ArrayList<Object>(3);
                bundleMap.put(((TargetBundle)resolved).getBundleInfo().getSymbolicName(), list);
            }
            list.add(resolved);
            ++n2;
        }
        resolved = new ArrayList();
        NameVersionDescriptor[] nameVersionDescriptorArray = included;
        int n3 = included.length;
        n = 0;
        while (n < n3) {
            NameVersionDescriptor element = nameVersionDescriptorArray[n];
            BundleInfo info = new BundleInfo(element.getId(), element.getVersion(), null, -1, false);
            TargetBundle bundle = TargetDefinition.resolveBundle(bundleMap, info, handleMissingBundles);
            if (bundle != null) {
                resolved.add(bundle);
            }
            ++n;
        }
        return resolved;
    }

    private static TargetBundle resolveBundle(Map<String, List<TargetBundle>> bundleMap, BundleInfo info, boolean handleMissingBundles) {
        List<TargetBundle> list = bundleMap.get(info.getSymbolicName());
        if (list != null) {
            String version = info.getVersion();
            if (version == null || version.equals("0.0.0")) {
                if (list.size() > 1) {
                    Collections.sort(list, (o1, o2) -> {
                        BundleInfo b1 = o1.getBundleInfo();
                        BundleInfo b2 = o2.getBundleInfo();
                        try {
                            Version v1 = Version.create((String)b1.getVersion());
                            Version v2 = Version.create((String)b2.getVersion());
                            return v1.compareTo((Object)v2);
                        }
                        catch (IllegalArgumentException e) {
                            PDECore.log(e);
                            return b1.getVersion().compareTo(b2.getVersion());
                        }
                    });
                }
                TargetBundle rb = list.get(list.size() - 1);
                return rb;
            }
            for (TargetBundle bundle : list) {
                if (!bundle.getBundleInfo().getVersion().equals(version)) continue;
                return bundle;
            }
            for (TargetBundle bundle : list) {
                try {
                    org.osgi.framework.Version bundleVersion = new org.osgi.framework.Version(bundle.getBundleInfo().getVersion());
                    org.osgi.framework.Version infoVersion = new org.osgi.framework.Version(version);
                    if (bundleVersion.getMajor() != infoVersion.getMajor() || bundleVersion.getMinor() != infoVersion.getMinor() || bundleVersion.getMicro() != infoVersion.getMicro()) continue;
                    return bundle;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (!handleMissingBundles) {
                return null;
            }
            int sev = 4;
            String message = NLS.bind((String)Messages.AbstractBundleContainer_1, (Object[])new Object[]{info.getVersion(), info.getSymbolicName()});
            Status status = new Status(sev, "org.eclipse.pde.core", 101, message, null);
            return new InvalidTargetBundle(info, (IStatus)status);
        }
        if (!handleMissingBundles) {
            return null;
        }
        int sev = 4;
        String message = NLS.bind((String)Messages.AbstractBundleContainer_3, (Object)info.getSymbolicName());
        Status status = new Status(sev, "org.eclipse.pde.core", 100, message, null);
        return new InvalidTargetBundle(info, (IStatus)status);
    }

    @Override
    public ITargetHandle getHandle() {
        return this.fHandle;
    }

    void setContents(InputStream stream) throws CoreException {
        try {
            this.fArch = null;
            this.fContainers = null;
            this.fImplicit = null;
            this.fJREContainer = null;
            this.fIncluded = null;
            this.fName = null;
            this.fNL = null;
            this.fOS = null;
            this.fProgramArgs = null;
            this.fVMArgs = null;
            this.fWS = null;
            this.fSequenceNumber = 0;
            TargetDefinitionPersistenceHelper.initFromXML(this, stream);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (SAXException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
    }

    void write(OutputStream stream) throws CoreException {
        try {
            TargetDefinitionPersistenceHelper.persistXML(this, stream);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (TransformerException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (SAXException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
    }

    private void abort(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", message, (Throwable)e));
    }

    @Override
    public NameVersionDescriptor[] getImplicitDependencies() {
        return this.fImplicit;
    }

    @Override
    public void setImplicitDependencies(NameVersionDescriptor[] bundles) {
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        this.fImplicit = bundles;
    }

    @Override
    public IPath getJREContainer() {
        return this.fJREContainer;
    }

    @Override
    public void setJREContainer(IPath containerPath) {
        this.fJREContainer = containerPath;
    }

    public boolean isContentEqual(ITargetDefinition definition) {
        ITargetLocation[] c2;
        ITargetLocation[] c1;
        if (this.isNullOrEqual(this.getName(), definition.getName()) && this.isNullOrEqual(this.getArch(), definition.getArch()) && this.isNullOrEqual(this.getNL(), definition.getNL()) && this.isNullOrEqual(this.getOS(), definition.getOS()) && this.isNullOrEqual(this.getWS(), definition.getWS()) && this.isNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && this.isNullOrEqual(this.getJREContainer(), definition.getJREContainer()) && this.isNullOrEqual(this.getIncluded(), definition.getIncluded()) && this.areContainersEqual(c1 = this.getTargetLocations(), c2 = definition.getTargetLocations())) {
            return this.isNullOrEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    public boolean isContentEquivalent(ITargetDefinition definition) {
        ITargetLocation[] c2;
        ITargetLocation[] c1;
        if (this.isNullOrEqual(this.getArch(), definition.getArch()) && this.isNullOrEqual(this.getNL(), definition.getNL()) && this.isNullOrEqual(this.getOS(), definition.getOS()) && this.isNullOrEqual(this.getWS(), definition.getWS()) && this.isArgsNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isArgsNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && this.isNullOrEqual(this.getJREContainer(), definition.getJREContainer()) && this.isNullOrEqual(this.getIncluded(), definition.getIncluded()) && this.areContainersEqual(c1 = this.getTargetLocations(), c2 = definition.getTargetLocations())) {
            return this.isNullOrEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private boolean isNullOrEqual(Object[] objects1, Object[] objects2) {
        if (objects1 == null) {
            return objects2 == null;
        }
        if (objects2 == null) {
            return false;
        }
        if (objects1.length == objects2.length) {
            int i = 0;
            while (i < objects1.length) {
                if (!objects1[i].equals(objects2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isArgsNullOrEqual(String args1, String args2) {
        String[] a2;
        if (args1 == null) {
            return args2 == null;
        }
        if (args2 == null) {
            return false;
        }
        String[] a1 = DebugPlugin.parseArguments((String)args1);
        if (a1.length == (a2 = DebugPlugin.parseArguments((String)args2)).length) {
            int i = 0;
            while (i < a1.length) {
                if (!a1[i].equals(a2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean areContainersEqual(ITargetLocation[] c1, ITargetLocation[] c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.length == c2.length) {
            int i = 0;
            while (i < c2.length) {
                if (!c1[i].equals(c2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fName != null ? this.fName : "No Name");
        if (this.fContainers == null) {
            buf.append("\n\tNo containers");
        } else {
            ITargetLocation[] iTargetLocationArray = this.fContainers;
            int n = this.fContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation fContainer = iTargetLocationArray[n2];
                buf.append("\n\t").append(fContainer.toString());
                ++n2;
            }
        }
        buf.append("\nEnv: ").append(this.fOS).append("/").append(this.fWS).append("/").append(this.fArch).append("/").append(this.fNL);
        buf.append("\nJRE: ").append(this.fJREContainer);
        buf.append("\nArgs: ").append(this.fProgramArgs).append("/").append(this.fVMArgs);
        buf.append("\nImplicit: ").append(this.fImplicit == null ? "null" : Integer.toString(this.fImplicit.length));
        buf.append("\nHandle: ").append(this.fHandle.toString());
        return buf.toString();
    }

    public TargetFeature[] resolveFeatures(String locationPath, IProgressMonitor monitor) throws CoreException {
        String path = locationPath;
        if (path == null) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            path = manager.performStringSubstitution(path);
        }
        TargetFeature[] models = null;
        if (fFeaturesInLocation != null) {
            models = fFeaturesInLocation.get(path);
        }
        if (models != null) {
            return models;
        }
        models = ExternalFeatureModelManager.createFeatures(path, new ArrayList(), monitor);
        fFeaturesInLocation.put(path, models);
        return models;
    }

    @Override
    public TargetFeature[] getAllFeatures() {
        if (!this.isResolved()) {
            return null;
        }
        if (this.fFeatures != null) {
            return this.fFeatures;
        }
        ITargetLocation[] containers = this.getTargetLocations();
        HashMap<NameVersionDescriptor, TargetFeature> result = new HashMap<NameVersionDescriptor, TargetFeature>();
        if (containers != null && containers.length > 0) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                TargetFeature[] currentFeatures = container.getFeatures();
                if (currentFeatures != null && currentFeatures.length > 0) {
                    TargetFeature[] targetFeatureArray = currentFeatures;
                    int n3 = currentFeatures.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TargetFeature feature = targetFeatureArray[n4];
                        if (feature.getId() != null) {
                            NameVersionDescriptor key = new NameVersionDescriptor(feature.getId(), feature.getVersion());
                            result.put(key, feature);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.fFeatures = result.values().toArray(new TargetFeature[result.size()]);
        return this.fFeatures;
    }

    public TargetBundle[] getOtherBundles() {
        TargetFeature[] features;
        if (!this.isResolved()) {
            return null;
        }
        if (this.fOtherBundles != null) {
            return this.fOtherBundles;
        }
        TargetBundle[] allBundles = this.getAllBundles();
        HashMap<String, TargetBundle> remaining = new HashMap<String, TargetBundle>();
        TargetBundle[] targetBundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle allBundle = targetBundleArray[n2];
            remaining.put(allBundle.getBundleInfo().getSymbolicName(), allBundle);
            ++n2;
        }
        TargetFeature[] targetFeatureArray = features = this.getAllFeatures();
        int n3 = features.length;
        n = 0;
        while (n < n3) {
            NameVersionDescriptor[] plugins;
            TargetFeature feature = targetFeatureArray[n];
            NameVersionDescriptor[] nameVersionDescriptorArray = plugins = feature.getPlugins();
            int n4 = plugins.length;
            int n5 = 0;
            while (n5 < n4) {
                NameVersionDescriptor plugin = nameVersionDescriptorArray[n5];
                remaining.remove(plugin.getId());
                ++n5;
            }
            ++n;
        }
        Collection values = remaining.values();
        this.fOtherBundles = values.toArray(new TargetBundle[values.size()]);
        return this.fOtherBundles;
    }

    public Set<Object> getFeaturesAndBundles() {
        if (!this.isResolved()) {
            return null;
        }
        TargetFeature[] allFeatures = this.getAllFeatures();
        TargetBundle[] allExtraBundles = this.getOtherBundles();
        NameVersionDescriptor[] included = this.getIncluded();
        if (included == null) {
            HashSet<Object> result = new HashSet<Object>();
            result.addAll(Arrays.asList(allFeatures));
            result.addAll(Arrays.asList(allExtraBundles));
            return result;
        }
        HashSet<Object> result = new HashSet<Object>();
        NameVersionDescriptor[] nameVersionDescriptorArray = included;
        int n = included.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            Object[] objectArray;
            NameVersionDescriptor element = nameVersionDescriptorArray[n2];
            if (element.getType() == "plugin") {
                objectArray = allExtraBundles;
                n4 = allExtraBundles.length;
                n3 = 0;
                while (n3 < n4) {
                    Object allExtraBundle = objectArray[n3];
                    if (((TargetBundle)allExtraBundle).getBundleInfo().getSymbolicName().equals(element.getId())) {
                        result.add(allExtraBundle);
                    }
                    ++n3;
                }
            } else if (element.getType() == "feature") {
                objectArray = allFeatures;
                n4 = allFeatures.length;
                n3 = 0;
                while (n3 < n4) {
                    Object allFeature = objectArray[n3];
                    if (((TargetFeature)allFeature).getId().equals(element.getId())) {
                        result.add(allFeature);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return result;
    }

    public int getUIMode() {
        return this.fUIMode;
    }

    public void setUIMode(int mode) {
        this.fUIMode = mode;
    }

    public int getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public int incrementSequenceNumber() {
        return ++this.fSequenceNumber;
    }

    void setSequenceNumber(int value) {
        this.fSequenceNumber = value;
    }
}

