/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.codemining.ICodeMiningAnnotation;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CodeMiningLineContentAnnotation
extends LineContentAnnotation
implements ICodeMiningAnnotation {
    private static final String SEPARATOR = " | ";
    private ICodeMining[] fResolvedMinings = null;
    private final List<ICodeMining> fMinings = new ArrayList<ICodeMining>();
    private final List<Rectangle> fBounds = new ArrayList<Rectangle>();
    private IProgressMonitor fMonitor;

    public CodeMiningLineContentAnnotation(Position position, ISourceViewer viewer) {
        super(position, viewer);
    }

    @Override
    public void update(List<ICodeMining> minings, IProgressMonitor monitor) {
        this.disposeMinings();
        this.fMonitor = monitor;
        this.fMinings.addAll(minings);
        if (this.fResolvedMinings == null || this.fResolvedMinings.length != this.fMinings.size()) {
            this.fResolvedMinings = new ICodeMining[this.fMinings.size()];
        }
    }

    public void markDeleted(boolean deleted) {
        super.markDeleted(deleted);
        if (deleted) {
            this.disposeMinings();
            this.fResolvedMinings = null;
        }
    }

    private void disposeMinings() {
        this.fMinings.stream().forEach(ICodeMining::dispose);
        this.fMinings.clear();
    }

    @Override
    protected int drawAndComputeWidth(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(this.fMinings);
        int nbDraw = 0;
        int originalX = x;
        int separatorWidth = -1;
        boolean redrawn = false;
        this.fBounds.clear();
        int i = 0;
        while (i < minings.size()) {
            block7: {
                ICodeMining mining;
                block6: {
                    block5: {
                        mining = (ICodeMining)minings.get(i);
                        if (mining.isResolved()) break block5;
                        if (!redrawn) {
                            this.redraw();
                            redrawn = true;
                        }
                        if (this.fResolvedMinings != null) {
                            mining = this.fResolvedMinings[i];
                        }
                        if (mining != null) break block6;
                        break block7;
                    }
                    this.fResolvedMinings[i] = mining;
                }
                if (nbDraw > 0) {
                    this.initGC(textWidget, color, gc);
                    gc.drawText(SEPARATOR, x, y);
                    if (separatorWidth == -1) {
                        separatorWidth = gc.stringExtent((String)SEPARATOR).x;
                    }
                    x += separatorWidth;
                }
                this.initGC(textWidget, color, gc);
                Point loc = mining.draw(gc, textWidget, color, x, y);
                this.fBounds.add(new Rectangle(x, y, loc.x, loc.y));
                x += loc.x;
                ++nbDraw;
            }
            ++i;
        }
        return x - originalX;
    }

    private void initGC(StyledText textWidget, Color color, GC gc) {
        gc.setForeground(color);
        gc.setBackground(textWidget.getBackground());
        gc.setFont(textWidget.getFont());
    }

    @Override
    public void redraw() {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(this.fMinings);
        for (ICodeMining mining : minings) {
            if (mining.isResolved()) continue;
            mining.resolve(this.getViewer(), this.fMonitor).thenRunAsync(() -> this.redraw());
            return;
        }
        super.redraw();
    }

    @Override
    public Consumer<MouseEvent> getAction(MouseEvent e) {
        int i = 0;
        while (i < this.fBounds.size()) {
            Rectangle bound = this.fBounds.get(i);
            if (bound.contains(e.x, e.y)) {
                ICodeMining mining = this.fMinings.get(i);
                return mining.getAction();
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isInVisibleLines() {
        return super.isInVisibleLines();
    }
}

