/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import java.util.function.Consumer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationDrawingStrategy;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public abstract class AbstractInlinedAnnotation
extends Annotation {
    public static final String TYPE = "org.eclipse.jface.text.source.inlined";
    private final Position position;
    private ISourceViewer fViewer;
    private InlinedAnnotationSupport support;

    protected AbstractInlinedAnnotation(Position position, ISourceViewer viewer) {
        super(TYPE, false, "");
        this.position = position;
        this.fViewer = viewer;
    }

    public Position getPosition() {
        return this.position;
    }

    public StyledText getTextWidget() {
        return this.fViewer.getTextWidget();
    }

    public ISourceViewer getViewer() {
        return this.fViewer;
    }

    public void redraw() {
        StyledText text = this.getTextWidget();
        InlinedAnnotationSupport.runInUIThread(text, t -> {
            Position pos = this.getPosition();
            int offset = pos.getOffset();
            ISourceViewer viewer = this.getViewer();
            if (viewer instanceof ITextViewerExtension5) {
                offset = ((ITextViewerExtension5)((Object)viewer)).modelOffset2WidgetOffset(offset);
            }
            InlinedAnnotationDrawingStrategy.draw(this, null, t, offset, pos.getLength(), null);
        });
    }

    public void draw(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        gc.setForeground(color);
        gc.setBackground(textWidget.getBackground());
        gc.drawText(this.getText(), x, y);
    }

    public void onMouseHover(MouseEvent e) {
        StyledText styledText = (StyledText)e.widget;
        styledText.setCursor(styledText.getDisplay().getSystemCursor(21));
    }

    public void onMouseOut(MouseEvent e) {
        StyledText styledText = (StyledText)e.widget;
        styledText.setCursor(null);
    }

    public Consumer<MouseEvent> getAction(MouseEvent e) {
        return null;
    }

    void setSupport(InlinedAnnotationSupport support) {
        this.support = support;
    }

    protected boolean isInVisibleLines() {
        return this.support.isInVisibleLines(this.getPosition().getOffset());
    }

    protected boolean isInVisibleLines(int offset) {
        return this.support.isInVisibleLines(offset);
    }
}

