/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationDrawingStrategy;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextLineSpacingProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class InlinedAnnotationSupport
implements StyledTextLineSpacingProvider {
    private static final AnnotationPainter.IDrawingStrategy INLINED_STRATEGY = new InlinedAnnotationDrawingStrategy();
    private static final String INLINED_STRATEGY_ID = "inlined";
    private ITextPresentationListener updateStylesWidth;
    private VisibleLines visibleLines;
    private ISourceViewer fViewer;
    private AnnotationPainter fPainter;
    private Set<AbstractInlinedAnnotation> fInlinedAnnotations;
    private final MouseTracker fMouseTracker = new MouseTracker();

    public void install(ISourceViewer viewer, AnnotationPainter painter) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)painter);
        this.fViewer = viewer;
        this.fPainter = painter;
        this.initPainter();
        StyledText text = this.fViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        if (this.fViewer instanceof ITextViewerExtension4) {
            this.updateStylesWidth = new UpdateStylesWidth();
            ((ITextViewerExtension4)((Object)this.fViewer)).addTextPresentationListener(this.updateStylesWidth);
        }
        this.visibleLines = new VisibleLines();
        this.fViewer.addViewportListener(this.visibleLines);
        text.addMouseListener((MouseListener)this.fMouseTracker);
        text.addMouseTrackListener((MouseTrackListener)this.fMouseTracker);
        text.addMouseMoveListener((MouseMoveListener)this.fMouseTracker);
        text.setLineSpacingProvider((StyledTextLineSpacingProvider)this);
        this.setColor(text.getDisplay().getSystemColor(16));
    }

    private void initPainter() {
        this.fPainter.addDrawingStrategy(INLINED_STRATEGY_ID, INLINED_STRATEGY);
        this.fPainter.addAnnotationType("org.eclipse.jface.text.source.inlined", INLINED_STRATEGY_ID);
    }

    public void setColor(Color color) {
        this.fPainter.setAnnotationTypeColor("org.eclipse.jface.text.source.inlined", color);
    }

    public void uninstall() {
        StyledText text = this.fViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.removeMouseListener((MouseListener)this.fMouseTracker);
            text.removeMouseTrackListener((MouseTrackListener)this.fMouseTracker);
            text.removeMouseMoveListener((MouseMoveListener)this.fMouseTracker);
        }
        if (this.fViewer != null) {
            if (this.fViewer instanceof ITextViewerExtension4) {
                ((ITextViewerExtension4)((Object)this.fViewer)).removeTextPresentationListener(this.updateStylesWidth);
            }
            this.fViewer.removeViewportListener(this.visibleLines);
        }
        if (this.visibleLines != null) {
            this.visibleLines.uninstall();
            this.visibleLines = null;
        }
        this.fViewer = null;
        this.fPainter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnotations(Set<AbstractInlinedAnnotation> annotations) {
        IDocument document;
        IDocument iDocument = document = this.fViewer != null ? this.fViewer.getDocument() : null;
        if (document == null) {
            return;
        }
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        HashMap<AbstractInlinedAnnotation, Position> annotationsToAdd = new HashMap<AbstractInlinedAnnotation, Position>();
        ArrayList<AbstractInlinedAnnotation> annotationsToRemove = this.fInlinedAnnotations != null ? new ArrayList<AbstractInlinedAnnotation>(this.fInlinedAnnotations) : Collections.emptyList();
        for (AbstractInlinedAnnotation ann : annotations) {
            if (annotationsToRemove.remove((Object)ann)) continue;
            annotationsToAdd.put(ann, ann.getPosition());
        }
        for (AbstractInlinedAnnotation ann : annotationsToRemove) {
            ann.markDeleted(true);
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            for (AbstractInlinedAnnotation ann : annotations) {
                ann.setSupport(this);
            }
            if (annotationsToAdd.size() != 0 || annotationsToRemove.size() != 0) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), annotationsToAdd);
                } else {
                    this.removeInlinedAnnotations();
                    for (Map.Entry mapEntry : annotationsToAdd.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
            }
            this.fInlinedAnnotations = annotations;
        }
    }

    public <T extends AbstractInlinedAnnotation> T findExistingAnnotation(Position pos) {
        if (this.fInlinedAnnotations == null) {
            return null;
        }
        for (AbstractInlinedAnnotation ann : this.fInlinedAnnotations) {
            if (!pos.equals((Object)ann.getPosition()) || ann.getPosition().isDeleted()) continue;
            try {
                return (T)((Object)ann);
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInlinedAnnotations() {
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        if (annotationModel == null || this.fInlinedAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fInlinedAnnotations.toArray(new Annotation[this.fInlinedAnnotations.size()]), null);
            } else {
                for (AbstractInlinedAnnotation annotation : this.fInlinedAnnotations) {
                    annotationModel.removeAnnotation((Annotation)annotation);
                }
            }
            this.fInlinedAnnotations = null;
        }
    }

    public Integer getLineSpacing(int lineIndex) {
        AbstractInlinedAnnotation annotation = InlinedAnnotationSupport.getInlinedAnnotationAtLine(this.fViewer, lineIndex);
        return annotation instanceof LineHeaderAnnotation ? Integer.valueOf(((LineHeaderAnnotation)annotation).getHeight()) : null;
    }

    private static AbstractInlinedAnnotation getInlinedAnnotationAtLine(ISourceViewer viewer, int lineIndex) {
        if (viewer == null) {
            return null;
        }
        IAnnotationModel annotationModel = viewer.getAnnotationModel();
        if (annotationModel == null) {
            return null;
        }
        int lineNumber = lineIndex + 1;
        IDocument document = viewer.getDocument();
        if (lineNumber > document.getNumberOfLines()) {
            return null;
        }
        try {
            if (viewer instanceof ITextViewerExtension5) {
                lineNumber = ((ITextViewerExtension5)((Object)viewer)).widgetLine2ModelLine(lineNumber);
            }
            IRegion line = document.getLineInformation(lineNumber);
            return InlinedAnnotationSupport.getInlinedAnnotationAtOffset(viewer, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static AbstractInlinedAnnotation getInlinedAnnotationAtPoint(ISourceViewer viewer, Point point) {
        AbstractInlinedAnnotation annotation = InlinedAnnotationSupport.getLineContentAnnotationAtPoint(viewer, point);
        if (annotation != null) {
            return annotation;
        }
        return InlinedAnnotationSupport.getLineHeaderAnnotationAtPoint(viewer, point);
    }

    private static AbstractInlinedAnnotation getLineContentAnnotationAtPoint(ISourceViewer viewer, Point point) {
        AbstractInlinedAnnotation annotation;
        StyledText styledText = viewer.getTextWidget();
        int offset = styledText.getOffsetAtPoint(point);
        if (offset == -1) {
            return null;
        }
        if (viewer instanceof ITextViewerExtension5) {
            offset = ((ITextViewerExtension5)((Object)viewer)).widgetOffset2ModelOffset(offset);
        }
        if ((annotation = InlinedAnnotationSupport.getInlinedAnnotationAtOffset(viewer, offset, 1)) instanceof LineContentAnnotation) {
            return annotation;
        }
        return null;
    }

    private static AbstractInlinedAnnotation getLineHeaderAnnotationAtPoint(ISourceViewer viewer, Point point) {
        StyledText styledText = viewer.getTextWidget();
        int lineIndex = styledText.getLineIndex(point.y);
        AbstractInlinedAnnotation annotation = InlinedAnnotationSupport.getInlinedAnnotationAtLine(viewer, lineIndex);
        if (annotation instanceof LineHeaderAnnotation) {
            return annotation;
        }
        return null;
    }

    private static AbstractInlinedAnnotation getInlinedAnnotationAtOffset(ISourceViewer viewer, int offset, int length) {
        if (viewer == null) {
            return null;
        }
        IAnnotationModel annotationModel = viewer.getAnnotationModel();
        if (annotationModel == null) {
            return null;
        }
        Iterator iter = annotationModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)annotationModel).getAnnotationIterator(offset, length, true, true) : annotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Position p;
            Annotation ann = (Annotation)iter.next();
            if (!(ann instanceof AbstractInlinedAnnotation) || (p = annotationModel.getPosition(ann)) == null || !p.overlapsWith(offset, length)) continue;
            return (AbstractInlinedAnnotation)ann;
        }
        return null;
    }

    static void runInUIThread(StyledText text, Consumer<StyledText> fn) {
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            try {
                fn.accept(text);
            }
            catch (Exception exception) {}
        } else {
            display.asyncExec(() -> {
                if (text.isDisposed()) {
                    return;
                }
                try {
                    fn.accept(text);
                }
                catch (Exception exception) {}
            });
        }
    }

    boolean isInVisibleLines(int offset) {
        return this.visibleLines.isInVisibleLines(offset);
    }

    private class MouseTracker
    implements MouseTrackListener,
    MouseMoveListener,
    MouseListener {
        private AbstractInlinedAnnotation fAnnotation;
        private Consumer<MouseEvent> fAction;

        private MouseTracker() {
        }

        private void update(MouseEvent e) {
            Consumer<MouseEvent> action;
            this.fAnnotation = null;
            this.fAction = null;
            AbstractInlinedAnnotation annotation = InlinedAnnotationSupport.getInlinedAnnotationAtPoint(InlinedAnnotationSupport.this.fViewer, new Point(e.x, e.y));
            if (annotation != null && (action = annotation.getAction(e)) != null) {
                this.fAnnotation = annotation;
                this.fAction = action;
            }
        }

        public void mouseHover(MouseEvent e) {
            this.update(e);
            if (this.fAnnotation != null) {
                this.fAnnotation.onMouseHover(e);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.fAnnotation != null) {
                AbstractInlinedAnnotation oldAnnotation = this.fAnnotation;
                this.update(e);
                if (!((Object)((Object)oldAnnotation)).equals((Object)this.fAnnotation)) {
                    oldAnnotation.onMouseOut(e);
                    this.fAnnotation = null;
                    this.fAction = null;
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button != 1) {
                return;
            }
            if (this.fAction != null) {
                this.fAction.accept(e);
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
        }
    }

    private class UpdateStylesWidth
    implements ITextPresentationListener {
        private UpdateStylesWidth() {
        }

        @Override
        public void applyTextPresentation(TextPresentation textPresentation) {
            IAnnotationModel annotationModel = InlinedAnnotationSupport.this.fViewer.getAnnotationModel();
            IRegion region = textPresentation.getExtent();
            ((IAnnotationModelExtension2)annotationModel).getAnnotationIterator(region.getOffset(), region.getLength(), true, true).forEachRemaining(annotation -> {
                int width;
                LineContentAnnotation ann;
                Position position;
                if (annotation instanceof LineContentAnnotation && (position = (ann = (LineContentAnnotation)((Object)annotation)).getPosition()) != null && (width = ann.getWidth()) != 0) {
                    StyleRange s = new StyleRange();
                    s.start = position.getOffset();
                    s.length = 1;
                    s.metrics = ann.isMarkedDeleted() ? null : new GlyphMetrics(0, 0, width);
                    textPresentation.mergeStyleRange(s);
                }
            });
        }
    }

    private class VisibleLines
    implements IViewportListener,
    IDocumentListener {
        private int startOffset;
        private Integer endOffset;

        public VisibleLines() {
            InlinedAnnotationSupport.this.fViewer.getTextWidget().getDisplay().asyncExec(() -> this.compute());
            InlinedAnnotationSupport.this.fViewer.getDocument().addDocumentListener((IDocumentListener)this);
        }

        @Override
        public void viewportChanged(int verticalOffset) {
            this.compute();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            this.endOffset = null;
        }

        public void documentChanged(DocumentEvent event) {
        }

        private void compute() {
            this.startOffset = this.getInclusiveTopIndexStartOffset();
            this.endOffset = this.getExclusiveBottomIndexEndOffset();
        }

        private int getInclusiveTopIndexStartOffset() {
            if (InlinedAnnotationSupport.this.fViewer != null && InlinedAnnotationSupport.this.fViewer.getTextWidget() != null && !InlinedAnnotationSupport.this.fViewer.getTextWidget().isDisposed()) {
                int top = JFaceTextUtil.getPartialTopIndex(InlinedAnnotationSupport.this.fViewer);
                try {
                    IDocument document = InlinedAnnotationSupport.this.fViewer.getDocument();
                    return document.getLineOffset(top);
                }
                catch (BadLocationException badLocationException) {}
            }
            return -1;
        }

        private int getExclusiveBottomIndexEndOffset() {
            if (InlinedAnnotationSupport.this.fViewer != null && InlinedAnnotationSupport.this.fViewer.getTextWidget() != null && !InlinedAnnotationSupport.this.fViewer.getTextWidget().isDisposed()) {
                int bottom = JFaceTextUtil.getPartialBottomIndex(InlinedAnnotationSupport.this.fViewer);
                try {
                    IDocument document = InlinedAnnotationSupport.this.fViewer.getDocument();
                    if (bottom >= document.getNumberOfLines()) {
                        bottom = document.getNumberOfLines() - 1;
                    }
                    return document.getLineOffset(bottom) + document.getLineLength(bottom);
                }
                catch (BadLocationException badLocationException) {}
            }
            return -1;
        }

        boolean isInVisibleLines(int offset) {
            if (this.endOffset == null) {
                Display display = InlinedAnnotationSupport.this.fViewer.getTextWidget().getDisplay();
                if (display.getThread() == Thread.currentThread()) {
                    this.endOffset = this.getExclusiveBottomIndexEndOffset();
                } else {
                    display.syncExec(() -> {
                        Integer n = this.endOffset = Integer.valueOf(this.getExclusiveBottomIndexEndOffset());
                    });
                }
            }
            return offset >= this.startOffset && offset <= this.endOffset;
        }

        void uninstall() {
            if (InlinedAnnotationSupport.this.fViewer != null && InlinedAnnotationSupport.this.fViewer.getDocument() != null) {
                InlinedAnnotationSupport.this.fViewer.getDocument().removeDocumentListener((IDocumentListener)this);
            }
        }
    }
}

