/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.swt.custom.StyledText;

public class LineHeaderAnnotation
extends AbstractInlinedAnnotation {
    public LineHeaderAnnotation(Position position, ISourceViewer viewer) {
        super(position, viewer);
    }

    public int getHeight() {
        StyledText styledText = super.getTextWidget();
        return styledText.getLineHeight();
    }

    @Override
    protected boolean isInVisibleLines() {
        if (!super.isInVisibleLines()) {
            return false;
        }
        ISourceViewer viewer = super.getViewer();
        IDocument document = viewer.getDocument();
        if (document == null) {
            return false;
        }
        try {
            int startLineOffset = document.getLineInformationOfOffset(this.getPosition().getOffset()).getOffset();
            int previousEndLineOffset = startLineOffset - 1;
            return super.isInVisibleLines(previousEndLineOffset);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

