/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class PluginImportHelper {
    public static void importContent(Object source, IPath dstPath, IImportStructureProvider provider, List<Object> filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = file -> "ALL";
        try {
            ImportOperation op = new ImportOperation(dstPath, source, provider, query);
            op.setCreateContainerStructure(false);
            if (filesToImport != null) {
                op.setFilesToImport(filesToImport);
            }
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    public static void extractArchive(File file, IPath dstPath, Set<IPath> collectedPackages, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                if (collectedPackages != null) {
                    ArrayList<Object> collected = new ArrayList<Object>();
                    PluginImportHelper.collectResources((IImportStructureProvider)provider, provider.getRoot(), collected);
                    PluginImportHelper.collectJavaPackages((IImportStructureProvider)provider, collected, null, collectedPackages);
                }
                PluginImportHelper.importContent(provider.getRoot(), dstPath, (IImportStructureProvider)provider, null, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void extractFolderFromArchive(File file, IPath folderPath, IPath dstPath, Set<IPath> collectedPackages, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList<Object> collected = new ArrayList<Object>();
                PluginImportHelper.collectResourcesFromFolder(provider, (Object)provider.getRoot(), folderPath, collected);
                if (collectedPackages != null) {
                    PluginImportHelper.collectJavaPackages((IImportStructureProvider)provider, collected, folderPath, collectedPackages);
                }
                PluginImportHelper.importContent(provider.getRoot(), dstPath, (IImportStructureProvider)provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void extractJavaSourceFromArchive(File file, List<IPath> excludeFolders, IPath dstPath, Set<IPath> collectedPackages, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList<Object> collected = new ArrayList<Object>();
                PluginImportHelper.collectJavaSourceFromRoot(provider, excludeFolders, collected);
                if (collectedPackages != null) {
                    PluginImportHelper.collectJavaPackages((IImportStructureProvider)provider, collected, null, collectedPackages);
                }
                PluginImportHelper.importContent(provider.getRoot(), dstPath, (IImportStructureProvider)provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void collectJavaPackages(IImportStructureProvider provider, List<Object> javaFiles, IPath prefixPath, Set<IPath> packageList) {
        for (Object object : javaFiles) {
            String stringPath = provider.getFullPath(object);
            Path path = new Path(stringPath);
            path = path.removeLastSegments(1);
            if (prefixPath != null) {
                boolean prefixMatches = true;
                int i = 0;
                while (i < prefixPath.segmentCount()) {
                    if (!prefixPath.segment(i).equals(path.segment(i))) {
                        prefixMatches = false;
                    }
                    ++i;
                }
                if (prefixMatches) {
                    path = path.removeFirstSegments(prefixPath.segmentCount());
                }
            }
            packageList.add((IPath)path);
        }
    }

    public static void copyArchive(File file, IFile dstFile, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fstream = new FileInputStream(file);){
                if (dstFile.exists()) {
                    dstFile.setContents((InputStream)fstream, true, false, monitor);
                } else {
                    dstFile.create((InputStream)fstream, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public static String[] getTopLevelResources(File file) {
        ArrayList<String> result;
        block21: {
            result = new ArrayList<String>();
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(file);
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                    List children = provider.getChildren((Object)provider.getRoot());
                    if (children != null && !children.isEmpty()) {
                        int i = 0;
                        while (i < children.size()) {
                            Object curr = children.get(i);
                            if (provider.isFolder(curr)) {
                                if (!PluginImportHelper.isClassFolder((IImportStructureProvider)provider, curr)) {
                                    result.add(String.valueOf(provider.getLabel(curr)) + "/");
                                } else if (!result.contains(".")) {
                                    result.add(".");
                                }
                            } else {
                                result.add(provider.getLabel(curr));
                            }
                            ++i;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void collectRequiredBundleFiles(IImportStructureProvider provider, Object element, ArrayList<Object> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                String name = provider.getLabel(curr);
                if (provider.isFolder(curr)) {
                    if (!name.equals("src") && !PluginImportHelper.isClassFolder(provider, curr)) {
                        PluginImportHelper.collectRequiredBundleFiles(provider, curr, collected);
                    }
                } else if (!(name.endsWith(".class") || name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF"))) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    public static void collectBinaryFiles(IImportStructureProvider provider, Object element, Map<IPath, IPath> packageLocations, Map<IPath, List<Object>> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                String name = provider.getLabel(curr);
                if (provider.isFolder(curr)) {
                    PluginImportHelper.collectBinaryFiles(provider, curr, packageLocations, collected);
                } else if (!(name.endsWith(".class") || name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF"))) {
                    List<Object> fileList;
                    String fullPath = provider.getFullPath(curr);
                    Path packagePath = new Path(fullPath);
                    IPath destination = null;
                    packagePath = packagePath.removeLastSegments(1);
                    while (packagePath.segmentCount() > 0 && destination == null) {
                        destination = packageLocations.get(packagePath);
                        packagePath = packagePath.removeLastSegments(1);
                    }
                    if (destination == null) {
                        destination = new Path("");
                    }
                    if ((fileList = collected.get(destination)) == null) {
                        fileList = new ArrayList<Object>();
                        collected.put(destination, fileList);
                    }
                    fileList.add(curr);
                }
                ++i;
            }
        }
    }

    public static void collectNonJavaNonBuildFiles(IImportStructureProvider provider, Object element, ArrayList<Object> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!(PluginImportHelper.folderContainsFileExtension(provider, curr, ".java") || provider.getFullPath(curr).equals("META-INF/") || provider.getFullPath(curr).equals("OSGI-INF/"))) {
                        collected.add(curr);
                    }
                } else if (!provider.getLabel(curr).endsWith(".java")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    public static void collectResources(IImportStructureProvider provider, Object element, ArrayList<Object> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    PluginImportHelper.collectResources(provider, curr, collected);
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    private static void collectResourcesFromFolder(ZipFileStructureProvider provider, Object element, IPath folderPath, ArrayList<Object> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals(folderPath.segment(0))) {
                    if (folderPath.segmentCount() > 1) {
                        PluginImportHelper.collectResourcesFromFolder(provider, curr, folderPath.removeFirstSegments(1), collected);
                    } else {
                        PluginImportHelper.collectResources((IImportStructureProvider)provider, curr, collected);
                    }
                }
                ++i;
            }
        }
    }

    public static void collectResourcesFromFolder(IImportStructureProvider provider, Object element, IPath folderPath, ArrayList<Object> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals(folderPath.segment(0))) {
                    if (folderPath.segmentCount() > 1) {
                        PluginImportHelper.collectResourcesFromFolder(provider, curr, folderPath.removeFirstSegments(1), collected);
                    } else {
                        PluginImportHelper.collectResources(provider, curr, collected);
                    }
                }
                ++i;
            }
        }
    }

    private static void collectJavaSourceFromRoot(ZipFileStructureProvider provider, List<IPath> ignoreFolders, ArrayList<Object> collected) {
        List children = provider.getChildren((Object)provider.getRoot());
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && PluginImportHelper.folderContainsFileExtension((IImportStructureProvider)provider, curr, ".java")) {
                    ArrayList<IPath> ignoreSubFolders = new ArrayList<IPath>();
                    boolean ignoreThisChild = false;
                    for (IPath currentPath : ignoreFolders) {
                        if (!provider.getLabel(curr).equals(currentPath.segment(0))) continue;
                        if (currentPath.segmentCount() > 1) {
                            ignoreSubFolders.add(currentPath.removeFirstSegments(1));
                            continue;
                        }
                        ignoreThisChild = true;
                        break;
                    }
                    if (!ignoreThisChild) {
                        PluginImportHelper.collectJavaSource(provider, curr, ignoreSubFolders, collected);
                    }
                }
                ++i;
            }
        }
    }

    private static void collectJavaSource(ZipFileStructureProvider provider, Object element, List<IPath> ignoreFolders, ArrayList<Object> collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    ArrayList<IPath> ignoreSubFolders = new ArrayList<IPath>();
                    boolean ignoreThisChild = false;
                    for (IPath currentPath : ignoreFolders) {
                        if (!provider.getLabel(curr).equals(currentPath.segment(0))) continue;
                        if (currentPath.segmentCount() > 1) {
                            ignoreSubFolders.add(currentPath.removeFirstSegments(1));
                            continue;
                        }
                        ignoreThisChild = true;
                        break;
                    }
                    if (!ignoreThisChild) {
                        PluginImportHelper.collectJavaSource(provider, curr, ignoreSubFolders, collected);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    private static boolean folderContainsFileExtension(IImportStructureProvider provider, Object element, String fileExtension) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) ? PluginImportHelper.folderContainsFileExtension(provider, curr, fileExtension) : provider.getLabel(curr).endsWith(fileExtension)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isClassFolder(IImportStructureProvider provider, Object element) {
        return PluginImportHelper.folderContainsFileExtension(provider, element, ".class");
    }
}

