/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ContextMenuRule
extends AbstractSimpleRedDeerRule {
    private List<String> path;
    private String menu;

    public boolean appliesTo(Event event) {
        boolean menu = event.widget instanceof MenuItem;
        int style = 0;
        if (menu) {
            MenuItem currentItem = (MenuItem)event.widget;
            Menu parent = null;
            while (currentItem != null && (parent = currentItem.getParent()) != null) {
                style = parent.getStyle();
                currentItem = parent.getParentItem();
            }
        }
        return event.type == 13 && menu && (style & 8) != 0;
    }

    public void initializeForEvent(Event event) {
        MenuItem item = (MenuItem)event.widget;
        this.widget = item;
        this.menu = WidgetUtils.cleanText((String)item.getText());
        this.path = new ArrayList<String>();
        MenuItem currentItem = item;
        Menu parent = null;
        while (currentItem != null && (parent = currentItem.getParent()) != null) {
            currentItem = parent.getParentItem();
            if (currentItem == null || currentItem.getText() == null) continue;
            this.path.add(WidgetUtils.cleanText((String)currentItem.getText()));
        }
        Collections.reverse(this.path);
    }

    public List<String> getActions() {
        StringBuilder code = new StringBuilder();
        ArrayList<String> toReturn = new ArrayList<String>();
        code.append("new ContextMenu(");
        for (String text : this.path) {
            code.append("\"" + text + "\",");
        }
        code.append("\"" + this.menu + "\").select()");
        toReturn.add(code.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.swt.impl.menu.ContextMenu");
        return toReturn;
    }

    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public String getMenu() {
        return this.menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.menu == null ? 0 : this.menu.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ContextMenuRule other = (ContextMenuRule)((Object)obj);
        if (this.menu == null ? other.menu != null : !this.menu.equals(other.menu)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

