/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.wizard;

import org.eclipse.jface.window.Window;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.condition.WindowIsAvailable;
import org.eclipse.reddeer.jface.dialogs.TitleAreaDialog;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.impl.button.BackButton;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.NextButton;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;

public class WizardDialog
extends TitleAreaDialog {
    protected final Logger log = Logger.getLogger(this.getClass());

    public WizardDialog(String text) {
        super(text);
    }

    public WizardDialog(Shell shell) {
        super(shell);
    }

    public WizardDialog(Matcher<?> ... matchers) {
        super(matchers);
    }

    public WizardDialog() {
    }

    public void finish() {
        this.finish(TimePeriod.LONG);
    }

    public void finish(TimePeriod timeout) {
        this.checkShell();
        this.log.info("Finish wizard");
        FinishButton button = new FinishButton((ReferencedComposite)this);
        button.click();
        new WaitWhile((WaitCondition)new WindowIsAvailable(this), timeout);
        try {
            new WaitWhile((WaitCondition)new JobIsRunning(), timeout);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public void cancel() {
        this.checkShell();
        this.log.info("Cancel wizard");
        new CancelButton((ReferencedComposite)this).click();
        new WaitWhile((WaitCondition)new WindowIsAvailable(this));
        try {
            new WaitWhile((WaitCondition)new JobIsRunning());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public WizardDialog next() {
        this.checkShell();
        this.log.info("Go to next wizard page");
        NextButton button = new NextButton((ReferencedComposite)this);
        button.click();
        return this;
    }

    public WizardDialog back() {
        this.checkShell();
        this.log.info("Go to previous wizard page");
        BackButton button = new BackButton((ReferencedComposite)this);
        button.click();
        return this;
    }

    public boolean isFinishEnabled() {
        this.checkShell();
        return new FinishButton((ReferencedComposite)this).isEnabled();
    }

    public boolean isNextEnabled() {
        this.checkShell();
        return new NextButton((ReferencedComposite)this).isEnabled();
    }

    public boolean isBackEnabled() {
        this.checkShell();
        return new BackButton((ReferencedComposite)this).isEnabled();
    }

    @Override
    public Class<? extends Window> getEclipseClass() {
        return org.eclipse.jface.wizard.WizardDialog.class;
    }
}

