/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.runner;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.junit.extensionpoint.IIssueTracker;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.internal.extensionpoint.AfterTestInitialization;
import org.eclipse.reddeer.junit.internal.extensionpoint.BeforeTestInitialization;
import org.eclipse.reddeer.junit.internal.extensionpoint.IssueTrackerInitialization;
import org.eclipse.reddeer.junit.internal.runner.EmptySuite;
import org.eclipse.reddeer.junit.internal.runner.NamedSuite;
import org.eclipse.reddeer.junit.internal.runner.RequirementsRunnerBuilder;
import org.eclipse.reddeer.junit.internal.runner.TestsExecutionManager;
import org.eclipse.reddeer.junit.internal.runner.TestsWithoutExecutionSuite;
import org.eclipse.reddeer.junit.requirement.configuration.MissingRequirementConfiguration;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class RedDeerSuite
extends Suite {
    private static final Logger log = Logger.getLogger(RedDeerSuite.class);
    protected static RunListener[] runListeners;
    private static List<IBeforeTest> beforeTestExtensions;
    private static List<IAfterTest> afterTestExtensions;
    private static List<IIssueTracker> issueTrackerExtensions;
    private String suiteName;

    static {
        beforeTestExtensions = RedDeerSuite.initializeBeforeTestExtensions();
        afterTestExtensions = RedDeerSuite.initializeAfterTestExtensions();
    }

    public RedDeerSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        this(clazz, builder, new SuiteConfiguration(clazz));
    }

    protected RedDeerSuite(Class<?> clazz, RunnerBuilder builder, SuiteConfiguration config) throws InitializationError {
        super(EmptySuite.class, RedDeerSuite.createSuites(clazz, config));
        this.suiteName = clazz.getName();
    }

    public static List<Runner> createSuites(Class<?> clazz, SuiteConfiguration config) throws InitializationError {
        TestsExecutionManager testsManager = new TestsExecutionManager();
        ArrayList<Runner> configuredSuites = new ArrayList<Runner>();
        boolean isSuite = RedDeerSuite.isSuite(clazz);
        Map<RequirementConfigurationSet, List<Class<?>>> configurationSetsMap = config.getConfigurationSetsSuites();
        for (RequirementConfigurationSet configurationSet : configurationSetsMap.keySet()) {
            List<Class<?>> testClasses = configurationSetsMap.get(configurationSet);
            RequirementsRunnerBuilder requirementsRunnerBuilder = new RequirementsRunnerBuilder(configurationSet, runListeners, beforeTestExtensions, afterTestExtensions, testsManager);
            if (configurationSet.getConfigurationSet().contains(new MissingRequirementConfiguration())) {
                configuredSuites.add((Runner)new TestsWithoutExecutionSuite(testClasses.toArray(new Class[0]), testsManager));
                continue;
            }
            configuredSuites.add((Runner)new NamedSuite(testClasses.toArray(new Class[0]), (RunnerBuilder)requirementsRunnerBuilder, configurationSet.getId()));
        }
        if (!testsManager.allTestsAreExecuted()) {
            if (isSuite) {
                configuredSuites.add((Runner)new TestsWithoutExecutionSuite(clazz, testsManager));
            } else {
                configuredSuites.add((Runner)new TestsWithoutExecutionSuite(new Class[]{clazz}, testsManager));
            }
        }
        log.info("RedDeer suite created");
        return configuredSuites;
    }

    private static boolean isSuite(Class<?> clazz) {
        Suite.SuiteClasses annotation = clazz.getAnnotation(Suite.SuiteClasses.class);
        return annotation != null;
    }

    protected String getName() {
        return this.suiteName;
    }

    private static List<IBeforeTest> initializeBeforeTestExtensions() {
        List<IBeforeTest> beforeTestExts;
        try {
            Class.forName("org.eclipse.core.runtime.Platform");
            log.debug("Eclipse is running");
            beforeTestExts = BeforeTestInitialization.initialize();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug("Eclipse is not running");
            beforeTestExts = new LinkedList<IBeforeTest>();
        }
        return beforeTestExts;
    }

    private static List<IAfterTest> initializeAfterTestExtensions() {
        List<IAfterTest> afterTestExts;
        try {
            Class.forName("org.eclipse.core.runtime.Platform");
            log.debug("Eclipse is running");
            afterTestExts = AfterTestInitialization.initialize();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug("Eclipse is not running");
            afterTestExts = new LinkedList<IAfterTest>();
        }
        return afterTestExts;
    }

    public static List<IIssueTracker> getIssueTrackerExtensions() {
        if (issueTrackerExtensions == null) {
            issueTrackerExtensions = RedDeerSuite.initializeIssueTrackerExtensions();
        }
        return issueTrackerExtensions;
    }

    private static List<IIssueTracker> initializeIssueTrackerExtensions() {
        List<IIssueTracker> issueTrackerExts;
        try {
            Class.forName("org.eclipse.core.runtime.Platform");
            log.debug("Eclipse is running");
            issueTrackerExts = IssueTrackerInitialization.initialize();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug("Eclipse is not running");
            issueTrackerExts = new LinkedList<IIssueTracker>();
        }
        return issueTrackerExts;
    }
}

