/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bytecode.Addition;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.SerializedConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.visitor.ExceptionTableSensitiveMethodVisitor;
import net.bytebuddy.utility.visitor.LineNumberPrependingMethodVisitor;
import net.bytebuddy.utility.visitor.StackAwareMethodVisitor;

public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper,
Implementation {
    private static final ClassReader UNDEFINED = null;
    private static final MethodDescription.InDefinedShape INLINE_ENTER;
    private static final MethodDescription.InDefinedShape SUPPRESS_ENTER;
    private static final MethodDescription.InDefinedShape PREPEND_LINE_NUMBER;
    private static final MethodDescription.InDefinedShape SKIP_ON;
    private static final MethodDescription.InDefinedShape INLINE_EXIT;
    private static final MethodDescription.InDefinedShape SUPPRESS_EXIT;
    private static final MethodDescription.InDefinedShape ON_THROWABLE;
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final Assigner assigner;
    private final StackManipulation exceptionHandler;
    private final Implementation delegate;

    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit) {
        this(methodEnter, methodExit, Assigner.DEFAULT, Removal.of(TypeDescription.THROWABLE), SuperMethodCall.INSTANCE);
    }

    private Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, Assigner assigner, StackManipulation exceptionHandler, Implementation delegate) {
        this.methodEnter = methodEnter;
        this.methodExit = methodExit;
        this.assigner = assigner;
        this.exceptionHandler = exceptionHandler;
        this.delegate = delegate;
    }

    public static Advice to(Class<?> advice) {
        return Advice.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
    }

    public static Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
    }

    public static Advice to(TypeDescription advice) {
        return Advice.to(advice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
        return Advice.to(advice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription advice, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : advice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodEnter.isAlive() && !methodExit.isAlive()) {
            throw new IllegalArgumentException("No advice defined by " + advice);
        }
        try {
            ClassReader classReader = methodEnter.isBinary() || methodExit.isBinary() ? new ClassReader(classFileLocator.locate(advice.getName()).resolve()) : UNDEFINED;
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter(userFactories, classReader);
            return new Advice(resolved, methodExit.asMethodExitTo(userFactories, classReader, resolved));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + advice, exception);
        }
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
        ClassLoader exitLoader;
        ClassLoader enterLoader = enterAdvice.getClassLoader();
        return Advice.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
        return Advice.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to(enterAdvice, exitAdvice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : enterAdvice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
        }
        if (!methodEnter.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + enterAdvice);
        }
        for (MethodDescription.InDefinedShape methodDescription : exitAdvice.getDeclaredMethods()) {
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodExit.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + exitAdvice);
        }
        try {
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter(userFactories, methodEnter.isBinary() ? new ClassReader(classFileLocator.locate(enterAdvice.getName()).resolve()) : UNDEFINED);
            return new Advice(resolved, methodExit.asMethodExitTo(userFactories, methodExit.isBinary() ? new ClassReader(classFileLocator.locate(exitAdvice.getName()).resolve()) : UNDEFINED, resolved));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + enterAdvice + " or " + exitAdvice, exception);
        }
    }

    private static Dispatcher.Unresolved locate(Class<? extends Annotation> type, MethodDescription.InDefinedShape property, Dispatcher.Unresolved dispatcher, MethodDescription.InDefinedShape methodDescription) {
        AnnotationDescription.Loadable<? extends Annotation> annotation = methodDescription.getDeclaredAnnotations().ofType(type);
        if (annotation == null) {
            return dispatcher;
        }
        if (dispatcher.isAlive()) {
            throw new IllegalStateException("Duplicate advice for " + dispatcher + " and " + methodDescription);
        }
        if (!methodDescription.isStatic()) {
            throw new IllegalStateException("Advice for " + methodDescription + " is not static");
        }
        return annotation.getValue(property).resolve(Boolean.class) != false ? new Dispatcher.Inlining(methodDescription) : new Dispatcher.Delegating(methodDescription);
    }

    public static WithCustomMapping withCustomMapping() {
        return new WithCustomMapping();
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().method(matcher, this);
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return instrumentedMethod.isAbstract() || instrumentedMethod.isNative() ? methodVisitor : this.doWrap(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, writerFlags, readerFlags);
    }

    protected MethodVisitor doWrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, int writerFlags, int readerFlags) {
        MethodVisitor methodVisitor2 = methodVisitor = this.methodEnter.isPrependLineNumber() ? new LineNumberPrependingMethodVisitor(methodVisitor) : methodVisitor;
        if (!this.methodExit.isAlive()) {
            return new AdviceVisitor.WithoutExitAdvice(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, writerFlags, readerFlags);
        }
        if (this.methodExit.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
            return new AdviceVisitor.WithExitAdvice.WithoutExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags);
        }
        if (instrumentedMethod.isConstructor()) {
            throw new IllegalStateException("Cannot catch exception during constructor call for " + instrumentedMethod);
        }
        return new AdviceVisitor.WithExitAdvice.WithExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags, this.methodExit.getThrowable());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.delegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this, implementationTarget, this.delegate.appender(implementationTarget));
    }

    public Advice withAssigner(Assigner assigner) {
        return new Advice(this.methodEnter, this.methodExit, assigner, this.exceptionHandler, this.delegate);
    }

    public Advice withExceptionPrinting() {
        try {
            return this.withExceptionHandler(MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Throwable.class.getMethod("printStackTrace", new Class[0]))));
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Cannot locate Throwable::printStackTrace");
        }
    }

    public Advice withExceptionHandler(StackManipulation exceptionHandler) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, exceptionHandler, this.delegate);
    }

    public Implementation wrap(Implementation implementation) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, this.exceptionHandler, implementation);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Advice)) {
            return false;
        }
        Advice other = (Advice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Dispatcher.Resolved.ForMethodEnter this$methodEnter = this.methodEnter;
        Dispatcher.Resolved.ForMethodEnter other$methodEnter = other.methodEnter;
        if (this$methodEnter == null ? other$methodEnter != null : !this$methodEnter.equals(other$methodEnter)) {
            return false;
        }
        Dispatcher.Resolved.ForMethodExit this$methodExit = this.methodExit;
        Dispatcher.Resolved.ForMethodExit other$methodExit = other.methodExit;
        if (this$methodExit == null ? other$methodExit != null : !this$methodExit.equals(other$methodExit)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        StackManipulation this$exceptionHandler = this.exceptionHandler;
        StackManipulation other$exceptionHandler = other.exceptionHandler;
        if (this$exceptionHandler == null ? other$exceptionHandler != null : !this$exceptionHandler.equals(other$exceptionHandler)) {
            return false;
        }
        Implementation this$delegate = this.delegate;
        Implementation other$delegate = other.delegate;
        return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Advice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dispatcher.Resolved.ForMethodEnter $methodEnter = this.methodEnter;
        result = result * 59 + ($methodEnter == null ? 43 : $methodEnter.hashCode());
        Dispatcher.Resolved.ForMethodExit $methodExit = this.methodExit;
        result = result * 59 + ($methodExit == null ? 43 : $methodExit.hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        StackManipulation $exceptionHandler = this.exceptionHandler;
        result = result * 59 + ($exceptionHandler == null ? 43 : $exceptionHandler.hashCode());
        Implementation $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        return result;
    }

    static {
        MethodList<MethodDescription.InDefinedShape> enter = new TypeDescription.ForLoadedType(OnMethodEnter.class).getDeclaredMethods();
        INLINE_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("suppress"))).getOnly();
        SKIP_ON = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("skipOn"))).getOnly();
        PREPEND_LINE_NUMBER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("prependLineNumber"))).getOnly();
        MethodList<MethodDescription.InDefinedShape> exit = new TypeDescription.ForLoadedType(OnMethodExit.class).getDeclaredMethods();
        INLINE_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("suppress"))).getOnly();
        ON_THROWABLE = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("onThrowable"))).getOnly();
    }

    protected static abstract class AdviceVisitor
    extends ExceptionTableSensitiveMethodVisitor
    implements Dispatcher.Bound.SkipHandler {
        private static final int NO_OFFSET = 0;
        protected final MethodVisitor methodVisitor;
        protected final MethodDescription instrumentedMethod;
        private final int padding;
        private final Dispatcher.Bound.ForMethodEnter methodEnter;
        protected final Dispatcher.Bound.ForMethodExit methodExit;
        protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
        protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;

        protected AdviceVisitor(MethodVisitor methodVisitor, MethodVisitor delegate, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> yieldedTypes, int writerFlags, int readerFlags) {
            super(393216, delegate);
            this.methodVisitor = methodVisitor;
            this.instrumentedMethod = instrumentedMethod;
            this.padding = methodEnter.getEnterType().getStackSize().getSize();
            List requiredTypes = methodEnter.getEnterType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodEnter.getEnterType().asErasure());
            this.methodSizeHandler = MethodSizeHandler.Default.of(instrumentedMethod, requiredTypes, yieldedTypes, writerFlags);
            this.stackMapFrameHandler = StackMapFrameHandler.Default.of(instrumentedType, instrumentedMethod, requiredTypes, yieldedTypes, implementationContext.getClassFileVersion(), writerFlags, readerFlags);
            this.methodEnter = methodEnter.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler);
            this.methodExit = methodExit.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler);
        }

        @Override
        protected void onAfterExceptionTable() {
            this.methodEnter.prepare();
            this.onUserPrepare();
            this.methodExit.prepare();
            this.methodEnter.apply(this);
            this.onUserStart();
        }

        protected abstract void onUserPrepare();

        protected abstract void onUserStart();

        @Override
        protected void onVisitVarInsn(int opcode, int offset) {
            this.mv.visitVarInsn(opcode, this.resolve(offset));
        }

        @Override
        protected void onVisitIincInsn(int offset, int increment) {
            this.mv.visitIincInsn(this.resolve(offset), increment);
        }

        protected void variable(int opcode) {
            this.variable(opcode, 0);
        }

        protected void variable(int opcode, int offset) {
            this.methodVisitor.visitVarInsn(opcode, this.instrumentedMethod.getStackSize() + this.padding + offset);
        }

        @Override
        public void visitFrame(int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            this.stackMapFrameHandler.translateFrame(this.methodVisitor, type, localVariableLength, localVariable, stackSize, stack);
        }

        @Override
        public void visitMaxs(int stackSize, int localVariableLength) {
            this.onUserEnd();
            this.methodVisitor.visitMaxs(this.methodSizeHandler.compoundStackSize(stackSize), this.methodSizeHandler.compoundLocalVariableLength(localVariableLength));
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, descriptor, signature, start, end, this.resolve(index));
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            return this.mv.visitLocalVariableAnnotation(typeReference, typePath, start, end, this.resolve(index), descriptor, visible);
        }

        private int[] resolve(int[] index) {
            int[] resolved = new int[index.length];
            for (int anIndex = 0; anIndex < index.length; ++anIndex) {
                resolved[anIndex] = this.resolve(index[anIndex]);
            }
            return resolved;
        }

        private int resolve(int index) {
            return index < this.instrumentedMethod.getStackSize() ? index : this.padding + index;
        }

        protected abstract void onUserEnd();

        protected static abstract class WithExitAdvice
        extends AdviceVisitor {
            protected final Label returnHandler = new Label();
            protected boolean doesReturn = false;

            protected WithExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> yieldedTypes, int writerFlags, int readerFlags) {
                super(methodVisitor, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod), implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, yieldedTypes, writerFlags, readerFlags);
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(1);
                }
                methodVisitor.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onVisitInsn(int opcode) {
                switch (opcode) {
                    case 177: {
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        break;
                    }
                    case 172: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                        break;
                    }
                    case 174: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                        break;
                    }
                    case 175: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                        break;
                    }
                    case 173: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                        break;
                    }
                    case 176: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                        break;
                    }
                    default: {
                        this.mv.visitInsn(opcode);
                        return;
                    }
                }
                this.mv.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onUserEnd() {
                Type returnType = Type.getType(this.instrumentedMethod.getReturnType().asErasure().getDescriptor());
                this.methodVisitor.visitLabel(this.returnHandler);
                if (this.doesReturn) {
                    this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                    if (!returnType.equals(Type.VOID_TYPE)) {
                        this.variable(returnType.getOpcode(54));
                    }
                }
                this.onUserReturn();
                this.methodExit.apply();
                this.onExitAdviceReturn();
                if (returnType.equals(Type.VOID_TYPE)) {
                    this.methodVisitor.visitInsn(177);
                } else {
                    this.variable(returnType.getOpcode(21));
                    this.methodVisitor.visitInsn(returnType.getOpcode(172));
                }
            }

            protected abstract void onUserReturn();

            protected abstract void onExitAdviceReturn();

            protected static class WithExceptionHandling
            extends WithExitAdvice {
                private final TypeDescription throwable;
                private final Label userStart;
                private final Label exceptionHandler;

                protected WithExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags, TypeDescription throwable) {
                    super(methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.singletonList(TypeDescription.THROWABLE) : Arrays.asList(instrumentedMethod.getReturnType().asErasure(), TypeDescription.THROWABLE), writerFlags, readerFlags);
                    this.throwable = throwable;
                    this.userStart = new Label();
                    this.exceptionHandler = new Label();
                }

                @Override
                protected void onUserPrepare() {
                    this.methodVisitor.visitTryCatchBlock(this.userStart, this.returnHandler, this.exceptionHandler, this.throwable.getInternalName());
                }

                @Override
                protected void onUserStart() {
                    this.methodVisitor.visitLabel(this.userStart);
                }

                @Override
                protected void onUserReturn() {
                    Label endOfHandler = new Label();
                    if (this.doesReturn) {
                        this.methodVisitor.visitInsn(1);
                        this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                        this.methodVisitor.visitJumpInsn(167, endOfHandler);
                    }
                    this.methodVisitor.visitLabel(this.exceptionHandler);
                    this.stackMapFrameHandler.injectExceptionFrame(this.methodVisitor);
                    this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    this.storeDefaultReturn();
                    if (this.doesReturn) {
                        this.methodVisitor.visitLabel(endOfHandler);
                    }
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                protected void onExitAdviceReturn() {
                    this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    Label endOfHandler = new Label();
                    this.methodVisitor.visitJumpInsn(198, endOfHandler);
                    this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    this.methodVisitor.visitInsn(191);
                    this.methodVisitor.visitLabel(endOfHandler);
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, true);
                }

                private void storeDefaultReturn() {
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.methodVisitor.visitInsn(3);
                        this.variable(54);
                    } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.methodVisitor.visitInsn(9);
                        this.variable(55);
                    } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.methodVisitor.visitInsn(11);
                        this.variable(56);
                    } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.methodVisitor.visitInsn(14);
                        this.variable(57);
                    } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.methodVisitor.visitInsn(1);
                        this.variable(58);
                    }
                }
            }

            protected static class WithoutExceptionHandling
            extends WithExitAdvice {
                protected WithoutExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags) {
                    super(methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(instrumentedMethod.getReturnType().asErasure()), writerFlags, readerFlags);
                }

                @Override
                protected void onUserPrepare() {
                }

                @Override
                protected void onUserStart() {
                }

                @Override
                protected void onUserReturn() {
                    if (!this.doesReturn || !this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                    }
                }

                @Override
                protected void onExitAdviceReturn() {
                }
            }
        }

        protected static class WithoutExitAdvice
        extends AdviceVisitor {
            protected WithoutExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, int writerFlags, int readerFlags) {
                super(methodVisitor, methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, Dispatcher.Inactive.INSTANCE, Collections.emptyList(), writerFlags, readerFlags);
            }

            @Override
            protected void onUserPrepare() {
            }

            @Override
            protected void onUserStart() {
            }

            @Override
            protected void onUserEnd() {
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitInsn(172);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                    methodVisitor.visitInsn(173);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                    methodVisitor.visitInsn(174);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                    methodVisitor.visitInsn(175);
                } else if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(177);
                } else {
                    methodVisitor.visitInsn(1);
                    methodVisitor.visitInsn(176);
                }
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AllArguments {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Advice advice;
        private final Implementation.Target implementationTarget;
        private final ByteCodeAppender delegate;

        protected Appender(Advice advice, Implementation.Target implementationTarget, ByteCodeAppender delegate) {
            this.advice = advice;
            this.implementationTarget = implementationTarget;
            this.delegate = delegate;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            EmulatingMethodVisitor emulatingMethodVisitor = new EmulatingMethodVisitor(methodVisitor, this.delegate);
            methodVisitor = this.advice.doWrap(this.implementationTarget.getInstrumentedType(), instrumentedMethod, emulatingMethodVisitor, implementationContext, 0, 0);
            return emulatingMethodVisitor.resolve(methodVisitor, implementationContext, instrumentedMethod);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Appender)) {
                return false;
            }
            Appender other = (Appender)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Advice this$advice = this.advice;
            Advice other$advice = other.advice;
            if (this$advice == null ? other$advice != null : !((Object)this$advice).equals(other$advice)) {
                return false;
            }
            Implementation.Target this$implementationTarget = this.implementationTarget;
            Implementation.Target other$implementationTarget = other.implementationTarget;
            if (this$implementationTarget == null ? other$implementationTarget != null : !this$implementationTarget.equals(other$implementationTarget)) {
                return false;
            }
            ByteCodeAppender this$delegate = this.delegate;
            ByteCodeAppender other$delegate = other.delegate;
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Appender;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Advice $advice = this.advice;
            result = result * 59 + ($advice == null ? 43 : ((Object)$advice).hashCode());
            Implementation.Target $implementationTarget = this.implementationTarget;
            result = result * 59 + ($implementationTarget == null ? 43 : $implementationTarget.hashCode());
            ByteCodeAppender $delegate = this.delegate;
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }

        protected static class EmulatingMethodVisitor
        extends MethodVisitor {
            private final ByteCodeAppender delegate;
            private int stackSize;
            private int localVariableLength;

            protected EmulatingMethodVisitor(MethodVisitor methodVisitor, ByteCodeAppender delegate) {
                super(393216, methodVisitor);
                this.delegate = delegate;
            }

            protected ByteCodeAppender.Size resolve(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitCode();
                ByteCodeAppender.Size size = this.delegate.apply(methodVisitor, implementationContext, instrumentedMethod);
                methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                methodVisitor.visitEnd();
                return new ByteCodeAppender.Size(this.stackSize, this.localVariableLength);
            }

            @Override
            public void visitCode() {
            }

            @Override
            public void visitMaxs(int stackSize, int localVariableLength) {
                this.stackSize = stackSize;
                this.localVariableLength = localVariableLength;
            }

            @Override
            public void visitEnd() {
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Argument {
        public int value();

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;

        public boolean optional() default false;
    }

    protected static interface Dispatcher {
        public static final MethodVisitor IGNORE_METHOD = null;
        public static final AnnotationVisitor IGNORE_ANNOTATION = null;

        public boolean isAlive();

        public static interface Bound {
            public void prepare();

            public static interface ForMethodEnter
            extends Bound {
                public void apply(SkipHandler var1);
            }

            public static interface ForMethodExit
            extends Bound {
                public void apply();
            }

            public static interface SkipHandler {
                public void apply(MethodVisitor var1);
            }
        }

        public static class Delegating
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Delegating(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                return new Resolved.ForMethodEnter(this.adviceMethod, userFactories);
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, dispatcher.getEnterType());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Delegating)) {
                    return false;
                }
                Delegating other = (Delegating)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$adviceMethod = this.adviceMethod;
                MethodDescription.InDefinedShape other$adviceMethod = other.adviceMethod;
                return !(this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Delegating;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $adviceMethod = this.adviceMethod;
                result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                return result;
            }

            protected static abstract class Resolved<T extends Bound>
            implements net.bytebuddy.asm.Advice$Dispatcher$Resolved {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final List<OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType) {
                    this.adviceMethod = adviceMethod;
                    HashMap offsetMappings = new HashMap();
                    for (OffsetMapping.Factory<?> factory : factories) {
                        offsetMappings.put(new TypeDescription.ForLoadedType(factory.getAnnotationType()), factory);
                    }
                    this.offsetMappings = new ArrayList<OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = null;
                        for (AnnotationDescription annotationDescription : parameterDescription.getDeclaredAnnotations()) {
                            OffsetMapping.Factory factory = (OffsetMapping.Factory)offsetMappings.get(annotationDescription.getAnnotationType());
                            if (factory == null) continue;
                            OffsetMapping current = factory.make(parameterDescription, annotationDescription.prepare(factory.getAnnotationType()), OffsetMapping.Factory.AdviceType.DELEGATION);
                            if (offsetMapping == null) {
                                offsetMapping = current;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + current + " and " + offsetMapping);
                        }
                        this.offsetMappings.add(offsetMapping == null ? new OffsetMapping.ForArgument.Unresolved(parameterDescription) : offsetMapping);
                    }
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                public T bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                    if (!this.adviceMethod.isVisibleTo(instrumentedType)) {
                        throw new IllegalStateException(this.adviceMethod + " is not visible to " + instrumentedMethod.getDeclaringType());
                    }
                    return this.resolve(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, exceptionHandler);
                }

                protected abstract T resolve(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)object;
                    return this.adviceMethod.equals(resolved.adviceMethod) && this.offsetMappings.equals(resolved.offsetMappings) && this.suppressionHandler.equals(resolved.suppressionHandler);
                }

                public int hashCode() {
                    int result = this.adviceMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    result = 31 * result + this.suppressionHandler.hashCode();
                    return result;
                }

                protected static abstract class AdviceMethodWriter
                implements Bound,
                SuppressionHandler.ReturnValueProducer {
                    private static final int EMPTY = 0;
                    protected final MethodDescription.InDefinedShape adviceMethod;
                    protected final MethodDescription instrumentedMethod;
                    private final List<OffsetMapping.Target> offsetMappings;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                    protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                    private final SuppressionHandler.Bound suppressionHandler;

                    protected AdviceMethodWriter(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler) {
                        this.adviceMethod = adviceMethod;
                        this.instrumentedMethod = instrumentedMethod;
                        this.offsetMappings = offsetMappings;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                    }

                    @Override
                    public void prepare() {
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    protected void doApply() {
                        this.suppressionHandler.onStart(this.methodVisitor);
                        int index = 0;
                        int currentStackSize = 0;
                        int maximumStackSize = 0;
                        for (OffsetMapping.Target offsetMapping : this.offsetMappings) {
                            maximumStackSize = Math.max(maximumStackSize, (currentStackSize += ((ParameterDescription.InDefinedShape)this.adviceMethod.getParameters().get(index++)).getType().getStackSize().getSize()) + offsetMapping.resolveRead().apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                        }
                        this.methodVisitor.visitMethodInsn(184, this.adviceMethod.getDeclaringType().getInternalName(), this.adviceMethod.getInternalName(), this.adviceMethod.getDescriptor(), false);
                        this.onMethodReturn();
                        this.suppressionHandler.onEndSkipped(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this);
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                        this.methodSizeHandler.recordMaxima(Math.max(maximumStackSize, this.adviceMethod.getReturnType().getStackSize().getSize()), 0);
                    }

                    protected abstract void onMethodReturn();

                    protected static class ForMethodEnter
                    extends AdviceMethodWriter
                    implements Bound.ForMethodEnter {
                        private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;

                        protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, Resolved.ForMethodEnter.SkipDispatcher skipDispatcher) {
                            super(adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, suppressionHandler);
                            this.skipDispatcher = skipDispatcher;
                        }

                        @Override
                        protected void onMethodReturn() {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                this.methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                this.methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                this.methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                this.methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                this.methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                            }
                        }

                        @Override
                        public void apply(Bound.SkipHandler skipHandler) {
                            this.doApply();
                            this.skipDispatcher.apply(this.methodVisitor, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedMethod, skipHandler);
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                methodVisitor.visitInsn(3);
                                methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                methodVisitor.visitInsn(9);
                                methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                methodVisitor.visitInsn(1);
                                methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                            }
                        }
                    }

                    protected static class ForMethodExit
                    extends AdviceMethodWriter
                    implements Bound.ForMethodExit {
                        protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler) {
                            super(adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, suppressionHandler);
                        }

                        @Override
                        public void apply() {
                            this.doApply();
                        }

                        @Override
                        protected void onMethodReturn() {
                            switch (this.adviceMethod.getReturnType().getStackSize()) {
                                case ZERO: {
                                    return;
                                }
                                case SINGLE: {
                                    this.methodVisitor.visitInsn(87);
                                    return;
                                }
                                case DOUBLE: {
                                    this.methodVisitor.visitInsn(88);
                                    return;
                                }
                            }
                            throw new IllegalStateException("Unexpected size: " + (Object)((Object)this.adviceMethod.getReturnType().getStackSize()));
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                        }
                    }
                }

                protected static class ForMethodEnter
                extends Resolved<Bound.ForMethodEnter>
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.Factory.Illegal<Thrown>(Thrown.class), new OffsetMapping.Factory.Illegal<Enter>(Enter.class), new OffsetMapping.Factory.Illegal<Return>(Return.class)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class));
                        this.skipDispatcher = Resolved.ForMethodEnter.SkipDispatcher.ForType.of(adviceMethod);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    @Override
                    public TypeDefinition getEnterType() {
                        return this.adviceMethod.getReturnType();
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected Bound.ForMethodEnter resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodEntry.of(instrumentedMethod)));
                        }
                        return new AdviceMethodWriter.ForMethodEnter(this.adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler.bindEntry(this.adviceMethod), stackMapFrameHandler.bindEntry(this.adviceMethod), this.suppressionHandler.bind(exceptionHandler), this.skipDispatcher);
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)object;
                        return this.prependLineNumber == that.prependLineNumber && this.skipDispatcher.equals(that.skipDispatcher);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.skipDispatcher.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }
                }

                protected static abstract class ForMethodExit
                extends Resolved<Bound.ForMethodExit>
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDefinition enterType;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType), OffsetMapping.ForReturnValue.Factory.INSTANCE, OffsetMapping.ForThrowable.Factory.of(adviceMethod)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class));
                        this.enterType = enterType;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return throwable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, enterType) : new WithExceptionHandler(adviceMethod, userFactories, enterType, throwable);
                    }

                    @Override
                    protected Bound.ForMethodExit resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodExit.of(this.enterType)));
                        }
                        return new AdviceMethodWriter.ForMethodExit(this.adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler.bindExit(this.adviceMethod, this.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), this.suppressionHandler.bind(exceptionHandler));
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodExit that = (ForMethodExit)object;
                        return this.enterType.equals(that.enterType);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType, TypeDescription throwable) {
                            super(adviceMethod, userFactories, enterType);
                            this.throwable = throwable;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        @Override
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof WithExceptionHandler)) {
                                return false;
                            }
                            WithExceptionHandler other = (WithExceptionHandler)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            TypeDescription this$throwable = this.getThrowable();
                            TypeDescription other$throwable = other.getThrowable();
                            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof WithExceptionHandler;
                        }

                        @Override
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            result = result * 59 + super.hashCode();
                            TypeDescription $throwable = this.getThrowable();
                            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
                            return result;
                        }
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                            super(adviceMethod, userFactories, enterType);
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }
                    }
                }
            }
        }

        public static enum Inactive implements Unresolved,
        Resolved.ForMethodEnter,
        Resolved.ForMethodExit,
        Bound.ForMethodEnter,
        Bound.ForMethodExit
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public TypeDescription getThrowable() {
                return NoExceptionHandler.DESCRIPTION;
            }

            @Override
            public TypeDefinition getEnterType() {
                return TypeDescription.VOID;
            }

            @Override
            public boolean isPrependLineNumber() {
                return false;
            }

            @Override
            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                return this;
            }

            @Override
            public Resolved.ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Resolved.ForMethodEnter dispatcher) {
                return this;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void apply() {
            }

            @Override
            public void apply(Bound.SkipHandler skipHandler) {
            }

            @Override
            public Inactive bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                return this;
            }
        }

        public static class Inlining
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Inlining(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return true;
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                return new Resolved.ForMethodEnter(this.adviceMethod, userFactories, classReader);
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, classReader, dispatcher.getEnterType());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Inlining)) {
                    return false;
                }
                Inlining other = (Inlining)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$adviceMethod = this.adviceMethod;
                MethodDescription.InDefinedShape other$adviceMethod = other.adviceMethod;
                return !(this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Inlining;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $adviceMethod = this.adviceMethod;
                result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                return result;
            }

            protected static abstract class CodeTranslationVisitor
            extends MethodVisitor
            implements SuppressionHandler.ReturnValueProducer {
                protected final MethodVisitor methodVisitor;
                protected final Implementation.Context implementationContext;
                protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                protected final MethodDescription instrumentedMethod;
                protected final MethodDescription.InDefinedShape adviceMethod;
                private final Map<Integer, OffsetMapping.Target> offsetMappings;
                private final SuppressionHandler.Bound suppressionHandler;
                protected final Label endOfMethod;

                protected CodeTranslationVisitor(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler) {
                    super(393216, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod));
                    this.methodVisitor = methodVisitor;
                    this.implementationContext = implementationContext;
                    this.methodSizeHandler = methodSizeHandler;
                    this.stackMapFrameHandler = stackMapFrameHandler;
                    this.instrumentedMethod = instrumentedMethod;
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = offsetMappings;
                    this.suppressionHandler = suppressionHandler;
                    this.endOfMethod = new Label();
                }

                protected void propagateHandler(Label label) {
                    ((StackAwareMethodVisitor)this.mv).register(label, Collections.singletonList(StackSize.SINGLE));
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public void visitAttribute(Attribute attribute) {
                }

                @Override
                public void visitCode() {
                    this.suppressionHandler.onStart(this.methodVisitor);
                }

                @Override
                public void visitFrame(int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    this.stackMapFrameHandler.translateFrame(this.methodVisitor, type, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void visitEnd() {
                    this.suppressionHandler.onEnd(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this);
                    this.methodVisitor.visitLabel(this.endOfMethod);
                    this.onMethodReturn();
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                public void visitMaxs(int stackSize, int localVariableLength) {
                    this.methodSizeHandler.recordMaxima(stackSize, localVariableLength);
                }

                @Override
                public void visitVarInsn(int opcode, int offset) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        StackSize expectedGrowth;
                        StackManipulation stackManipulation;
                        switch (opcode) {
                            case 21: 
                            case 23: 
                            case 25: {
                                stackManipulation = target.resolveRead();
                                expectedGrowth = StackSize.SINGLE;
                                break;
                            }
                            case 22: 
                            case 24: {
                                stackManipulation = target.resolveRead();
                                expectedGrowth = StackSize.DOUBLE;
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                stackManipulation = target.resolveWrite();
                                expectedGrowth = StackSize.ZERO;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected opcode: " + opcode);
                            }
                        }
                        this.methodSizeHandler.recordPadding(stackManipulation.apply(this.mv, this.implementationContext).getMaximalSize() - expectedGrowth.getSize());
                    } else {
                        this.mv.visitVarInsn(opcode, this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize()));
                    }
                }

                @Override
                public void visitIincInsn(int offset, int value) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        this.methodSizeHandler.recordPadding(target.resolveIncrement(value).apply(this.mv, this.implementationContext).getMaximalSize());
                    } else {
                        this.mv.visitIincInsn(this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize()), value);
                    }
                }

                protected abstract int adjust(int var1);

                @Override
                public abstract void visitInsn(int var1);

                protected abstract void onMethodReturn();

                protected static class ForMethodEnter
                extends CodeTranslationVisitor {
                    private boolean doesReturn = false;

                    protected ForMethodEnter(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler) {
                        super(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                ((StackAwareMethodVisitor)this.mv).drainStack();
                                break;
                            }
                            case 172: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                                break;
                            }
                            case 176: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                                break;
                            }
                            case 174: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                                break;
                            }
                            case 173: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                                break;
                            }
                            case 175: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                        this.doesReturn = true;
                    }

                    @Override
                    protected int adjust(int offset) {
                        return offset;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                        if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                            methodVisitor.visitInsn(3);
                        } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                            methodVisitor.visitInsn(9);
                        } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                            methodVisitor.visitInsn(11);
                        } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                            methodVisitor.visitInsn(14);
                        } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitInsn(1);
                        }
                        this.doesReturn = true;
                    }

                    @Override
                    protected void onMethodReturn() {
                        Type returnType = Type.getType(this.adviceMethod.getReturnType().asErasure().getDescriptor());
                        if (this.doesReturn && !returnType.equals(Type.VOID_TYPE)) {
                            this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                            this.methodVisitor.visitVarInsn(returnType.getOpcode(54), this.instrumentedMethod.getStackSize());
                        }
                    }
                }

                protected static class ForMethodExit
                extends CodeTranslationVisitor {
                    private final int padding;

                    protected ForMethodExit(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, int padding) {
                        super(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler);
                        this.padding = padding;
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                break;
                            }
                            case 172: 
                            case 174: 
                            case 176: {
                                this.mv.visitInsn(87);
                                break;
                            }
                            case 173: 
                            case 175: {
                                this.mv.visitInsn(88);
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                    }

                    @Override
                    protected int adjust(int offset) {
                        return this.instrumentedMethod.getReturnType().getStackSize().getSize() + this.padding + offset;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                    }

                    @Override
                    protected void onMethodReturn() {
                    }
                }
            }

            protected static abstract class Resolved
            implements net.bytebuddy.asm.Advice$Dispatcher$Resolved {
                private static final boolean READ_ONLY = true;
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final ClassReader classReader;
                protected final Map<Integer, OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Factory<?>> factories, ClassReader classReader, TypeDescription throwableType) {
                    this.adviceMethod = adviceMethod;
                    HashMap offsetMappings = new HashMap();
                    for (OffsetMapping.Factory<?> factory : factories) {
                        offsetMappings.put(new TypeDescription.ForLoadedType(factory.getAnnotationType()), factory);
                    }
                    this.offsetMappings = new HashMap<Integer, OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = null;
                        for (AnnotationDescription annotationDescription : parameterDescription.getDeclaredAnnotations()) {
                            OffsetMapping.Factory factory = (OffsetMapping.Factory)offsetMappings.get(annotationDescription.getAnnotationType());
                            if (factory == null) continue;
                            OffsetMapping current = factory.make(parameterDescription, annotationDescription.prepare(factory.getAnnotationType()), OffsetMapping.Factory.AdviceType.INLINING);
                            if (offsetMapping == null) {
                                offsetMapping = current;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + current + " and " + offsetMapping);
                        }
                        this.offsetMappings.put(parameterDescription.getOffset(), offsetMapping == null ? new OffsetMapping.ForArgument.Unresolved(parameterDescription) : offsetMapping);
                    }
                    this.classReader = classReader;
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                protected abstract MethodVisitor apply(MethodVisitor var1, Implementation.Context var2, Assigner var3, MethodSizeHandler.ForInstrumentedMethod var4, StackMapFrameHandler.ForInstrumentedMethod var5, TypeDescription var6, MethodDescription var7, SuppressionHandler.Bound var8);

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)object;
                    return this.adviceMethod.equals(resolved.adviceMethod) && this.offsetMappings.equals(resolved.offsetMappings) && this.suppressionHandler.equals(resolved.suppressionHandler);
                }

                public int hashCode() {
                    int result = this.adviceMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    result = 31 * result + this.suppressionHandler.hashCode();
                    return result;
                }

                protected abstract class AdviceMethodInliner
                extends ClassVisitor
                implements Bound {
                    protected final TypeDescription instrumentedType;
                    protected final MethodDescription instrumentedMethod;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final Assigner assigner;
                    protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
                    protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;
                    protected final SuppressionHandler.Bound suppressionHandler;
                    protected final ClassReader classReader;
                    protected List<Label> labels;

                    protected AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader) {
                        super(393216);
                        this.instrumentedType = instrumentedType;
                        this.instrumentedMethod = instrumentedMethod;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.assigner = assigner;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.classReader = classReader;
                        this.labels = new ArrayList<Label>();
                    }

                    @Override
                    public void prepare() {
                        this.classReader.accept(new ExceptionTableExtractor(), 6);
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    protected void doApply() {
                        this.classReader.accept(this, 2 | this.stackMapFrameHandler.getReaderHint());
                    }

                    @Override
                    public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                        return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableSubstitutor(Resolved.this.apply(this.methodVisitor, this.implementationContext, this.assigner, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedType, this.instrumentedMethod, this.suppressionHandler)) : IGNORE_METHOD;
                    }

                    protected class ExceptionTableCollector
                    extends MethodVisitor {
                        private final MethodVisitor methodVisitor;

                        protected ExceptionTableCollector(MethodVisitor methodVisitor) {
                            super(393216);
                            this.methodVisitor = methodVisitor;
                        }

                        @Override
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.methodVisitor.visitTryCatchBlock(start, end, handler, type);
                            AdviceMethodInliner.this.labels.addAll(Arrays.asList(start, end, handler));
                        }

                        @Override
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return this.methodVisitor.visitTryCatchAnnotation(typeReference, typePath, descriptor, visible);
                        }
                    }

                    protected class ExceptionTableExtractor
                    extends ClassVisitor {
                        protected ExceptionTableExtractor() {
                            super(393216);
                        }

                        @Override
                        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                            return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableCollector(AdviceMethodInliner.this.methodVisitor) : IGNORE_METHOD;
                        }
                    }

                    protected class ExceptionTableSubstitutor
                    extends MethodVisitor {
                        private final Map<Label, Label> substitutions;
                        private int index;

                        protected ExceptionTableSubstitutor(MethodVisitor methodVisitor) {
                            super(393216, methodVisitor);
                            this.substitutions = new IdentityHashMap<Label, Label>();
                        }

                        @Override
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.substitutions.put(start, AdviceMethodInliner.this.labels.get(this.index++));
                            this.substitutions.put(end, AdviceMethodInliner.this.labels.get(this.index++));
                            Label actualHandler = AdviceMethodInliner.this.labels.get(this.index++);
                            this.substitutions.put(handler, actualHandler);
                            ((CodeTranslationVisitor)this.mv).propagateHandler(actualHandler);
                        }

                        @Override
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return IGNORE_ANNOTATION;
                        }

                        @Override
                        public void visitLabel(Label label) {
                            super.visitLabel(this.resolve(label));
                        }

                        @Override
                        public void visitJumpInsn(int opcode, Label label) {
                            super.visitJumpInsn(opcode, this.resolve(label));
                        }

                        @Override
                        public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... label) {
                            super.visitTableSwitchInsn(minimum, maximum, defaultOption, this.resolve(label));
                        }

                        @Override
                        public void visitLookupSwitchInsn(Label defaultOption, int[] keys, Label[] label) {
                            super.visitLookupSwitchInsn(this.resolve(defaultOption), keys, this.resolve(label));
                        }

                        private Label[] resolve(Label[] label) {
                            Label[] resolved = new Label[label.length];
                            int index = 0;
                            for (Label aLabel : label) {
                                resolved[index++] = this.resolve(aLabel);
                            }
                            return resolved;
                        }

                        private Label resolve(Label label) {
                            Label substitution = this.substitutions.get(label);
                            return substitution == null ? label : substitution;
                        }
                    }
                }

                protected static class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, OffsetMapping.ForThrowable.Factory.INSTANCE, new OffsetMapping.Factory.Illegal<Thrown>(Thrown.class), new OffsetMapping.Factory.Illegal<Enter>(Enter.class), new OffsetMapping.Factory.Illegal<Return>(Return.class)), userFactories), classReader, adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class));
                        this.skipDispatcher = Resolved.ForMethodEnter.SkipDispatcher.ForType.of(adviceMethod);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    @Override
                    public Bound.ForMethodEnter bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.classReader, this.skipDispatcher);
                    }

                    @Override
                    public TypeDefinition getEnterType() {
                        return this.adviceMethod.getReturnType();
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodEntry.of(instrumentedMethod)));
                        }
                        return new CodeTranslationVisitor.ForMethodEnter(methodVisitor, implementationContext, methodSizeHandler.bindEntry(this.adviceMethod), stackMapFrameHandler.bindEntry(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler);
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)object;
                        return this.prependLineNumber == that.prependLineNumber && this.skipDispatcher.equals(that.skipDispatcher);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.skipDispatcher.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    protected class AdviceMethodInliner
                    extends net.bytebuddy.asm.Advice$Dispatcher$Inlining$Resolved$AdviceMethodInliner
                    implements Bound.ForMethodEnter {
                        private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;

                        protected AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader, Resolved.ForMethodEnter.SkipDispatcher skipDispatcher) {
                            super(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, suppressionHandler, classReader);
                            this.skipDispatcher = skipDispatcher;
                        }

                        @Override
                        public void apply(Bound.SkipHandler skipHandler) {
                            this.doApply();
                            this.skipDispatcher.apply(this.methodVisitor, this.methodSizeHandler.bindEntry(ForMethodEnter.this.adviceMethod), this.stackMapFrameHandler.bindEntry(ForMethodEnter.this.adviceMethod), this.instrumentedMethod, skipHandler);
                        }
                    }
                }

                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDefinition enterType;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType), OffsetMapping.ForReturnValue.Factory.INSTANCE, OffsetMapping.ForThrowable.Factory.of(adviceMethod)), userFactories), classReader, adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class));
                        this.enterType = enterType;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType) {
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return throwable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, classReader, enterType) : new WithExceptionHandler(adviceMethod, userFactories, classReader, enterType, throwable);
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodExit.of(this.enterType)));
                        }
                        return new CodeTranslationVisitor.ForMethodExit(methodVisitor, implementationContext, methodSizeHandler.bindExit(this.adviceMethod, this.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler, this.enterType.getStackSize().getSize() + this.getPadding().getSize());
                    }

                    @Override
                    public Bound.ForMethodExit bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.classReader);
                    }

                    protected abstract StackSize getPadding();

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodExit that = (ForMethodExit)object;
                        return this.enterType.equals(that.enterType);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected class AdviceMethodInliner
                    extends net.bytebuddy.asm.Advice$Dispatcher$Inlining$Resolved$AdviceMethodInliner
                    implements Bound.ForMethodExit {
                        public AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader) {
                            super(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, suppressionHandler, classReader);
                        }

                        @Override
                        public void apply() {
                            this.doApply();
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType, TypeDescription throwable) {
                            super(adviceMethod, userFactories, classReader, enterType);
                            this.throwable = throwable;
                        }

                        @Override
                        protected StackSize getPadding() {
                            return this.throwable.getStackSize();
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        @Override
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof WithExceptionHandler)) {
                                return false;
                            }
                            WithExceptionHandler other = (WithExceptionHandler)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            TypeDescription this$throwable = this.getThrowable();
                            TypeDescription other$throwable = other.getThrowable();
                            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof WithExceptionHandler;
                        }

                        @Override
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            result = result * 59 + super.hashCode();
                            TypeDescription $throwable = this.getThrowable();
                            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
                            return result;
                        }
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType) {
                            super(adviceMethod, userFactories, classReader, enterType);
                        }

                        @Override
                        protected StackSize getPadding() {
                            return StackSize.ZERO;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }
                    }
                }
            }
        }

        public static interface Resolved
        extends Dispatcher {
            public Bound bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);

            public static interface ForMethodEnter
            extends Resolved {
                public TypeDefinition getEnterType();

                public boolean isPrependLineNumber();

                @Override
                public Bound.ForMethodEnter bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);

                public static interface SkipDispatcher {
                    public void apply(MethodVisitor var1, MethodSizeHandler.ForAdvice var2, StackMapFrameHandler.ForAdvice var3, MethodDescription var4, Bound.SkipHandler var5);

                    public static enum Disabled implements SkipDispatcher
                    {
                        INSTANCE;


                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                        }
                    }

                    public static class ForType
                    implements SkipDispatcher {
                        private final TypeDescription typeDescription;

                        protected ForType(TypeDescription typeDescription) {
                            this.typeDescription = typeDescription;
                        }

                        public static SkipDispatcher of(MethodDescription adviceMethod) {
                            return ForType.of(adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class), adviceMethod);
                        }

                        protected static SkipDispatcher of(TypeDescription typeDescription, MethodDescription adviceMethod) {
                            if (typeDescription.represents(Void.TYPE)) {
                                return Disabled.INSTANCE;
                            }
                            if (typeDescription.represents((java.lang.reflect.Type)((Object)OnDefaultValue.class))) {
                                return ForValue.of(adviceMethod.getReturnType(), false);
                            }
                            if (typeDescription.represents((java.lang.reflect.Type)((Object)OnNonDefaultValue.class))) {
                                return ForValue.of(adviceMethod.getReturnType(), true);
                            }
                            if (typeDescription.isPrimitive() || adviceMethod.getReturnType().isPrimitive()) {
                                throw new IllegalStateException("Cannot skip method by instance type for primitive return value on " + adviceMethod);
                            }
                            return new ForType(typeDescription);
                        }

                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                            methodVisitor.visitVarInsn(25, instrumentedMethod.getStackSize());
                            methodVisitor.visitTypeInsn(193, this.typeDescription.getInternalName());
                            Label noSkip = new Label();
                            methodVisitor.visitJumpInsn(153, noSkip);
                            skipHandler.apply(methodVisitor);
                            methodVisitor.visitLabel(noSkip);
                            stackMapFrameHandler.injectCompletionFrame(methodVisitor, true);
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof ForType)) {
                                return false;
                            }
                            ForType other = (ForType)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            TypeDescription this$typeDescription = this.typeDescription;
                            TypeDescription other$typeDescription = other.typeDescription;
                            return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof ForType;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            TypeDescription $typeDescription = this.typeDescription;
                            result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                            return result;
                        }
                    }

                    public static enum ForValue implements SkipDispatcher
                    {
                        FOR_INTEGER(21, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                            }
                        }
                        ,
                        FOR_LONG(22, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(136);
                            }
                        }
                        ,
                        FOR_FLOAT(23, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitInsn(149);
                                methodSizeHandler.requireStackSize(2);
                            }
                        }
                        ,
                        FOR_DOUBLE(24, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitInsn(151);
                                methodSizeHandler.requireStackSize(4);
                            }
                        }
                        ,
                        FOR_REFERENCE(25, 199, 198){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                            }
                        };

                        private final int load;
                        private final int defaultJump;
                        private final int nonDefaultJump;

                        private ForValue(int load, int defaultJump, int nonDefaultJump) {
                            this.load = load;
                            this.defaultJump = defaultJump;
                            this.nonDefaultJump = nonDefaultJump;
                        }

                        protected static SkipDispatcher of(TypeDefinition typeDefinition, boolean inverted) {
                            ForValue skipDispatcher;
                            if (typeDefinition.represents(Long.TYPE)) {
                                skipDispatcher = FOR_LONG;
                            } else if (typeDefinition.represents(Float.TYPE)) {
                                skipDispatcher = FOR_FLOAT;
                            } else if (typeDefinition.represents(Double.TYPE)) {
                                skipDispatcher = FOR_DOUBLE;
                            } else {
                                if (typeDefinition.represents(Void.TYPE)) {
                                    throw new IllegalStateException("Cannot skip on default value for void return type");
                                }
                                skipDispatcher = typeDefinition.isPrimitive() ? FOR_INTEGER : FOR_REFERENCE;
                            }
                            return inverted ? skipDispatcher.inverted() : skipDispatcher;
                        }

                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                            this.doApply(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, skipHandler, false);
                        }

                        protected void doApply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler, boolean inverted) {
                            methodVisitor.visitVarInsn(this.load, instrumentedMethod.getStackSize());
                            this.convertValue(methodVisitor, methodSizeHandler);
                            Label noSkip = new Label();
                            methodVisitor.visitJumpInsn(inverted ? this.nonDefaultJump : this.defaultJump, noSkip);
                            skipHandler.apply(methodVisitor);
                            methodVisitor.visitLabel(noSkip);
                            stackMapFrameHandler.injectCompletionFrame(methodVisitor, true);
                        }

                        protected abstract void convertValue(MethodVisitor var1, MethodSizeHandler.ForAdvice var2);

                        private SkipDispatcher inverted() {
                            return new Inverted();
                        }

                        protected class Inverted
                        implements SkipDispatcher {
                            protected Inverted() {
                            }

                            @Override
                            public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                                ForValue.this.doApply(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, skipHandler, true);
                            }

                            private SkipDispatcher getOuter() {
                                return ForValue.this;
                            }

                            public int hashCode() {
                                return ForValue.this.hashCode();
                            }

                            public boolean equals(Object other) {
                                if (other == this) {
                                    return true;
                                }
                                if (other == null || other.getClass() != this.getClass()) {
                                    return false;
                                }
                                Inverted inverted = (Inverted)other;
                                return inverted.getOuter().equals(ForValue.this);
                            }
                        }
                    }
                }
            }

            public static interface ForMethodExit
            extends Resolved {
                public TypeDescription getThrowable();

                @Override
                public Bound.ForMethodExit bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);
            }
        }

        public static interface SuppressionHandler {
            public Bound bind(StackManipulation var1);

            public static interface Bound {
                public void onPrepare(MethodVisitor var1);

                public void onStart(MethodVisitor var1);

                public void onEnd(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, ReturnValueProducer var5);

                public void onEndSkipped(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, ReturnValueProducer var5);
            }

            public static enum NoOp implements SuppressionHandler,
            Bound
            {
                INSTANCE;


                @Override
                public Bound bind(StackManipulation exceptionHandler) {
                    return this;
                }

                @Override
                public void onPrepare(MethodVisitor methodVisitor) {
                }

                @Override
                public void onStart(MethodVisitor methodVisitor) {
                }

                @Override
                public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }

                @Override
                public void onEndSkipped(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }
            }

            public static interface ReturnValueProducer {
                public void onDefaultValue(MethodVisitor var1);
            }

            public static class Suppressing
            implements SuppressionHandler {
                private final TypeDescription suppressedType;

                protected Suppressing(TypeDescription suppressedType) {
                    this.suppressedType = suppressedType;
                }

                protected static SuppressionHandler of(TypeDescription suppressedType) {
                    return suppressedType.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? NoOp.INSTANCE : new Suppressing(suppressedType);
                }

                @Override
                public net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound bind(StackManipulation exceptionHandler) {
                    return new Bound(this.suppressedType, exceptionHandler);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Suppressing)) {
                        return false;
                    }
                    Suppressing other = (Suppressing)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$suppressedType = this.suppressedType;
                    TypeDescription other$suppressedType = other.suppressedType;
                    return !(this$suppressedType == null ? other$suppressedType != null : !this$suppressedType.equals(other$suppressedType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Suppressing;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $suppressedType = this.suppressedType;
                    result = result * 59 + ($suppressedType == null ? 43 : $suppressedType.hashCode());
                    return result;
                }

                protected static class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound {
                    private final TypeDescription suppressedType;
                    private final StackManipulation exceptionHandler;
                    private final Label startOfMethod;
                    private final Label endOfMethod;

                    protected Bound(TypeDescription suppressedType, StackManipulation exceptionHandler) {
                        this.suppressedType = suppressedType;
                        this.exceptionHandler = exceptionHandler;
                        this.startOfMethod = new Label();
                        this.endOfMethod = new Label();
                    }

                    @Override
                    public void onPrepare(MethodVisitor methodVisitor) {
                        methodVisitor.visitTryCatchBlock(this.startOfMethod, this.endOfMethod, this.endOfMethod, this.suppressedType.getInternalName());
                    }

                    @Override
                    public void onStart(MethodVisitor methodVisitor) {
                        methodVisitor.visitLabel(this.startOfMethod);
                    }

                    @Override
                    public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        methodVisitor.visitLabel(this.endOfMethod);
                        stackMapFrameHandler.injectExceptionFrame(methodVisitor);
                        methodSizeHandler.requireStackSize(1 + this.exceptionHandler.apply(methodVisitor, implementationContext).getMaximalSize());
                        returnValueProducer.onDefaultValue(methodVisitor);
                    }

                    @Override
                    public void onEndSkipped(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        Label endOfHandler = new Label();
                        methodVisitor.visitJumpInsn(167, endOfHandler);
                        this.onEnd(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, returnValueProducer);
                        methodVisitor.visitLabel(endOfHandler);
                    }
                }
            }
        }

        public static interface Unresolved
        extends Dispatcher {
            public boolean isBinary();

            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> var1, ClassReader var2);

            public Resolved.ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory<?>> var1, ClassReader var2, Resolved.ForMethodEnter var3);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Enter {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldValue {
        public String value();

        public Class<?> declaringType() default void.class;

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    protected static interface MethodSizeHandler {
        public static final int UNDEFINED_SIZE = Short.MAX_VALUE;

        public void requireLocalVariableLength(int var1);

        public static class Default
        implements ForInstrumentedMethod {
            private final MethodDescription instrumentedMethod;
            private final TypeList requiredTypes;
            private final TypeList yieldedTypes;
            private int stackSize;
            private int localVariableLength;

            protected Default(MethodDescription instrumentedMethod, TypeList requiredTypes, TypeList yieldedTypes) {
                this.instrumentedMethod = instrumentedMethod;
                this.requiredTypes = requiredTypes;
                this.yieldedTypes = yieldedTypes;
            }

            protected static ForInstrumentedMethod of(MethodDescription instrumentedMethod, List<? extends TypeDescription> requiredTypes, List<? extends TypeDescription> yieldedTypes, int writerFlags) {
                return (writerFlags & 3) != 0 ? NoOp.INSTANCE : new Default(instrumentedMethod, new TypeList.Explicit(requiredTypes), new TypeList.Explicit(yieldedTypes));
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                return new ForAdvice(adviceMethod, new TypeList.Empty(), new TypeList.Explicit(this.requiredTypes));
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().maximum(skipThrowable ? StackSize.ZERO : StackSize.SINGLE).getSize());
                return new ForAdvice(adviceMethod, new TypeList.Explicit(CompoundList.of(this.requiredTypes, this.yieldedTypes)), new TypeList.Empty());
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Math.max(this.stackSize, stackSize);
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Math.max(this.localVariableLength, localVariableLength + this.requiredTypes.getStackSize() + this.yieldedTypes.getStackSize());
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
                this.localVariableLength = Math.max(this.localVariableLength, localVariableLength);
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice {
                private final MethodDescription.InDefinedShape adviceMethod;
                private final TypeList requiredTypes;
                private final TypeList yieldedTypes;
                private int padding;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, TypeList requiredTypes, TypeList yieldedTypes) {
                    this.adviceMethod = adviceMethod;
                    this.requiredTypes = requiredTypes;
                    this.yieldedTypes = yieldedTypes;
                    Default.this.stackSize = Math.max(Default.this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                }

                @Override
                public void requireLocalVariableLength(int localVariableLength) {
                    Default.this.requireLocalVariableLength(localVariableLength);
                }

                @Override
                public void requireStackSize(int stackSize) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize);
                }

                @Override
                public void recordMaxima(int stackSize, int localVariableLength) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize) + this.padding;
                    Default.this.localVariableLength = Math.max(Default.this.localVariableLength, localVariableLength - this.adviceMethod.getStackSize() + Default.this.instrumentedMethod.getStackSize() + this.requiredTypes.getStackSize() + this.yieldedTypes.getStackSize());
                }

                @Override
                public void recordPadding(int padding) {
                    this.padding = Math.max(this.padding, padding);
                }
            }
        }

        public static interface ForAdvice
        extends MethodSizeHandler {
            public void requireStackSize(int var1);

            public void recordMaxima(int var1, int var2);

            public void recordPadding(int var1);
        }

        public static interface ForInstrumentedMethod
        extends MethodSizeHandler {
            public ForAdvice bindEntry(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1, boolean var2);

            public int compoundStackSize(int var1);

            public int compoundLocalVariableLength(int var1);
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                return this;
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Short.MAX_VALUE;
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Short.MAX_VALUE;
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
            }

            @Override
            public void requireStackSize(int stackSize) {
            }

            @Override
            public void recordMaxima(int stackSize, int localVariableLength) {
            }

            @Override
            public void recordPadding(int padding) {
            }
        }
    }

    private static class NoExceptionHandler
    extends Throwable {
        private static final TypeDescription DESCRIPTION = new TypeDescription.ForLoadedType(NoExceptionHandler.class);

        private NoExceptionHandler() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static interface OffsetMapping {
        public Target resolve(TypeDescription var1, MethodDescription var2, Assigner var3, Context var4);

        public static interface Context {
            public boolean isInitialized();

            public int getPadding();

            public static enum ForMethodEntry implements Context
            {
                INITIALIZED(true),
                NON_INITIALIZED(false);

                private final boolean initialized;

                protected static Context of(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isConstructor() ? NON_INITIALIZED : INITIALIZED;
                }

                private ForMethodEntry(boolean initialized) {
                    this.initialized = initialized;
                }

                @Override
                public boolean isInitialized() {
                    return this.initialized;
                }

                @Override
                public int getPadding() {
                    return StackSize.ZERO.getSize();
                }
            }

            public static enum ForMethodExit implements Context
            {
                ZERO(StackSize.ZERO),
                SINGLE(StackSize.SINGLE),
                DOUBLE(StackSize.DOUBLE);

                private final StackSize stackSize;

                private ForMethodExit(StackSize stackSize) {
                    this.stackSize = stackSize;
                }

                protected static Context of(TypeDefinition typeDescription) {
                    switch (typeDescription.getStackSize()) {
                        case ZERO: {
                            return ZERO;
                        }
                        case SINGLE: {
                            return SINGLE;
                        }
                        case DOUBLE: {
                            return DOUBLE;
                        }
                    }
                    throw new IllegalStateException("Unknown stack size: " + typeDescription);
                }

                @Override
                public boolean isInitialized() {
                    return true;
                }

                @Override
                public int getPadding() {
                    return this.stackSize.getSize();
                }
            }
        }

        public static interface Factory<T extends Annotation> {
            public Class<T> getAnnotationType();

            public OffsetMapping make(ParameterDescription.InDefinedShape var1, AnnotationDescription.Loadable<T> var2, AdviceType var3);

            public static enum AdviceType {
                DELEGATION(true),
                INLINING(false);

                private final boolean delegation;

                private AdviceType(boolean delegation) {
                    this.delegation = delegation;
                }

                public boolean isDelegation() {
                    return this.delegation;
                }
            }

            public static class Illegal<T extends Annotation>
            implements Factory<T> {
                private final Class<T> annotationType;

                public Illegal(Class<T> annotationType) {
                    this.annotationType = annotationType;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, AdviceType adviceType) {
                    throw new IllegalStateException("Usage of " + this.annotationType + " is not allowed on " + target);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Illegal)) {
                        return false;
                    }
                    Illegal other = (Illegal)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Illegal;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    return result;
                }
            }

            public static class Simple<T extends Annotation>
            implements Factory<T> {
                private final Class<T> annotationType;
                private final OffsetMapping offsetMapping;

                public Simple(Class<T> annotationType, OffsetMapping offsetMapping) {
                    this.annotationType = annotationType;
                    this.offsetMapping = offsetMapping;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, AdviceType adviceType) {
                    return this.offsetMapping;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Simple)) {
                        return false;
                    }
                    Simple other = (Simple)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    OffsetMapping this$offsetMapping = this.offsetMapping;
                    OffsetMapping other$offsetMapping = other.offsetMapping;
                    return !(this$offsetMapping == null ? other$offsetMapping != null : !this$offsetMapping.equals(other$offsetMapping));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Simple;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    OffsetMapping $offsetMapping = this.offsetMapping;
                    result = result * 59 + ($offsetMapping == null ? 43 : $offsetMapping.hashCode());
                    return result;
                }
            }
        }

        public static class ForAllArguments
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForAllArguments(TypeDescription.Generic target, AllArguments annotation) {
                this(target, annotation.readOnly(), annotation.typing());
            }

            public ForAllArguments(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                ArrayList<StackManipulation.Compound> valueReads = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                    StackManipulation readAssignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                    }
                    valueReads.add(new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), readAssignment));
                }
                if (this.readOnly) {
                    return new Target.ForArray.ReadOnly(this.target, valueReads);
                }
                ArrayList<StackManipulation.Compound> valueWrites = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                    StackManipulation writeAssignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + parameterDescription);
                    }
                    valueWrites.add(new StackManipulation.Compound(writeAssignment, MethodVariableAccess.store(parameterDescription)));
                }
                return new Target.ForArray.ReadWrite(this.target, valueReads, valueWrites);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForAllArguments)) {
                    return false;
                }
                ForAllArguments other = (ForAllArguments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForAllArguments;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<AllArguments>
            {
                INSTANCE;


                @Override
                public Class<AllArguments> getAnnotationType() {
                    return AllArguments.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<AllArguments> annotation, Factory.AdviceType adviceType) {
                    if (!target.getType().represents((java.lang.reflect.Type)((Object)Object.class)) && !target.getType().isArray()) {
                        throw new IllegalStateException("Cannot use AllArguments annotation on a non-array type");
                    }
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot define writable field access for " + target);
                    }
                    return new ForAllArguments(target.getType().represents((java.lang.reflect.Type)((Object)Object.class)) ? TypeDescription.Generic.OBJECT : target.getType().getComponentType(), annotation.loadSilent());
                }
            }
        }

        public static abstract class ForArgument
        implements OffsetMapping {
            protected final TypeDescription.Generic target;
            protected final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForArgument(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                ParameterDescription parameterDescription = this.resolve(instrumentedMethod);
                StackManipulation readAssignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(parameterDescription, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                }
                return new Target.ForVariable.ReadWrite(parameterDescription, readAssignment, writeAssignment);
            }

            protected abstract ParameterDescription resolve(MethodDescription var1);

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForArgument)) {
                    return false;
                }
                ForArgument other = (ForArgument)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForArgument;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            public static class Resolved
            extends ForArgument {
                private final ParameterDescription parameterDescription;

                public Resolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, ParameterDescription parameterDescription) {
                    super(target, readOnly, typing);
                    this.parameterDescription = parameterDescription;
                }

                @Override
                protected ParameterDescription resolve(MethodDescription instrumentedMethod) {
                    if (!this.parameterDescription.getDeclaringMethod().equals(instrumentedMethod)) {
                        throw new IllegalStateException(this.parameterDescription + " is not a parameter of " + instrumentedMethod);
                    }
                    return this.parameterDescription;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Resolved)) {
                        return false;
                    }
                    Resolved other = (Resolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    ParameterDescription this$parameterDescription = this.parameterDescription;
                    ParameterDescription other$parameterDescription = other.parameterDescription;
                    return !(this$parameterDescription == null ? other$parameterDescription != null : !this$parameterDescription.equals(other$parameterDescription));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Resolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + super.hashCode();
                    ParameterDescription $parameterDescription = this.parameterDescription;
                    result = result * 59 + ($parameterDescription == null ? 43 : $parameterDescription.hashCode());
                    return result;
                }

                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final ParameterDescription parameterDescription;
                    private final boolean readOnly;
                    private final Assigner.Typing typing;

                    public Factory(Class<T> annotationType, ParameterDescription parameterDescription) {
                        this(annotationType, parameterDescription, true, Assigner.Typing.STATIC);
                    }

                    public Factory(Class<T> annotationType, ParameterDescription parameterDescription, boolean readOnly, Assigner.Typing typing) {
                        this.annotationType = annotationType;
                        this.parameterDescription = parameterDescription;
                        this.readOnly = readOnly;
                        this.typing = typing;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        return new Resolved(target.getType(), this.readOnly, this.typing, this.parameterDescription);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Factory)) {
                            return false;
                        }
                        Factory other = (Factory)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Class<T> this$annotationType = this.getAnnotationType();
                        Class<T> other$annotationType = other.getAnnotationType();
                        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                            return false;
                        }
                        ParameterDescription this$parameterDescription = this.parameterDescription;
                        ParameterDescription other$parameterDescription = other.parameterDescription;
                        if (this$parameterDescription == null ? other$parameterDescription != null : !this$parameterDescription.equals(other$parameterDescription)) {
                            return false;
                        }
                        if (this.readOnly != other.readOnly) {
                            return false;
                        }
                        Assigner.Typing this$typing = this.typing;
                        Assigner.Typing other$typing = other.typing;
                        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Factory;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Class<T> $annotationType = this.getAnnotationType();
                        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                        ParameterDescription $parameterDescription = this.parameterDescription;
                        result = result * 59 + ($parameterDescription == null ? 43 : $parameterDescription.hashCode());
                        result = result * 59 + (this.readOnly ? 79 : 97);
                        Assigner.Typing $typing = this.typing;
                        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                        return result;
                    }
                }
            }

            public static class Unresolved
            extends ForArgument {
                private final int index;
                private final boolean optional;

                protected Unresolved(TypeDescription.Generic target, Argument argument) {
                    this(target, argument.readOnly(), argument.typing(), argument.value(), argument.optional());
                }

                protected Unresolved(ParameterDescription parameterDescription) {
                    this(parameterDescription.getType(), true, Assigner.Typing.STATIC, parameterDescription.getIndex());
                }

                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, int index) {
                    this(target, readOnly, typing, index, false);
                }

                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, int index, boolean optional) {
                    super(target, readOnly, typing);
                    this.index = index;
                    this.optional = optional;
                }

                @Override
                protected ParameterDescription resolve(MethodDescription instrumentedMethod) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (parameters.size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not define an index " + this.index);
                    }
                    return (ParameterDescription)parameters.get(this.index);
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    if (this.optional && instrumentedMethod.getParameters().size() <= this.index) {
                        return this.readOnly ? new Target.ForDefaultValue.ReadOnly(this.target) : new Target.ForDefaultValue.ReadWrite(this.target);
                    }
                    return super.resolve(instrumentedType, instrumentedMethod, assigner, context);
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Unresolved)) {
                        return false;
                    }
                    Unresolved other = (Unresolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    if (this.index != other.index) {
                        return false;
                    }
                    return this.optional == other.optional;
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Unresolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + super.hashCode();
                    result = result * 59 + this.index;
                    result = result * 59 + (this.optional ? 79 : 97);
                    return result;
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Argument>
                {
                    INSTANCE;


                    @Override
                    public Class<Argument> getAnnotationType() {
                        return Argument.class;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Argument> annotation, Factory.AdviceType adviceType) {
                        if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot define writable field access for " + target + " when using delegation");
                        }
                        return new Unresolved(target.getType(), annotation.loadSilent());
                    }
                }
            }
        }

        public static class ForEnterValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription.Generic enterType;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, Enter enter) {
                this(target, enterType, enter.readOnly(), enter.typing());
            }

            public ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.enterType = enterType;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                StackManipulation readAssignment = assigner.assign(this.enterType, this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.enterType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(this.target, instrumentedMethod.getStackSize(), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, this.enterType, this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + this.enterType);
                }
                return new Target.ForVariable.ReadWrite(this.target, instrumentedMethod.getStackSize(), readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForEnterValue)) {
                    return false;
                }
                ForEnterValue other = (ForEnterValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                TypeDescription.Generic this$enterType = this.enterType;
                TypeDescription.Generic other$enterType = other.enterType;
                if (this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForEnterValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                TypeDescription.Generic $enterType = this.enterType;
                result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Enter> {
                private final TypeDefinition enterType;

                protected Factory(TypeDefinition enterType) {
                    this.enterType = enterType;
                }

                @Override
                public Class<Enter> getAnnotationType() {
                    return Enter.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Enter> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForEnterValue(target.getType(), this.enterType.asGenericType(), annotation.loadSilent());
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDefinition this$enterType = this.enterType;
                    TypeDefinition other$enterType = other.enterType;
                    return !(this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDefinition $enterType = this.enterType;
                    result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                    return result;
                }
            }
        }

        public static abstract class ForField
        implements OffsetMapping {
            private static final MethodDescription.InDefinedShape VALUE;
            private static final MethodDescription.InDefinedShape DECLARING_TYPE;
            private static final MethodDescription.InDefinedShape READ_ONLY;
            private static final MethodDescription.InDefinedShape TYPING;
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            public ForField(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                FieldDescription fieldDescription = this.resolve(instrumentedType);
                if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot read non-static field " + fieldDescription + " from static method " + instrumentedMethod);
                }
                if (!context.isInitialized() && !fieldDescription.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static field before calling constructor: " + instrumentedMethod);
                }
                StackManipulation readAssignment = assigner.assign(fieldDescription.getType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + fieldDescription + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForField.ReadOnly(fieldDescription, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, fieldDescription.getType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + fieldDescription);
                }
                return new Target.ForField.ReadWrite((FieldDescription)fieldDescription.asDefined(), readAssignment, writeAssignment);
            }

            protected abstract FieldDescription resolve(TypeDescription var1);

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForField)) {
                    return false;
                }
                ForField other = (ForField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            static {
                MethodList<MethodDescription.InDefinedShape> methods = new TypeDescription.ForLoadedType(FieldValue.class).getDeclaredMethods();
                VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("declaringType"))).getOnly();
                READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                TYPING = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("typing"))).getOnly();
            }

            public static class Resolved
            extends ForField {
                private final FieldDescription fieldDescription;

                public Resolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, FieldDescription fieldDescription) {
                    super(target, readOnly, typing);
                    this.fieldDescription = fieldDescription;
                }

                @Override
                protected FieldDescription resolve(TypeDescription instrumentedType) {
                    if (!this.fieldDescription.isStatic() && !this.fieldDescription.getDeclaringType().asErasure().isAssignableFrom(instrumentedType)) {
                        throw new IllegalStateException(this.fieldDescription + " is no member of " + instrumentedType);
                    }
                    if (!this.fieldDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + instrumentedType);
                    }
                    return this.fieldDescription;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Resolved)) {
                        return false;
                    }
                    Resolved other = (Resolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    FieldDescription this$fieldDescription = this.fieldDescription;
                    FieldDescription other$fieldDescription = other.fieldDescription;
                    return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Resolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + super.hashCode();
                    FieldDescription $fieldDescription = this.fieldDescription;
                    result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                    return result;
                }

                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final FieldDescription fieldDescription;
                    private final boolean readOnly;
                    private final Assigner.Typing typing;

                    public Factory(Class<T> annotationType, FieldDescription fieldDescription) {
                        this(annotationType, fieldDescription, true, Assigner.Typing.STATIC);
                    }

                    public Factory(Class<T> annotationType, FieldDescription fieldDescription, boolean readOnly, Assigner.Typing typing) {
                        this.annotationType = annotationType;
                        this.fieldDescription = fieldDescription;
                        this.readOnly = readOnly;
                        this.typing = typing;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        return new Resolved(target.getType(), this.readOnly, this.typing, this.fieldDescription);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Factory)) {
                            return false;
                        }
                        Factory other = (Factory)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Class<T> this$annotationType = this.getAnnotationType();
                        Class<T> other$annotationType = other.getAnnotationType();
                        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                            return false;
                        }
                        FieldDescription this$fieldDescription = this.fieldDescription;
                        FieldDescription other$fieldDescription = other.fieldDescription;
                        if (this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription)) {
                            return false;
                        }
                        if (this.readOnly != other.readOnly) {
                            return false;
                        }
                        Assigner.Typing this$typing = this.typing;
                        Assigner.Typing other$typing = other.typing;
                        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Factory;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Class<T> $annotationType = this.getAnnotationType();
                        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                        FieldDescription $fieldDescription = this.fieldDescription;
                        result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                        result = result * 59 + (this.readOnly ? 79 : 97);
                        Assigner.Typing $typing = this.typing;
                        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                        return result;
                    }
                }
            }

            public static abstract class Unresolved
            extends ForField {
                private final String name;

                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name) {
                    super(target, readOnly, typing);
                    this.name = name;
                }

                @Override
                protected FieldDescription resolve(TypeDescription instrumentedType) {
                    FieldLocator.Resolution resolution = this.fieldLocator(instrumentedType).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot locate field named " + this.name + " for " + instrumentedType);
                    }
                    return resolution.getField();
                }

                protected abstract FieldLocator fieldLocator(TypeDescription var1);

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Unresolved)) {
                        return false;
                    }
                    Unresolved other = (Unresolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    String this$name = this.name;
                    String other$name = other.name;
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Unresolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + super.hashCode();
                    String $name = this.name;
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<FieldValue>
                {
                    INSTANCE;


                    @Override
                    public Class<FieldValue> getAnnotationType() {
                        return FieldValue.class;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<FieldValue> annotation, Factory.AdviceType adviceType) {
                        if (adviceType.isDelegation() && !annotation.getValue(READ_ONLY).resolve(Boolean.class).booleanValue()) {
                            throw new IllegalStateException("Cannot write to field for " + target + " in read-only context");
                        }
                        TypeDescription declaringType = annotation.getValue(DECLARING_TYPE).resolve(TypeDescription.class);
                        return declaringType.represents(Void.TYPE) ? new WithImplicitType(target.getType(), annotation) : new WithExplicitType(target.getType(), annotation, declaringType);
                    }
                }

                public static class WithExplicitType
                extends Unresolved {
                    private final TypeDescription declaringType;

                    protected WithExplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation, TypeDescription declaringType) {
                        this(target, annotation.getValue(READ_ONLY).resolve(Boolean.class), annotation.getValue(TYPING).loadSilent(Assigner.Typing.class.getClassLoader()).resolve(Assigner.Typing.class), annotation.getValue(VALUE).resolve(String.class), declaringType);
                    }

                    public WithExplicitType(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name, TypeDescription declaringType) {
                        super(target, readOnly, typing, name);
                        this.declaringType = declaringType;
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        if (!this.declaringType.represents((java.lang.reflect.Type)((Object)TargetType.class)) && !instrumentedType.isAssignableTo(this.declaringType)) {
                            throw new IllegalStateException(this.declaringType + " is no super type of " + instrumentedType);
                        }
                        return new FieldLocator.ForExactType(TargetType.resolve(this.declaringType, instrumentedType));
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WithExplicitType)) {
                            return false;
                        }
                        WithExplicitType other = (WithExplicitType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        TypeDescription this$declaringType = this.declaringType;
                        TypeDescription other$declaringType = other.declaringType;
                        return !(this$declaringType == null ? other$declaringType != null : !this$declaringType.equals(other$declaringType));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof WithExplicitType;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        TypeDescription $declaringType = this.declaringType;
                        result = result * 59 + ($declaringType == null ? 43 : $declaringType.hashCode());
                        return result;
                    }
                }

                public static class WithImplicitType
                extends Unresolved {
                    protected WithImplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation) {
                        this(target, annotation.getValue(READ_ONLY).resolve(Boolean.class), annotation.getValue(TYPING).loadSilent(Assigner.Typing.class.getClassLoader()).resolve(Assigner.Typing.class), annotation.getValue(VALUE).resolve(String.class));
                    }

                    public WithImplicitType(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name) {
                        super(target, readOnly, typing, name);
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        return new FieldLocator.ForClassHierarchy(instrumentedType);
                    }
                }
            }
        }

        public static enum ForInstrumentedMethod implements OffsetMapping
        {
            METHOD{

                @Override
                protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isMethod();
                }
            }
            ,
            CONSTRUCTOR{

                @Override
                protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isConstructor();
                }
            }
            ,
            EXECUTABLE{

                @Override
                protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return true;
                }
            };


            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                if (!this.isRepresentable(instrumentedMethod)) {
                    throw new IllegalStateException("Cannot represent " + instrumentedMethod + " as given method constant");
                }
                return Target.ForStackManipulation.of((MethodDescription.InDefinedShape)instrumentedMethod.asDefined());
            }

            protected abstract boolean isRepresentable(MethodDescription var1);
        }

        public static enum ForInstrumentedType implements OffsetMapping
        {
            INSTANCE;


            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                return Target.ForStackManipulation.of(instrumentedType);
            }
        }

        public static class ForOrigin
        implements OffsetMapping {
            private static final char DELIMITER = '#';
            private static final char ESCAPE = '\\';
            private final List<Renderer> renderers;

            public ForOrigin(List<Renderer> renderers) {
                this.renderers = renderers;
            }

            public static OffsetMapping parse(String pattern) {
                if (pattern.equals("")) {
                    return new ForOrigin(Collections.singletonList(Renderer.ForStringRepresentation.INSTANCE));
                }
                ArrayList<Renderer> renderers = new ArrayList<Renderer>(pattern.length());
                int from = 0;
                int to = pattern.indexOf(35);
                while (to != -1) {
                    if (to != 0 && pattern.charAt(to - 1) == '\\' && (to == 1 || pattern.charAt(to - 2) != '\\')) {
                        renderers.add(new Renderer.ForConstantValue(pattern.substring(from, Math.max(0, to - 1)) + '#'));
                        from = to + 1;
                    } else {
                        if (pattern.length() == to + 1) {
                            throw new IllegalStateException("Missing sort descriptor for " + pattern + " at index " + to);
                        }
                        renderers.add(new Renderer.ForConstantValue(pattern.substring(from, to).replace("\\\\", "\\")));
                        switch (pattern.charAt(to + 1)) {
                            case 'm': {
                                renderers.add(Renderer.ForMethodName.INSTANCE);
                                break;
                            }
                            case 't': {
                                renderers.add(Renderer.ForTypeName.INSTANCE);
                                break;
                            }
                            case 'd': {
                                renderers.add(Renderer.ForDescriptor.INSTANCE);
                                break;
                            }
                            case 'r': {
                                renderers.add(Renderer.ForReturnTypeName.INSTANCE);
                                break;
                            }
                            case 's': {
                                renderers.add(Renderer.ForJavaSignature.INSTANCE);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Illegal sort descriptor " + pattern.charAt(to + 1) + " for " + pattern);
                            }
                        }
                        from = to + 2;
                    }
                    to = pattern.indexOf(35, from);
                }
                renderers.add(new Renderer.ForConstantValue(pattern.substring(from)));
                return new ForOrigin(renderers);
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Renderer renderer : this.renderers) {
                    stringBuilder.append(renderer.apply(instrumentedType, instrumentedMethod));
                }
                return Target.ForStackManipulation.of(stringBuilder.toString());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForOrigin)) {
                    return false;
                }
                ForOrigin other = (ForOrigin)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Renderer> this$renderers = this.renderers;
                List<Renderer> other$renderers = other.renderers;
                return !(this$renderers == null ? other$renderers != null : !((Object)this$renderers).equals(other$renderers));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForOrigin;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Renderer> $renderers = this.renderers;
                result = result * 59 + ($renderers == null ? 43 : ((Object)$renderers).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Origin>
            {
                INSTANCE;


                @Override
                public Class<Origin> getAnnotationType() {
                    return Origin.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Origin> annotation, Factory.AdviceType adviceType) {
                    if (target.getType().asErasure().represents((java.lang.reflect.Type)((Object)Class.class))) {
                        return ForInstrumentedType.INSTANCE;
                    }
                    if (target.getType().asErasure().represents((java.lang.reflect.Type)((Object)Method.class))) {
                        return ForInstrumentedMethod.METHOD;
                    }
                    if (target.getType().asErasure().represents((java.lang.reflect.Type)((Object)Constructor.class))) {
                        return ForInstrumentedMethod.CONSTRUCTOR;
                    }
                    if (JavaType.EXECUTABLE.getTypeStub().equals(target.getType().asErasure())) {
                        return ForInstrumentedMethod.EXECUTABLE;
                    }
                    if (target.getType().asErasure().isAssignableFrom(String.class)) {
                        return ForOrigin.parse(annotation.loadSilent().value());
                    }
                    throw new IllegalStateException("Non-supported type " + target.getType() + " for @Origin annotation");
                }
            }

            public static interface Renderer {
                public String apply(TypeDescription var1, MethodDescription var2);

                public static class ForConstantValue
                implements Renderer {
                    private final String value;

                    public ForConstantValue(String value) {
                        this.value = value;
                    }

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return this.value;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForConstantValue)) {
                            return false;
                        }
                        ForConstantValue other = (ForConstantValue)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$value = this.value;
                        String other$value = other.value;
                        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForConstantValue;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $value = this.value;
                        result = result * 59 + ($value == null ? 43 : $value.hashCode());
                        return result;
                    }
                }

                public static enum ForDescriptor implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'd';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getDescriptor();
                    }
                }

                public static enum ForJavaSignature implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 's';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        StringBuilder stringBuilder = new StringBuilder("(");
                        boolean comma = false;
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            if (comma) {
                                stringBuilder.append(',');
                            } else {
                                comma = true;
                            }
                            stringBuilder.append(typeDescription.getName());
                        }
                        return stringBuilder.append(')').toString();
                    }
                }

                public static enum ForMethodName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'm';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getInternalName();
                    }
                }

                public static enum ForReturnTypeName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'r';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getReturnType().asErasure().getName();
                    }
                }

                public static enum ForStringRepresentation implements Renderer
                {
                    INSTANCE;


                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.toString();
                    }
                }

                public static enum ForTypeName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 't';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedType.getName();
                    }
                }
            }
        }

        public static class ForReturnValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForReturnValue(TypeDescription.Generic target, Return annotation) {
                this(target, annotation.readOnly(), annotation.typing());
            }

            public ForReturnValue(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                int offset = instrumentedMethod.getStackSize() + context.getPadding();
                StackManipulation readAssignment = assigner.assign(instrumentedMethod.getReturnType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedMethod.getReturnType() + " to " + this.target);
                }
                if (this.readOnly) {
                    return instrumentedMethod.getReturnType().represents(Void.TYPE) ? new Target.ForDefaultValue.ReadOnly(this.target) : new Target.ForVariable.ReadOnly(instrumentedMethod.getReturnType(), offset, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, instrumentedMethod.getReturnType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedMethod.getReturnType());
                }
                return instrumentedMethod.getReturnType().represents(Void.TYPE) ? new Target.ForDefaultValue.ReadWrite(this.target) : new Target.ForVariable.ReadWrite(instrumentedMethod.getReturnType(), offset, readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForReturnValue)) {
                    return false;
                }
                ForReturnValue other = (ForReturnValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForReturnValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Return>
            {
                INSTANCE;


                @Override
                public Class<Return> getAnnotationType() {
                    return Return.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Return> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot write return value for " + target + " in read-only context");
                    }
                    return new ForReturnValue(target.getType(), annotation.loadSilent());
                }
            }
        }

        public static class ForSerializedValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription typeDescription;
            private final StackManipulation deserialization;

            public ForSerializedValue(TypeDescription.Generic target, TypeDescription typeDescription, StackManipulation deserialization) {
                this.target = target;
                this.typeDescription = typeDescription;
                this.deserialization = deserialization;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                StackManipulation assignment = assigner.assign(this.typeDescription.asGenericType(), this.target, Assigner.Typing.DYNAMIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + this.target);
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(this.deserialization, assignment));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForSerializedValue)) {
                    return false;
                }
                ForSerializedValue other = (ForSerializedValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                    return false;
                }
                StackManipulation this$deserialization = this.deserialization;
                StackManipulation other$deserialization = other.deserialization;
                return !(this$deserialization == null ? other$deserialization != null : !this$deserialization.equals(other$deserialization));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForSerializedValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                StackManipulation $deserialization = this.deserialization;
                result = result * 59 + ($deserialization == null ? 43 : $deserialization.hashCode());
                return result;
            }

            public static class Factory<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final TypeDescription typeDescription;
                private final StackManipulation deserialization;

                protected Factory(Class<T> annotationType, TypeDescription typeDescription, StackManipulation deserialization) {
                    this.annotationType = annotationType;
                    this.typeDescription = typeDescription;
                    this.deserialization = deserialization;
                }

                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, Serializable target, Class<?> targetType) {
                    if (!targetType.isInstance(target)) {
                        throw new IllegalArgumentException(target + " is no instance of " + targetType);
                    }
                    return new Factory<S>(annotationType, new TypeDescription.ForLoadedType(targetType), SerializedConstant.of(target));
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    return new ForSerializedValue(target.getType(), this.typeDescription, this.deserialization);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                        return false;
                    }
                    StackManipulation this$deserialization = this.deserialization;
                    StackManipulation other$deserialization = other.deserialization;
                    return !(this$deserialization == null ? other$deserialization != null : !this$deserialization.equals(other$deserialization));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    StackManipulation $deserialization = this.deserialization;
                    result = result * 59 + ($deserialization == null ? 43 : $deserialization.hashCode());
                    return result;
                }
            }
        }

        public static class ForStackManipulation
        implements OffsetMapping {
            private final StackManipulation stackManipulation;
            private final TypeDescription.Generic typeDescription;
            private final TypeDescription.Generic targetType;
            private final Assigner.Typing typing;

            public ForStackManipulation(StackManipulation stackManipulation, TypeDescription.Generic typeDescription, TypeDescription.Generic targetType, Assigner.Typing typing) {
                this.stackManipulation = stackManipulation;
                this.typeDescription = typeDescription;
                this.targetType = targetType;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                StackManipulation assigment = assigner.assign(this.typeDescription, this.targetType, this.typing);
                if (!assigment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + this.targetType);
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(this.stackManipulation, assigment));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForStackManipulation)) {
                    return false;
                }
                ForStackManipulation other = (ForStackManipulation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StackManipulation this$stackManipulation = this.stackManipulation;
                StackManipulation other$stackManipulation = other.stackManipulation;
                if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                    return false;
                }
                TypeDescription.Generic this$typeDescription = this.typeDescription;
                TypeDescription.Generic other$typeDescription = other.typeDescription;
                if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                    return false;
                }
                TypeDescription.Generic this$targetType = this.targetType;
                TypeDescription.Generic other$targetType = other.targetType;
                if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForStackManipulation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StackManipulation $stackManipulation = this.stackManipulation;
                result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                TypeDescription.Generic $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                TypeDescription.Generic $targetType = this.targetType;
                result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            public static class Factory<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final StackManipulation stackManipulation;
                private final TypeDescription.Generic typeDescription;

                public Factory(Class<T> annotationType, TypeDescription typeDescription) {
                    this(annotationType, ClassConstant.of(typeDescription), TypeDescription.CLASS.asGenericType());
                }

                public Factory(Class<T> annotationType, EnumerationDescription enumerationDescription) {
                    this(annotationType, FieldAccess.forEnumeration(enumerationDescription), enumerationDescription.getEnumerationType().asGenericType());
                }

                public Factory(Class<T> annotationType, StackManipulation stackManipulation, TypeDescription.Generic typeDescription) {
                    this.annotationType = annotationType;
                    this.stackManipulation = stackManipulation;
                    this.typeDescription = typeDescription;
                }

                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, Object value) {
                    TypeDescription typeDescription;
                    StackManipulation stackManipulation;
                    if (value == null) {
                        return new OfDefaultValue<S>(annotationType);
                    }
                    if (value instanceof Boolean) {
                        stackManipulation = IntegerConstant.forValue((Boolean)value);
                        typeDescription = new TypeDescription.ForLoadedType(Boolean.TYPE);
                    } else if (value instanceof Byte) {
                        stackManipulation = IntegerConstant.forValue(((Byte)value).byteValue());
                        typeDescription = new TypeDescription.ForLoadedType(Byte.TYPE);
                    } else if (value instanceof Short) {
                        stackManipulation = IntegerConstant.forValue(((Short)value).shortValue());
                        typeDescription = new TypeDescription.ForLoadedType(Short.TYPE);
                    } else if (value instanceof Character) {
                        stackManipulation = IntegerConstant.forValue(((Character)value).charValue());
                        typeDescription = new TypeDescription.ForLoadedType(Character.TYPE);
                    } else if (value instanceof Integer) {
                        stackManipulation = IntegerConstant.forValue((Integer)value);
                        typeDescription = new TypeDescription.ForLoadedType(Integer.TYPE);
                    } else if (value instanceof Long) {
                        stackManipulation = LongConstant.forValue((Long)value);
                        typeDescription = new TypeDescription.ForLoadedType(Long.TYPE);
                    } else if (value instanceof Float) {
                        stackManipulation = FloatConstant.forValue(((Float)value).floatValue());
                        typeDescription = new TypeDescription.ForLoadedType(Float.TYPE);
                    } else if (value instanceof Double) {
                        stackManipulation = DoubleConstant.forValue((Double)value);
                        typeDescription = new TypeDescription.ForLoadedType(Double.TYPE);
                    } else if (value instanceof String) {
                        stackManipulation = new TextConstant((String)value);
                        typeDescription = TypeDescription.STRING;
                    } else {
                        throw new IllegalStateException("Not a constant value: " + value);
                    }
                    return new Factory<S>(annotationType, stackManipulation, typeDescription.asGenericType());
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    return new ForStackManipulation(this.stackManipulation, this.typeDescription, target.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    StackManipulation this$stackManipulation = this.stackManipulation;
                    StackManipulation other$stackManipulation = other.stackManipulation;
                    if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                        return false;
                    }
                    TypeDescription.Generic this$typeDescription = this.typeDescription;
                    TypeDescription.Generic other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    StackManipulation $stackManipulation = this.stackManipulation;
                    result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                    TypeDescription.Generic $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }

            public static class OfAnnotationProperty<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final MethodDescription.InDefinedShape property;

                protected OfAnnotationProperty(Class<T> annotationType, MethodDescription.InDefinedShape property) {
                    this.annotationType = annotationType;
                    this.property = property;
                }

                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, String property) {
                    if (!annotationType.isAnnotation()) {
                        throw new IllegalArgumentException("Not an annotation type: " + annotationType);
                    }
                    try {
                        return new OfAnnotationProperty<S>(annotationType, new MethodDescription.ForLoadedMethod(annotationType.getMethod(property, new Class[0])));
                    }
                    catch (NoSuchMethodException exception) {
                        throw new IllegalArgumentException("Cannot find a property " + property + " on " + annotationType, exception);
                    }
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> factory;
                    Object value = annotation.getValue(this.property).resolve();
                    if (value instanceof TypeDescription) {
                        factory = new Factory<T>(this.annotationType, (TypeDescription)value);
                    } else if (value instanceof EnumerationDescription) {
                        factory = new Factory<T>(this.annotationType, (EnumerationDescription)value);
                    } else {
                        if (value instanceof AnnotationDescription) {
                            throw new IllegalStateException("Cannot bind annotation as fixed value for " + this.property);
                        }
                        factory = Factory.of(this.annotationType, value);
                    }
                    return factory.make(target, annotation, adviceType);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfAnnotationProperty)) {
                        return false;
                    }
                    OfAnnotationProperty other = (OfAnnotationProperty)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    MethodDescription.InDefinedShape this$property = this.property;
                    MethodDescription.InDefinedShape other$property = other.property;
                    return !(this$property == null ? other$property != null : !this$property.equals(other$property));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfAnnotationProperty;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    MethodDescription.InDefinedShape $property = this.property;
                    result = result * 59 + ($property == null ? 43 : $property.hashCode());
                    return result;
                }
            }

            public static class OfDefaultValue<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;

                public OfDefaultValue(Class<T> annotationType) {
                    this.annotationType = annotationType;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    return new ForStackManipulation(DefaultValue.of(target.getType()), target.getType(), target.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfDefaultValue)) {
                        return false;
                    }
                    OfDefaultValue other = (OfDefaultValue)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfDefaultValue;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    return result;
                }
            }
        }

        public static enum ForStubValue implements OffsetMapping,
        Factory<StubValue>
        {
            INSTANCE;


            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                return new Target.ForDefaultValue.ReadOnly(instrumentedMethod.getReturnType(), assigner.assign(instrumentedMethod.getReturnType(), TypeDescription.Generic.OBJECT, Assigner.Typing.DYNAMIC));
            }

            @Override
            public Class<StubValue> getAnnotationType() {
                return StubValue.class;
            }

            @Override
            public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<StubValue> annotation, Factory.AdviceType adviceType) {
                if (!target.getType().represents((java.lang.reflect.Type)((Object)Object.class))) {
                    throw new IllegalStateException("Cannot use StubValue on non-Object parameter type " + target);
                }
                return this;
            }
        }

        public static class ForThisReference
        implements OffsetMapping {
            private static final int THIS_REFERENCE = 0;
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;
            private final boolean optional;

            protected ForThisReference(TypeDescription.Generic target, This annotation) {
                this(target, annotation.readOnly(), annotation.typing(), annotation.optional());
            }

            public ForThisReference(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, boolean optional) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
                this.optional = optional;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                if (instrumentedMethod.isStatic() || !context.isInitialized()) {
                    if (this.optional) {
                        return this.readOnly ? new Target.ForDefaultValue.ReadOnly(instrumentedType) : new Target.ForDefaultValue.ReadWrite(instrumentedType);
                    }
                    throw new IllegalStateException("Cannot map this reference for static method or constructor start: " + instrumentedMethod);
                }
                StackManipulation readAssignment = assigner.assign(instrumentedType.asGenericType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(instrumentedType.asGenericType(), 0, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, instrumentedType.asGenericType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedType);
                }
                return new Target.ForVariable.ReadWrite(instrumentedType.asGenericType(), 0, readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForThisReference)) {
                    return false;
                }
                ForThisReference other = (ForThisReference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                if (this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing)) {
                    return false;
                }
                return this.optional == other.optional;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForThisReference;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                result = result * 59 + (this.optional ? 79 : 97);
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<This>
            {
                INSTANCE;


                @Override
                public Class<This> getAnnotationType() {
                    return This.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<This> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot write to this reference for " + target + " in read-only context");
                    }
                    return new ForThisReference(target.getType(), annotation.loadSilent());
                }
            }
        }

        public static class ForThrowable
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForThrowable(TypeDescription.Generic target, Thrown annotation) {
                this(target, annotation.readOnly(), annotation.typing());
            }

            public ForThrowable(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                int offset = instrumentedMethod.getStackSize() + context.getPadding() + instrumentedMethod.getReturnType().getStackSize().getSize();
                StackManipulation readAssignment = assigner.assign(TypeDescription.THROWABLE.asGenericType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign Throwable to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(TypeDescription.THROWABLE, offset, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, TypeDescription.THROWABLE.asGenericType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to Throwable");
                }
                return new Target.ForVariable.ReadWrite(TypeDescription.THROWABLE, offset, readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForThrowable)) {
                    return false;
                }
                ForThrowable other = (ForThrowable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForThrowable;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Thrown>
            {
                INSTANCE;


                protected static net.bytebuddy.asm.Advice$OffsetMapping$Factory<?> of(MethodDescription.InDefinedShape adviceMethod) {
                    return adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class).represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new Factory.Illegal<Thrown>(Thrown.class) : INSTANCE;
                }

                @Override
                public Class<Thrown> getAnnotationType() {
                    return Thrown.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Thrown> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForThrowable(target.getType(), annotation.loadSilent());
                }
            }
        }

        public static class ForUnusedValue
        implements OffsetMapping {
            private final TypeDefinition target;

            public ForUnusedValue(TypeDefinition target) {
                this.target = target;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                return new Target.ForDefaultValue.ReadWrite(this.target);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForUnusedValue)) {
                    return false;
                }
                ForUnusedValue other = (ForUnusedValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDefinition this$target = this.target;
                TypeDefinition other$target = other.target;
                return !(this$target == null ? other$target != null : !this$target.equals(other$target));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForUnusedValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDefinition $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Unused>
            {
                INSTANCE;


                @Override
                public Class<Unused> getAnnotationType() {
                    return Unused.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Unused> annotation, Factory.AdviceType adviceType) {
                    return new ForUnusedValue(target.getType());
                }
            }
        }

        public static interface Target {
            public StackManipulation resolveRead();

            public StackManipulation resolveWrite();

            public StackManipulation resolveIncrement(int var1);

            public static abstract class AbstractReadOnlyAdapter
            implements Target {
                @Override
                public StackManipulation resolveWrite() {
                    throw new IllegalStateException("Cannot write to read-only value");
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot write to read-only value");
                }
            }

            public static abstract class ForArray
            implements Target {
                protected final TypeDescription.Generic target;
                protected final List<? extends StackManipulation> valueReads;

                protected ForArray(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                    this.target = target;
                    this.valueReads = valueReads;
                }

                @Override
                public StackManipulation resolveRead() {
                    return ArrayFactory.forType(this.target).withValues(this.valueReads);
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot increment read-only array value");
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForArray)) {
                        return false;
                    }
                    ForArray other = (ForArray)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription.Generic this$target = this.target;
                    TypeDescription.Generic other$target = other.target;
                    if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                        return false;
                    }
                    List<? extends StackManipulation> this$valueReads = this.valueReads;
                    List<? extends StackManipulation> other$valueReads = other.valueReads;
                    return !(this$valueReads == null ? other$valueReads != null : !((Object)this$valueReads).equals(other$valueReads));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForArray;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription.Generic $target = this.target;
                    result = result * 59 + ($target == null ? 43 : $target.hashCode());
                    List<? extends StackManipulation> $valueReads = this.valueReads;
                    result = result * 59 + ($valueReads == null ? 43 : ((Object)$valueReads).hashCode());
                    return result;
                }

                public static class ReadOnly
                extends ForArray {
                    public ReadOnly(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                        super(target, valueReads);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only array value");
                    }
                }

                public static class ReadWrite
                extends ForArray {
                    private final List<? extends StackManipulation> valueWrites;

                    public ReadWrite(TypeDescription.Generic target, List<? extends StackManipulation> valueReads, List<? extends StackManipulation> valueWrites) {
                        super(target, valueReads);
                        this.valueWrites = valueWrites;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return ArrayAccess.of(this.target).forEach(this.valueWrites);
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ReadWrite)) {
                            return false;
                        }
                        ReadWrite other = (ReadWrite)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        List<? extends StackManipulation> this$valueWrites = this.valueWrites;
                        List<? extends StackManipulation> other$valueWrites = other.valueWrites;
                        return !(this$valueWrites == null ? other$valueWrites != null : !((Object)this$valueWrites).equals(other$valueWrites));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ReadWrite;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        List<? extends StackManipulation> $valueWrites = this.valueWrites;
                        result = result * 59 + ($valueWrites == null ? 43 : ((Object)$valueWrites).hashCode());
                        return result;
                    }
                }
            }

            public static abstract class ForDefaultValue
            implements Target {
                protected final TypeDefinition typeDefinition;
                protected final StackManipulation readAssignment;

                protected ForDefaultValue(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                    this.typeDefinition = typeDefinition;
                    this.readAssignment = readAssignment;
                }

                @Override
                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(DefaultValue.of(this.typeDefinition), this.readAssignment);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForDefaultValue)) {
                        return false;
                    }
                    ForDefaultValue other = (ForDefaultValue)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDefinition this$typeDefinition = this.typeDefinition;
                    TypeDefinition other$typeDefinition = other.typeDefinition;
                    if (this$typeDefinition == null ? other$typeDefinition != null : !this$typeDefinition.equals(other$typeDefinition)) {
                        return false;
                    }
                    StackManipulation this$readAssignment = this.readAssignment;
                    StackManipulation other$readAssignment = other.readAssignment;
                    return !(this$readAssignment == null ? other$readAssignment != null : !this$readAssignment.equals(other$readAssignment));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForDefaultValue;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDefinition $typeDefinition = this.typeDefinition;
                    result = result * 59 + ($typeDefinition == null ? 43 : $typeDefinition.hashCode());
                    StackManipulation $readAssignment = this.readAssignment;
                    result = result * 59 + ($readAssignment == null ? 43 : $readAssignment.hashCode());
                    return result;
                }

                public static class ReadOnly
                extends ForDefaultValue {
                    public ReadOnly(TypeDefinition typeDefinition) {
                        this(typeDefinition, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        super(typeDefinition, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only default value");
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only default value");
                    }
                }

                public static class ReadWrite
                extends ForDefaultValue {
                    public ReadWrite(TypeDefinition typeDefinition) {
                        this(typeDefinition, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        super(typeDefinition, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return Removal.of(this.typeDefinition);
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        return StackManipulation.Trivial.INSTANCE;
                    }
                }
            }

            public static abstract class ForField
            implements Target {
                protected final FieldDescription fieldDescription;
                protected final StackManipulation readAssignment;

                protected ForField(FieldDescription fieldDescription, StackManipulation readAssignment) {
                    this.fieldDescription = fieldDescription;
                    this.readAssignment = readAssignment;
                }

                @Override
                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), this.readAssignment);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForField)) {
                        return false;
                    }
                    ForField other = (ForField)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    FieldDescription this$fieldDescription = this.fieldDescription;
                    FieldDescription other$fieldDescription = other.fieldDescription;
                    if (this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription)) {
                        return false;
                    }
                    StackManipulation this$readAssignment = this.readAssignment;
                    StackManipulation other$readAssignment = other.readAssignment;
                    return !(this$readAssignment == null ? other$readAssignment != null : !this$readAssignment.equals(other$readAssignment));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForField;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    FieldDescription $fieldDescription = this.fieldDescription;
                    result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                    StackManipulation $readAssignment = this.readAssignment;
                    result = result * 59 + ($readAssignment == null ? 43 : $readAssignment.hashCode());
                    return result;
                }

                public static class ReadOnly
                extends ForField {
                    public ReadOnly(FieldDescription fieldDescription) {
                        this(fieldDescription, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(FieldDescription fieldDescription, StackManipulation readAssignment) {
                        super(fieldDescription, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only field value");
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only field value");
                    }
                }

                public static class ReadWrite
                extends ForField {
                    private final StackManipulation writeAssignment;

                    public ReadWrite(FieldDescription fieldDescription) {
                        this(fieldDescription, StackManipulation.Trivial.INSTANCE, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(FieldDescription fieldDescription, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        super(fieldDescription, readAssignment);
                        this.writeAssignment = writeAssignment;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        StackManipulation preparation = this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.loadThis(), Duplication.SINGLE.flipOver(this.fieldDescription.getType()), Removal.SINGLE);
                        return new StackManipulation.Compound(this.writeAssignment, preparation, FieldAccess.forField(this.fieldDescription).write());
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        return new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(value), Addition.INTEGER, this.resolveWrite());
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ReadWrite)) {
                            return false;
                        }
                        ReadWrite other = (ReadWrite)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        StackManipulation this$writeAssignment = this.writeAssignment;
                        StackManipulation other$writeAssignment = other.writeAssignment;
                        return !(this$writeAssignment == null ? other$writeAssignment != null : !this$writeAssignment.equals(other$writeAssignment));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ReadWrite;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        StackManipulation $writeAssignment = this.writeAssignment;
                        result = result * 59 + ($writeAssignment == null ? 43 : $writeAssignment.hashCode());
                        return result;
                    }
                }
            }

            public static class ForStackManipulation
            implements Target {
                private final StackManipulation stackManipulation;

                public ForStackManipulation(StackManipulation stackManipulation) {
                    this.stackManipulation = stackManipulation;
                }

                public static Target of(MethodDescription.InDefinedShape methodDescription) {
                    return new ForStackManipulation(MethodConstant.forMethod(methodDescription));
                }

                public static Target of(TypeDescription typeDescription) {
                    return new ForStackManipulation(ClassConstant.of(typeDescription));
                }

                public static Target of(Object value) {
                    if (value == null) {
                        return new ForStackManipulation(NullConstant.INSTANCE);
                    }
                    if (value instanceof Boolean) {
                        return new ForStackManipulation(IntegerConstant.forValue((Boolean)value));
                    }
                    if (value instanceof Byte) {
                        return new ForStackManipulation(IntegerConstant.forValue(((Byte)value).byteValue()));
                    }
                    if (value instanceof Short) {
                        return new ForStackManipulation(IntegerConstant.forValue(((Short)value).shortValue()));
                    }
                    if (value instanceof Character) {
                        return new ForStackManipulation(IntegerConstant.forValue(((Character)value).charValue()));
                    }
                    if (value instanceof Integer) {
                        return new ForStackManipulation(IntegerConstant.forValue((Integer)value));
                    }
                    if (value instanceof Long) {
                        return new ForStackManipulation(LongConstant.forValue((Long)value));
                    }
                    if (value instanceof Float) {
                        return new ForStackManipulation(FloatConstant.forValue(((Float)value).floatValue()));
                    }
                    if (value instanceof Double) {
                        return new ForStackManipulation(DoubleConstant.forValue((Double)value));
                    }
                    if (value instanceof String) {
                        return new ForStackManipulation(new TextConstant((String)value));
                    }
                    throw new IllegalArgumentException("Not a constant value: " + value);
                }

                @Override
                public StackManipulation resolveRead() {
                    return this.stackManipulation;
                }

                @Override
                public StackManipulation resolveWrite() {
                    throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForStackManipulation)) {
                        return false;
                    }
                    ForStackManipulation other = (ForStackManipulation)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    StackManipulation this$stackManipulation = this.stackManipulation;
                    StackManipulation other$stackManipulation = other.stackManipulation;
                    return !(this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForStackManipulation;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    StackManipulation $stackManipulation = this.stackManipulation;
                    result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                    return result;
                }
            }

            public static abstract class ForVariable
            implements Target {
                protected final TypeDefinition typeDefinition;
                protected final int offset;
                protected final StackManipulation readAssignment;

                protected ForVariable(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                    this.typeDefinition = typeDefinition;
                    this.offset = offset;
                    this.readAssignment = readAssignment;
                }

                @Override
                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(MethodVariableAccess.of(this.typeDefinition).loadFrom(this.offset), this.readAssignment);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForVariable)) {
                        return false;
                    }
                    ForVariable other = (ForVariable)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDefinition this$typeDefinition = this.typeDefinition;
                    TypeDefinition other$typeDefinition = other.typeDefinition;
                    if (this$typeDefinition == null ? other$typeDefinition != null : !this$typeDefinition.equals(other$typeDefinition)) {
                        return false;
                    }
                    if (this.offset != other.offset) {
                        return false;
                    }
                    StackManipulation this$readAssignment = this.readAssignment;
                    StackManipulation other$readAssignment = other.readAssignment;
                    return !(this$readAssignment == null ? other$readAssignment != null : !this$readAssignment.equals(other$readAssignment));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForVariable;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDefinition $typeDefinition = this.typeDefinition;
                    result = result * 59 + ($typeDefinition == null ? 43 : $typeDefinition.hashCode());
                    result = result * 59 + this.offset;
                    StackManipulation $readAssignment = this.readAssignment;
                    result = result * 59 + ($readAssignment == null ? 43 : $readAssignment.hashCode());
                    return result;
                }

                public static class ReadOnly
                extends ForVariable {
                    public ReadOnly(ParameterDescription parameterDescription) {
                        this(parameterDescription, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(ParameterDescription parameterDescription, StackManipulation readAssignment) {
                        this(parameterDescription.getType(), parameterDescription.getOffset(), readAssignment);
                    }

                    public ReadOnly(TypeDefinition typeDefinition, int offset) {
                        this(typeDefinition, offset, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                        super(typeDefinition, offset, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only parameter " + this.typeDefinition + " at " + this.offset);
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only variable " + this.typeDefinition + " at " + this.offset);
                    }
                }

                public static class ReadWrite
                extends ForVariable {
                    private final StackManipulation writeAssignment;

                    public ReadWrite(ParameterDescription parameterDescription) {
                        this(parameterDescription, StackManipulation.Trivial.INSTANCE, (StackManipulation)StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(ParameterDescription parameterDescription, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        this(parameterDescription.getType(), parameterDescription.getOffset(), readAssignment, writeAssignment);
                    }

                    public ReadWrite(TypeDefinition typeDefinition, int offset) {
                        this(typeDefinition, offset, StackManipulation.Trivial.INSTANCE, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        super(typeDefinition, offset, readAssignment);
                        this.writeAssignment = writeAssignment;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return new StackManipulation.Compound(this.writeAssignment, MethodVariableAccess.of(this.typeDefinition).storeAt(this.offset));
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        return this.typeDefinition.represents(Integer.TYPE) ? MethodVariableAccess.of(this.typeDefinition).increment(this.offset, value) : new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(1), Addition.INTEGER, this.resolveWrite());
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ReadWrite)) {
                            return false;
                        }
                        ReadWrite other = (ReadWrite)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        StackManipulation this$writeAssignment = this.writeAssignment;
                        StackManipulation other$writeAssignment = other.writeAssignment;
                        return !(this$writeAssignment == null ? other$writeAssignment != null : !this$writeAssignment.equals(other$writeAssignment));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ReadWrite;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        StackManipulation $writeAssignment = this.writeAssignment;
                        result = result * 59 + ($writeAssignment == null ? 43 : $writeAssignment.hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static final class OnDefaultValue {
        private OnDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodEnter {
        public Class<?> skipOn() default void.class;

        public boolean prependLineNumber() default true;

        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodExit {
        public Class<? extends Throwable> onThrowable() default NoExceptionHandler.class;

        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;
    }

    public static final class OnNonDefaultValue {
        private OnNonDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Origin {
        public static final String DEFAULT = "";

        public String value() default "";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Return {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    protected static interface StackMapFrameHandler {
        public void translateFrame(MethodVisitor var1, int var2, int var3, Object[] var4, int var5, Object[] var6);

        public void injectReturnFrame(MethodVisitor var1);

        public void injectExceptionFrame(MethodVisitor var1);

        public void injectCompletionFrame(MethodVisitor var1, boolean var2);

        public static class Default
        implements ForInstrumentedMethod {
            private static final Object[] EMPTY = new Object[0];
            private final TypeDescription instrumentedType;
            protected final MethodDescription instrumentedMethod;
            protected final TypeList requiredTypes;
            protected final TypeList yieldedTypes;
            private final boolean expandFrames;
            private int currentFrameDivergence;

            protected Default(TypeDescription instrumentedType, MethodDescription instrumentedMethod, TypeList requiredTypes, TypeList yieldedTypes, boolean expandFrames) {
                this.instrumentedType = instrumentedType;
                this.instrumentedMethod = instrumentedMethod;
                this.requiredTypes = requiredTypes;
                this.yieldedTypes = yieldedTypes;
                this.expandFrames = expandFrames;
            }

            protected static ForInstrumentedMethod of(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> requiredTypes, List<? extends TypeDescription> yieldedTypes, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                return (writerFlags & 2) != 0 || classFileVersion.isLessThan(ClassFileVersion.JAVA_V6) ? NoOp.INSTANCE : new Default(instrumentedType, instrumentedMethod, new TypeList.Explicit(requiredTypes), new TypeList.Explicit(yieldedTypes), (readerFlags & 8) != 0);
            }

            protected static Object toFrame(TypeDescription typeDescription) {
                if (typeDescription.represents(Boolean.TYPE) || typeDescription.represents(Byte.TYPE) || typeDescription.represents(Short.TYPE) || typeDescription.represents(Character.TYPE) || typeDescription.represents(Integer.TYPE)) {
                    return Opcodes.INTEGER;
                }
                if (typeDescription.represents(Long.TYPE)) {
                    return Opcodes.LONG;
                }
                if (typeDescription.represents(Float.TYPE)) {
                    return Opcodes.FLOAT;
                }
                if (typeDescription.represents(Double.TYPE)) {
                    return Opcodes.DOUBLE;
                }
                return typeDescription.getInternalName();
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, new TypeList.Empty(), this.requiredTypes, TranslationMode.ENTRY);
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, new TypeList.Explicit(CompoundList.of(this.requiredTypes, this.yieldedTypes)), new TypeList.Empty(), TranslationMode.EXIT);
            }

            @Override
            public int getReaderHint() {
                return this.expandFrames ? 8 : 0;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                this.translateFrame(methodVisitor, TranslationMode.COPY, this.instrumentedMethod, this.requiredTypes, type, localVariableLength, localVariable, stackSize, stack);
            }

            protected void translateFrame(MethodVisitor methodVisitor, TranslationMode translationMode, MethodDescription methodDescription, TypeList additionalTypes, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                switch (type) {
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        this.currentFrameDivergence += localVariableLength;
                        break;
                    }
                    case 2: {
                        this.currentFrameDivergence -= localVariableLength;
                        break;
                    }
                    case -1: 
                    case 0: {
                        int offset;
                        if (methodDescription.getParameters().size() + (methodDescription.isStatic() ? 0 : 1) > localVariableLength) {
                            throw new IllegalStateException("Inconsistent frame length for " + methodDescription + ": " + localVariableLength);
                        }
                        if (methodDescription.isStatic()) {
                            offset = 0;
                        } else {
                            if (!translationMode.isPossibleThisFrameValue(this.instrumentedType, this.instrumentedMethod, localVariable[0])) {
                                throw new IllegalStateException(methodDescription + " is inconsistent for 'this' reference: " + localVariable[0]);
                            }
                            offset = 1;
                        }
                        for (int index = 0; index < methodDescription.getParameters().size(); ++index) {
                            if (Default.toFrame(((ParameterDescription)methodDescription.getParameters().get(index)).getType().asErasure()).equals(localVariable[index + offset])) continue;
                            throw new IllegalStateException(methodDescription + " is inconsistent at " + index + ": " + localVariable[index + offset]);
                        }
                        Object[] translated = new Object[localVariableLength - methodDescription.getParameters().size() - (methodDescription.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + additionalTypes.size()];
                        int index = translationMode.copy(this.instrumentedType, this.instrumentedMethod, methodDescription, localVariable, translated);
                        for (TypeDescription typeDescription : additionalTypes) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        System.arraycopy(localVariable, methodDescription.getParameters().size() + (methodDescription.isStatic() ? 0 : 1), translated, index, translated.length - index);
                        localVariableLength = translated.length;
                        localVariable = translated;
                        this.currentFrameDivergence = translated.length - index;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected frame type: " + type);
                    }
                }
                methodVisitor.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
                if (!this.expandFrames && this.currentFrameDivergence == 0 && !this.instrumentedMethod.isConstructor()) {
                    if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                    } else {
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Default.toFrame(this.instrumentedMethod.getReturnType().asErasure())});
                    }
                } else {
                    this.injectFullFrame(methodVisitor, this.requiredTypes, this.instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.instrumentedMethod.getReturnType().asErasure()));
                }
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
                if (!this.expandFrames && this.currentFrameDivergence == 0) {
                    methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                } else {
                    this.injectFullFrame(methodVisitor, this.requiredTypes, Collections.singletonList(TypeDescription.THROWABLE));
                }
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                if (!(this.expandFrames || this.currentFrameDivergence != 0 || !secondary && this.instrumentedMethod.isConstructor())) {
                    if (secondary) {
                        methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                    } else {
                        Object[] local = new Object[this.yieldedTypes.size()];
                        int index = 0;
                        for (TypeDescription typeDescription : this.yieldedTypes) {
                            local[index++] = Default.toFrame(typeDescription);
                        }
                        methodVisitor.visitFrame(1, local.length, local, EMPTY.length, EMPTY);
                    }
                } else {
                    this.injectFullFrame(methodVisitor, CompoundList.of(this.requiredTypes, this.yieldedTypes), Collections.emptyList());
                }
            }

            protected void injectFullFrame(MethodVisitor methodVisitor, List<? extends TypeDescription> typesInArray, List<? extends TypeDescription> typesOnStack) {
                Object[] localVariable = new Object[this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + typesInArray.size()];
                int index = 0;
                if (!this.instrumentedMethod.isStatic()) {
                    localVariable[index++] = Default.toFrame(this.instrumentedType);
                }
                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                for (TypeDescription typeDescription : typesInArray) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                index = 0;
                Object[] stackType = new Object[typesOnStack.size()];
                for (TypeDescription typeDescription : typesOnStack) {
                    stackType[index++] = Default.toFrame(typeDescription);
                }
                methodVisitor.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, localVariable, stackType.length, stackType);
                this.currentFrameDivergence = 0;
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final TypeList requiredTypes;
                private final TypeList yieldedTypes;
                protected final TranslationMode translationMode;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, TypeList requiredTypes, TypeList yieldedTypes, TranslationMode translationMode) {
                    this.adviceMethod = adviceMethod;
                    this.requiredTypes = requiredTypes;
                    this.yieldedTypes = yieldedTypes;
                    this.translationMode = translationMode;
                }

                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    Default.this.translateFrame(methodVisitor, this.translationMode, this.adviceMethod, this.requiredTypes, type, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        if (this.yieldedTypes.isEmpty() || this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        } else {
                            methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Default.toFrame(this.adviceMethod.getReturnType().asErasure())});
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.requiredTypes, this.yieldedTypes.isEmpty() || this.adviceMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.adviceMethod.getReturnType().asErasure()));
                    }
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.requiredTypes, Collections.singletonList(TypeDescription.THROWABLE));
                    }
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0 && this.yieldedTypes.size() < 4) {
                        if (secondary || this.yieldedTypes.isEmpty()) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        } else {
                            Object[] local = new Object[this.yieldedTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.yieldedTypes) {
                                local[index++] = Default.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, local, EMPTY.length, EMPTY);
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, CompoundList.of(this.requiredTypes, this.yieldedTypes), Collections.emptyList());
                    }
                }
            }

            protected static enum TranslationMode {
                COPY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int length = instrumentedMethod.getParameters().size() + (instrumentedMethod.isStatic() ? 0 : 1);
                        System.arraycopy(localVariable, 0, translated, 0, length);
                        return length;
                    }

                    @Override
                    protected boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        return instrumentedMethod.isConstructor() && Opcodes.UNINITIALIZED_THIS.equals(frame) || Default.toFrame(instrumentedType).equals(frame);
                    }
                }
                ,
                ENTRY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS : Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }

                    @Override
                    protected boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        return instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS.equals(frame) : Default.toFrame(instrumentedType).equals(frame);
                    }
                }
                ,
                EXIT{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }

                    @Override
                    protected boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        return Default.toFrame(instrumentedType).equals(frame);
                    }
                };


                protected abstract int copy(TypeDescription var1, MethodDescription var2, MethodDescription var3, Object[] var4, Object[] var5);

                protected abstract boolean isPossibleThisFrameValue(TypeDescription var1, MethodDescription var2, Object var3);
            }
        }

        public static interface ForAdvice
        extends StackMapFrameHandler {
        }

        public static interface ForInstrumentedMethod
        extends StackMapFrameHandler {
            public ForAdvice bindEntry(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1);

            public int getReaderHint();
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public int getReaderHint() {
                return 4;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface StubValue {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface This {
        public boolean optional() default false;

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Thrown {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.DYNAMIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Unused {
    }

    public static class WithCustomMapping {
        private final Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> offsetMappings;

        protected WithCustomMapping() {
            this(Collections.emptyMap());
        }

        protected WithCustomMapping(Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> offsetMappings) {
            this.offsetMappings = offsetMappings;
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Object value) {
            return this.bind(OffsetMapping.ForStackManipulation.Factory.of(type, value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Field field) {
            return this.bind(type, new FieldDescription.ForLoadedField(field));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, FieldDescription fieldDescription) {
            return this.bind(new OffsetMapping.ForField.Resolved.Factory<T>(type, fieldDescription));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Method method, int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (method.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(method + " does not declare a parameter with index " + index);
            }
            return this.bind(type, (ParameterDescription)new MethodDescription.ForLoadedMethod(method).getParameters().get(index));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Constructor<?> constructor, int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (constructor.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(constructor + " does not declare a parameter with index " + index);
            }
            return this.bind(type, (ParameterDescription)new MethodDescription.ForLoadedConstructor(constructor).getParameters().get(index));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, ParameterDescription parameterDescription) {
            return this.bind(new OffsetMapping.ForArgument.Resolved.Factory<T>(type, parameterDescription));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Class<?> value) {
            return this.bind(type, new TypeDescription.ForLoadedType(value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, TypeDescription value) {
            return this.bind(new OffsetMapping.ForStackManipulation.Factory<T>(type, value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Enum<?> value) {
            return this.bind(type, new EnumerationDescription.ForLoadedEnumeration(value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, EnumerationDescription value) {
            return this.bind(new OffsetMapping.ForStackManipulation.Factory<T>(type, value));
        }

        public <T extends Annotation> WithCustomMapping bindSerialized(Class<T> type, Serializable value) {
            return this.bindSerialized(type, value, value.getClass());
        }

        public <T extends Annotation, S extends Serializable> WithCustomMapping bindSerialized(Class<T> type, S value, Class<? super S> targetType) {
            return this.bind(OffsetMapping.ForSerializedValue.Factory.of(type, value, targetType));
        }

        public <T extends Annotation> WithCustomMapping bindProperty(Class<T> type, String property) {
            return this.bind(OffsetMapping.ForStackManipulation.OfAnnotationProperty.of(type, property));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, StackManipulation stackManipulation, java.lang.reflect.Type targetType) {
            return this.bind(type, stackManipulation, TypeDefinition.Sort.describe(targetType));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, StackManipulation stackManipulation, TypeDescription.Generic targetType) {
            return this.bind(new OffsetMapping.ForStackManipulation.Factory<T>(type, stackManipulation, targetType));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, OffsetMapping offsetMapping) {
            return this.bind(new OffsetMapping.Factory.Simple<T>(type, offsetMapping));
        }

        public WithCustomMapping bind(OffsetMapping.Factory<?> offsetMapping) {
            HashMap offsetMappings = new HashMap(this.offsetMappings);
            if (!offsetMapping.getAnnotationType().isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + offsetMapping.getAnnotationType());
            }
            if (offsetMappings.put(offsetMapping.getAnnotationType(), offsetMapping) != null) {
                throw new IllegalArgumentException("Annotation type already mapped: " + offsetMapping.getAnnotationType());
            }
            return new WithCustomMapping(offsetMappings);
        }

        public Advice to(Class<?> advice) {
            return this.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
        }

        public Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
            return this.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
        }

        public Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
            return Advice.to(advice, classFileLocator, new ArrayList(this.offsetMappings.values()));
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
            ClassLoader exitLoader;
            ClassLoader enterLoader = enterAdvice.getClassLoader();
            return this.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
            return this.to(new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
            return this.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
            return Advice.to(enterAdvice, exitAdvice, classFileLocator, new ArrayList(this.offsetMappings.values()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithCustomMapping)) {
                return false;
            }
            WithCustomMapping other = (WithCustomMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Class<Annotation>, OffsetMapping.Factory<?>> this$offsetMappings = this.offsetMappings;
            Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> other$offsetMappings = other.offsetMappings;
            return !(this$offsetMappings == null ? other$offsetMappings != null : !((Object)this$offsetMappings).equals(other$offsetMappings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WithCustomMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<Annotation>, OffsetMapping.Factory<?>> $offsetMappings = this.offsetMappings;
            result = result * 59 + ($offsetMappings == null ? 43 : ((Object)$offsetMappings).hashCode());
            return result;
        }
    }
}

