/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;

public interface AnnotationSource {
    public AnnotationList getDeclaredAnnotations();

    public static enum Empty implements AnnotationSource
    {
        INSTANCE;


        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }
    }

    public static class Explicit
    implements AnnotationSource {
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(AnnotationDescription ... annotation) {
            this(Arrays.asList(annotation));
        }

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Explicit)) {
                return false;
            }
            Explicit other = (Explicit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<? extends AnnotationDescription> this$annotations = this.annotations;
            List<? extends AnnotationDescription> other$annotations = other.annotations;
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Explicit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<? extends AnnotationDescription> $annotations = this.annotations;
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }
    }
}

