/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.wizards.datatransfer;

import java.io.File;
import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ExternalProjectImportWizardDialogTest {
    private static final File RESOURCES_DIR = new File(Activator.getTestResourcesLocation(ExternalProjectImportWizardDialogTest.class), "projectImport");
    private static final String PROJECT_A = "ProjectA";
    private static final String PROJECT_B = "ProjectB";
    private static final String PROJECT_C = "ProjectC";
    private ExternalProjectImportWizardDialog wizard;
    private WizardProjectsImportPage wizardPage;

    @Before
    public void setUp() {
        this.wizard = new ExternalProjectImportWizardDialog();
        this.wizard.open();
        this.wizardPage = new WizardProjectsImportPage((ReferencedComposite)this.wizard);
    }

    @Test
    public void setRootDirectory() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        List projects = this.wizardPage.getProjects();
        this.assertProjects(projects, true, true, true);
    }

    @Test
    public void setArchiveFile() {
        this.wizardPage.setArchiveFile(new File(RESOURCES_DIR, "zip/projectImport.zip").getAbsolutePath());
        List projects = this.wizardPage.getProjects();
        this.assertProjects(projects, true, true, true);
    }

    @Test
    public void copyProjectsIntoWorkspace_directory_true() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        this.wizardPage.copyProjectsIntoWorkspace(true);
    }

    @Test
    public void copyProjectsIntoWorkspace_directory_false() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        this.wizardPage.copyProjectsIntoWorkspace(false);
    }

    @Test(expected=EclipseLayerException.class)
    public void copyProjectsIntoWorkspace_zipFile_true() {
        this.wizardPage.setArchiveFile(new File(RESOURCES_DIR, "zip/projectImport.zip").getAbsolutePath());
        this.wizardPage.copyProjectsIntoWorkspace(false);
    }

    @Test(expected=EclipseLayerException.class)
    public void copyProjectsIntoWorkspace_zipFile_false() {
        this.wizardPage.setArchiveFile(new File(RESOURCES_DIR, "zip/projectImport.zip").getAbsolutePath());
        this.wizardPage.copyProjectsIntoWorkspace(false);
    }

    @Test
    public void selectAllProjects() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        this.wizardPage.deselectAllProjects();
        this.wizardPage.selectAllProjects();
        List projects = this.wizardPage.getProjects();
        this.assertProjects(projects, true, true, true);
    }

    @Test
    public void deselectAllProjects() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        this.wizardPage.deselectAllProjects();
        List projects = this.wizardPage.getProjects();
        this.assertProjects(projects, false, false, false);
    }

    @Test
    public void selectProjects() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        this.wizardPage.selectProjects(new String[]{PROJECT_B, PROJECT_C});
        List projects = this.wizardPage.getProjects();
        this.assertProjects(projects, false, true, true);
    }

    @Test
    public void selectProjects_none() {
        this.wizardPage.setRootDirectory(new File(RESOURCES_DIR, "directory").getAbsolutePath());
        this.wizardPage.selectProjects(new String[0]);
        List projects = this.wizardPage.getProjects();
        this.assertProjects(projects, false, false, false);
    }

    @Test
    public void getProjects_none() {
        List projects = this.wizardPage.getProjects();
        Assert.assertTrue((boolean)projects.isEmpty());
    }

    @After
    public void tearDown() {
        this.wizard.cancel();
    }

    private void assertProjects(List<WizardProjectsImportPage.ImportProject> projects, boolean checkedProjectA, boolean checkedProjectB, boolean checkedProjectC) {
        MatcherAssert.assertThat((Object)projects.size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat(projects, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{new ImportProjectMatcher(checkedProjectA, PROJECT_A), new ImportProjectMatcher(checkedProjectB, PROJECT_B), new ImportProjectMatcher(checkedProjectC, PROJECT_C)}));
    }

    class ImportProjectMatcher
    extends TypeSafeMatcher<WizardProjectsImportPage.ImportProject> {
        private boolean expectedChecked;
        private String expectedName;

        public ImportProjectMatcher(boolean expectedChecked, String expectedName) {
            this.expectedChecked = expectedChecked;
            this.expectedName = expectedName;
        }

        public void describeTo(Description description) {
            description.appendText("ImportProject[" + this.expectedChecked + ", " + this.expectedName + "]");
        }

        public boolean matchesSafely(WizardProjectsImportPage.ImportProject item) {
            return item.isChecked == this.expectedChecked && this.expectedName.equals(item.name);
        }
    }
}

