/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.ProfileMetadataRepository;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Configure;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.engine.phases.Property;
import org.eclipse.equinox.internal.p2.engine.phases.Uninstall;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.LocalTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class P2TargetUtils {
    private static final String SOURCE_IU_ID = "org.eclipse.pde.core.target.source.bundles";
    public static URI AGENT_LOCATION;
    public static final IPath BUNDLE_POOL;
    static final IPath INSTALL_FOLDERS;
    static final String PROFILE_ID_PREFIX = "TARGET_DEFINITION:";
    static final String PROP_INSTALLED_IU = "org.eclipse.pde.core.installed_iu";
    static final String PROP_PROVISION_MODE = "org.eclipse.pde.core.provision_mode";
    static final String PROP_ALL_ENVIRONMENTS = "org.eclipse.pde.core.all_environments";
    static final String PROP_SEQUENCE_NUMBER = "org.eclipse.pde.core.sequence";
    static final String PROP_AUTO_INCLUDE_SOURCE = "org.eclipse.pde.core.autoIncludeSource";
    static final String PROP_INCLUDE_CONFIGURE_PHASE = "org.eclipse.pde.core.includeConfigure";
    private static Map<ITargetDefinition, P2TargetUtils> synchronizers;
    public static Map<ITargetDefinition, IFileArtifactRepository> fgTargetArtifactRepo;
    public static Map<IArtifactKey, Map<IFileArtifactRepository, File>> fgArtifactKeyRepoFile;
    private IProfile fProfile;
    private boolean fIncludeAllRequired = true;
    private boolean fIncludeMultipleEnvironments = false;
    private boolean fIncludeSource = false;
    private boolean fIncludeConfigurePhase = false;
    private static final String NATIVE_ARTIFACTS = "nativeArtifacts";
    private static final String NATIVE_TYPE = "org.eclipse.equinox.p2.native";
    private static final String PARM_OPERAND = "operand";

    static {
        try {
            AGENT_LOCATION = URIUtil.fromString((String)("file:" + PDECore.getDefault().getStateLocation().append(".p2")));
        }
        catch (Exception exception) {}
        BUNDLE_POOL = PDECore.getDefault().getStateLocation().append(".bundle_pool");
        INSTALL_FOLDERS = PDECore.getDefault().getStateLocation().append(".install_folders");
        synchronizers = new HashMap<ITargetDefinition, P2TargetUtils>();
        fgTargetArtifactRepo = new ConcurrentHashMap<ITargetDefinition, IFileArtifactRepository>();
        fgArtifactKeyRepoFile = new ConcurrentHashMap<IArtifactKey, Map<IFileArtifactRepository, File>>();
    }

    public static List<String> cleanOrphanedTargetDefinitionProfiles() throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        IProfileRegistry registry = P2TargetUtils.getProfileRegistry();
        ITargetPlatformService tps = PDECore.getDefault().acquireService(ITargetPlatformService.class);
        if (registry != null && tps != null) {
            IProfile[] profiles;
            IProfile[] iProfileArray = profiles = registry.getProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                String memento;
                ITargetHandle handle;
                IProfile profile = iProfileArray[n2];
                String id = profile.getProfileId();
                if (id.startsWith(PROFILE_ID_PREFIX) && !(handle = tps.getTarget(memento = id.substring(PROFILE_ID_PREFIX.length()))).exists()) {
                    P2TargetUtils.deleteProfile(handle);
                    list.add(id);
                }
                ++n2;
            }
        }
        return list;
    }

    private static void delete(File folder) {
        File[] files;
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                P2TargetUtils.delete(file);
            }
            file.delete();
            ++n2;
        }
        folder.delete();
    }

    public static void deleteProfile(ITargetHandle handle) throws CoreException {
        IProfile profile;
        IProfileRegistry registry = P2TargetUtils.getProfileRegistry();
        if (registry != null && (profile = registry.getProfile(P2TargetUtils.getProfileId(handle))) != null) {
            File folder;
            String location = profile.getProperty("org.eclipse.equinox.p2.installFolder");
            registry.removeProfile(P2TargetUtils.getProfileId(handle));
            if (location != null && location.length() > 0 && (folder = new File(location)).exists()) {
                P2TargetUtils.delete(folder);
            }
        }
    }

    public static void forceCheckTarget(ITargetDefinition target) {
        P2TargetUtils result = P2TargetUtils.getSynchronizer(target);
        if (result != null && result.fProfile != null && result.fProfile instanceof Profile) {
            ((Profile)result.fProfile).setProperty(PROP_SEQUENCE_NUMBER, "-1");
        }
    }

    public static void garbageCollect() {
        try {
            IProfile[] profiles;
            IProfile[] iProfileArray = profiles = P2TargetUtils.getProfileRegistry().getProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                IProfile profile = iProfileArray[n2];
                if (profile.getProfileId().startsWith(PROFILE_ID_PREFIX)) {
                    P2TargetUtils.getGarbageCollector().runGC(profile);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private String generateEnvironmentProperties(ITargetDefinition target) {
        StringBuilder env = new StringBuilder();
        String ws = target.getWS();
        if (ws == null) {
            ws = Platform.getWS();
        }
        env.append("osgi.ws=");
        env.append(ws);
        env.append(",");
        String os = target.getOS();
        if (os == null) {
            os = Platform.getOS();
        }
        env.append("osgi.os=");
        env.append(os);
        env.append(",");
        String arch = target.getArch();
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        env.append("osgi.arch=");
        env.append(arch);
        return env.toString();
    }

    private String generateNLProperty(ITargetDefinition target) {
        String nl = target.getNL();
        if (nl == null) {
            nl = Platform.getNL();
        }
        return nl;
    }

    public static IProvisioningAgent getAgent() throws CoreException {
        String filter = "(locationURI=" + String.valueOf(AGENT_LOCATION) + ")";
        ServiceReference[] serviceReferences = null;
        BundleContext context = PDECore.getDefault().getBundleContext();
        try {
            serviceReferences = context.getServiceReferences(IProvisioningAgent.SERVICE_NAME, filter);
            if (serviceReferences != null) {
                IProvisioningAgent iProvisioningAgent = (IProvisioningAgent)context.getService(serviceReferences[0]);
                return iProvisioningAgent;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
        }
        finally {
            if (serviceReferences != null) {
                context.ungetService(serviceReferences[0]);
            }
        }
        IProvisioningAgentProvider provider = PDECore.getDefault().acquireService(IProvisioningAgentProvider.class);
        try {
            if (provider == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7));
            }
            IProvisioningAgent agent = provider.createAgent(AGENT_LOCATION);
            if (agent == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7));
            }
            GarbageCollector garbageCollector = (GarbageCollector)agent.getService(GarbageCollector.class.getName());
            if (garbageCollector != null) {
                garbageCollector.stop();
            }
            return agent;
        }
        catch (ProvisionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7, (Throwable)e));
        }
    }

    public static IProvisioningAgent getGlobalAgent() throws CoreException {
        IProvisioningAgent agent = PDECore.getDefault().acquireService(IProvisioningAgent.class);
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_11));
        }
        return agent;
    }

    public static IAgentLocation getAgentLocation() throws CoreException {
        IAgentLocation result = (IAgentLocation)P2TargetUtils.getAgent().getService(IAgentLocation.SERVICE_NAME);
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_10));
        }
        return result;
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)P2TargetUtils.getAgent().getService(IArtifactRepositoryManager.class.getName());
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_3));
        }
        return manager;
    }

    public static IFileArtifactRepository getBundlePool() throws CoreException {
        URI uri = BUNDLE_POOL.toFile().toURI();
        IArtifactRepositoryManager manager = P2TargetUtils.getArtifactRepositoryManager();
        try {
            if (manager.contains(uri)) {
                return (IFileArtifactRepository)manager.loadRepository(uri, null);
            }
        }
        catch (CoreException coreException) {}
        String repoName = "PDE Target Bundle Pool";
        IArtifactRepository result = manager.createRepository(uri, repoName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        return (IFileArtifactRepository)result;
    }

    public static IEngine getEngine() throws CoreException {
        IEngine engine = (IEngine)P2TargetUtils.getAgent().getService(IEngine.class.getName());
        if (engine == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_4));
        }
        return engine;
    }

    public static GarbageCollector getGarbageCollector() throws CoreException {
        GarbageCollector engine = (GarbageCollector)P2TargetUtils.getAgent().getService(GarbageCollector.class.getName());
        if (engine == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_9));
        }
        return engine;
    }

    public static IPlanner getPlanner() throws CoreException {
        IPlanner planner = (IPlanner)P2TargetUtils.getAgent().getService(IPlanner.class.getName());
        if (planner == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_5));
        }
        return planner;
    }

    public static IPreferencesService getPreferences() {
        return PDECore.getDefault().acquireService(IPreferencesService.class);
    }

    private boolean checkProfile(ITargetDefinition target) throws CoreException {
        if (this.fProfile == null) {
            return false;
        }
        String profileNumber = this.fProfile.getProperty(PROP_SEQUENCE_NUMBER);
        if (Integer.toString(((TargetDefinition)target).getSequenceNumber()).equals(profileNumber)) {
            return true;
        }
        boolean all = false;
        String value = this.fProfile.getProperty(PROP_ALL_ENVIRONMENTS);
        if (value != null) {
            all = Boolean.valueOf(value);
            if (!Boolean.toString(this.getIncludeAllEnvironments()).equals(value)) {
                return false;
            }
        }
        String property = null;
        if (!all && !(property = this.generateEnvironmentProperties(target)).equals(value = this.fProfile.getProperty("org.eclipse.equinox.p2.environments"))) {
            return false;
        }
        property = this.generateNLProperty(target);
        if (!property.equals(value = this.fProfile.getProperty("org.eclipse.equinox.p2.nl"))) {
            return false;
        }
        if (!this.getProvisionMode(target).equals(this.fProfile.getProperty(PROP_PROVISION_MODE))) {
            return false;
        }
        if (this.getIncludeSource() != Boolean.valueOf(this.fProfile.getProperty(PROP_AUTO_INCLUDE_SOURCE)).booleanValue()) {
            return false;
        }
        if (this.getIncludeConfigurePhase() != Boolean.valueOf(this.fProfile.getProperty(PROP_INCLUDE_CONFIGURE_PHASE)).booleanValue()) {
            return false;
        }
        IUProfilePropertyQuery propertyQuery = new IUProfilePropertyQuery(PROP_INSTALLED_IU, Boolean.toString(true));
        IQueryResult queryResult = this.fProfile.query((IQuery)propertyQuery, null);
        Iterator iterator = queryResult.iterator();
        HashSet<NameVersionDescriptor> installedIUs = new HashSet<NameVersionDescriptor>();
        while (iterator.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iterator.next();
            installedIUs.add(new NameVersionDescriptor(unit.getId(), unit.getVersion().toString()));
        }
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            return installedIUs.isEmpty();
        }
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                IUBundleContainer bc = (IUBundleContainer)container;
                String[] ids = bc.getIds();
                Version[] versions = bc.getVersions();
                int j = 0;
                while (j < versions.length) {
                    if (!installedIUs.remove(new NameVersionDescriptor(ids[j], versions[j].toString()))) {
                        return false;
                    }
                    ++j;
                }
            }
            ++n2;
        }
        return installedIUs.isEmpty();
    }

    public void setIncludeAllRequired(boolean value) {
        this.fIncludeAllRequired = value;
    }

    public boolean getIncludeAllRequired() {
        return this.fIncludeAllRequired;
    }

    public void setIncludeAllEnvironments(boolean value) {
        this.fIncludeMultipleEnvironments = value;
    }

    public boolean getIncludeAllEnvironments() {
        return this.fIncludeMultipleEnvironments;
    }

    public void setIncludeSource(boolean value) {
        this.fIncludeSource = value;
    }

    public boolean getIncludeSource() {
        return this.fIncludeSource;
    }

    public void setIncludeConfigurePhase(boolean value) {
        this.fIncludeConfigurePhase = value;
    }

    public boolean getIncludeConfigurePhase() {
        return this.fIncludeConfigurePhase;
    }

    public static boolean isResolved(ITargetDefinition target) {
        P2TargetUtils synchronizer = P2TargetUtils.getSynchronizer(target);
        if (synchronizer == null) {
            return false;
        }
        try {
            return synchronizer.checkProfile(target);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isProfileValid(ITargetDefinition target) {
        P2TargetUtils synchronizer = P2TargetUtils.getSynchronizer(target);
        if (synchronizer == null) {
            return false;
        }
        try {
            synchronizer.updateProfileFromRegistry(target);
            return synchronizer.checkProfile(target);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void updateProfileFromRegistry(ITargetDefinition target) {
        if (this.fProfile == null) {
            try {
                this.fProfile = P2TargetUtils.getProfileRegistry().getProfile(P2TargetUtils.getProfileId(target));
            }
            catch (CoreException coreException) {}
        }
    }

    static synchronized P2TargetUtils getSynchronizer(ITargetDefinition target) {
        P2TargetUtils result = synchronizers.get(target);
        if (result != null) {
            return result;
        }
        result = new P2TargetUtils();
        synchronizers.put(target, result);
        return result;
    }

    public static IQueryResult<?> getIUs(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        P2TargetUtils synchronizer = P2TargetUtils.getSynchronizer(target);
        if (synchronizer == null) {
            return null;
        }
        synchronizer.synchronize(target, monitor);
        return synchronizer.getProfile().query(QueryUtil.createIUAnyQuery(), null);
    }

    public synchronized void synchronize(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.fProfile == null) {
            this.fProfile = P2TargetUtils.getProfileRegistry().getProfile(P2TargetUtils.getProfileId(target));
        }
        if (this.fProfile != null && this.checkProfile(target)) {
            this.notify(target, (IProgressMonitor)progress.split(25));
            return;
        }
        P2TargetUtils.deleteProfile(target.getHandle());
        this.createProfile(target);
        if (progress.isCanceled()) {
            return;
        }
        progress.setWorkRemaining(75);
        try {
            if (this.getIncludeAllRequired()) {
                this.resolveWithPlanner(target, (IProgressMonitor)progress.split(60));
            } else {
                this.resolveWithSlicer(target, (IProgressMonitor)progress.split(60));
            }
            this.notify(target, (IProgressMonitor)progress.split(15));
        }
        catch (CoreException e) {
            P2TargetUtils.deleteProfile(target.getHandle());
            throw e;
        }
    }

    private void createProfile(ITargetDefinition target) throws CoreException, ProvisionException {
        IProfileRegistry registry = P2TargetUtils.getProfileRegistry();
        if (registry == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.AbstractTargetHandle_0));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", INSTALL_FOLDERS.append(Long.toString(LocalTargetHandle.nextTimeStamp())).toOSString());
        properties.put("org.eclipse.equinox.p2.cache", BUNDLE_POOL.toOSString());
        properties.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
        properties.put("org.eclipse.equinox.p2.environments", this.generateEnvironmentProperties(target));
        properties.put("org.eclipse.equinox.p2.nl", this.generateNLProperty(target));
        properties.put(PROP_SEQUENCE_NUMBER, Integer.toString(((TargetDefinition)target).getSequenceNumber()));
        properties.put(PROP_PROVISION_MODE, this.getProvisionMode(target));
        properties.put(PROP_ALL_ENVIRONMENTS, Boolean.toString(this.getIncludeAllEnvironments()));
        properties.put(PROP_AUTO_INCLUDE_SOURCE, Boolean.toString(this.getIncludeSource()));
        properties.put(PROP_INCLUDE_CONFIGURE_PHASE, Boolean.toString(this.getIncludeConfigurePhase()));
        this.fProfile = registry.addProfile(P2TargetUtils.getProfileId(target), properties);
    }

    private void notify(ITargetDefinition target, IProgressMonitor monitor) {
        ((TargetDefinition)target).flushCaches(BUNDLE_POOL.toOSString());
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                if (container instanceof IUBundleContainer) {
                    ((IUBundleContainer)container).synchronizerChanged(target);
                }
                ++n2;
            }
        }
    }

    private static String getProfileId(ITargetHandle handle) throws CoreException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(PROFILE_ID_PREFIX);
        String memento = handle.getMemento();
        if (memento.length() > 200) {
            buffer.append(memento.substring(memento.length() - 200));
            buffer.append(memento.hashCode());
        } else {
            buffer.append(memento);
        }
        return buffer.toString();
    }

    public static String getProfileId(ITargetDefinition definition) {
        try {
            return P2TargetUtils.getProfileId(definition.getHandle());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IProfileRegistry getProfileRegistry() throws CoreException {
        IProfileRegistry result = (IProfileRegistry)P2TargetUtils.getAgent().getService(IProfileRegistry.SERVICE_NAME);
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_8));
        }
        return result;
    }

    private String getProvisionMode(ITargetDefinition target) {
        return this.getIncludeAllRequired() ? "planner" : "slicer";
    }

    public static IMetadataRepositoryManager getRepoManager() throws CoreException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)P2TargetUtils.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_2));
        }
        return manager;
    }

    static IQueryable<IInstallableUnit> getQueryableMetadata(URI[] repos, IProgressMonitor monitor) throws CoreException {
        IMetadataRepositoryManager manager = P2TargetUtils.getRepoManager();
        if (repos == null) {
            repos = manager.getKnownRepositories(0);
        }
        int repoCount = repos.length;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)repoCount);
        ArrayList<IMetadataRepository> result = new ArrayList<IMetadataRepository>(repoCount);
        MultiStatus repoStatus = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories, null);
        int i = 0;
        while (i < repoCount) {
            try {
                result.add(manager.loadRepository(repos[i], (IProgressMonitor)subMonitor.split(1)));
            }
            catch (ProvisionException e) {
                repoStatus.add(e.getStatus());
            }
            ++i;
        }
        if (result.size() != repos.length) {
            throw new CoreException((IStatus)repoStatus);
        }
        if (result.size() == 1) {
            return (IQueryable)result.get(0);
        }
        return QueryUtil.compoundQueryable(result);
    }

    private void resolveWithPlanner(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IUBundleContainer_0, (int)220);
        IInstallableUnit[] units = this.getRootIUs(target, (IProgressMonitor)subMonitor.split(20));
        IPlanner planner = P2TargetUtils.getPlanner();
        IProfileChangeRequest request = planner.createChangeRequest(this.fProfile);
        this.computeRemovals(this.fProfile, request, this.getIncludeSource());
        request.addAll(Arrays.asList(units));
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit unit = iInstallableUnitArray[n2];
            request.setInstallableUnitProfileProperty(unit, PROP_INSTALLED_IU, Boolean.toString(true));
            ++n2;
        }
        ProvisioningContext context = new ProvisioningContext(P2TargetUtils.getAgent());
        context.setMetadataRepositories(this.getMetadataRepositories(target));
        context.setArtifactRepositories(this.getArtifactRepositories(target));
        IProvisioningPlan plan = planner.getProvisioningPlan(request, context, (IProgressMonitor)subMonitor.split(20));
        IStatus status = plan.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        this.setPlanProperties(plan, target, "planner");
        IProvisioningPlan installerPlan = plan.getInstallerPlan();
        if (installerPlan != null) {
            PDECore.log((IStatus)new Status(1, "org.eclipse.pde.core", Messages.IUBundleContainer_6));
        }
        subMonitor.split(10);
        IPhaseSet phases = this.createPhaseSet();
        IEngine engine = P2TargetUtils.getEngine();
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)subMonitor.split(100));
        if (result.getSeverity() == 4 || result.getSeverity() == 8) {
            throw new CoreException(result);
        }
        try {
            this.planInSourceBundles(this.fProfile, context, (IProgressMonitor)subMonitor.split(60));
        }
        catch (CoreException e) {
            P2TargetUtils.getProfileRegistry().removeProfile(this.fProfile.getProfileId(), this.fProfile.getTimestamp());
            throw e;
        }
    }

    private void setPlanProperties(IProvisioningPlan plan, ITargetDefinition definition, String mode) {
        plan.setProfileProperty(PROP_PROVISION_MODE, mode);
        plan.setProfileProperty(PROP_ALL_ENVIRONMENTS, Boolean.toString(this.getIncludeAllEnvironments()));
        plan.setProfileProperty(PROP_AUTO_INCLUDE_SOURCE, Boolean.toString(this.getIncludeSource()));
        plan.setProfileProperty(PROP_INCLUDE_CONFIGURE_PHASE, Boolean.toString(this.getIncludeConfigurePhase()));
        plan.setProfileProperty(PROP_SEQUENCE_NUMBER, Integer.toString(((TargetDefinition)definition).getSequenceNumber()));
    }

    private IPhaseSet createPhaseSet() {
        ArrayList<Object> phases = new ArrayList<Object>(4);
        phases.add(new Collect(100));
        phases.add(new Property(1));
        phases.add(new Uninstall(50, true));
        phases.add(new Install(50));
        phases.add((Object)new CollectNativesPhase(100));
        if (this.getIncludeConfigurePhase()) {
            phases.add(new Configure(100));
        }
        return new PhaseSet(phases.toArray(new Phase[phases.size()]));
    }

    private void computeRemovals(IProfile profile, IProfileChangeRequest request, boolean includeSource) {
        IInstallableUnit sourceIU;
        if (!includeSource && (sourceIU = this.getCurrentSourceIU((IQueryable<IInstallableUnit>)profile)) != null) {
            request.remove(sourceIU);
        }
        IUProfilePropertyQuery query = new IUProfilePropertyQuery(PROP_INSTALLED_IU, Boolean.toString(true));
        IQueryResult installedIUs = profile.query((IQuery)query, null);
        request.removeAll((Collection)installedIUs.toSet());
    }

    private void planInSourceBundles(IProfile fProfile, ProvisioningContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.P2TargetUtils_ProvisioningSourceTask, (int)100);
        IInstallableUnit currentSourceIU = this.getCurrentSourceIU((IQueryable<IInstallableUnit>)fProfile);
        Version sourceVersion = Version.createOSGi((int)1, (int)0, (int)0);
        if (currentSourceIU != null) {
            Integer major = (Integer)currentSourceIU.getVersion().getSegment(0);
            sourceVersion = Version.createOSGi((int)(major + 1), (int)0, (int)0);
        }
        IInstallableUnit sourceIU = this.createSourceIU((IQueryable<IInstallableUnit>)fProfile, sourceVersion);
        IPlanner planner = P2TargetUtils.getPlanner();
        IProfileChangeRequest request = planner.createChangeRequest(fProfile);
        if (currentSourceIU != null) {
            request.remove(currentSourceIU);
        }
        request.add(sourceIU);
        IProvisioningPlan plan = planner.getProvisioningPlan(request, context, (IProgressMonitor)subMonitor.split(25));
        IStatus status = plan.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        if (subMonitor.isCanceled()) {
            return;
        }
        long oldTimestamp = fProfile.getTimestamp();
        IPhaseSet phases = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_CHECK_TRUST, PhaseSetFactory.PHASE_CONFIGURE, PhaseSetFactory.PHASE_UNCONFIGURE, PhaseSetFactory.PHASE_UNINSTALL});
        IEngine engine = P2TargetUtils.getEngine();
        plan.setProfileProperty(PROP_PROVISION_MODE, "planner");
        plan.setProfileProperty(PROP_ALL_ENVIRONMENTS, Boolean.toString(false));
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)subMonitor.split(75));
        if (subMonitor.isCanceled()) {
            return;
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        P2TargetUtils.getProfileRegistry().removeProfile(fProfile.getProfileId(), oldTimestamp);
    }

    private IInstallableUnit createSourceIU(IQueryable<IInstallableUnit> queryable, Version iuVersion) {
        IRequirement bundleRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false, (boolean)false);
        IQueryResult profileIUs = queryable.query(QueryUtil.createIUAnyQuery(), null);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        for (IInstallableUnit profileIU : profileIUs) {
            if (!profileIU.satisfies(bundleRequirement)) continue;
            String id = String.valueOf(profileIU.getId()) + ".source";
            Version version = profileIU.getVersion();
            VersionRange range = new VersionRange(version, true, version, true);
            IRequirement sourceRequirement = MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)range, null, (boolean)true, (boolean)false, (boolean)true);
            requirements.add(sourceRequirement);
        }
        MetadataFactory.InstallableUnitDescription sourceDescription = new MetadataFactory.InstallableUnitDescription();
        sourceDescription.setSingleton(true);
        sourceDescription.setId(SOURCE_IU_ID);
        sourceDescription.setVersion(iuVersion);
        sourceDescription.addRequirements(requirements);
        IProvidedCapability capability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)SOURCE_IU_ID, (Version)iuVersion);
        sourceDescription.setCapabilities(new IProvidedCapability[]{capability});
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)sourceDescription);
    }

    private IInstallableUnit getCurrentSourceIU(IQueryable<IInstallableUnit> queryable) {
        IQuery query = QueryUtil.createIUQuery((String)SOURCE_IU_ID);
        IQueryResult list = queryable.query(query, null);
        IInstallableUnit currentSourceIU = null;
        if (!list.isEmpty()) {
            currentSourceIU = (IInstallableUnit)list.iterator().next();
        }
        return currentSourceIU;
    }

    private void resolveWithSlicer(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IUBundleContainer_0, (int)110);
        IInstallableUnit[] units = this.getRootIUs(target, (IProgressMonitor)subMonitor.split(40));
        URI[] repositories = this.getMetadataRepositories(target);
        int repoCount = repositories.length;
        if (repoCount == 0) {
            return;
        }
        IQueryable<IInstallableUnit> allMetadata = P2TargetUtils.getQueryableMetadata(repositories, (IProgressMonitor)subMonitor.split(5));
        IQueryResult<IInstallableUnit> queryResult = this.slice(units, allMetadata, target, (IProgressMonitor)subMonitor.split(5));
        if (queryResult == null || queryResult.isEmpty()) {
            return;
        }
        if (this.getIncludeSource()) {
            IInstallableUnit sourceIU = this.createSourceIU((IQueryable<IInstallableUnit>)queryResult, Version.createOSGi((int)1, (int)0, (int)0));
            IInstallableUnit[] units2 = new IInstallableUnit[units.length + 1];
            System.arraycopy(units, 0, units2, 0, units.length);
            units2[units.length] = sourceIU;
            queryResult = this.slice(units2, allMetadata, target, (IProgressMonitor)subMonitor.split(5));
            if (queryResult == null || queryResult.isEmpty()) {
                return;
            }
        }
        IEngine engine = P2TargetUtils.getEngine();
        ProvisioningContext context = new ProvisioningContext(P2TargetUtils.getAgent());
        context.setMetadataRepositories(repositories);
        context.setArtifactRepositories(this.getArtifactRepositories(target));
        IProvisioningPlan plan = engine.createPlan(this.fProfile, context);
        this.setPlanProperties(plan, target, "slicer");
        Set newSet = queryResult.toSet();
        Iterator itor = newSet.iterator();
        while (itor.hasNext()) {
            plan.addInstallableUnit((IInstallableUnit)itor.next());
        }
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit unit = iInstallableUnitArray[n2];
            plan.setInstallableUnitProfileProperty(unit, PROP_INSTALLED_IU, Boolean.toString(true));
            ++n2;
        }
        Set toRemove = this.fProfile.query(QueryUtil.ALL_UNITS, null).toSet();
        toRemove.removeAll(newSet);
        for (Object name : toRemove) {
            plan.removeInstallableUnit((IInstallableUnit)name);
        }
        subMonitor.split(5);
        IPhaseSet phases = this.createPhaseSet();
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)subMonitor.split(50));
        if (result.getSeverity() == 4 || result.getSeverity() == 8) {
            throw new CoreException(result);
        }
    }

    private IQueryResult<IInstallableUnit> slice(IInstallableUnit[] units, IQueryable<IInstallableUnit> allMetadata, ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        PermissiveSlicer slicer = null;
        if (this.getIncludeAllEnvironments()) {
            slicer = new PermissiveSlicer(allMetadata, new HashMap(), true, false, true, true, false);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("osgi.os", definition.getOS() != null ? definition.getOS() : Platform.getOS());
            props.put("osgi.ws", definition.getWS() != null ? definition.getWS() : Platform.getWS());
            props.put("osgi.arch", definition.getArch() != null ? definition.getArch() : Platform.getOSArch());
            props.put("osgi.nl", definition.getNL() != null ? definition.getNL() : Platform.getNL());
            props.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
            slicer = new PermissiveSlicer(allMetadata, props, true, false, false, true, false);
        }
        IQueryable slice = slicer.slice(units, (IProgressMonitor)subMonitor.split(50));
        MultiStatus sliceStatus = slicer.getStatus();
        if (sliceStatus.getSeverity() == 4) {
            throw new CoreException((IStatus)sliceStatus);
        }
        IQueryResult queryResult = null;
        if (slice != null) {
            queryResult = slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)subMonitor.split(50));
        }
        if (!sliceStatus.isOK() && queryResult != null && !queryResult.iterator().hasNext()) {
            throw new CoreException((IStatus)sliceStatus);
        }
        return queryResult;
    }

    private URI[] getArtifactRepositories(ITargetDefinition target) throws CoreException {
        HashSet<URI> result = new HashSet<URI>();
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            containers = new ITargetLocation[]{};
        }
        IArtifactRepositoryManager manager = P2TargetUtils.getArtifactRepositoryManager();
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                URI[] repos = ((IUBundleContainer)container).getRepositories();
                if (repos == null) {
                    repos = manager.getKnownRepositories(0);
                }
                result.addAll(Arrays.asList(repos));
            }
            ++n2;
        }
        if (this.useAdditionalLocalArtifacts()) {
            result.addAll(Arrays.asList(manager.getKnownRepositories(0)));
            this.findProfileRepos(result);
            this.findWorkspaceRepos(result);
        }
        return result.toArray(new URI[result.size()]);
    }

    private boolean useAdditionalLocalArtifacts() {
        return true;
    }

    private void findWorkspaceRepos(Set<URI> additionalRepos) {
        String[] recents;
        IPreferencesService prefs = P2TargetUtils.getPreferences();
        if (prefs == null) {
            return;
        }
        String recent = prefs.getString("org.eclipse.ui.ide", "RECENT_WORKSPACES", null, null);
        if (recent == null) {
            return;
        }
        String[] stringArray = recents = recent.split("\n");
        int n = recents.length;
        int n2 = 0;
        while (n2 < n) {
            String recentWorkspace = stringArray[n2];
            File bundlePool = new File(String.valueOf(recentWorkspace) + "/.metadata/.plugins/org.eclipse.pde.core/.bundle_pool");
            if (bundlePool.exists()) {
                additionalRepos.add(bundlePool.toURI().normalize());
            }
            ++n2;
        }
    }

    private void findProfileRepos(Set<URI> additionalRepos) {
        try {
            IProfileRegistry profileRegistry = (IProfileRegistry)P2TargetUtils.getGlobalAgent().getService(IProfileRegistry.SERVICE_NAME);
            if (profileRegistry == null) {
                return;
            }
            IProfile self = profileRegistry.getProfile("_SELF_");
            if (self == null) {
                return;
            }
            IAgentLocation location = (IAgentLocation)P2TargetUtils.getGlobalAgent().getService(IAgentLocation.SERVICE_NAME);
            URI dataArea = location.getDataArea("org.eclipse.equinox.p2.engine");
            dataArea = URIUtil.append((URI)dataArea, (String)("profileRegistry/" + self.getProfileId() + ".profile"));
            ProfileMetadataRepository profileRepo = new ProfileMetadataRepository(P2TargetUtils.getGlobalAgent(), dataArea, null);
            Collection repos = profileRepo.getReferences();
            for (Object element : repos) {
                IRepositoryReference reference;
                if (!(element instanceof IRepositoryReference) || (reference = (IRepositoryReference)element).getType() != 1 || reference.getLocation() == null) continue;
                additionalRepos.add(reference.getLocation());
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private IInstallableUnit[] getRootIUs(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        HashSet result = new HashSet();
        ITargetLocation[] containers = definition.getTargetLocations();
        if (containers == null) {
            return new IInstallableUnit[0];
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IUBundleContainer_0, (int)(containers.length * 10));
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories, null);
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                try {
                    IUBundleContainer iuContainer = (IUBundleContainer)container;
                    Collections.addAll(result, iuContainer.getRootIUs(definition, (IProgressMonitor)subMonitor.split(10)));
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
            ++n2;
        }
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
        return result.toArray(new IInstallableUnit[result.size()]);
    }

    private URI[] getMetadataRepositories(ITargetDefinition target) throws CoreException {
        HashSet<URI> result = new HashSet<URI>();
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            containers = new ITargetLocation[]{};
        }
        IMetadataRepositoryManager manager = P2TargetUtils.getRepoManager();
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                URI[] repos = ((IUBundleContainer)container).getRepositories();
                if (repos == null) {
                    repos = manager.getKnownRepositories(0);
                }
                result.addAll(Arrays.asList(repos));
            }
            ++n2;
        }
        return result.toArray(new URI[result.size()]);
    }

    IProfile getProfile() {
        return this.fProfile;
    }

    protected static class CollectNativesAction
    extends ProvisioningAction {
        protected CollectNativesAction() {
        }

        public IStatus execute(Map<String, Object> parameters) {
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get(P2TargetUtils.PARM_OPERAND);
            IInstallableUnit installableUnit = operand.second();
            if (installableUnit == null) {
                return Status.OK_STATUS;
            }
            try {
                Collection toDownload = installableUnit.getArtifacts();
                if (toDownload == null) {
                    return Status.OK_STATUS;
                }
                List artifactRequests = (List)parameters.get(P2TargetUtils.NATIVE_ARTIFACTS);
                IFileArtifactRepository destinationArtifactRepository = P2TargetUtils.getBundlePool();
                IArtifactRepositoryManager manager = P2TargetUtils.getArtifactRepositoryManager();
                for (Object name : toDownload) {
                    IArtifactKey keyToDownload = (IArtifactKey)name;
                    IArtifactRequest request = manager.createMirrorRequest(keyToDownload, (IArtifactRepository)destinationArtifactRepository, null, null);
                    artifactRequests.add(request);
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return Status.OK_STATUS;
        }
    }

    protected static class CollectNativesPhase
    extends InstallableUnitPhase {
        public CollectNativesPhase(int weight) {
            super(P2TargetUtils.NATIVE_ARTIFACTS, weight);
        }

        protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
            IInstallableUnit unit = operand.second();
            if (unit != null && unit.getTouchpointType().getId().equals(P2TargetUtils.NATIVE_TYPE)) {
                ArrayList<ProvisioningAction> list = new ArrayList<ProvisioningAction>(1);
                list.add(new CollectNativesAction());
                return list;
            }
            return null;
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            parameters.put(P2TargetUtils.NATIVE_ARTIFACTS, new ArrayList());
            parameters.put("profile", profile);
            return null;
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            List artifactRequests = (List)parameters.get(P2TargetUtils.NATIVE_ARTIFACTS);
            ProvisioningContext context = (ProvisioningContext)parameters.get("context");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            DownloadManager dm = new DownloadManager(context, agent);
            for (IArtifactRequest iArtifactRequest : artifactRequests) {
                dm.add(iArtifactRequest);
            }
            return dm.start(monitor);
        }
    }
}

