/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui.test.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.selectionwizard.NewMenuWizard;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestPluginWizard;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestPluginWizardPage;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public abstract class RedDeerWizardTestCase {
    protected static final String PLUGIN_NAME = "reddeer.test.plugin";
    protected static final String PLUGIN_ID = "test.plugin";
    protected static final String PLUGIN_PROVIDER = "Eclipse.org - RedDeer";
    protected static final String APPLICATION = "org.eclipse.ui.ide.workbench";
    protected static final String PRODUCT = "org.eclipse.platform.ide";
    protected static final String VERSION = "8.2.9.qualifier";
    protected static final String SOURCE = "src";
    protected static final String EXAMPLE_TEST_CLASS_NAME = "RedDeerTest";
    protected static final String EXAMPLE_TEST_CLASS_JAVA_NAME = "RedDeerTest.java";
    protected static final String EXAMPLE_PACKAGE_NAME = "org.reddeer.test";
    protected static final String[] EXAMPLE_TEST_CLASS_PATH = new String[]{"src", "org.reddeer.test", "RedDeerTest.java"};
    private static final Logger LOG = Logger.getLogger(RedDeerWizardTestCase.class.getName());
    protected static String projectName;

    public abstract String getWizardText();

    @BeforeClass
    public static void setUpTargetPlatform() {
        try {
            RedDeerWizardTestCase.setTargetPlatform();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to load target platform:" + e.getMessage()));
        }
    }

    @AfterClass
    public static void deleteProject() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)pe.getProject(projectName), (boolean)true);
    }

    public static void createRedDeerPluginProject() {
        RedDeerTestPluginWizard wizard = new RedDeerTestPluginWizard();
        wizard.open();
        RedDeerWizardTestCase.fillInWizard(wizard);
        wizard.finish();
    }

    protected void closeOpenedWizard(NewMenuWizard wizard) {
        try {
            new DefaultShell(this.getWizardText());
            wizard.cancel();
        }
        catch (CoreLayerException coreLayerException) {
            LOG.info("Shell " + this.getWizardText() + " is not open");
        }
    }

    protected static void fillInWizard(NewMenuWizard wizard) {
        RedDeerTestPluginWizardPage page = new RedDeerTestPluginWizardPage((ReferencedComposite)wizard);
        page.setPluginName(PLUGIN_NAME);
        page.setPluginId(PLUGIN_ID);
        page.setVersion(VERSION);
        page.setProvider(PLUGIN_PROVIDER);
        page.setApplication(true);
        Assert.assertTrue((String)"Application combo was not enabled", (boolean)new DefaultCombo(1, new Matcher[0]).isEnabled());
        page.selectApplication(APPLICATION);
        page.toggleExampleTest(true);
        Assert.assertTrue((String)"'Example test' checkbox was not checked", (boolean)new CheckBox().isChecked());
        page.setProduct(true);
        Assert.assertFalse((String)"Application combo was not disabled", (boolean)new DefaultCombo(1, new Matcher[0]).isEnabled());
        Assert.assertTrue((String)"Product combo was not enabled", (boolean)new DefaultCombo().isEnabled());
        page.selectProduct(PRODUCT);
        Assert.assertTrue((String)"Finish button is not enabled", (boolean)new FinishButton().isEnabled());
    }

    protected DefaultProject getProject(String name) {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        DefaultProject project = null;
        try {
            project = explorer.getProject(name);
        }
        catch (RedDeerException redDeerException) {
            Assert.fail((String)"Cannot retrieve created plug-in project");
        }
        return project;
    }

    public static void setTargetPlatform() throws Exception {
        ITargetPlatformService tpService = TargetPlatformService.getDefault();
        ITargetDefinition targetDef = tpService.newTarget();
        targetDef.setName("Tycho platform");
        Bundle[] bundles = Platform.getBundle((String)"org.eclipse.core.runtime").getBundleContext().getBundles();
        ArrayList<ITargetLocation> bundleContainers = new ArrayList<ITargetLocation>();
        HashSet<File> dirs = new HashSet<File>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            EquinoxBundle bundleImpl = (EquinoxBundle)bundle;
            BundleInfo.Generation generation = (BundleInfo.Generation)bundleImpl.getModule().getCurrentRevision().getRevisionInfo();
            File file = generation.getBundleFile().getBaseFile();
            File folder = file.getParentFile();
            if (!dirs.contains(folder)) {
                dirs.add(folder);
                bundleContainers.add(tpService.newDirectoryLocation(folder.getAbsolutePath()));
            }
            ++n2;
        }
        targetDef.setTargetLocations(bundleContainers.toArray(new ITargetLocation[bundleContainers.size()]));
        targetDef.setArch(Platform.getOSArch());
        targetDef.setOS(Platform.getOS());
        targetDef.setWS(Platform.getWS());
        targetDef.setNL(Platform.getNL());
        tpService.saveTargetDefinition(targetDef);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(targetDef);
        job.schedule();
        job.join();
    }
}

