/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.utility.JavaType;

public class JavaModule
implements NamedElement.WithOptionalName {
    public static final JavaModule UNSUPPORTED = null;
    private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
    private final Object module;

    protected JavaModule(Object module) {
        this.module = module;
    }

    public static JavaModule ofType(Class<?> type) {
        return DISPATCHER.moduleOf(type);
    }

    public static JavaModule of(Object module) {
        if (!JavaType.MODULE.getTypeStub().isInstance(module)) {
            throw new IllegalArgumentException("Not a Java module: " + module);
        }
        return new JavaModule(module);
    }

    public static boolean isSupported() {
        return DISPATCHER.isAlive();
    }

    @Override
    public boolean isNamed() {
        return DISPATCHER.isNamed(this.module);
    }

    @Override
    public String getActualName() {
        return DISPATCHER.getName(this.module);
    }

    public InputStream getResourceAsStream(String name) {
        return DISPATCHER.getResourceAsStream(this.module, name);
    }

    public ClassLoader getClassLoader() {
        return DISPATCHER.getClassLoader(this.module);
    }

    public Object unwrap() {
        return this.module;
    }

    public boolean canRead(JavaModule module) {
        return DISPATCHER.canRead(this.module, module.unwrap());
    }

    public void addReads(Instrumentation instrumentation, JavaModule module) {
        DISPATCHER.addReads(instrumentation, this.module, module.unwrap());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaModule)) {
            return false;
        }
        JavaModule that = (JavaModule)other;
        return this.module.equals(that.module);
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public String toString() {
        return this.module.toString();
    }

    protected static interface Dispatcher {
        public boolean isAlive();

        public JavaModule moduleOf(Class<?> var1);

        public boolean isNamed(Object var1);

        public String getName(Object var1);

        public InputStream getResourceAsStream(Object var1, String var2);

        public ClassLoader getClassLoader(Object var1);

        public boolean canRead(Object var1, Object var2);

        public void addReads(Instrumentation var1, Object var2, Object var3);

        public static enum CreationAction implements PrivilegedAction<Dispatcher>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public Dispatcher run() {
                try {
                    Class<?> module = Class.forName("java.lang.Module");
                    return new Enabled(Class.class.getMethod("getModule", new Class[0]), module.getMethod("getClassLoader", new Class[0]), module.getMethod("isNamed", new Class[0]), module.getMethod("getName", new Class[0]), module.getMethod("getResourceAsStream", String.class), module.getMethod("canRead", module), Instrumentation.class.getMethod("isModifiableModule", module), Instrumentation.class.getMethod("redefineModule", module, Set.class, Map.class, Map.class, Set.class, Map.class));
                }
                catch (Exception ignored) {
                    return Disabled.INSTANCE;
                }
            }
        }

        public static enum Disabled implements Dispatcher
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public JavaModule moduleOf(Class<?> type) {
                return UNSUPPORTED;
            }

            @Override
            public ClassLoader getClassLoader(Object module) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public boolean isNamed(Object module) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public String getName(Object module) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public InputStream getResourceAsStream(Object module, String name) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public boolean canRead(Object source, Object target) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public void addReads(Instrumentation instrumentation, Object source, Object target) {
                throw new IllegalStateException("Current VM does not support modules");
            }
        }

        public static class Enabled
        implements Dispatcher {
            private final Method getModule;
            private final Method getClassLoader;
            private final Method isNamed;
            private final Method getName;
            private final Method getResourceAsStream;
            private final Method canRead;
            private final Method isModifiableModule;
            private final Method redefineModule;

            protected Enabled(Method getModule, Method getClassLoader, Method isNamed, Method getName, Method getResourceAsStream, Method canRead, Method isModifiableModule, Method redefineModule) {
                this.getModule = getModule;
                this.getClassLoader = getClassLoader;
                this.isNamed = isNamed;
                this.getName = getName;
                this.getResourceAsStream = getResourceAsStream;
                this.canRead = canRead;
                this.isModifiableModule = isModifiableModule;
                this.redefineModule = redefineModule;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public JavaModule moduleOf(Class<?> type) {
                try {
                    return new JavaModule(this.getModule.invoke(type, new Object[0]));
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getModule, exception.getCause());
                }
            }

            @Override
            public InputStream getResourceAsStream(Object module, String name) {
                try {
                    return (InputStream)this.getResourceAsStream.invoke(module, name);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getResourceAsStream, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getResourceAsStream, exception.getCause());
                }
            }

            @Override
            public ClassLoader getClassLoader(Object module) {
                try {
                    return (ClassLoader)this.getClassLoader.invoke(module, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getClassLoader, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getClassLoader, exception.getCause());
                }
            }

            @Override
            public boolean isNamed(Object module) {
                try {
                    return (Boolean)this.isNamed.invoke(module, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.isNamed, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.isNamed, exception.getCause());
                }
            }

            @Override
            public String getName(Object module) {
                try {
                    return (String)this.getName.invoke(module, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getName, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getName, exception.getCause());
                }
            }

            @Override
            public boolean canRead(Object source, Object target) {
                try {
                    return (Boolean)this.canRead.invoke(source, target);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.canRead, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.canRead, exception.getCause());
                }
            }

            @Override
            public void addReads(Instrumentation instrumentation, Object source, Object target) {
                try {
                    if (!((Boolean)this.isModifiableModule.invoke((Object)instrumentation, source)).booleanValue()) {
                        throw new IllegalStateException(source + " is not modifable");
                    }
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.redefineModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.redefineModule, exception.getCause());
                }
                try {
                    this.redefineModule.invoke((Object)instrumentation, source, Collections.singleton(target), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.redefineModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.redefineModule, exception.getCause());
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Enabled)) {
                    return false;
                }
                Enabled other = (Enabled)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Method this$getModule = this.getModule;
                Method other$getModule = other.getModule;
                if (this$getModule == null ? other$getModule != null : !((Object)this$getModule).equals(other$getModule)) {
                    return false;
                }
                Method this$getClassLoader = this.getClassLoader;
                Method other$getClassLoader = other.getClassLoader;
                if (this$getClassLoader == null ? other$getClassLoader != null : !((Object)this$getClassLoader).equals(other$getClassLoader)) {
                    return false;
                }
                Method this$isNamed = this.isNamed;
                Method other$isNamed = other.isNamed;
                if (this$isNamed == null ? other$isNamed != null : !((Object)this$isNamed).equals(other$isNamed)) {
                    return false;
                }
                Method this$getName = this.getName;
                Method other$getName = other.getName;
                if (this$getName == null ? other$getName != null : !((Object)this$getName).equals(other$getName)) {
                    return false;
                }
                Method this$getResourceAsStream = this.getResourceAsStream;
                Method other$getResourceAsStream = other.getResourceAsStream;
                if (this$getResourceAsStream == null ? other$getResourceAsStream != null : !((Object)this$getResourceAsStream).equals(other$getResourceAsStream)) {
                    return false;
                }
                Method this$canRead = this.canRead;
                Method other$canRead = other.canRead;
                if (this$canRead == null ? other$canRead != null : !((Object)this$canRead).equals(other$canRead)) {
                    return false;
                }
                Method this$isModifiableModule = this.isModifiableModule;
                Method other$isModifiableModule = other.isModifiableModule;
                if (this$isModifiableModule == null ? other$isModifiableModule != null : !((Object)this$isModifiableModule).equals(other$isModifiableModule)) {
                    return false;
                }
                Method this$redefineModule = this.redefineModule;
                Method other$redefineModule = other.redefineModule;
                return !(this$redefineModule == null ? other$redefineModule != null : !((Object)this$redefineModule).equals(other$redefineModule));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Enabled;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Method $getModule = this.getModule;
                result = result * 59 + ($getModule == null ? 43 : ((Object)$getModule).hashCode());
                Method $getClassLoader = this.getClassLoader;
                result = result * 59 + ($getClassLoader == null ? 43 : ((Object)$getClassLoader).hashCode());
                Method $isNamed = this.isNamed;
                result = result * 59 + ($isNamed == null ? 43 : ((Object)$isNamed).hashCode());
                Method $getName = this.getName;
                result = result * 59 + ($getName == null ? 43 : ((Object)$getName).hashCode());
                Method $getResourceAsStream = this.getResourceAsStream;
                result = result * 59 + ($getResourceAsStream == null ? 43 : ((Object)$getResourceAsStream).hashCode());
                Method $canRead = this.canRead;
                result = result * 59 + ($canRead == null ? 43 : ((Object)$canRead).hashCode());
                Method $isModifiableModule = this.isModifiableModule;
                result = result * 59 + ($isModifiableModule == null ? 43 : ((Object)$isModifiableModule).hashCode());
                Method $redefineModule = this.redefineModule;
                result = result * 59 + ($redefineModule == null ? 43 : ((Object)$redefineModule).hashCode());
                return result;
            }
        }
    }
}

