/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ButtonRule
extends AbstractSimpleRedDeerRule {
    private String text;
    private int index;
    private int style;
    private boolean toggle;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Button && event.type == 13;
    }

    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.text = WidgetUtils.cleanText((String)((Button)event.widget).getText());
        this.composites = RedDeerUtils.getComposites((Control)((Button)event.widget));
        this.index = WidgetUtils.getIndex((Control)((Button)event.widget));
        Shell s = WidgetUtils.getShell((Control)((Button)event.widget));
        if (s != null) {
            this.setShellTitle(s.getText());
        }
        this.style = ((Button)event.widget).getStyle();
        if ((this.style & 0x20) != 0) {
            this.toggle = ((Button)event.widget).getSelection();
        }
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if ((this.style & 8) != 0) {
            builder.append("new PushButton(");
        } else if ((this.style & 0x20) != 0) {
            builder.append("new CheckBox(");
        } else if ((this.style & 4) != 0) {
            builder.append("new ArrowButton(");
        } else if ((this.style & 0x10) != 0) {
            builder.append("new RadioButton(");
        } else if ((this.style & 2) != 0) {
            builder.append("new ToggleButton(");
        }
        builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
        if (this.text == null || this.text.isEmpty()) {
            builder.append(this.index);
        } else {
            builder.append("\"" + this.text + "\"");
        }
        builder.append(")");
        if ((this.style & 0x20) != 0) {
            builder.append(".toggle(" + this.toggle + ")");
        } else {
            builder.append(".click()");
        }
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        if ((this.style & 8) != 0) {
            toReturn.add("org.eclipse.reddeer.swt.impl.button.PushButton");
        } else if ((this.style & 0x20) != 0) {
            toReturn.add("org.eclipse.reddeer.swt.impl.button.CheckBox");
        } else if ((this.style & 4) != 0) {
            toReturn.add("org.eclipse.reddeer.swt.impl.button.ArrowButton");
        } else if ((this.style & 0x10) != 0) {
            toReturn.add("org.eclipse.reddeer.swt.impl.button.RadioButton");
        } else if ((this.style & 2) != 0) {
            toReturn.add("org.eclipse.reddeer.swt.impl.button.ToggleButton");
        }
        return toReturn;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.composites == null ? 0 : this.composites.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + this.style;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ButtonRule other = (ButtonRule)((Object)obj);
        if (this.composites == null ? other.composites != null : !this.composites.equals(other.composites)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

