/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.preferences;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.core.resources.Project;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyDialog;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class BuildPathsPropertyPageTest {
    private static final String TEST_PROJECT_NAME = "buildpathspropertypagetest";
    private DefaultProject project;
    private PropertyDialog propertiesDialog = null;
    private BuildPathsPropertyPage buildPathsPropertyPage = null;

    @BeforeClass
    public static void setupClass() {
        JavaProjectWizard javaProject = new JavaProjectWizard();
        javaProject.open();
        NewJavaProjectWizardPageOne javaWizardPage = new NewJavaProjectWizardPageOne((ReferencedComposite)javaProject);
        javaWizardPage.setProjectName(TEST_PROJECT_NAME);
        javaProject.finish();
    }

    @AfterClass
    public static void teardownClass() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        for (DefaultProject p : pe.getProjects()) {
            DeleteUtils.forceProjectDeletion((DefaultProject)p, (boolean)true);
        }
    }

    @Before
    public void setUp() {
        this.propertiesDialog = this.getProject().openProperties();
        this.buildPathsPropertyPage = new BuildPathsPropertyPage((ReferencedComposite)this.propertiesDialog);
        this.propertiesDialog.select((PreferencePage)this.buildPathsPropertyPage);
    }

    @After
    public void cleanup() {
        if (this.propertiesDialog != null && this.propertiesDialog.isOpen()) {
            this.propertiesDialog.cancel();
        }
    }

    @Test
    public void selectTabs() {
        this.buildPathsPropertyPage.activateLibrariesTab();
        this.buildPathsPropertyPage.activateSourceTab();
        this.buildPathsPropertyPage.activateOrderAndExportTab();
        this.buildPathsPropertyPage.activateProjectsTab();
    }

    @Test
    public void getLibraries() {
        Assert.assertTrue((String)"Exactly one library has to be defined on build path", (this.buildPathsPropertyPage.getLibraries().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void addRemoveVariable() {
        String addedVariableLabel = this.buildPathsPropertyPage.addVariable("VN", this.getJarVariableLocation(), true);
        Assert.assertTrue((String)("Libraries has to contain item:'" + addedVariableLabel + "'"), (boolean)this.buildPathsPropertyPage.getLibraries().contains(addedVariableLabel));
        this.propertiesDialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new PackageExplorerPart().open();
        this.propertiesDialog = this.getProject().openProperties();
        this.buildPathsPropertyPage = new BuildPathsPropertyPage((ReferencedComposite)this.propertiesDialog);
        this.propertiesDialog.select((PreferencePage)this.buildPathsPropertyPage);
        this.buildPathsPropertyPage.removeVariable(addedVariableLabel, true);
        Assert.assertFalse((String)("Libraries should not contain item:'" + addedVariableLabel + "'"), (boolean)this.buildPathsPropertyPage.getLibraries().contains(addedVariableLabel));
        this.propertiesDialog.ok();
    }

    public Project getProject() {
        if (this.project == null) {
            PackageExplorerPart packageExplorer = new PackageExplorerPart();
            packageExplorer.open();
            this.project = packageExplorer.getProject(TEST_PROJECT_NAME);
        }
        return this.project;
    }

    private String getJarVariableLocation() {
        try {
            File jarFileRoot = new File(FileLocator.resolve((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.eclipse.test"), (IPath)new Path("target"), null)).getFile());
            File[] jarFiles = jarFileRoot.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jarFiles == null || jarFiles.length == 0) {
                jarFiles = new File(jarFileRoot, "plugins").listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
            }
            return jarFiles[0].getAbsolutePath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

