/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.test.wait;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.test.wait.CustomWaitCondition;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupWaitTest {
    private WaitCondition falseCondition;
    private WaitCondition trueCondition;
    private WaitWrapper waitUntil;
    private WaitWrapper waitWhile;

    @Before
    public void setup() {
        this.falseCondition = new CustomWaitCondition(false, 3, () -> CustomWaitCondition.sleep(1000L));
        this.trueCondition = new CustomWaitCondition(true, 3, () -> CustomWaitCondition.sleep(1000L));
        this.waitUntil = WaitProvider.waitUntil((WaitCondition)this.falseCondition);
        this.waitWhile = WaitProvider.waitWhile((WaitCondition)this.trueCondition);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_groupWaitNullWaitCondition() {
        new GroupWait(TimePeriod.SHORT, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_groupWaitValidAndNullWaitCondition() {
        new GroupWait(new WaitWrapper[]{this.waitUntil, null});
    }

    @Test
    public void test_groupWaitTimeoutDefault() {
        try {
            new GroupWait(new WaitWrapper[]{this.waitUntil});
            Assert.assertTrue((boolean)((Boolean)this.waitUntil.getWaitCondition().getResult()));
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"GroupWait should have not thrown WaitTimeExpiredException");
        }
    }

    @Test
    public void test_groupWaitTimeoutMedium() {
        try {
            new GroupWait(TimePeriod.SHORT, new WaitWrapper[]{this.waitUntil});
            Assert.fail((String)"GroupWait should have thrown WaitTimeExpiredException");
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.assertFalse((boolean)((Boolean)this.waitUntil.getWaitCondition().getResult()));
        }
    }

    @Test
    public void test_groupWaitWaitUntilAndWhileFulfilled() {
        this.waitUntil = WaitProvider.waitUntil((WaitCondition)new CustomWaitCondition(false, 3, () -> CustomWaitCondition.sleep(1000L)));
        this.waitWhile = WaitProvider.waitWhile((WaitCondition)new CustomWaitCondition(true, 5, () -> CustomWaitCondition.sleep(1000L)));
        try {
            new GroupWait(new WaitWrapper[]{this.waitUntil, this.waitWhile});
            Assert.assertTrue((boolean)((Boolean)this.waitUntil.getWaitCondition().getResult()));
            Assert.assertTrue((boolean)((Boolean)this.waitWhile.getWaitCondition().getResult()));
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"GroupWait should have not thrown WaitTimeExpiredException");
        }
    }

    @Test
    public void test_groupWaitWaitWhileFailed() {
        this.waitUntil = WaitProvider.waitUntil((WaitCondition)new CustomWaitCondition(false, 1, () -> CustomWaitCondition.sleep(1000L)));
        this.waitWhile = WaitProvider.waitWhile((WaitCondition)new CustomWaitCondition(true, 5, () -> CustomWaitCondition.sleep(1000L)));
        try {
            new GroupWait(TimePeriod.MEDIUM, new WaitWrapper[]{this.waitUntil, this.waitWhile});
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.assertTrue((boolean)((Boolean)this.waitUntil.getWaitCondition().getResult()));
            Assert.assertFalse((boolean)((Boolean)this.waitWhile.getWaitCondition().getResult()));
        }
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void test_groupWaitBothConditionsFailed() {
        new GroupWait(TimePeriod.MEDIUM, new WaitWrapper[]{this.waitUntil, this.waitWhile});
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void test_groupWaitOneFailed() {
        this.waitWhile = WaitProvider.waitWhile((WaitCondition)new CustomWaitCondition(true, 1, () -> CustomWaitCondition.sleep(1000L)));
        this.waitUntil = WaitProvider.waitUntil((WaitCondition)new CustomWaitCondition(false, 5, () -> CustomWaitCondition.sleep(1000L)));
        new GroupWait(TimePeriod.MEDIUM, new WaitWrapper[]{this.waitUntil, this.waitWhile});
    }
}

