/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class TextRule
extends AbstractSimpleRedDeerRule {
    private String text;
    private int index;
    private String label;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Text && event.type == 24 && !((Text)event.widget).getText().equals("") && !((Text)event.widget).getMessage().equals(((Text)event.widget).getText());
    }

    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.setText(((Text)event.widget).getText());
        this.setIndex(WidgetUtils.getIndex((Control)((Text)event.widget)));
        Shell s = WidgetUtils.getShell((Control)((Text)event.widget));
        if (s != null) {
            this.setShellTitle(s.getText());
        }
        this.setLabel(WidgetUtils.cleanText((String)WidgetUtils.getLabel((Control)((Text)event.widget))));
        this.setComposites(RedDeerUtils.getComposites((Control)((Text)event.widget)));
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (this.label != null) {
            builder.append("new LabeledText(");
            builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
            builder.append("\"" + this.label + "\"");
        } else {
            builder.append("new DefaultText(");
            builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
            builder.append(this.index);
        }
        builder.append(").setText(\"" + this.text + "\")");
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.label != null) {
            toReturn.add("org.eclipse.reddeer.swt.impl.text.LabeledText");
        } else {
            toReturn.add("org.eclipse.reddeer.swt.impl.text.DefaultText");
        }
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.composites == null ? 0 : this.composites.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TextRule other = (TextRule)((Object)obj);
        if (this.composites == null ? other.composites != null : !this.composites.equals(other.composites)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

