/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriber;
import org.eclipse.team.internal.ui.synchronize.patch.PatchModelProvider;

public class ApplyPatchSubscriberMergeContext
extends SubscriberMergeContext {
    protected ApplyPatchSubscriberMergeContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        super(subscriber, manager);
    }

    public static ApplyPatchSubscriberMergeContext createContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        ApplyPatchSubscriberMergeContext mergeContext = new ApplyPatchSubscriberMergeContext(subscriber, manager);
        mergeContext.initialize();
        return mergeContext;
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, true, monitor);
    }

    public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        WorkspacePatcher patcher;
        IResource resource = this.getDiffTree().getResource(node);
        Object object = PatchModelProvider.getPatchObject(resource, patcher = ((ApplyPatchSubscriber)this.getSubscriber()).getPatcher());
        if (object instanceof FilePatch2) {
            HunkResult[] hunkResults = patcher.getDiffResult((FilePatch2)object).getHunkResults();
            int i = 0;
            while (i < hunkResults.length) {
                if (inSyncHint) {
                    if (hunkResults[i].isOK()) {
                        patcher.setEnabled((Object)hunkResults[i].getHunk(), false);
                    }
                } else {
                    patcher.setManuallyMerged(hunkResults[i].getHunk(), true);
                }
                ++i;
            }
        } else {
            patcher.setEnabled(object, false);
        }
        ((ApplyPatchSubscriber)this.getSubscriber()).merged(new IResource[]{resource});
    }

    protected IStatus performThreeWayMerge(IThreeWayDiff diff, IProgressMonitor monitor) throws CoreException {
        WorkspacePatcher patcher;
        IResource resource;
        Object object;
        IStatus status = super.performThreeWayMerge(diff, monitor);
        if (status.isOK() && (object = PatchModelProvider.getPatchObject(resource = this.getDiffTree().getResource((IDiff)diff), patcher = ((ApplyPatchSubscriber)this.getSubscriber()).getPatcher())) instanceof FilePatch2) {
            HunkResult[] hunkResults = patcher.getDiffResult((FilePatch2)object).getHunkResults();
            int i = 0;
            while (i < hunkResults.length) {
                if (patcher.isManuallyMerged(hunkResults[i].getHunk())) {
                    patcher.setManuallyMerged(hunkResults[i].getHunk(), false);
                    if (hunkResults[i].isOK()) {
                        patcher.setEnabled((Object)hunkResults[i].getHunk(), false);
                    }
                }
                ++i;
            }
        }
        return status;
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
    }
}

