/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.reddeer.codegen.builder.MethodBuilder;

public class ClassBuilder {
    private static final String SPACE = " ";
    private static final String SEMICOLON = ";";
    private static final String TAB = "\t";
    private static final String NEW_LINE = "\n";
    private static final String D_NEW_LINE = "\n\n";
    private static final String JAVA_QUALIFIER = ".java";
    private String className;
    private String visibility;
    private StringBuffer classBuilder;
    private String packageName;
    private List<String> imports;
    private List<String> selectedOptions;
    private List<MethodBuilder> methods;
    private Map<String, String> constants;
    private String extendedClass;

    public ClassBuilder(String name, String projectPackage) {
        this.className = this.getClassName(name);
        this.visibility = "public";
        this.packageName = projectPackage;
        this.extendedClass = "";
        this.methods = new ArrayList<MethodBuilder>();
        this.imports = new ArrayList<String>();
        this.selectedOptions = new ArrayList<String>();
        this.constants = new TreeMap<String, String>();
        this.classBuilder = new StringBuffer();
    }

    public ClassBuilder(String name, String projectPackage, List<MethodBuilder> methods) {
        this.className = this.getClassName(name);
        this.visibility = "public";
        this.packageName = projectPackage;
        this.methods = methods;
        this.extendedClass = "";
        this.imports = new ArrayList<String>();
        this.selectedOptions = new ArrayList<String>();
        this.constants = new TreeMap<String, String>();
        this.classBuilder = new StringBuffer();
    }

    public ClassBuilder() {
        this.className = "CodeGenDefault";
        this.visibility = "public";
        this.packageName = "org";
        this.extendedClass = "";
        this.methods = new ArrayList<MethodBuilder>();
        this.imports = new ArrayList<String>();
        this.selectedOptions = new ArrayList<String>();
        this.constants = new TreeMap<String, String>();
        this.classBuilder = new StringBuffer();
    }

    public static ClassBuilder getInstance() {
        return new ClassBuilder();
    }

    public void createMethod(String name) {
        this.methods.add(new MethodBuilder().name(name));
    }

    public void addMethod(MethodBuilder method) {
        for (MethodBuilder m : this.methods) {
            if (!m.getName().equals(method.getName())) continue;
            return;
        }
        this.methods.add(method);
    }

    public void addMethods(List<MethodBuilder> meths) {
        for (MethodBuilder meth : meths) {
            boolean exist = false;
            for (MethodBuilder m : this.methods) {
                if (!m.getName().equals(meth.getName())) continue;
                exist = true;
            }
            if (exist) continue;
            this.methods.add(meth);
        }
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void addImport(String importName) {
        if (!this.imports.contains(importName)) {
            this.imports.add(importName);
        }
    }

    public void addImports(List<String> imports) {
        for (String im : imports) {
            if (this.imports.contains(im)) continue;
            this.imports.add(im);
        }
    }

    public void clearImports() {
        this.imports.clear();
    }

    public void removeImport(String importt) {
        if (this.imports.contains(importt)) {
            this.imports.remove(importt);
        }
    }

    public void removeImport(int type) {
        String importt = "";
        switch (type) {
            case 8: {
                importt = "org.eclipse.reddeer.swt.impl.button.PushButton";
                break;
            }
            case 32: {
                importt = "org.eclipse.reddeer.swt.impl.button.CheckBox";
                break;
            }
            case 4: {
                importt = "org.eclipse.reddeer.swt.impl.button.ArrowButton";
                break;
            }
            case 16: {
                importt = "org.eclipse.reddeer.swt.impl.button.RadioButton";
                break;
            }
            case 2: {
                importt = "org.eclipse.reddeer.swt.impl.button.ToggleButton";
                break;
            }
        }
        if (this.imports.contains(importt)) {
            this.imports.remove(importt);
        }
    }

    public void addOptions(List<String> options) {
        this.selectedOptions = options;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getExtendedClass() {
        return this.extendedClass;
    }

    public void setExtendedClass(String name) {
        this.extendedClass = name;
    }

    public void addConstants(Map<String, String> map) {
        if (map != null) {
            this.constants.putAll(map);
        }
    }

    public String toString() {
        this.classBuilder = new StringBuffer(this.iniComment());
        this.classBuilder.append("package").append(SPACE).append(this.packageName).append(SEMICOLON).append(D_NEW_LINE);
        boolean extend = this.removeInheriteMethods();
        for (String projectImport : this.imports) {
            this.classBuilder.append("import").append(SPACE).append(projectImport).append(SEMICOLON).append(NEW_LINE);
        }
        if (!this.imports.isEmpty()) {
            this.classBuilder.append(NEW_LINE);
        }
        if (extend && this.selectedOptions.contains("Allow inheriting (only, if are included all wizard pages)") && this.selectedOptions.contains("Include all wizard pages")) {
            this.classBuilder.append(this.visibility).append(SPACE).append("class").append(SPACE).append(this.getClassName(this.className)).append(SPACE).append("extends").append(SPACE).append(this.extendedClass).append(SPACE).append("{");
        } else {
            this.classBuilder.append(this.visibility).append(SPACE).append("class").append(SPACE).append(this.getClassName(this.className)).append(SPACE).append("{");
        }
        if (!this.constants.isEmpty()) {
            for (String constant : this.constants.keySet()) {
                this.classBuilder.append(D_NEW_LINE).append(TAB).append("public static final String").append(SPACE).append(constant).append(" = ").append("\"" + this.constants.get(constant) + "\"").append(SEMICOLON);
            }
        }
        Collections.sort(this.methods);
        this.classBuilder.append(D_NEW_LINE).append(TAB).append("// Generated class methods ").append("(").append(this.methods.size()).append(")").append(NEW_LINE);
        for (MethodBuilder method : this.methods) {
            this.classBuilder.append(method.toString()).append(D_NEW_LINE);
        }
        this.classBuilder.append("}");
        return this.classBuilder.toString();
    }

    public boolean isExtendible() {
        boolean extendible = false;
        for (MethodBuilder meth : this.methods) {
            if (!meth.getName().contains("Finish") && !meth.getName().contains("Cancel") && !meth.getName().contains("Next") && !meth.getName().contains("Back") && !meth.getName().contains("OK")) continue;
            extendible = true;
        }
        return extendible;
    }

    public boolean removeInheriteMethods() {
        ArrayList<MethodBuilder> toRemove = new ArrayList<MethodBuilder>();
        for (MethodBuilder meth : this.methods) {
            if (!meth.getName().contains("Finish") && !meth.getName().contains("Cancel") && !meth.getName().contains("Next") && !meth.getName().contains("Back") && !meth.getName().contains("OK")) continue;
            toRemove.add(meth);
        }
        if (this.isExtendible() && this.selectedOptions.contains("Allow inheriting (only, if are included all wizard pages)") && this.selectedOptions.contains("Include all wizard pages")) {
            for (MethodBuilder rm : toRemove) {
                this.methods.remove(rm);
            }
            int i = 0;
            for (MethodBuilder meth : this.methods) {
                if (!meth.getRule().equals("BTN")) continue;
                ++i;
            }
            if (i == 0) {
                this.removeImport(8);
            }
        }
        return true;
    }

    private String iniComment() {
        StringBuffer sb = new StringBuffer();
        sb.append("/** \n * This class '" + this.getFileName(this.className) + "' was generated by RedDeer Code Generator. \n");
        sb.append(" * Selected options:");
        for (String optional : this.selectedOptions) {
            sb.append("\n *").append(TAB).append(TAB).append(optional);
        }
        sb.append("\n */ \n");
        return sb.toString();
    }

    private String getClassName(String name) {
        try {
            if (name.substring(name.lastIndexOf("."), name.length()).equals(JAVA_QUALIFIER)) {
                return name.substring(0, name.lastIndexOf("."));
            }
            return name;
        }
        catch (Exception exception) {
            return name;
        }
    }

    private String getFileName(String name) {
        try {
            if (name.substring(name.lastIndexOf("."), name.length()).equals(JAVA_QUALIFIER)) {
                return name;
            }
            return String.valueOf(name) + JAVA_QUALIFIER;
        }
        catch (Exception exception) {
            return String.valueOf(name) + JAVA_QUALIFIER;
        }
    }
}

