/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.packageexplorer;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class ProjectTest {
    private static final String PROJECT_NAME_0 = "ProjectTestProject0";
    private static final String PROJECT_NAME_1 = "ProjectTestProject1";
    private static final String PROJECT_NAME_2 = "ProjectTestProject2";
    private static final String PROJECT_NAME_3 = "ProjectTestProject3";
    private static PackageExplorerPart packageExplorer;
    private static DefaultProject project0;
    private static DefaultProject project1;
    private static DefaultProject project2;

    @BeforeClass
    public static void setUp() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_0);
        dialog.finish();
        dialog = new JavaProjectWizard();
        dialog.open();
        page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_1);
        dialog.finish();
        dialog = new JavaProjectWizard();
        dialog.open();
        page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_2);
        dialog.finish();
        packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        project0 = packageExplorer.getProject(PROJECT_NAME_0);
        project1 = packageExplorer.getProject(PROJECT_NAME_1);
        project2 = packageExplorer.getProject(PROJECT_NAME_2);
    }

    @Test
    public void select() {
        project1.select();
        Assert.assertTrue((String)("Project " + project1.getName() + " is not selected"), (boolean)project1.isSelected());
        Assert.assertTrue((String)("Project " + project0.getName() + " is selected"), (!project0.isSelected() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Project " + project2.getName() + " is selected"), (!project2.isSelected() ? 1 : 0) != 0);
    }

    @Test
    public void selectProjectItem() {
        project1.getProjectItem(new String[]{"src"}).select();
        Assert.assertTrue((boolean)project1.getProjectItem(new String[]{"src"}).isSelected());
        Assert.assertFalse((boolean)project1.isSelected());
        project1.select();
        Assert.assertTrue((boolean)project1.isSelected());
    }

    @Test
    public void delete() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_3);
        dialog.finish();
        packageExplorer.getProject(PROJECT_NAME_3).delete(true);
        Assert.assertFalse((String)"Package Explorer contains project ProjectTestProject3 but it should be deleted.", (boolean)packageExplorer.containsProject(PROJECT_NAME_3));
    }

    @AfterClass
    public static void tearDown() {
        packageExplorer.close();
        packageExplorer.open();
        for (DefaultProject p : packageExplorer.getProjects()) {
            DeleteUtils.forceProjectDeletion((DefaultProject)p, (boolean)true);
        }
    }
}

