/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class DeletePackageFragmentRootChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    public DeletePackageFragmentRootChange(IPackageFragmentRoot root, boolean isExecuteChange, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isNotNull((Object)root);
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fHandle = root.getHandleIdentifier();
        this.fIsExecuteChange = isExecuteChange;
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    public String getName() {
        Object[] keys = new String[]{this.getRoot().getElementName()};
        return Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_delete, keys);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    private IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaScriptCore.create((String)this.fHandle);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(pm, 2);
        }
        return super.isValid(pm, 3);
    }

    @Override
    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        if (!this.confirmDeleteIfReferenced()) {
            return new NullChange();
        }
        int resourceUpdateFlags = 2;
        int jCoreUpdateFlags = 6;
        pm.beginTask("", 2);
        IPackageFragmentRoot root = this.getRoot();
        IResource rootResource = root.getResource();
        CompositeChange result = new CompositeChange(this.getName());
        ResourceDescription rootDescription = ResourceDescription.fromResource((IResource)rootResource);
        IJavaScriptProject[] referencingProjects = JavaElementUtil.getReferencingProjects(root);
        HashMap<IFile, String> classpathFilesContents = new HashMap<IFile, String>();
        int i = 0;
        while (i < referencingProjects.length) {
            IJavaScriptProject javaProject = referencingProjects[i];
            IFile classpathFile = javaProject.getJSDTScopeFile();
            if (classpathFile.exists()) {
                classpathFilesContents.put(classpathFile, DeletePackageFragmentRootChange.getFileContents(classpathFile));
            }
            ++i;
        }
        root.delete(resourceUpdateFlags, jCoreUpdateFlags, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        rootDescription.recordStateFromHistory(rootResource, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        for (Map.Entry entry : classpathFilesContents.entrySet()) {
            IFile file = (IFile)entry.getKey();
            String contents = (String)entry.getValue();
            TextFileChange classpathUndo = new TextFileChange(Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_restore_file, file.getFullPath().toOSString()), file);
            classpathUndo.setEdit((TextEdit)new ReplaceEdit(0, DeletePackageFragmentRootChange.getFileLength(file), contents));
            result.add((Change)classpathUndo);
        }
        result.add((Change)new UndoDeleteResourceChange(rootDescription));
        pm.done();
        return result;
    }

    private static String getFileContents(IFile file) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        try {
            String string = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument().get();
            return string;
        }
        finally {
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getFileLength(IFile file) throws CoreException {
        int n;
        InputStreamReader reader;
        InputStream contents = file.getContents();
        try {
            reader = new InputStreamReader(contents, file.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            JavaScriptPlugin.log(e);
            reader = new InputStreamReader(contents);
        }
        try {
            n = (int)reader.skip(Integer.MAX_VALUE);
        }
        catch (IOException e) {
            try {
                throw new CoreException((IStatus)new Status(4, Corext.getPluginId(), e.getMessage(), (Throwable)e));
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            reader.close();
            return n;
        }
        catch (IOException iOException) {}
        return n;
    }

    private boolean confirmDeleteIfReferenced() throws JavaScriptModelException {
        if (!this.getRoot().isArchive()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IJavaScriptProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length <= 1) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
    }
}

