/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.databinding.WorkbenchProperties;
import org.eclipse.ui.services.IServiceLocator;

public class WorkbenchObservables {
    public static <T> IObservableValue<T> observeDetailAdaptedValue(IObservableValue<?> master, Class<T> adapter) {
        return WorkbenchObservables.observeDetailAdaptedValue(master, adapter, Platform.getAdapterManager());
    }

    static <T> IObservableValue<T> observeDetailAdaptedValue(IObservableValue<?> master, Class<T> adapter, IAdapterManager adapterManager) {
        return WorkbenchProperties.adaptedValue(adapter, adapterManager).observeDetail(master);
    }

    public static <T> IObservableValue<T> observeAdaptedSingleSelection(IServiceLocator locator, Class<T> targetType) {
        ISelectionService selectionService = locator.getService(ISelectionService.class);
        Assert.isNotNull((Object)selectionService);
        return WorkbenchProperties.singleSelection(null, true).value(WorkbenchProperties.adaptedValue(targetType)).observe((Object)selectionService);
    }

    public static IObservableValue<IWorkbenchWindow> observeActiveWorkbenchWindow(final IWorkbench workbench) {
        Assert.isNotNull((Object)workbench);
        return new ListeningValue<IWorkbenchWindow>(){
            private final IWindowListener listener;
            {
                this.listener = new IWindowListener(){

                    @Override
                    public void windowActivated(IWorkbenchWindow window) {
                        this.protectedSetValue(window);
                    }

                    @Override
                    public void windowDeactivated(IWorkbenchWindow window) {
                        if (window == this.doGetValue()) {
                            this.protectedSetValue(null);
                        }
                    }

                    @Override
                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    @Override
                    public void windowOpened(IWorkbenchWindow window) {
                    }
                };
            }

            @Override
            protected void startListening() {
                workbench.addWindowListener(this.listener);
            }

            @Override
            protected void stopListening() {
                workbench.removeWindowListener(this.listener);
            }

            @Override
            protected IWorkbenchWindow calculate() {
                return workbench.getActiveWorkbenchWindow();
            }
        };
    }

    public static IObservableValue<IWorkbenchPage> observeActiveWorkbenchPage(final IWorkbenchWindow window) {
        Assert.isNotNull((Object)window);
        return new ListeningValue<IWorkbenchPage>(){
            private final IPageListener listener;
            {
                this.listener = new IPageListener(){

                    @Override
                    public void pageActivated(IWorkbenchPage page) {
                        this.protectedSetValue(page);
                    }

                    @Override
                    public void pageClosed(IWorkbenchPage page) {
                        if (page == this.doGetValue()) {
                            this.protectedSetValue(null);
                        }
                    }

                    @Override
                    public void pageOpened(IWorkbenchPage page) {
                    }
                };
            }

            @Override
            protected void startListening() {
                window.addPageListener(this.listener);
            }

            @Override
            protected void stopListening() {
                window.removePageListener(this.listener);
            }

            @Override
            protected IWorkbenchPage calculate() {
                return window.getActivePage();
            }
        };
    }

    public static IObservableValue<IWorkbenchPartReference> observeActivePart(final IPartService partService) {
        Assert.isNotNull((Object)partService);
        return new ListeningValue<IWorkbenchPartReference>(){
            private final IPartListener2 listener;
            {
                this.listener = new IPartListener2(){

                    @Override
                    public void partActivated(IWorkbenchPartReference partRef) {
                        this.protectedSetValue(partRef);
                    }

                    @Override
                    public void partDeactivated(IWorkbenchPartReference partRef) {
                        if (partRef == this.doGetValue()) {
                            this.protectedSetValue(null);
                        }
                    }

                    @Override
                    public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    }

                    @Override
                    public void partClosed(IWorkbenchPartReference partRef) {
                    }

                    @Override
                    public void partOpened(IWorkbenchPartReference partRef) {
                    }

                    @Override
                    public void partHidden(IWorkbenchPartReference partRef) {
                    }

                    @Override
                    public void partVisible(IWorkbenchPartReference partRef) {
                    }

                    @Override
                    public void partInputChanged(IWorkbenchPartReference partRef) {
                    }
                };
            }

            @Override
            protected void startListening() {
                partService.addPartListener(this.listener);
            }

            @Override
            protected void stopListening() {
                partService.removePartListener(this.listener);
            }

            @Override
            protected IWorkbenchPartReference calculate() {
                return partService.getActivePartReference();
            }
        };
    }

    public static IObservableValue<IEditorReference> observeActiveEditor(IPartService partService) {
        IObservableValue<IWorkbenchPartReference> partObservable = WorkbenchObservables.observeActivePart(partService);
        return ComputedValue.create(() -> {
            IWorkbenchPartReference value = (IWorkbenchPartReference)partObservable.getValue();
            return value instanceof IEditorReference ? (IEditorReference)value : null;
        });
    }

    public static IObservableValue<IEditorInput> observeEditorInput(final IEditorPart editor) {
        Assert.isNotNull((Object)editor);
        return new ListeningValue<IEditorInput>(){
            private final IPropertyListener listener;
            {
                this.listener = (source, propId) -> {
                    if (propId == 258) {
                        this.protectedSetValue(iEditorPart.getEditorInput());
                    }
                };
            }

            @Override
            protected void startListening() {
                editor.addPropertyListener(this.listener);
            }

            @Override
            protected void stopListening() {
                editor.removePropertyListener(this.listener);
            }

            @Override
            protected IEditorInput calculate() {
                return editor.getEditorInput();
            }
        };
    }

    private static abstract class ListeningValue<T>
    extends AbstractObservableValue<T> {
        private T value;
        private boolean isListening;
        private volatile boolean hasListeners;

        private ListeningValue() {
        }

        protected final T doGetValue() {
            if (this.isListening) {
                return this.value;
            }
            return this.calculate();
        }

        protected final void protectedSetValue(T value) {
            this.checkRealm();
            if (!this.isListening) {
                throw new IllegalStateException();
            }
            if (this.value != value) {
                this.value = value;
                this.fireValueChange(Diffs.createValueDiff(this.value, this.value));
            }
        }

        protected final void firstListenerAdded() {
            if (this.getRealm().isCurrent()) {
                this.startListeningInternal();
            } else {
                this.getRealm().asyncExec(() -> {
                    if (this.hasListeners && !this.isListening) {
                        this.startListeningInternal();
                    }
                });
            }
            this.hasListeners = true;
            super.firstListenerAdded();
        }

        protected final void lastListenerRemoved() {
            if (this.getRealm().isCurrent()) {
                this.stopListeningInternal();
            } else {
                this.getRealm().asyncExec(() -> {
                    if (!this.hasListeners && this.isListening) {
                        this.stopListeningInternal();
                    }
                });
            }
            this.hasListeners = false;
            super.lastListenerRemoved();
        }

        private void startListeningInternal() {
            this.isListening = true;
            this.value = this.calculate();
            this.startListening();
        }

        private void stopListeningInternal() {
            this.isListening = false;
            this.value = null;
            this.stopListening();
        }

        protected abstract void startListening();

        protected abstract void stopListening();

        protected abstract T calculate();

        public Object getValueType() {
            return null;
        }
    }
}

