/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ResourceSelectionUtil {
    private ResourceSelectionUtil() {
    }

    public static boolean allResourcesAreOfType(IStructuredSelection selection, int resourceMask) {
        for (Object next : selection) {
            if (!(next instanceof IResource)) {
                return false;
            }
            if (ResourceSelectionUtil.resourceIsType((IResource)next, resourceMask)) continue;
            return false;
        }
        return true;
    }

    public static IStructuredSelection allResources(IStructuredSelection selection, int resourceMask) {
        Iterator adaptables = selection.iterator();
        ArrayList<IResource> result = new ArrayList<IResource>();
        while (adaptables.hasNext()) {
            Object next = adaptables.next();
            IResource resource = (IResource)Adapters.adapt(next, IResource.class);
            if (resource == null) {
                return null;
            }
            if (!ResourceSelectionUtil.resourceIsType(resource, resourceMask)) continue;
            result.add(resource);
        }
        return new StructuredSelection(result);
    }

    public static boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }
}

