/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.command.MoveShapeFeatureCommandWithContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.command.AddModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.CreateModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.figures.GFPolylineConnection;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.graphiti.ui.internal.policy.ShapeXYLayoutEditPolicy;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFColorConstants;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class DefaultConnectionEditPolicy
extends ConnectionEditPolicy {
    private IConfigurationProvider _configurationProvider;
    private Color originalColor;
    private int originalLineStyle;
    private Map<IFigure, Color> decorationColor = new HashMap<IFigure, Color>();
    private Map<IFigure, Integer> decorationLineStyle = new HashMap<IFigure, Integer>();

    public DefaultConnectionEditPolicy(IConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected final IConfigurationProvider getConfigurationProvider() {
        return this._configurationProvider;
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("add children")) {
            return this.getAddCommand((ChangeBoundsRequest)request);
        }
        if (request.getType().equals("create child")) {
            return this.getCreateCommand((CreateRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        Object model;
        GefCommandWrapper result = null;
        Object hostModel = this.getHost().getModel();
        Connection connection = (Connection)hostModel;
        List editParts = request.getEditParts();
        if (editParts != null && editParts.size() > 0 && (model = ((EditPart)editParts.get(0)).getModel()) instanceof org.eclipse.graphiti.mm.pictograms.Shape) {
            org.eclipse.graphiti.mm.pictograms.Shape shape = (org.eclipse.graphiti.mm.pictograms.Shape)model;
            IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
            ContainerShape oldContainer = shape.getContainer();
            ContainerShape targetContainerShape = null;
            Point location = request.getLocation();
            GraphicalViewer graphicalViewer = this.getConfigurationProvider().getDiagramContainer().getGraphicalViewer();
            Point searchLocation = this.getAbsolutePosition(request.getLocation(), graphicalViewer);
            EditPart findEditPartAt = GraphitiUiInternal.getGefService().findEditPartAt((EditPartViewer)graphicalViewer, searchLocation, false);
            if (findEditPartAt != null && findEditPartAt.getModel() instanceof ContainerShape) {
                targetContainerShape = (ContainerShape)findEditPartAt.getModel();
                location = this.createRealLocation(request.getLocation(), findEditPartAt);
            } else {
                targetContainerShape = this.getCommonContainerShape();
            }
            IMoveShapeContext context = this.createMoveShapeContext(shape, oldContainer, targetContainerShape, location, connection);
            IMoveShapeFeature layoutShapeFeature = featureProvider.getMoveShapeFeature(context);
            if (layoutShapeFeature != null) {
                result = new GefCommandWrapper((ICommand)new MoveShapeFeatureCommandWithContext((IFeature)layoutShapeFeature, context), this.getConfigurationProvider().getDiagramBehavior().getEditingDomain());
            }
        }
        return result;
    }

    private Point getAbsolutePosition(Point requestLocation, GraphicalViewer graphicalViewer) {
        Control control = graphicalViewer.getControl();
        Point searchLocation = requestLocation.getCopy();
        if (control instanceof FigureCanvas) {
            Viewport viewport = ((FigureCanvas)control).getViewport();
            Point viewPortLocation = viewport.getViewLocation();
            searchLocation.translate(viewPortLocation);
        }
        return searchLocation;
    }

    protected IMoveShapeContext createMoveShapeContext(org.eclipse.graphiti.mm.pictograms.Shape shape, ContainerShape source, ContainerShape target, Object constraint, Connection connection) {
        MoveShapeContext ret = new MoveShapeContext(shape);
        ret.setSourceContainer(source);
        ret.setTargetContainer(target);
        ret.setTargetConnection(connection);
        Point loc = null;
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            loc = rect.getLocation();
        } else if (constraint instanceof Point) {
            loc = (Point)constraint;
        }
        if (loc != null) {
            GraphicsAlgorithm graphicsAlgorithm;
            ret.setX(loc.x);
            ret.setY(loc.y);
            if (shape != null && (graphicsAlgorithm = shape.getGraphicsAlgorithm()) != null) {
                ret.setDeltaX(loc.x - graphicsAlgorithm.getX());
                ret.setDeltaY(loc.y - graphicsAlgorithm.getY());
            }
        }
        return ret;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object cmd = UnexecutableCommand.INSTANCE;
        GraphicalViewer graphicalViewer = this.getConfigurationProvider().getDiagramContainer().getGraphicalViewer();
        Point searchLocation = this.getAbsolutePosition(request.getLocation(), graphicalViewer);
        EditPart findEditPartAt = GraphitiUiInternal.getGefService().findEditPartAt((EditPartViewer)graphicalViewer, searchLocation, false);
        ContainerShape targetContainerShape = findEditPartAt != null && findEditPartAt.getModel() instanceof ContainerShape ? (ContainerShape)findEditPartAt.getModel() : this.getCommonContainerShape();
        Object createdObject = request.getNewObject();
        Rectangle rectangle = new Rectangle();
        if (findEditPartAt != null) {
            Point where = this.createRealLocation(request.getLocation(), findEditPartAt);
            rectangle.setLocation(where);
        } else {
            rectangle.setLocation(request.getLocation());
        }
        if (request.getSize() != null) {
            rectangle.setSize(request.getSize());
        }
        Connection connection = (Connection)this.getHost().getModel();
        if (request.getNewObjectType() == ICreateFeature.class) {
            ICreateContext context = ShapeXYLayoutEditPolicy.createCreateContext(targetContainerShape, rectangle);
            ((CreateContext)context).setTargetConnection(connection);
            ICreateFeature createFeature = (ICreateFeature)createdObject;
            cmd = new CreateModelObjectCommand(this.getConfigurationProvider(), createFeature, context);
            cmd.setLabel(createFeature.getDescription());
        } else if (request.getNewObjectType() == ISelection.class) {
            cmd = new AddModelObjectCommand(this.getConfigurationProvider(), targetContainerShape, (ISelection)createdObject, rectangle, connection);
        }
        return cmd;
    }

    private Point createRealLocation(Point location, EditPart findEditPartAt) {
        IFigure layoutContainer = ((GraphicalEditPart)findEditPartAt).getContentPane();
        Point where = location.getCopy();
        layoutContainer.translateToRelative((Translatable)where);
        layoutContainer.translateFromParent((Translatable)where);
        Point layoutOrigin = layoutContainer.getClientArea().getLocation();
        where.translate(layoutOrigin.getNegated());
        return where;
    }

    public EditPart getTargetEditPart(Request request) {
        return this.getHost();
    }

    protected Command getDeleteCommand(GroupRequest request) {
        if (this.getHost().getParent() == null) {
            return null;
        }
        IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        EditPart modelObjectEditPart = this.getHost();
        Object model = modelObjectEditPart.getModel();
        if (!(model instanceof PictogramElement)) {
            return null;
        }
        DeleteContext context = new DeleteContext((PictogramElement)model);
        IDeleteFeature feature = featureProvider.getDeleteFeature((IDeleteContext)context);
        if (feature == null) {
            return null;
        }
        GenericFeatureCommandWithContext command = new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context);
        return new GefCommandWrapper((ICommand)command, this.getConfigurationProvider().getDiagramBehavior().getEditingDomain());
    }

    public void showTargetFeedback(Request request) {
        if ("create child".equals(request.getType()) || "add children".equals(request.getType())) {
            boolean commandExistsForRequest;
            Command command = this.getHost().getCommand(request);
            boolean bl = commandExistsForRequest = command != null && command.canExecute();
            if (!commandExistsForRequest) {
                return;
            }
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
            GFPolylineConnection connection = (GFPolylineConnection)connectionEditPart.getFigure();
            if (this.originalColor == null) {
                this.originalColor = connection.getForegroundColor();
                this.originalLineStyle = connection.getLineStyle();
                connection.setForegroundColor(GFColorConstants.HANDLE_BG);
                connection.setLineStyle(2);
                List<IFigure> allDecorations = connection.getAllDecorations();
                for (IFigure decoration : allDecorations) {
                    if (decoration == null) continue;
                    Color currentColor = decoration.getForegroundColor();
                    this.decorationColor.put(decoration, currentColor);
                    decoration.setForegroundColor(GFColorConstants.HANDLE_BG);
                    if (!(decoration instanceof Shape)) continue;
                    Shape decorationShape = (Shape)decoration;
                    int currentLineStyle = decorationShape.getLineStyle();
                    this.decorationLineStyle.put((IFigure)decorationShape, new Integer(currentLineStyle));
                    decorationShape.setLineStyle(2);
                }
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("create child".equals(request.getType()) || "add children".equals(request.getType())) {
            if (this.originalColor == null) {
                return;
            }
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
            GFPolylineConnection connection = (GFPolylineConnection)connectionEditPart.getFigure();
            connection.setForegroundColor(this.originalColor);
            connection.setLineStyle(this.originalLineStyle);
            List<IFigure> allDecorations = connection.getAllDecorations();
            for (IFigure decoration : allDecorations) {
                if (decoration == null) continue;
                Color previousColor = this.decorationColor.get(decoration);
                decoration.setForegroundColor(previousColor);
                if (!(decoration instanceof Shape)) continue;
                Shape decorationShape = (Shape)decoration;
                Integer previousLineStyle = this.decorationLineStyle.get(decoration);
                if (previousLineStyle == null) continue;
                decorationShape.setLineStyle(previousLineStyle.intValue());
            }
            this.originalColor = null;
            this.decorationColor.clear();
            this.decorationLineStyle.clear();
        }
    }

    private ContainerShape getCommonContainerShape() {
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        EditPart sourceEditPart = connectionEditPart.getSource();
        EditPart targetEditPart = connectionEditPart.getTarget();
        EditPart parent = DefaultConnectionEditPolicy.getCommonEditPart(sourceEditPart, targetEditPart);
        return (ContainerShape)parent.getModel();
    }

    private static EditPart getCommonEditPart(EditPart source, EditPart target) {
        ArrayList<EditPart> list1 = new ArrayList<EditPart>();
        ArrayList<EditPart> list2 = new ArrayList<EditPart>();
        EditPart editPart = source;
        while (!(editPart instanceof RootEditPart)) {
            list1.add(0, editPart);
            editPart = editPart.getParent();
        }
        editPart = target;
        while (!(editPart instanceof RootEditPart)) {
            list2.add(0, editPart);
            editPart = editPart.getParent();
        }
        int index = 0;
        while (index != list1.size()) {
            if (index == list2.size()) {
                return (EditPart)list1.get(index - 1);
            }
            if (list1.get(index) != list2.get(index)) {
                return (EditPart)list1.get(index - 1);
            }
            ++index;
        }
        return (EditPart)list1.get(index - 1);
    }
}

