/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.spy.widget.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.spy.widget.ListChild;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class WidgetResolver {
    private static WidgetResolver instance = null;

    private WidgetResolver() {
    }

    public static WidgetResolver getInstance() {
        if (instance == null) {
            instance = new WidgetResolver();
        }
        return instance;
    }

    public Widget getParent(Widget w) {
        if (w instanceof Composite) {
            return ((Composite)w).getParent();
        }
        if (w instanceof Control) {
            return ((Control)w).getParent();
        }
        if (w instanceof TreeColumn) {
            return ((TreeColumn)w).getParent();
        }
        if (w instanceof CoolItem) {
            return ((CoolItem)w).getParent();
        }
        if (w instanceof ExpandItem) {
            return ((ExpandItem)w).getParent();
        }
        if (w instanceof CTabItem) {
            return ((CTabItem)w).getParent();
        }
        if (w instanceof TabItem) {
            return ((TabItem)w).getParent();
        }
        if (w instanceof ToolItem) {
            return ((ToolItem)w).getParent();
        }
        if (w instanceof TreeItem) {
            return ((TreeItem)w).getParent();
        }
        if (w instanceof Menu) {
            return ((Menu)w).getParent();
        }
        if (w instanceof ScrollBar) {
            return ((ScrollBar)w).getParent();
        }
        if (w instanceof ToolTip) {
            return ((ToolTip)w).getParent();
        }
        return null;
    }

    public List<Widget> getChildren(Widget w) {
        Control[] items;
        ArrayList<Widget> children = new ArrayList<Widget>();
        if (w instanceof CoolItem) {
            Control control = ((CoolItem)w).getControl();
            if (control != null) {
                children.add((Widget)control);
            }
        } else if (w instanceof CTabItem) {
            Control control = ((CTabItem)w).getControl();
            if (control != null) {
                children.add((Widget)control);
            }
        } else if (w instanceof ExpandItem) {
            Control control = ((ExpandItem)w).getControl();
            if (control != null) {
                children.add((Widget)control);
            }
        } else if (w instanceof TabItem) {
            Control control = ((TabItem)w).getControl();
            if (control != null) {
                children.add((Widget)control);
            }
        } else if (w instanceof ToolItem) {
            Control control = ((ToolItem)w).getControl();
            if (control != null) {
                children.add((Widget)control);
            }
        } else if (w instanceof TreeItem) {
            TreeItem[] items2 = ((TreeItem)w).getItems();
            if (items2.length > 0) {
                children.addAll(Arrays.asList(items2));
            }
        } else if (w instanceof Menu) {
            MenuItem[] items3 = ((Menu)w).getItems();
            if (items3.length > 0) {
                children.addAll(Arrays.asList(items3));
            }
        } else if (w instanceof TaskBar) {
            TaskItem[] items4 = ((TaskBar)w).getItems();
            if (items4.length > 0) {
                children.addAll(Arrays.asList(items4));
            }
        } else if (w instanceof Tray) {
            TrayItem[] items5 = ((Tray)w).getItems();
            if (items5.length > 0) {
                children.addAll(Arrays.asList(items5));
            }
        } else if (w instanceof org.eclipse.swt.widgets.List) {
            String[] items6 = ((org.eclipse.swt.widgets.List)w).getItems();
            if (items6.length > 0) {
                String[] stringArray = items6;
                int n = items6.length;
                int n2 = 0;
                while (n2 < n) {
                    String listChild = stringArray[n2];
                    children.add(new ListChild(w, listChild));
                    ++n2;
                }
            }
        } else if (w instanceof Composite && (items = ((Composite)w).getChildren()).length > 0) {
            children.addAll(Arrays.asList(items));
        }
        return children;
    }

    public boolean hasParent(Widget w) {
        return this.getParent(w) != null;
    }

    public boolean hasChildren(Widget w) {
        return this.getChildren(w).size() > 0;
    }
}

