/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.runtime;

import org.eclipse.wst.jsdt.core.runtime.AbstractJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;

public class JSRuntimeWorkingCopy
extends AbstractJSRuntimeInstall {
    public JSRuntimeWorkingCopy(IJSRuntimeType type, String id) {
        super(type, id);
    }

    public JSRuntimeWorkingCopy(IJSRuntimeInstall sourceRuntime, String id) {
        super(sourceRuntime.getRuntimeType(), id);
        this.init(sourceRuntime);
    }

    public JSRuntimeWorkingCopy(IJSRuntimeInstall realRuntime) {
        this(realRuntime.getRuntimeType(), realRuntime.getId());
        this.init(realRuntime);
    }

    private void init(IJSRuntimeInstall realRuntime) {
        this.setName(realRuntime.getName());
        this.setInstallLocation(realRuntime.getInstallLocation());
        this.setJSRuntimeArguments(realRuntime.getJSRuntimeArgumentsAsString());
    }

    public IJSRuntimeInstall convertToRealRuntime() {
        IJSRuntimeType runtimeType = this.getRuntimeType();
        IJSRuntimeInstall realRuntime = JSRuntimeManager.getJSRuntimeInstall(this.getId());
        boolean existingInstall = true;
        if (realRuntime == null) {
            existingInstall = false;
            realRuntime = runtimeType.createRuntimeInstall(this.getId());
        }
        realRuntime.setName(this.getName());
        realRuntime.setInstallLocation(this.getInstallLocation());
        realRuntime.setJSRuntimeArguments(this.getJSRuntimeArgumentsAsString());
        if (existingInstall) {
            JSRuntimeManager.updateJSRuntimeInstall(realRuntime);
        } else {
            JSRuntimeManager.addJSRuntimeInstall(realRuntime);
        }
        return realRuntime;
    }
}

