/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.preferences;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.common.ui.preferences.AbstractDBPreferenceFieldPage;
import org.eclipse.datatools.sqltools.common.ui.util.SWTUtils;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.preferences.PreferenceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CodeAssistPage
extends AbstractDBPreferenceFieldPage {
    private Button _insertSingleProposal;
    private Button _showSystemTables;
    private Button _showSystemProcedures;
    private Button _showOwnerOfTable;
    private Button _enableAuto;
    private Label _autoActivationDelay;
    private Text _autoActivationDelayText;
    private Label _autoActivationTriggers;
    private Text _autoActivationTriggersText;
    private Button _showSystemViews;
    private IPreferenceStore _store = this.getPreferenceStore();

    public CodeAssistPage() {
        this.setDescription(PreferenceMessages.CodeAssist_description);
        this.setPreferenceStore(SQLEditorPlugin.getDefault().getPreferenceStore());
    }

    private Composite createGeneralPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this._insertSingleProposal = SWTUtils.createCheckBox((Composite)composite, (String)PreferenceMessages.CodeAssist_insertSingleProposals, (int)2);
        Group databaseGroup = SWTUtils.createGroup((Composite)composite, (String)PreferenceMessages.CodeAssist_showSystemGroup, (int)2);
        this._showSystemTables = SWTUtils.createCheckBox((Composite)databaseGroup, (String)PreferenceMessages.CodeAssist_showSystemTables, (int)2);
        this._showSystemViews = SWTUtils.createCheckBox((Composite)databaseGroup, (String)PreferenceMessages.CodeAssist_showSystemViews, (int)2);
        this._showSystemProcedures = SWTUtils.createCheckBox((Composite)databaseGroup, (String)PreferenceMessages.CodeAssist_showSystemProcedures, (int)2);
        this._showOwnerOfTable = SWTUtils.createCheckBox((Composite)databaseGroup, (String)PreferenceMessages.CodeAssist_showOwnerOfTable, (int)2);
        Group autoActivationGroup = SWTUtils.createGroup((Composite)composite, (String)PreferenceMessages.CodeAssist_autoActivationGroup, (int)2);
        this._enableAuto = SWTUtils.createCheckBox((Composite)autoActivationGroup, (String)PreferenceMessages.CodeAssist_enableAuto, (int)2);
        this._enableAuto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistPage.this.updateActivationGroup();
            }
        });
        this._autoActivationDelay = SWTUtils.createLabel((Composite)autoActivationGroup, (String)PreferenceMessages.CodeAssist_autoActivationDelay, (int)1, (int)2);
        this._autoActivationDelayText = SWTUtils.createTextBox((Composite)autoActivationGroup, (int)1, (int)25);
        this._autoActivationTriggers = SWTUtils.createLabel((Composite)autoActivationGroup, (String)PreferenceMessages.CodeAssist_autoActivationTriggers, (int)1, (int)2);
        this._autoActivationTriggersText = SWTUtils.createTextBox((Composite)autoActivationGroup, (int)1, (int)25);
        return composite;
    }

    protected void initializeValues() {
        super.initializeValues();
        this._insertSingleProposal.setSelection(this._store.getBoolean("insert.single.proposals.auto"));
        this._showSystemTables.setSelection(this._store.getBoolean("show.system.tables"));
        this._showSystemProcedures.setSelection(this._store.getBoolean("show.system.procedures"));
        this._showOwnerOfTable.setSelection(this._store.getBoolean("show.owner.of.table"));
        this._enableAuto.setSelection(this._store.getBoolean("enable.auto.activation"));
        this._autoActivationDelayText.setText(Integer.toString(this._store.getInt("auto.activation.delay")));
        this._autoActivationTriggersText.setText(this._store.getString("auto.activation.trigger"));
        this._showSystemViews.setSelection(this._store.getBoolean("show.system.views"));
        this.updateEnablement();
    }

    public boolean performOk() {
        this._store.setValue("insert.single.proposals.auto", this._insertSingleProposal.getSelection());
        this._store.setValue("show.system.tables", this._showSystemTables.getSelection());
        this._store.setValue("show.system.procedures", this._showSystemProcedures.getSelection());
        this._store.setValue("show.owner.of.table", this._showOwnerOfTable.getSelection());
        this._store.setValue("enable.auto.activation", this._enableAuto.getSelection());
        this._store.setValue("auto.activation.delay", Integer.parseInt(this._autoActivationDelayText.getText()));
        this._store.setValue("auto.activation.trigger", this._autoActivationTriggersText.getText());
        this._store.setValue("show.system.views", this._showSystemViews.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this._insertSingleProposal.setSelection(this._store.getDefaultBoolean("insert.single.proposals.auto"));
        this._showSystemTables.setSelection(this._store.getDefaultBoolean("show.system.tables"));
        this._showSystemProcedures.setSelection(this._store.getDefaultBoolean("show.system.procedures"));
        this._showOwnerOfTable.setSelection(this._store.getDefaultBoolean("show.owner.of.table"));
        this._enableAuto.setSelection(this._store.getDefaultBoolean("enable.auto.activation"));
        this._autoActivationDelayText.setText(Integer.toString(this._store.getDefaultInt("auto.activation.delay")));
        this._autoActivationTriggersText.setText(this._store.getDefaultString("auto.activation.trigger"));
        this._showSystemViews.setSelection(this._store.getDefaultBoolean("show.system.views"));
        this.updateEnablement();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SQLEditorPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HelpUtil.getContextId((String)"preferences_code_assist", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
        Composite page = this.createGeneralPage(parent);
        this.initializeValues();
        Composite tabs = new Composite(page, 0);
        tabs.setLayoutData((Object)new GridData(1808));
        GridLayout gdl = new GridLayout();
        gdl.marginLeft = 0;
        gdl.marginWidth = 0;
        gdl.marginRight = 0;
        gdl.marginBottom = 0;
        tabs.setLayout((Layout)gdl);
        super.createContents(tabs);
        return page;
    }

    private void updateEnablement() {
        this.updateActivationGroup();
    }

    private void updateActivationGroup() {
        boolean activationEnabled = this._enableAuto.getSelection();
        this._autoActivationDelayText.setEnabled(activationEnabled);
        this._autoActivationTriggersText.setEnabled(activationEnabled);
    }

    public String getPreferencePageId() {
        return "org.eclipse.datatools.sqltools.sqleditor.preferences.codeassist";
    }
}

