/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.epp.logging.aeri.ide.dialogs;

import java.util.List;
import org.eclipse.reddeer.common.exception.TestFailureException;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.ConfigureServerDialog;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.PreferencePage;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.ReportingProject;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.SetupWizard;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.handler.WorkbenchShellHandler;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class AeriTest {
    @After
    public void closeShells() {
        WorkbenchShellHandler.getInstance().closeAllNonWorbenchShells();
    }

    @Test(expected=TestFailureException.class)
    public void testAeriServers() {
        WorkbenchPreferenceDialog wp = new WorkbenchPreferenceDialog();
        wp.open();
        PreferencePage aeriPage = new PreferencePage((ReferencedComposite)wp);
        try {
            wp.select((org.eclipse.reddeer.jface.preference.PreferencePage)aeriPage);
        }
        catch (CoreLayerException ex) {
            throw new TestFailureException(ex.getMessage());
        }
        SetupWizard sWizard = aeriPage.openConfigureProjects();
        List reportingProjects = sWizard.getProjects();
        Assert.assertNotNull((Object)reportingProjects);
        Assert.assertTrue((reportingProjects.size() >= 2 ? 1 : 0) != 0);
        ReportingProject rp = sWizard.getProject("Eclipse RedDeer Test Connector");
        Assert.assertEquals((Object)"Eclipse RedDeer Test Connector", (Object)rp.getProjectName());
        Assert.assertEquals((Object)"Eclipse RedDeer connector description", (Object)rp.getProjectDescription());
        rp.toggleEnable(true);
        Assert.assertTrue((boolean)rp.isEnabled());
        rp.toggleEnable(false);
        Assert.assertFalse((boolean)rp.isEnabled());
        ConfigureServerDialog csDialog = rp.configure();
        csDialog.setName("name");
        Assert.assertEquals((Object)"name", (Object)csDialog.getName());
        csDialog.setEmail("name@name.com");
        Assert.assertEquals((Object)"name@name.com", (Object)csDialog.getEmail());
        csDialog.anonymizeErrorLogMessages(true);
        Assert.assertTrue((boolean)csDialog.isAnonymizeErrorLogMessages());
        csDialog.anonymizePackageClassMethodNames(true);
        Assert.assertTrue((boolean)csDialog.isAnonymizePackageClassMethodNames());
        csDialog.enable();
        ReportingProject rp1 = sWizard.getProject("Eclipse RedDeer Test Connector1");
        Assert.assertEquals((Object)"Eclipse RedDeer Test Connector1", (Object)rp1.getProjectName());
        Assert.assertEquals((Object)"Eclipse RedDeer connector description1", (Object)rp1.getProjectDescription());
        Assert.assertNotNull((Object)rp.getProjectImage());
        rp1.toggleEnable(true);
        Assert.assertTrue((boolean)rp1.isEnabled());
        rp1.toggleEnable(false);
        Assert.assertFalse((boolean)rp1.isEnabled());
        ConfigureServerDialog csDialog1 = rp1.configure();
        csDialog1.disable();
        sWizard.getShell().close();
    }

    @Test(expected=TestFailureException.class)
    public void testSetupWizard() {
        WorkbenchPreferenceDialog wp = new WorkbenchPreferenceDialog();
        wp.open();
        PreferencePage aeriPage = new PreferencePage((ReferencedComposite)wp);
        try {
            wp.select((org.eclipse.reddeer.jface.preference.PreferencePage)aeriPage);
        }
        catch (CoreLayerException ex) {
            throw new TestFailureException(ex.getMessage());
        }
        SetupWizard sWizard = aeriPage.openConfigureProjects();
        ReportingProject rp = sWizard.getProject("Eclipse RedDeer Test Connector");
        rp.toggleEnable(true);
        sWizard.enable();
        sWizard = aeriPage.openConfigureProjects();
        rp = sWizard.getProject("Eclipse RedDeer Test Connector");
        rp.toggleEnable(false);
        sWizard.enable();
        sWizard = aeriPage.openConfigureProjects();
        rp = sWizard.getProject("Eclipse RedDeer Test Connector");
        sWizard.disable();
        sWizard = aeriPage.openConfigureProjects();
        rp = sWizard.getProject("Eclipse RedDeer Test Connector");
        rp.toggleEnable(true);
        sWizard.disable();
    }

    @Test(expected=TestFailureException.class)
    public void testAeriPrefPage() {
        WorkbenchPreferenceDialog wp = new WorkbenchPreferenceDialog();
        wp.open();
        PreferencePage aeriPage = new PreferencePage((ReferencedComposite)wp);
        try {
            wp.select((org.eclipse.reddeer.jface.preference.PreferencePage)aeriPage);
        }
        catch (CoreLayerException ex) {
            throw new TestFailureException(ex.getMessage());
        }
        aeriPage.anonymizeErrorLogMessages(true);
        Assert.assertTrue((boolean)aeriPage.isAnonymizeErrorLogMessages());
        aeriPage.anonymizeErrorLogMessages(false);
        Assert.assertFalse((boolean)aeriPage.isAnonymizeErrorLogMessages());
        aeriPage.anonymizePackageClassMethodNames(true);
        Assert.assertTrue((boolean)aeriPage.isAnonymizePackageClassMethodNames());
        aeriPage.anonymizePackageClassMethodNames(false);
        Assert.assertFalse((boolean)aeriPage.isAnonymizePackageClassMethodNames());
        aeriPage.disableExtendedClasspathAnalysis(true);
        Assert.assertTrue((boolean)aeriPage.isDisableExtendedClasspathAnalysis());
        aeriPage.disableExtendedClasspathAnalysis(false);
        Assert.assertFalse((boolean)aeriPage.isDisableExtendedClasspathAnalysis());
        aeriPage.enableDebugMode(true);
        Assert.assertTrue((boolean)aeriPage.isEnableDebugMode());
        aeriPage.enableDebugMode(false);
        Assert.assertFalse((boolean)aeriPage.isEnableDebugMode());
        aeriPage.setName("name");
        Assert.assertEquals((Object)"name", (Object)aeriPage.getName());
        aeriPage.setEmail("name@name.com");
        Assert.assertEquals((Object)"name@name.com", (Object)aeriPage.getEmail());
        List sendModes = aeriPage.getAvailableSendModes();
        Assert.assertNotNull((Object)sendModes);
        Assert.assertTrue((sendModes.size() > 0 ? 1 : 0) != 0);
        aeriPage.setSendMode((String)sendModes.get(0));
        Assert.assertEquals(sendModes.get(0), (Object)aeriPage.getSendMode());
        wp.cancel();
    }
}

