/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.GroupRule;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.SectionRule;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.ShellRule;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.WidgetUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;

public class RedDeerUtils {
    private static ShellRule activeShell;

    public static List<ReferencedComposite> getComposites(Control widget) {
        ArrayList<ReferencedComposite> toReturn = new ArrayList<ReferencedComposite>();
        if ((widget = widget.getParent()) != null) {
            if (widget instanceof Section) {
                Section section = (Section)widget;
                toReturn.add(new SectionRule(section.getText()));
            } else if (widget instanceof Group) {
                Group group = (Group)widget;
                toReturn.add(new GroupRule(group.getText()));
            }
            toReturn.addAll(RedDeerUtils.getComposites(widget));
        }
        return toReturn;
    }

    public static String getReferencedCompositeString(List<ReferencedComposite> composites) {
        StringBuilder builder = new StringBuilder();
        for (ReferencedComposite r : composites) {
            if (r instanceof SectionRule) {
                builder.append("new UIFormSection(");
                continue;
            }
            builder.append("new DefaultGroup(");
        }
        Collections.reverse(composites);
        int i = 0;
        while (i < composites.size()) {
            builder.append("\"" + WidgetUtils.cleanText((String)composites.get(i).getText()) + "\"),");
            ++i;
        }
        return builder.toString();
    }

    public static String getSection(Control widget) {
        if (Platform.getBundle((String)"org.eclipse.ui.forms") != null) {
            while (widget != null) {
                if (widget instanceof Section) {
                    return ((Section)widget).getText();
                }
                widget = widget.getParent();
            }
        }
        return null;
    }

    public static Shell getWorkbench() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static CTabItem getView(Control widget) {
        while (widget != null) {
            if (widget instanceof CTabFolder) {
                return ((CTabFolder)widget).getSelection();
            }
            widget = widget.getParent();
        }
        return null;
    }

    public static ShellRule getActiveShell() {
        return activeShell;
    }

    public static void setActiveShell(ShellRule activeShell) {
        RedDeerUtils.activeShell = activeShell;
    }
}

