/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.InnerClassesAttributeEntry;

public class InnerClassesAttribute
extends ClassFileAttribute {
    private static final InnerClassesAttributeEntry[] NO_ENTRIES = new InnerClassesAttributeEntry[0];
    private int numberOfClasses;
    private InnerClassesAttributeEntry[] entries;

    public InnerClassesAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.numberOfClasses = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new InnerClassesAttributeEntry[length];
            int i = 0;
            while (i < length) {
                this.entries[i] = new InnerClassesAttributeEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 8;
                ++i;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    public InnerClassesAttributeEntry[] getInnerClassAttributesEntries() {
        return this.entries;
    }

    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }
}

