/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Vector;

public class LineSeg
implements Serializable,
Translatable {
    static final long serialVersionUID = 1L;
    private static final int DEFAULT_INTERSECTION_TOLERANCE = 1;
    private static final float BIGSLOPE = 9999.0f;
    private Point origin;
    private Point terminus;

    public static double[] getLineEquation(double x1, double y1, double x2, double y2) {
        double[] equation = new double[3];
        int i = 0;
        while (i < 3) {
            equation[i] = 0.0;
            ++i;
        }
        if (x1 == x2 && y1 == y2) {
            return equation;
        }
        if (x1 == x2) {
            equation[0] = 1.0;
            equation[1] = 0.0;
            equation[2] = x1;
            return equation;
        }
        equation[0] = (y1 - y2) / (x2 - x1);
        equation[1] = 1.0;
        equation[2] = y2 + equation[0] * x2;
        return equation;
    }

    public LineSeg(KeyPoint start, int fromX, int fromY, float slope, long len, int xdir) {
        this.origin = new Point();
        this.terminus = new Point();
        double len_squared = start == KeyPoint.ORIGIN ? (double)((float)len * (float)len) : (double)len / 2.0 * (double)len / 2.0;
        double slope_squared = slope * slope;
        float dx_float = (float)Math.sqrt(len_squared / (slope_squared + 1.0));
        int dx = (int)((double)(dx_float *= (float)xdir) + 0.5);
        int dy = (int)((double)(slope * dx_float) + 0.5);
        if (start == KeyPoint.ORIGIN) {
            this.origin.x = fromX;
            this.origin.y = fromY;
        } else {
            this.origin.x = fromX - dx;
            this.origin.y = fromY - dy;
        }
        this.terminus.x = fromX + dx;
        this.terminus.y = fromY + dy;
    }

    public LineSeg(Point ptStart, Point ptEnd) {
        this.origin = new Point(ptStart);
        this.terminus = new Point(ptEnd);
    }

    public final boolean containsPoint(Point aPoint, int tolerance) {
        Point theOrigin = this.getOrigin();
        Point theTerminus = this.getTerminus();
        return theOrigin.getDistance(aPoint) + aPoint.getDistance(theTerminus) <= this.length() + (double)tolerance;
    }

    public final float distanceAlong(Point coord) {
        int xCoord = coord.x;
        int yCoord = coord.y;
        long dirx = (long)this.terminus.x - (long)this.origin.x;
        long diry = (long)this.terminus.y - (long)this.origin.y;
        long qpx = (long)xCoord - (long)this.origin.x;
        long qpy = (long)yCoord - (long)this.origin.y;
        long dotprod = qpx * dirx + qpy * diry;
        if (dirx == 0L && diry == 0L) {
            return -1.0f;
        }
        return (float)dotprod / (float)(dirx * dirx + diry * diry);
    }

    public final long distanceToPoint(int xCoord, int yCoord) {
        long d2;
        double proj = this.projection(xCoord, yCoord);
        if (proj > 0.0 && proj < 1.0) {
            Point pt = this.perpIntersect(xCoord, yCoord);
            return Math.round(pt.getDistance(new Point(xCoord, yCoord)));
        }
        long d1 = Math.round(this.getOrigin().getDistance(new Point(xCoord, yCoord)));
        return d1 < (d2 = Math.round(this.getTerminus().getDistance(new Point(xCoord, yCoord)))) ? d1 : d2;
    }

    public boolean equals(Object seg) {
        if (!(seg instanceof LineSeg)) {
            return false;
        }
        LineSeg ls = (LineSeg)seg;
        return this.getOrigin().equals((Object)ls.getOrigin()) && this.getTerminus().equals((Object)ls.getTerminus());
    }

    public double[] getEquation() {
        return LineSeg.getLineEquation(this.origin.x, this.origin.y, this.terminus.x, this.terminus.y);
    }

    public final Point getInfimum() {
        return new Point(Math.min(this.origin.x, this.terminus.x), Math.min(this.origin.y, this.terminus.y));
    }

    public PointList getLineIntersectionsWithEllipse(Rectangle ellipseBounds) {
        PointList intersections = new PointList();
        if (ellipseBounds.width == 0 || ellipseBounds.height == 0) {
            return intersections;
        }
        double xl1 = this.getOrigin().x - ellipseBounds.getCenter().x;
        double yl1 = this.getOrigin().y - ellipseBounds.getCenter().y;
        double xl2 = this.getTerminus().x - ellipseBounds.getCenter().x;
        double yl2 = this.getTerminus().y - ellipseBounds.getCenter().y;
        double[] equation = LineSeg.getLineEquation(xl1, yl1, xl2, yl2);
        if (equation.length < 3 || equation[0] == 0.0 && equation[1] == 0.0) {
            return intersections;
        }
        double a = equation[0];
        double b = equation[1];
        double c = equation[2];
        double w = ellipseBounds.width;
        double h = ellipseBounds.height;
        if (b == 0.0) {
            double x = c / a;
            double y = Math.pow(h / 2.0, 2.0) - Math.pow(h * c / (a * w), 2.0);
            if (y < 0.0) {
                return intersections;
            }
            intersections.addPoint((Point)new PrecisionPoint(x + (double)ellipseBounds.getCenter().x, Math.sqrt(y) + (double)ellipseBounds.getCenter().y));
            intersections.addPoint((Point)new PrecisionPoint(x + (double)ellipseBounds.getCenter().x, -Math.sqrt(y) + (double)ellipseBounds.getCenter().y));
        } else {
            double xA = Math.pow(h, 2.0) + Math.pow(w * a / b, 2.0);
            double xB = -2.0 * Math.pow(w, 2.0) * a * c / Math.pow(b, 2.0);
            double xC = Math.pow(w * c / b, 2.0) - Math.pow(h * w / 2.0, 2.0);
            double xD = Math.pow(xB, 2.0) - 4.0 * xA * xC;
            if (xD < 0.0) {
                return intersections;
            }
            double x1 = (-xB + Math.sqrt(xD)) / (2.0 * xA);
            double x2 = (-xB - Math.sqrt(xD)) / (2.0 * xA);
            intersections.addPoint((Point)new PrecisionPoint(x1 + (double)ellipseBounds.getCenter().x, (c - a * x1) / b + (double)ellipseBounds.getCenter().y));
            intersections.addPoint((Point)new PrecisionPoint(x2 + (double)ellipseBounds.getCenter().x, (c - a * x2) / b + (double)ellipseBounds.getCenter().y));
        }
        return intersections;
    }

    public PointList getLineIntersectionsWithLineSegs(PointList points) {
        double[] temp = this.getEquation();
        double a = temp[0];
        double b = temp[1];
        double c = temp[2];
        PointList intersections = new PointList();
        if (points.size() < 2) {
            if (a * (double)points.getPoint((int)0).x + b * (double)points.getPoint((int)0).y == c) {
                intersections.addPoint(points.getPoint(0).getCopy());
            }
            return intersections;
        }
        int i = 0;
        while (i < points.size() - 1) {
            LineSeg line = new LineSeg(points.getPoint(i).getCopy(), points.getPoint(i + 1).getCopy());
            PointList currentIntersections = this.getLinesIntersections(line);
            int j = 0;
            while (j < currentIntersections.size()) {
                Point intersection = currentIntersections.getPoint(j);
                if (line.containsPoint(intersection, 1)) {
                    intersections.addPoint(currentIntersections.getPoint(j));
                }
                ++j;
            }
            ++i;
        }
        return intersections;
    }

    public PointList getLinesIntersections(LineSeg line) {
        PointList intersections = new PointList();
        double[] temp = this.getEquation();
        double a1 = temp[0];
        double b1 = temp[1];
        double c1 = temp[2];
        temp = line.getEquation();
        double a2 = temp[0];
        double b2 = temp[1];
        double c2 = temp[2];
        double det = a1 * b2 - b1 * a2;
        if (det == 0.0) {
            if (a1 == a2 && b1 == b2 && c1 == c2) {
                intersections.addPoint(new Point(line.getOrigin().getCopy()));
                intersections.addPoint(new Point(line.getTerminus().getCopy()));
            }
        } else {
            intersections.addPoint((Point)new PrecisionPoint((c1 * b2 - b1 * c2) / det, (a1 * c2 - c1 * a2) / det));
        }
        return intersections;
    }

    public Point getOrigin() {
        return new Point(this.origin);
    }

    public final LineSeg getParallelLineSegThroughPoint(Point ptLoc) {
        if (this.isHorizontal()) {
            return new LineSeg(new Point(this.getOrigin().x, ptLoc.y), new Point(this.getTerminus().x, ptLoc.y));
        }
        if (this.isVertical()) {
            return new LineSeg(new Point(ptLoc.x, this.getOrigin().y), new Point(ptLoc.x, this.getTerminus().y));
        }
        Point ptProj = this.perpIntersect(ptLoc.x, ptLoc.y);
        long nHeight = Math.round(ptProj.getDistance(ptLoc));
        Sign position = this.positionRelativeTo(ptLoc);
        return new LineSeg(this.locatePoint(0.0, nHeight, position), this.locatePoint(1.0, nHeight, position));
    }

    public final Point getSupremum() {
        return new Point(Math.max(this.origin.x, this.terminus.x), Math.max(this.origin.y, this.terminus.y));
    }

    public Point getTerminus() {
        return new Point(this.terminus);
    }

    public TrigValues getTrigValues(Vector ptToVector) {
        double dFromLength = this.length();
        double dToLength = ptToVector.getLength();
        Vector ptFromVector = new Vector(new PrecisionPoint(this.getOrigin()), new PrecisionPoint(this.getTerminus()));
        if (dFromLength <= 0.0 || dToLength <= 0.0) {
            return null;
        }
        double dCosAlpha = ptFromVector.x / dFromLength;
        double dSinAlpha = ptFromVector.y / dFromLength;
        double dAlpha = Math.atan2(dSinAlpha, dCosAlpha);
        dCosAlpha = Math.cos(-dAlpha);
        dSinAlpha = Math.sin(-dAlpha);
        double dRotateX = ptToVector.x * dCosAlpha - ptToVector.y * dSinAlpha;
        double dRotateY = ptToVector.x * dSinAlpha + ptToVector.y * dCosAlpha;
        TrigValues val = new TrigValues();
        val.cosTheta = dRotateX / dToLength;
        val.sinTheta = dRotateY / dToLength;
        return val;
    }

    public int hashCode() {
        return this.getOrigin().hashCode() ^ this.getTerminus().hashCode();
    }

    public Point intersect(LineSeg line, int nTolerance) {
        PointList intersections = this.getLinesIntersections(line);
        if (intersections.size() > 1) {
            intersections.addPoint(this.getOrigin().getCopy());
            intersections.addPoint(this.getTerminus().getCopy());
        }
        int i = 0;
        while (i < intersections.size()) {
            Point result = intersections.getPoint(i).getCopy();
            if (this.containsPoint(result, nTolerance) && line.containsPoint(result, nTolerance)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public final boolean isHorizontal() {
        return this.origin.y == this.terminus.y;
    }

    public final boolean isVertical() {
        return this.origin.x == this.terminus.x;
    }

    public final double length() {
        return this.getOrigin().getDistance(this.getTerminus());
    }

    public final Point locatePoint(double pctDist, long theHeight, Sign asOriented) {
        int dist = (int)(pctDist * this.length());
        Point pt = new Point();
        this.pointOn(dist, KeyPoint.ORIGIN, pt);
        int xdir = this.getOrigin().y > this.getTerminus().y || this.getOrigin().y == this.getTerminus().y && this.getOrigin().x < this.getTerminus().x ? (asOriented == Sign.POSITIVE ? -1 : 1) : (asOriented == Sign.POSITIVE ? 1 : -1);
        LineSeg linesegAB = new LineSeg(KeyPoint.ORIGIN, pt.x, pt.y, this.perpSlope(), theHeight, xdir);
        return new Point(linesegAB.getTerminus().x, linesegAB.getTerminus().y);
    }

    public void performScale(double factor) {
        this.setOrigin(this.getOrigin().scale(factor));
        this.setTerminus(this.getTerminus().scale(factor));
    }

    public void performTranslate(int dx, int dy) {
        this.setOrigin(this.getOrigin().translate(dx, dy));
        this.setTerminus(this.getTerminus().translate(dx, dy));
    }

    public final Point perpIntersect(int startX, int startY) {
        Point ptResult = new Point();
        float m = this.slope();
        float fx = (m * (float)startY - m * (float)this.getOrigin().y + m * m * (float)this.getOrigin().x + (float)startX) / (float)((double)(m * m) + 1.0);
        ptResult.y = m == 0.0f ? this.getOrigin().y : (int)((double)((float)startY + ((float)startX - fx) / m) + 0.5);
        ptResult.x = Math.round(fx);
        return ptResult;
    }

    public final float perpSlope() {
        float m = this.slope();
        if ((double)m == 0.0) {
            return 9999.0f;
        }
        return -(1.0f / m);
    }

    public final boolean pointOn(long theDistance, KeyPoint fromKeyPoint, Point ptResult) {
        boolean in_line;
        int startX = 0;
        int startY = 0;
        int otherX = 0;
        int otherY = 0;
        if (fromKeyPoint == KeyPoint.ORIGIN) {
            startX = this.getOrigin().x;
            startY = this.getOrigin().y;
            otherX = this.getTerminus().x;
            otherY = this.getTerminus().y;
        } else if (fromKeyPoint == KeyPoint.TERMINUS) {
            startX = this.getTerminus().x;
            startY = this.getTerminus().y;
            otherX = this.getOrigin().x;
            otherY = this.getOrigin().y;
        } else if (fromKeyPoint == KeyPoint.MIDPOINT) {
            startX = (this.getOrigin().x + this.getTerminus().x) / 2;
            startY = (this.getOrigin().y + this.getTerminus().y) / 2;
            otherX = this.getTerminus().x;
            otherY = this.getTerminus().y;
        } else {
            return false;
        }
        float m = this.slope();
        double d_squared = (float)theDistance * (float)theDistance;
        double m_squared = m * m;
        float dx_float = (float)Math.sqrt(d_squared / (m_squared + 1.0));
        int dx = (int)((double)dx_float + 0.5);
        int dy = (int)(Math.sqrt(d_squared * m_squared / (m_squared + 1.0)) + 0.5);
        if (theDistance < 0L) {
            dx = -dx;
            dy = -dy;
        }
        ptResult.x = startX > otherX ? startX - dx : startX + dx;
        int n = ptResult.y = startY > otherY ? startY - dy : startY + dy;
        if (startX > otherX) {
            in_line = ptResult.x >= otherX;
        } else {
            boolean bl = in_line = ptResult.x <= otherX;
        }
        if (in_line) {
            in_line = startY > otherY ? ptResult.y >= otherY : ptResult.y <= otherY;
        }
        return in_line;
    }

    public final Sign positionRelativeTo(Point rel) {
        Vector ptRelRay = new Vector(new PrecisionPoint(this.getOrigin()), new PrecisionPoint(rel));
        TrigValues val = this.getTrigValues(ptRelRay);
        double dNewAngle = Math.atan2(-val.sinTheta, -val.cosTheta);
        if (dNewAngle > 0.0) {
            return Sign.POSITIVE;
        }
        return Sign.NEGATIVE;
    }

    public final double projection(int xCoord, int yCoord) {
        long dirx = (long)this.getTerminus().x - (long)this.getOrigin().x;
        long diry = (long)this.getTerminus().y - (long)this.getOrigin().y;
        long qpx = (long)xCoord - (long)this.getOrigin().x;
        long qpy = (long)yCoord - (long)this.getOrigin().y;
        long dotprod = qpx * dirx + qpy * diry;
        if (dirx == 0L && diry == 0L) {
            return -1.0;
        }
        return (double)dotprod / (double)(dirx * dirx + diry * diry);
    }

    public void setOrigin(Point origin) {
        this.origin = new Point(origin);
    }

    public void setTerminus(Point terminus) {
        this.terminus = new Point(terminus);
    }

    public final float slope() {
        if (this.isVertical()) {
            return 9999.0f;
        }
        return (float)(this.terminus.y - this.origin.y) / (float)(this.terminus.x - this.origin.x);
    }

    public static class KeyPoint {
        public static final KeyPoint ORIGIN = new KeyPoint("origin");
        public static final KeyPoint MIDPOINT = new KeyPoint("midpoint");
        public static final KeyPoint TERMINUS = new KeyPoint("terminus");
        private final String name;

        private KeyPoint(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Sign {
        public static final Sign POSITIVE = new Sign("positive");
        public static final Sign NEGATIVE = new Sign("negative");
        private final String name;

        private Sign(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TrigValues {
        public double sinTheta;
        public double cosTheta;
    }
}

