/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class StopAction
extends AbstractServerAction {
    public StopAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionStop);
        this.setToolTipText(Messages.actionStopToolTip);
        this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_STOP"));
        this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_STOP"));
        this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_STOP"));
        this.setActionDefinitionId("org.eclipse.wst.server.stop");
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean accept(IServer server) {
        if (server.getServerType() == null) {
            return false;
        }
        return server.getServerType() != null && server.canStop().isOK();
    }

    @Override
    public void perform(IServer server) {
        StopAction.stop(server, this.shell);
    }

    public static void stop(IServer server, Shell shell) {
        Job[] jobs;
        ServerUIPlugin.addTerminationWatch(shell, server, 1);
        IJobManager jobManager = Job.getJobManager();
        Job[] jobArray = jobs = jobManager.find(ServerUtil.SERVER_JOB_FAMILY);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Server.StartJob startJob;
            Job j = jobArray[n2];
            if (j instanceof Server.StartJob && (startJob = (Server.StartJob)j).getServer().equals(server)) {
                startJob.cancel();
                return;
            }
            ++n2;
        }
        server.stop(false);
    }
}

