/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.views.log;

import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.eclipse.ui.views.log.LogMessage;
import org.eclipse.reddeer.eclipse.ui.views.log.LogView;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.impl.menu.WorkbenchPartMenuItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=RedDeerSuite.class)
public class LogViewTest {
    public static final String OK_ID_1 = "fake_ID_OK_1";
    public static final String OK_MESSAGE_1 = "fake_OK_1";
    public static final String OK_ID_2 = "fake_ID_OK_2";
    public static final String OK_MESSAGE_2 = "fake_OK_2";
    public static final String OK_STACK_2 = "fake_OK_2";
    public static final String ERROR_ID_1 = "fake_ID_ERROR_1";
    public static final String ERROR_MESSAGE_1 = "fake_ERROR_1";
    public static final String ERROR_STACK_1 = "fake_ERROR_1";
    public static final String ERROR_ID_2 = "fake_ID_ERROR_2";
    public static final String ERROR_MESSAGE_2 = "fake_ERROR_2";
    public static final String ERROR_STACK_2 = "fake_ERROR_2";
    public static final String WARNING_ID_1 = "fake_ID_WARNING_1";
    public static final String WARNING_MESSAGE_1 = "fake_WARNING_1";
    public static final String WARNING_STACK_1 = "fake_WARNING_1";
    public static final String WARNING_ID_2 = "fake_ID_WARNING_2";
    public static final String WARNING_MESSAGE_2 = "fake_WARNING_2";
    public static final String WARNING_STACK_2 = "fake_WARNING_2";
    public static final String INFO_ID_1 = "fake_ID_INFO_1";
    public static final String INFO_MESSAGE_1 = "fake_INFO_1";
    public static final String INFO_ID_2 = "fake_ID_INFO_2";
    public static final String INFO_MESSAGE_2 = "fake_INFO_2";
    public static final String INFO_STACK_2 = "fake_INFO_2";
    private LogView logView;

    @Before
    public void setup() {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.eclipse.test"));
        log.log((IStatus)new Status(4, ERROR_ID_1, "fake_ERROR_1", (Throwable)new NullPointerException("fake_ERROR_1")));
        log.log((IStatus)new Status(4, ERROR_ID_2, "fake_ERROR_2", (Throwable)new NullPointerException("fake_ERROR_2")));
        log.log((IStatus)new Status(0, OK_ID_1, OK_MESSAGE_1, null));
        log.log((IStatus)new Status(0, OK_ID_2, "fake_OK_2", (Throwable)new NullPointerException("fake_OK_2")));
        log.log((IStatus)new Status(2, WARNING_ID_1, "fake_WARNING_1", (Throwable)new IllegalArgumentException("fake_WARNING_1")));
        log.log((IStatus)new Status(2, WARNING_ID_2, "fake_WARNING_2", (Throwable)new NullPointerException("fake_WARNING_2")));
        log.log((IStatus)new Status(1, INFO_ID_1, INFO_MESSAGE_1, null));
        log.log((IStatus)new Status(1, INFO_ID_2, "fake_INFO_2", (Throwable)new NullPointerException("fake_INFO_2")));
        AbstractWait.sleep((TimePeriod)TimePeriod.getCustom((long)3L));
    }

    @Test
    public void getOKMessage() {
        this.logView = new LogView();
        this.logView.open();
        List messages = this.logView.getOKMessages();
        Assert.assertTrue((String)"No OK messages found!", (!messages.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 0, OK_ID_1, OK_MESSAGE_1, "An exception stack trace is not available."));
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 0, OK_ID_2, "fake_OK_2", "fake_OK_2"));
    }

    @Test
    public void getInfoMessage() {
        this.logView = new LogView();
        this.logView.open();
        List messages = this.logView.getInfoMessages();
        Assert.assertTrue((String)"No INFO messages found!", (!messages.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 1, INFO_ID_1, INFO_MESSAGE_1, "An exception stack trace is not available."));
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 1, INFO_ID_2, "fake_INFO_2", "fake_INFO_2"));
    }

    @Test
    public void getWarningMessage() {
        this.logView = new LogView();
        this.logView.open();
        List messages = this.logView.getWarningMessages();
        Assert.assertTrue((String)"No WARNING messages found!", (!messages.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 2, WARNING_ID_1, "fake_WARNING_1", "fake_WARNING_1"));
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 2, WARNING_ID_2, "fake_WARNING_2", "fake_WARNING_2"));
    }

    @Test
    public void getErrorMessage() {
        this.logView = new LogView();
        this.logView.open();
        List messages = this.logView.getErrorMessages();
        Assert.assertTrue((String)"No ERROR messages found!", (!messages.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 4, ERROR_ID_1, "fake_ERROR_1", "fake_ERROR_1"));
        Assert.assertTrue((boolean)this.messageIsAvailable(messages, 4, ERROR_ID_2, "fake_ERROR_2", "fake_ERROR_2"));
    }

    @Test
    public void testClearAndRestore() {
        this.logView = new LogView();
        this.logView.open();
        Assert.assertFalse((String)"There must be messages", (boolean)this.logView.getErrorMessages().isEmpty());
        this.logView.clearLog();
        Assert.assertTrue((String)"There should be messages", (boolean)this.logView.getErrorMessages().isEmpty());
        this.logView.restoreLog();
        Assert.assertFalse((String)"There should be messages", (boolean)this.logView.getErrorMessages().isEmpty());
    }

    @Test
    public void testDelete() {
        this.logView = new LogView();
        this.logView.open();
        Assert.assertFalse((String)"There must be messages", (boolean)this.logView.getErrorMessages().isEmpty());
        this.logView.deleteLog();
        Assert.assertTrue((String)"There should be no messages", (boolean)this.logView.getErrorMessages().isEmpty());
        this.logView.deleteLog();
        this.logView.restoreLog();
        Assert.assertTrue((String)"There should be no messages", (boolean)this.logView.getErrorMessages().isEmpty());
    }

    @Test
    public void testSetActivateOnNewEvents() {
        this.logView = new LogView();
        this.logView.open();
        this.logView.setActivateOnNewEvents(true);
        WorkbenchPartMenuItem menu = new WorkbenchPartMenuItem(new String[]{"Activate on new events"});
        Assert.assertTrue((String)"'Activate on new events' option should be selected", (boolean)menu.isSelected());
        this.logView.setActivateOnNewEvents(false);
        Assert.assertFalse((String)"'Activate on new events' option should NOT be selected", (boolean)menu.isSelected());
        this.logView.setActivateOnNewEvents(true);
        Assert.assertTrue((String)"'Activate on new events' option should be selected", (boolean)menu.isSelected());
    }

    private boolean messageIsAvailable(List<LogMessage> messages, int severity, String plugin, String message, String stackTrace) {
        for (LogMessage m : messages) {
            if (m.getSeverity() != severity || !m.getPlugin().equals(plugin) || !m.getMessage().equals(message)) continue;
            return true;
        }
        return false;
    }

    @After
    public void cleanup() throws Exception {
        if (!Platform.getLogFileLocation().toFile().delete()) {
            System.out.println("Log file not deleted properly");
        }
        AbstractWait.sleep((TimePeriod)TimePeriod.getCustom((long)3L));
    }
}

