/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isDefaultMethod(IMethodBinding method) {
        return Modifier.isDefault((int)method.getModifiers());
    }

    public static boolean isDefaultMethod(IMethod method) throws JavaModelException {
        return Flags.isDefaultMethod((int)method.getFlags());
    }

    public static boolean isAbstract(IMember member) throws JavaModelException {
        int flags = member.getFlags();
        if (!member.isBinary() && JdtFlags.isInterfaceOrAnnotationMethod(member)) {
            return !Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && !Flags.isDefaultMethod((int)flags);
        }
        return Flags.isAbstract((int)flags);
    }

    public static boolean isAbstract(IMethodBinding member) {
        return Modifier.isAbstract((int)member.getModifiers());
    }

    public static boolean isStatic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isNestedInterfaceOrAnnotation(bodyDeclaration)) {
            return true;
        }
        int nodeType = bodyDeclaration.getNodeType();
        if (nodeType != 31 && nodeType != 82 && JdtFlags.isInterfaceOrAnnotationMember(bodyDeclaration)) {
            return true;
        }
        if (bodyDeclaration instanceof EnumConstantDeclaration) {
            return true;
        }
        if (bodyDeclaration instanceof EnumDeclaration && bodyDeclaration.getParent() instanceof AbstractTypeDeclaration) {
            return true;
        }
        return Modifier.isStatic((int)bodyDeclaration.getModifiers());
    }

    public static boolean isStatic(IMember member) throws JavaModelException {
        if (JdtFlags.isNestedInterfaceOrAnnotation(member)) {
            return true;
        }
        if (member.getElementType() != 9 && JdtFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (JdtFlags.isEnum(member) && (member.getElementType() == 8 || member.getDeclaringType() != null)) {
            return true;
        }
        return Flags.isStatic((int)member.getFlags());
    }

    public static boolean isStatic(IMethodBinding methodBinding) {
        return Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static boolean isDeprecated(IMember member) throws JavaModelException {
        return Flags.isDeprecated((int)member.getFlags());
    }

    public static boolean isFinal(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationField(member)) {
            return true;
        }
        if (JdtFlags.isAnonymousType(member)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(member) || JdtFlags.isEnumTypeFinal(member)) {
            return true;
        }
        return Flags.isFinal((int)member.getFlags());
    }

    private static boolean isEnumTypeFinal(IMember member) throws JavaModelException {
        IJavaElement[] children;
        if (!JdtFlags.isEnum(member) || member.getElementType() != 7) {
            return false;
        }
        IJavaElement[] iJavaElementArray = children = member.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (JdtFlags.isEnumConstant((IMember)child) && ((IField)child).getChildren().length != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNative(IMember member) throws JavaModelException {
        return Flags.isNative((int)member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws JavaModelException {
        return !JdtFlags.isPrivate(member) && !JdtFlags.isProtected(member) && !JdtFlags.isPublic(member);
    }

    public static boolean isPackageVisible(BodyDeclaration bodyDeclaration) {
        return !JdtFlags.isPrivate(bodyDeclaration) && !JdtFlags.isProtected(bodyDeclaration) && !JdtFlags.isPublic(bodyDeclaration);
    }

    public static boolean isPackageVisible(IBinding binding) {
        return !JdtFlags.isPrivate(binding) && !JdtFlags.isProtected(binding) && !JdtFlags.isPublic(binding);
    }

    public static boolean isPrivate(IMember member) throws JavaModelException {
        return Flags.isPrivate((int)member.getFlags());
    }

    public static boolean isPrivate(BodyDeclaration bodyDeclaration) {
        return Modifier.isPrivate((int)bodyDeclaration.getModifiers());
    }

    public static boolean isPrivate(IBinding binding) {
        return Modifier.isPrivate((int)binding.getModifiers());
    }

    public static boolean isProtected(IMember member) throws JavaModelException {
        return Flags.isProtected((int)member.getFlags());
    }

    public static boolean isProtected(BodyDeclaration bodyDeclaration) {
        return Modifier.isProtected((int)bodyDeclaration.getModifiers());
    }

    public static boolean isProtected(IBinding binding) {
        return Modifier.isProtected((int)binding.getModifiers());
    }

    public static boolean isPublic(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isPublic((int)member.getFlags());
    }

    public static boolean isPublic(IBinding binding) {
        if (JdtFlags.isInterfaceOrAnnotationMember(binding)) {
            return true;
        }
        return Modifier.isPublic((int)binding.getModifiers());
    }

    public static boolean isPublic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isInterfaceOrAnnotationMember(bodyDeclaration)) {
            return true;
        }
        return Modifier.isPublic((int)bodyDeclaration.getModifiers());
    }

    public static boolean isStatic(IVariableBinding variableBinding) {
        if (JdtFlags.isInterfaceOrAnnotationMember((IBinding)variableBinding)) {
            return true;
        }
        return Modifier.isStatic((int)variableBinding.getModifiers());
    }

    public static boolean isSynchronized(IMember member) throws JavaModelException {
        return Flags.isSynchronized((int)member.getFlags());
    }

    public static boolean isSynthetic(IMember member) throws JavaModelException {
        return Flags.isSynthetic((int)member.getFlags());
    }

    public static boolean isAnnotation(IMember member) throws JavaModelException {
        return Flags.isAnnotation((int)member.getFlags());
    }

    public static boolean isEnum(IMember member) throws JavaModelException {
        return Flags.isEnum((int)member.getFlags());
    }

    public static boolean isVarargs(IMethod method) throws JavaModelException {
        return Flags.isVarargs((int)method.getFlags());
    }

    public static boolean isTransient(IMember member) throws JavaModelException {
        return Flags.isTransient((int)member.getFlags());
    }

    public static boolean isVolatile(IMember member) throws JavaModelException {
        return Flags.isVolatile((int)member.getFlags());
    }

    private static boolean isInterfaceOrAnnotationMethod(IMember member) throws JavaModelException {
        return member.getElementType() == 9 && JdtFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationField(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationMember(IMember member) throws JavaModelException {
        return member.getDeclaringType() != null && JavaModelUtil.isInterfaceOrAnnotation(member.getDeclaringType());
    }

    private static boolean isInterfaceOrAnnotationMember(IBinding binding) {
        ITypeBinding declaringType = null;
        if (binding instanceof IVariableBinding) {
            declaringType = ((IVariableBinding)binding).getDeclaringClass();
        } else if (binding instanceof IMethodBinding) {
            declaringType = ((IMethodBinding)binding).getDeclaringClass();
        } else if (binding instanceof ITypeBinding) {
            declaringType = ((ITypeBinding)binding).getDeclaringClass();
        }
        return declaringType != null && (declaringType.isInterface() || declaringType.isAnnotation());
    }

    private static boolean isInterfaceOrAnnotationMember(BodyDeclaration bodyDeclaration) {
        return JdtFlags.isInterfaceOrAnnotation(bodyDeclaration.getParent());
    }

    private static boolean isInterfaceOrAnnotation(ASTNode node) {
        boolean isInterface = node instanceof TypeDeclaration && ((TypeDeclaration)node).isInterface();
        boolean isAnnotation = node instanceof AnnotationTypeDeclaration;
        return isInterface || isAnnotation;
    }

    private static boolean isNestedInterfaceOrAnnotation(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.getParent() instanceof AbstractTypeDeclaration && JdtFlags.isInterfaceOrAnnotation((ASTNode)bodyDeclaration);
    }

    private static boolean isNestedInterfaceOrAnnotation(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && member.getDeclaringType() != null && JavaModelUtil.isInterfaceOrAnnotation((IType)member);
    }

    private static boolean isEnumConstant(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isEnum(member);
    }

    private static boolean isAnonymousType(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && ((IType)member).isAnonymous();
    }

    public static int getVisibilityCode(IMember member) throws JavaModelException {
        if (JdtFlags.isPublic(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 0;
        }
        if (JdtFlags.isPrivate(member)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static int getVisibilityCode(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isPublic(bodyDeclaration)) {
            return 1;
        }
        if (JdtFlags.isProtected(bodyDeclaration)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(bodyDeclaration)) {
            return 0;
        }
        if (JdtFlags.isPrivate(bodyDeclaration)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static int getVisibilityCode(IBinding binding) {
        if (JdtFlags.isPublic(binding)) {
            return 1;
        }
        if (JdtFlags.isProtected(binding)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(binding)) {
            return 0;
        }
        if (JdtFlags.isPrivate(binding)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static String getVisibilityString(int visibilityCode) {
        if (Modifier.isPublic((int)visibilityCode)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected((int)visibilityCode)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate((int)visibilityCode)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static int getVisibilityCode(String visibilityString) {
        block16: {
            Assert.isNotNull((Object)visibilityString);
            if (visibilityString == null) break block16;
            switch (visibilityString) {
                case "": {
                    return 0;
                }
                case "private": {
                    return 2;
                }
                case "protected": {
                    return 4;
                }
                case "public": {
                    return 1;
                }
            }
        }
        return -1;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue((visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2 ? 1 : 0) != 0);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JdtFlags.assertVisibility(oldVisibility);
        JdtFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 0 || newVisibility == 1 || newVisibility == 4;
            }
            case 0: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    public static int getLowerVisibility(int visibility1, int visibility2) {
        if (JdtFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility2;
        }
        return visibility1;
    }

    public static int getHigherVisibility(int visibility1, int visibility2) {
        if (JdtFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility1;
        }
        return visibility2;
    }

    public static int clearAccessModifiers(int flags) {
        return JdtFlags.clearFlag(7, flags);
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }
}

